/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_peak_detector2_fb = R"doc(Detect the peak of a signal.

If a peak is detected, this block outputs a 1, or it outputs 0's. A separate debug output may be connected, to view the internal estimated mean described below.

Constructor Specific Documentation:

Build a peak detector block with float in, byte out.

Args:
    threshold_factor_rise : The threshold factor determines when a peak is present. An average of the input signal is calculated (through a single-pole autoregressive filter) and when the value of the input signal goes over threshold_factor_rise*average, we assume we are in the neighborhood of a peak. The block will then find the position of the maximum within a window of look_ahead samples starting at the point where the threshold was crossed upwards.
    look_ahead : The look-ahead value is used when the threshold is crossed upwards to locate the peak within this range.
    alpha : One minus the pole of a single-pole autoregressive filter that evaluates the average of the input signal.)doc";


static const char* __doc_gr_blocks_peak_detector2_fb_peak_detector2_fb_0 = R"doc()doc";


static const char* __doc_gr_blocks_peak_detector2_fb_peak_detector2_fb_1 = R"doc()doc";


static const char* __doc_gr_blocks_peak_detector2_fb_make = R"doc(Detect the peak of a signal.

If a peak is detected, this block outputs a 1, or it outputs 0's. A separate debug output may be connected, to view the internal estimated mean described below.

Constructor Specific Documentation:

Build a peak detector block with float in, byte out.

Args:
    threshold_factor_rise : The threshold factor determines when a peak is present. An average of the input signal is calculated (through a single-pole autoregressive filter) and when the value of the input signal goes over threshold_factor_rise*average, we assume we are in the neighborhood of a peak. The block will then find the position of the maximum within a window of look_ahead samples starting at the point where the threshold was crossed upwards.
    look_ahead : The look-ahead value is used when the threshold is crossed upwards to locate the peak within this range.
    alpha : One minus the pole of a single-pole autoregressive filter that evaluates the average of the input signal.)doc";


static const char* __doc_gr_blocks_peak_detector2_fb_set_threshold_factor_rise =
    R"doc()doc";


static const char* __doc_gr_blocks_peak_detector2_fb_set_look_ahead = R"doc(Set the look-ahead factor.)doc";


static const char* __doc_gr_blocks_peak_detector2_fb_set_alpha = R"doc(Set the running average alpha.)doc";


static const char* __doc_gr_blocks_peak_detector2_fb_threshold_factor_rise = R"doc(Get the threshold factor value for the rise time.)doc";


static const char* __doc_gr_blocks_peak_detector2_fb_look_ahead = R"doc(Get the look-ahead factor value.)doc";


static const char* __doc_gr_blocks_peak_detector2_fb_alpha = R"doc(Get the alpha value of the running average.)doc";
