/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_crc32_bb = R"doc(Byte-stream CRC block.

Input: stream of bytes, which form a packet. The first byte of the packet has a tag with key \"length\" and the value being the number of bytes in the packet.


Output: The same bytes as incoming, but trailing a CRC32 of the packet. The tag is re-set to the new length.

Constructor Specific Documentation:



Args:
    check : Set to true if you want to check CRC, false to create CRC.
    lengthtagname : Length tag key for the tagged stream.
    packed : If the data is packed or unpacked bits (default=true).)doc";


static const char* __doc_gr_digital_crc32_bb_crc32_bb = R"doc()doc";


static const char* __doc_gr_digital_crc32_bb_make = R"doc(Byte-stream CRC block.

Input: stream of bytes, which form a packet. The first byte of the packet has a tag with key \"length\" and the value being the number of bytes in the packet.


Output: The same bytes as incoming, but trailing a CRC32 of the packet. The tag is re-set to the new length.

Constructor Specific Documentation:



Args:
    check : Set to true if you want to check CRC, false to create CRC.
    lengthtagname : Length tag key for the tagged stream.
    packed : If the data is packed or unpacked bits (default=true).)doc";
