/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_multiply_by_tag_value_cc = R"doc(output = input * complex constant

The complex constant used by this block is found from a tag with the name specified by . The tag must contain a float/double or complex PMT value that will be converted into a gr_complex value. All input data is multiplied by this value until a new tag with an update value is found. The block starts with a value of '1.0' for the multiplier constant.

Constructor Specific Documentation:

Create an instance of multiply_by_tag_value_cc.

Args:
    tag_name : Tag's key that it will use to get the multiplicative constant.
    vlen : Vector length of incoming stream)doc";


static const char* __doc_gr_blocks_multiply_by_tag_value_cc_multiply_by_tag_value_cc_0 =
    R"doc()doc";


static const char* __doc_gr_blocks_multiply_by_tag_value_cc_multiply_by_tag_value_cc_1 =
    R"doc()doc";


static const char* __doc_gr_blocks_multiply_by_tag_value_cc_make = R"doc(output = input * complex constant

The complex constant used by this block is found from a tag with the name specified by . The tag must contain a float/double or complex PMT value that will be converted into a gr_complex value. All input data is multiplied by this value until a new tag with an update value is found. The block starts with a value of '1.0' for the multiplier constant.

Constructor Specific Documentation:

Create an instance of multiply_by_tag_value_cc.

Args:
    tag_name : Tag's key that it will use to get the multiplicative constant.
    vlen : Vector length of incoming stream)doc";


static const char* __doc_gr_blocks_multiply_by_tag_value_cc_k = R"doc(Get the current multiplicative constant. This block does not allow external setters.)doc";
