/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvb_bch_bb = R"doc(Encodes a BCH ((Bose, Chaudhuri, Hocquenghem) FEC.

Input: Variable length FEC baseband frames (BBFRAME). 
Output: Variable length FEC baseband frames with appended BCH (BCHFEC).

Constructor Specific Documentation:

Create a baseband frame BCH encoder.

Args:
    standard : DVB standard (DVB-S2 or DVB-T2).
    framesize : FEC frame size (normal, medium or short).
    rate : FEC code rate.)doc";


static const char* __doc_gr_dtv_dvb_bch_bb_dvb_bch_bb = R"doc()doc";


static const char* __doc_gr_dtv_dvb_bch_bb_make = R"doc(Encodes a BCH ((Bose, Chaudhuri, Hocquenghem) FEC.

Input: Variable length FEC baseband frames (BBFRAME). 
Output: Variable length FEC baseband frames with appended BCH (BCHFEC).

Constructor Specific Documentation:

Create a baseband frame BCH encoder.

Args:
    standard : DVB standard (DVB-S2 or DVB-T2).
    framesize : FEC frame size (normal, medium or short).
    rate : FEC code rate.)doc";
