/* gnome-tetravex.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-tetravex.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2010-2013 Robert Ancell
   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <locale.h>
#include <stdio.h>
#include <float.h>
#include <math.h>

#define TETRAVEX_PROGRAM_NAME _ ("Tetravex")
#define TETRAVEX_tiled_state ((((GDK_WINDOW_STATE_TILED | GDK_WINDOW_STATE_TOP_TILED) | GDK_WINDOW_STATE_BOTTOM_TILED) | GDK_WINDOW_STATE_LEFT_TILED) | GDK_WINDOW_STATE_RIGHT_TILED)
#define KEY_GRID_SIZE "grid-size"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TETRAVEX (tetravex_get_type ())
#define TETRAVEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TETRAVEX, Tetravex))
#define TETRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TETRAVEX, TetravexClass))
#define IS_TETRAVEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TETRAVEX))
#define IS_TETRAVEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TETRAVEX))
#define TETRAVEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TETRAVEX, TetravexClass))

typedef struct _Tetravex Tetravex;
typedef struct _TetravexClass TetravexClass;
typedef struct _TetravexPrivate TetravexPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_SCORE_OVERLAY (score_overlay_get_type ())
#define SCORE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_OVERLAY, ScoreOverlay))
#define SCORE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_OVERLAY, ScoreOverlayClass))
#define IS_SCORE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_OVERLAY))
#define IS_SCORE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_OVERLAY))
#define SCORE_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_OVERLAY, ScoreOverlayClass))

typedef struct _ScoreOverlay ScoreOverlay;
typedef struct _ScoreOverlayClass ScoreOverlayClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
enum  {
	TETRAVEX_0_PROPERTY,
	TETRAVEX_NUM_PROPERTIES
};
static GParamSpec* tetravex_properties[TETRAVEX_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TETRAVEX_TYPE_BOTTOM_BUTTON (tetravex_bottom_button_get_type ())
#define TETRAVEX_BOTTOM_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TETRAVEX_TYPE_BOTTOM_BUTTON, TetravexBottomButton))
#define TETRAVEX_BOTTOM_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TETRAVEX_TYPE_BOTTOM_BUTTON, TetravexBottomButtonClass))
#define TETRAVEX_IS_BOTTOM_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TETRAVEX_TYPE_BOTTOM_BUTTON))
#define TETRAVEX_IS_BOTTOM_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TETRAVEX_TYPE_BOTTOM_BUTTON))
#define TETRAVEX_BOTTOM_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TETRAVEX_TYPE_BOTTOM_BUTTON, TetravexBottomButtonClass))

typedef struct _TetravexBottomButton TetravexBottomButton;
typedef struct _TetravexBottomButtonClass TetravexBottomButtonClass;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TetravexBottomButtonPrivate TetravexBottomButtonPrivate;
enum  {
	TETRAVEX_BOTTOM_BUTTON_0_PROPERTY,
	TETRAVEX_BOTTOM_BUTTON_NUM_PROPERTIES
};
static GParamSpec* tetravex_bottom_button_properties[TETRAVEX_BOTTOM_BUTTON_NUM_PROPERTIES];

struct _Tetravex {
	GtkApplication parent_instance;
	TetravexPrivate * priv;
};

struct _TetravexClass {
	GtkApplicationClass parent_class;
};

struct _TetravexPrivate {
	GSettings* settings;
	Puzzle* puzzle;
	gboolean puzzle_init_done;
	GtkLabel* clock_label;
	GtkBox* clock_box;
	History* history;
	PuzzleView* view;
	GtkButton* pause_button;
	GtkButton* new_game_button;
	GtkApplicationWindow* window;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_fullscreen;
	gboolean window_is_tiled;
	GtkStack* new_game_solve_stack;
	GtkStack* play_pause_stack;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* pause_action;
	GSimpleAction* solve_action;
	GSimpleAction* finish_action;
	ScoreOverlay* score_overlay;
	GtkMenuButton* hamburger_button;
	GtkStack* restore_stack;
	GVariant* saved_game;
	gboolean can_restore;
	gboolean restore_stack_created;
	gboolean puzzle_is_finished;
	HistoryEntry* last_history_entry;
	gboolean scores_dialog_visible;
	gboolean has_been_solved;
	gboolean has_been_finished;
	GtkEventControllerKey* key_controller;
	GtkGestureMultiPress* new_game_button_click_controller;
	GtkGestureMultiPress* view_click_controller;
};

struct _TetravexBottomButton {
	GtkButton parent_instance;
	TetravexBottomButtonPrivate * priv;
};

struct _TetravexBottomButtonClass {
	GtkButtonClass parent_class;
};

static gint Tetravex_private_offset;
static gpointer tetravex_parent_class = NULL;
static gint tetravex_colors;
static gint tetravex_game_size;
static gchar** tetravex_remaining;
static gint tetravex_remaining_length1;
static gboolean tetravex_start_paused;
static gboolean tetravex_start_paused = FALSE;
static gboolean tetravex_restore_on_start;
static gboolean tetravex_restore_on_start = FALSE;
static gint tetravex_game_size = G_MININT;
static gint tetravex_colors = 10;
static gchar* tetravex_cli;
static gchar* tetravex_cli = NULL;
static gchar** tetravex_remaining = NULL;
static gint tetravex_remaining_length1 = 0;
static gint _tetravex_remaining_size_ = 0;
static gpointer tetravex_bottom_button_parent_class = NULL;

VALA_EXTERN GType tetravex_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tetravex, g_object_unref)
VALA_EXTERN GType puzzle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Puzzle, g_object_unref)
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, g_object_unref)
VALA_EXTERN GType puzzle_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleView, g_object_unref)
VALA_EXTERN GType score_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreOverlay, g_object_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
static gboolean _tetravex_cli (Tetravex* self,
                        const gchar* option_name,
                        const gchar* val);
static void tetravex_new_game_cb (Tetravex* self);
static void _tetravex_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void tetravex_pause_cb (Tetravex* self);
static void _tetravex_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void tetravex_solve_cb (Tetravex* self);
static void _tetravex_solve_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void tetravex_finish_cb (Tetravex* self);
static void _tetravex_finish_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void tetravex_scores_cb (Tetravex* self);
static void _tetravex_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void tetravex_move_up_l (Tetravex* self);
static void _tetravex_move_up_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void tetravex_move_down_l (Tetravex* self);
static void _tetravex_move_down_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void tetravex_move_left_l (Tetravex* self);
static void _tetravex_move_left_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void tetravex_move_right_l (Tetravex* self);
static void _tetravex_move_right_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void tetravex_move_up_r (Tetravex* self);
static void _tetravex_move_up_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void tetravex_move_down_r (Tetravex* self);
static void _tetravex_move_down_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void tetravex_move_left_r (Tetravex* self);
static void _tetravex_move_left_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void tetravex_move_right_r (Tetravex* self);
static void _tetravex_move_right_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void tetravex_undo_cb (Tetravex* self);
static void _tetravex_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void tetravex_redo_cb (Tetravex* self);
static void _tetravex_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void tetravex_reload_cb (Tetravex* self);
static void _tetravex_reload_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void tetravex_size_changed (Tetravex* self,
                            GSimpleAction* action,
                            GVariant* variant);
static void _tetravex_size_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                  GVariant* value,
                                                                  gpointer self);
static void tetravex_help_cb (Tetravex* self);
static void _tetravex_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void tetravex_about_cb (Tetravex* self);
static void _tetravex_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void tetravex_hamburger_cb (Tetravex* self);
static void _tetravex_hamburger_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static gint tetravex_main (gchar** args,
                    gint args_length1);
static Tetravex* tetravex_new (void);
static Tetravex* tetravex_construct (GType object_type);
static gint tetravex_real_handle_local_options (GApplication* base,
                                         GVariantDict* options);
VALA_EXTERN gint cli_play_cli (const gchar* cli,
                   const gchar* schema_name,
                   GSettings** settings,
                   GVariant** saved_game,
                   gboolean* can_restore,
                   Puzzle** puzzle,
                   gint* colors,
                   gint* game_size);
static void tetravex_real_startup (GApplication* base);
VALA_EXTERN gboolean puzzle_is_valid_saved_game (GVariant* maybe_variant,
                                     gboolean restore_finished_game);
static void tetravex_create_window (Tetravex* self);
VALA_EXTERN History* history_new (const gchar* filename);
VALA_EXTERN History* history_construct (GType object_type,
                            const gchar* filename);
static inline gboolean tetravex_on_key_pressed (Tetravex* self,
                                  GtkEventControllerKey* _key_controller,
                                  guint keyval,
                                  guint keycode,
                                  GdkModifierType state);
static gboolean _tetravex_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                        guint keyval,
                                                                        guint keycode,
                                                                        GdkModifierType state,
                                                                        gpointer self);
static void tetravex_size_allocate_cb (Tetravex* self,
                                GtkAllocation* allocation);
static void _tetravex_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                          GtkAllocation* allocation,
                                                          gpointer self);
static gboolean tetravex_window_state_event_cb (Tetravex* self,
                                         GdkEventWindowState* event);
static gboolean _tetravex_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                        GdkEventWindowState* event,
                                                                        gpointer self);
static GVariant* _variant_new1 (gchar* value);
static void tetravex_restore_game (Tetravex* self);
static void _tetravex_restore_game_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self);
VALA_EXTERN PuzzleView* puzzle_view_new (void);
VALA_EXTERN PuzzleView* puzzle_view_construct (GType object_type);
static inline void tetravex_on_release_on_view (Tetravex* self,
                                  GtkGestureMultiPress* _view_click_controller,
                                  gint n_press,
                                  gdouble event_x,
                                  gdouble event_y);
static void _tetravex_on_release_on_view_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                    gint n_press,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self);
VALA_EXTERN ScoreOverlay* score_overlay_new (void);
VALA_EXTERN ScoreOverlay* score_overlay_construct (GType object_type);
static TetravexBottomButton* tetravex_bottom_button_new (const gchar* icon_name,
                                                  const gchar* action_name,
                                                  const gchar* tooltip_text,
                                                  gboolean align_end,
                                                  GtkSizeGroup* sizegroup);
static TetravexBottomButton* tetravex_bottom_button_construct (GType object_type,
                                                        const gchar* icon_name,
                                                        const gchar* action_name,
                                                        const gchar* tooltip_text,
                                                        gboolean align_end,
                                                        GtkSizeGroup* sizegroup);
static GType tetravex_bottom_button_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TetravexBottomButton, g_object_unref)
static inline void tetravex_on_new_game_button_click (Tetravex* self,
                                        GtkGestureMultiPress* _new_game_button_click_controller,
                                        gint n_press,
                                        gdouble event_x,
                                        gdouble event_y);
static void _tetravex_on_new_game_button_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                         gint n_press,
                                                                         gdouble x,
                                                                         gdouble y,
                                                                         gpointer self);
static void __lambda10_ (Tetravex* self);
VALA_EXTERN gboolean puzzle_get_is_solved (Puzzle* self);
VALA_EXTERN gboolean puzzle_get_is_solved_right (Puzzle* self);
VALA_EXTERN gboolean puzzle_view_get_tile_selected (PuzzleView* self);
VALA_EXTERN gboolean puzzle_get_paused (Puzzle* self);
static void ___lambda10__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void tetravex_tick_cb (Tetravex* self);
static void tetravex_new_game (Tetravex* self,
                        GVariant* saved_game,
                        gint* given_size);
static gint* _int_dup (gint* self);
static void tetravex_real_shutdown (GApplication* base);
VALA_EXTERN gboolean puzzle_get_game_in_progress (Puzzle* self);
VALA_EXTERN GVariant* puzzle_to_variant (Puzzle* self,
                             gboolean save_time);
VALA_EXTERN gboolean puzzle_get_tainted_by_command_line (Puzzle* self);
static void tetravex_real_activate (GApplication* base);
static void tetravex_hide_restore_button (Tetravex* self);
VALA_EXTERN Puzzle* puzzle_new (guint8 size,
                    guint8 colors);
VALA_EXTERN Puzzle* puzzle_construct (GType object_type,
                          guint8 size,
                          guint8 colors);
VALA_EXTERN Puzzle* puzzle_new_restore (GVariant* maybe_variant);
VALA_EXTERN Puzzle* puzzle_construct_restore (GType object_type,
                                  GVariant* maybe_variant);
static void tetravex_solved_right_cb (Tetravex* self);
static void _tetravex_tick_cb_puzzle_tick (Puzzle* _sender,
                                    gpointer self);
static void tetravex_solved_cb (Tetravex* self,
                         Puzzle* puzzle);
static void _tetravex_solved_cb_puzzle_solved (Puzzle* _sender,
                                        gpointer self);
static void _tetravex_solved_right_cb_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static void __lambda7_ (Tetravex* self);
VALA_EXTERN gboolean puzzle_get_can_undo (Puzzle* self);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda8_ (Tetravex* self);
VALA_EXTERN gboolean puzzle_get_can_redo (Puzzle* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void ___lambda9_ (Tetravex* self);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
static void ____lambda9__puzzle_tile_moved (Puzzle* _sender,
                                     Tile* tile,
                                     guint8 x,
                                     guint8 y,
                                     gpointer self);
static void tetravex_show_end_game_cb (Tetravex* self,
                                Puzzle* puzzle);
static void _tetravex_show_end_game_cb_puzzle_show_end_game (Puzzle* _sender,
                                                      gpointer self);
VALA_EXTERN void puzzle_view_set_puzzle (PuzzleView* self,
                             Puzzle* value);
VALA_EXTERN void puzzle_set_paused (Puzzle* self,
                        gboolean value);
static void tetravex_update_bottom_button_states (Tetravex* self);
VALA_EXTERN gdouble puzzle_get_elapsed (Puzzle* self);
VALA_EXTERN void history_get_fallback_scores (History* self,
                                  guint8 puzzle_size,
                                  HistoryEntry** fallback_score_0,
                                  HistoryEntry** fallback_score_1,
                                  HistoryEntry** fallback_score_2,
                                  HistoryEntry** fallback_score_3);
VALA_EXTERN guint8 puzzle_get_size (Puzzle* self);
VALA_EXTERN void score_overlay_display_fallback_scores (ScoreOverlay* self,
                                            guint8 puzzle_size,
                                            HistoryEntry* best_score,
                                            HistoryEntry* second_score,
                                            HistoryEntry* third_score,
                                            HistoryEntry* worst_score);
VALA_EXTERN HistoryEntry* history_entry_new (GDateTime* date,
                                 guint8 size,
                                 gdouble duration,
                                 gboolean int_duration);
VALA_EXTERN HistoryEntry* history_entry_construct (GType object_type,
                                       GDateTime* date,
                                       guint8 size,
                                       gdouble duration,
                                       gboolean int_duration);
VALA_EXTERN guint history_get_place (History* self,
                         HistoryEntry* entry,
                         guint8 puzzle_size,
                         HistoryEntry** other_entry_0,
                         HistoryEntry** other_entry_1,
                         HistoryEntry** other_entry_2);
VALA_EXTERN void score_overlay_set_score (ScoreOverlay* self,
                              guint8 puzzle_size,
                              guint position,
                              HistoryEntry* entry,
                              HistoryEntry* other_entry_0,
                              HistoryEntry* other_entry_1,
                              HistoryEntry* other_entry_2);
VALA_EXTERN void puzzle_view_hide_right_sockets (PuzzleView* self);
VALA_EXTERN gboolean history_is_empty (History* self);
VALA_EXTERN ScoreDialog* score_dialog_new (History* history,
                               guint8 size,
                               HistoryEntry* selected_entry);
VALA_EXTERN ScoreDialog* score_dialog_construct (GType object_type,
                                     History* history,
                                     guint8 size,
                                     HistoryEntry* selected_entry);
VALA_EXTERN GType score_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreDialog, g_object_unref)
VALA_EXTERN void puzzle_solve (Puzzle* self);
VALA_EXTERN void puzzle_view_finish (PuzzleView* self);
VALA_EXTERN void puzzle_view_move_up (PuzzleView* self,
                          gboolean left_board);
VALA_EXTERN void puzzle_view_move_down (PuzzleView* self,
                            gboolean left_board);
VALA_EXTERN void puzzle_view_move_left (PuzzleView* self,
                            gboolean left_board);
VALA_EXTERN void puzzle_view_move_right (PuzzleView* self,
                             gboolean left_board);
VALA_EXTERN void puzzle_view_release_selected_tile (PuzzleView* self);
VALA_EXTERN void puzzle_view_undo (PuzzleView* self);
VALA_EXTERN void puzzle_view_redo (PuzzleView* self);
VALA_EXTERN void puzzle_view_reload (PuzzleView* self);
static gboolean tetravex_on_f1_pressed (Tetravex* self,
                                 GdkModifierType state);
VALA_EXTERN void puzzle_view_disable_highlight (PuzzleView* self);
static GObject * tetravex_bottom_button_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static GType tetravex_bottom_button_get_type_once (void);
static void tetravex_finalize (GObject * obj);
static GType tetravex_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry TETRAVEX_option_entries[8] = {{"cli", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) _tetravex_cli, N_ ("Play in the terminal (see “--cli=help”)"), N_ ("COMMAND")}, {"colors", 'c', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &tetravex_colors, N_ ("Set number of colors (2-10)"), N_ ("NUMBER")}, {"paused", 'p', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Start the game paused"), NULL}, {"restore", 'r', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Restore last game, if any"), NULL}, {"size", 's', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &tetravex_game_size, N_ ("Set size of board (2-6)"), N_ ("SIZE")}, {"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {G_OPTION_REMAINING, (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_STRING_ARRAY, &tetravex_remaining, "args", NULL}, {0}};
static const GActionEntry TETRAVEX_action_entries[21] = {{"new-game", _tetravex_new_game_cb_gsimple_action_activate_callback}, {"pause", _tetravex_pause_cb_gsimple_action_activate_callback}, {"solve", _tetravex_solve_cb_gsimple_action_activate_callback}, {"finish", _tetravex_finish_cb_gsimple_action_activate_callback}, {"scores", _tetravex_scores_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}, {"move-up-l", _tetravex_move_up_l_gsimple_action_activate_callback}, {"move-down-l", _tetravex_move_down_l_gsimple_action_activate_callback}, {"move-left-l", _tetravex_move_left_l_gsimple_action_activate_callback}, {"move-right-l", _tetravex_move_right_l_gsimple_action_activate_callback}, {"move-up-r", _tetravex_move_up_r_gsimple_action_activate_callback}, {"move-down-r", _tetravex_move_down_r_gsimple_action_activate_callback}, {"move-left-r", _tetravex_move_left_r_gsimple_action_activate_callback}, {"move-right-r", _tetravex_move_right_r_gsimple_action_activate_callback}, {"undo", _tetravex_undo_cb_gsimple_action_activate_callback}, {"redo", _tetravex_redo_cb_gsimple_action_activate_callback}, {"reload", _tetravex_reload_cb_gsimple_action_activate_callback}, {"size", NULL, "s", "'2'", _tetravex_size_changed_gsimple_action_change_state_callback}, {"help", _tetravex_help_cb_gsimple_action_activate_callback}, {"about", _tetravex_about_cb_gsimple_action_activate_callback}, {"hamburger", _tetravex_hamburger_cb_gsimple_action_activate_callback}};

static inline gpointer
tetravex_get_instance_private (Tetravex* self)
{
	return G_STRUCT_MEMBER_P (self, Tetravex_private_offset);
}

static void
_tetravex_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	tetravex_new_game_cb ((Tetravex*) self);
}

static void
_tetravex_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	tetravex_pause_cb ((Tetravex*) self);
}

static void
_tetravex_solve_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	tetravex_solve_cb ((Tetravex*) self);
}

static void
_tetravex_finish_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	tetravex_finish_cb ((Tetravex*) self);
}

static void
_tetravex_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	tetravex_scores_cb ((Tetravex*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static void
_tetravex_move_up_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	tetravex_move_up_l ((Tetravex*) self);
}

static void
_tetravex_move_down_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	tetravex_move_down_l ((Tetravex*) self);
}

static void
_tetravex_move_left_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	tetravex_move_left_l ((Tetravex*) self);
}

static void
_tetravex_move_right_l_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	tetravex_move_right_l ((Tetravex*) self);
}

static void
_tetravex_move_up_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	tetravex_move_up_r ((Tetravex*) self);
}

static void
_tetravex_move_down_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	tetravex_move_down_r ((Tetravex*) self);
}

static void
_tetravex_move_left_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	tetravex_move_left_r ((Tetravex*) self);
}

static void
_tetravex_move_right_r_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	tetravex_move_right_r ((Tetravex*) self);
}

static void
_tetravex_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	tetravex_undo_cb ((Tetravex*) self);
}

static void
_tetravex_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	tetravex_redo_cb ((Tetravex*) self);
}

static void
_tetravex_reload_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	tetravex_reload_cb ((Tetravex*) self);
}

static void
_tetravex_size_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                             GVariant* value,
                                                             gpointer self)
{
	tetravex_size_changed ((Tetravex*) self, action, value);
}

static void
_tetravex_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	tetravex_help_cb ((Tetravex*) self);
}

static void
_tetravex_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	tetravex_about_cb ((Tetravex*) self);
}

static void
_tetravex_hamburger_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	tetravex_hamburger_cb ((Tetravex*) self);
}

static gboolean
_tetravex_cli (Tetravex* self,
               const gchar* option_name,
               const gchar* val)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (option_name == NULL) {
		_tmp0_ = "";
	} else {
		_tmp0_ = (const gchar*) option_name;
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (tetravex_cli);
	tetravex_cli = _tmp1_;
	result = TRUE;
	return result;
}

static gint
tetravex_main (gchar** args,
               gint args_length1)
{
	Tetravex* app = NULL;
	Tetravex* _tmp0_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (TETRAVEX_PROGRAM_NAME);
	g_set_prgname ("org.gnome.Tetravex");
	gtk_window_set_default_icon_name ("org.gnome.Tetravex");
	_tmp0_ = tetravex_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return tetravex_main (argv, argc);
}

static Tetravex*
tetravex_construct (GType object_type)
{
	Tetravex * self = NULL;
	self = (Tetravex*) g_object_new (object_type, "application-id", "org.gnome.Tetravex", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, TETRAVEX_option_entries);
	return self;
}

static Tetravex*
tetravex_new (void)
{
	return tetravex_construct (TYPE_TETRAVEX);
}

static gint
tetravex_real_handle_local_options (GApplication* base,
                                    GVariantDict* options)
{
	Tetravex * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	const gchar* _tmp21_;
	gint result;
	self = (Tetravex*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		_tmp2_ = tetravex_remaining;
		_tmp2__length1 = tetravex_remaining_length1;
		_tmp3_ = _tmp2_[0];
		if (_tmp3_ != NULL) {
			gchar** _tmp4_;
			gint _tmp4__length1;
			const gchar* _tmp5_;
			_tmp4_ = tetravex_remaining;
			_tmp4__length1 = tetravex_remaining_length1;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_strcmp0 ((const gchar*) _tmp5_, "version") == 0;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		FILE* _tmp6_;
		_tmp6_ = stderr;
		fprintf (_tmp6_, "%1$s %2$s\n", "gnome-tetravex", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (g_variant_dict_contains (options, "paused")) {
		tetravex_start_paused = TRUE;
	}
	if (g_variant_dict_contains (options, "restore")) {
		tetravex_restore_on_start = TRUE;
	}
	if (tetravex_game_size != G_MININT) {
		gboolean _tmp8_ = FALSE;
		if (tetravex_game_size < 2) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = tetravex_game_size > 6;
		}
		_tmp7_ = _tmp8_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		FILE* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = stderr;
		_tmp10_ = g_strconcat (_ ("Size could only be from 2 to 6."), "\n", NULL);
		_tmp11_ = _tmp10_;
		fprintf (_tmp9_, "%s", _tmp11_);
		_g_free0 (_tmp11_);
		result = EXIT_FAILURE;
		return result;
	}
	if (tetravex_colors < 2) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = tetravex_colors > 10;
	}
	if (_tmp12_) {
		FILE* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = stderr;
		_tmp14_ = g_strconcat (_ ("There could only be between 2 and 10 colors."), "\n", NULL);
		_tmp15_ = _tmp14_;
		fprintf (_tmp13_, "%s", _tmp15_);
		_g_free0 (_tmp15_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp16_ = tetravex_remaining;
	_tmp16__length1 = tetravex_remaining_length1;
	_tmp17_ = _tmp16_[0];
	if (_tmp17_ != NULL) {
		FILE* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = stderr;
		_tmp19_ = g_strconcat (_ ("Failed to parse command-line arguments."), "\n", NULL);
		_tmp20_ = _tmp19_;
		fprintf (_tmp18_, "%s", _tmp20_);
		_g_free0 (_tmp20_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp21_ = tetravex_cli;
	if (_tmp21_ != NULL) {
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_;
		const gchar* _tmp141_;
		GSettings* _tmp142_ = NULL;
		GVariant* _tmp143_ = NULL;
		gboolean _tmp144_ = FALSE;
		Puzzle* _tmp145_ = NULL;
		gint _tmp146_;
		_tmp23_ = tetravex_cli;
		if (g_strcmp0 ((const gchar*) _tmp23_, "help") == 0) {
			_tmp22_ = TRUE;
		} else {
			const gchar* _tmp24_;
			_tmp24_ = tetravex_cli;
			_tmp22_ = g_strcmp0 ((const gchar*) _tmp24_, "HELP") == 0;
		}
		if (_tmp22_) {
			gchar* help_string = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			gchar* _tmp114_;
			gchar* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			gchar* _tmp119_;
			gchar* _tmp120_;
			gchar* _tmp121_;
			gchar* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			FILE* _tmp139_;
			const gchar* _tmp140_;
			_tmp25_ = g_strconcat ("" "\n", _ ("To play GNOME Tetravex in command-line:"), NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp26_, "\n", NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp28_, "  --cli A1b2    ", NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp30_, _ ("Invert two tiles, the one in A1, and the one in b2."), NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp32_, "\n", NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp34_, "                ", NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp36_, _ ("An uppercase targets a tile from the initial board."), NULL);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat (_tmp38_, "\n", NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "                ", NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, _ ("A lowercase targets a tile in the left/final board."), NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp44_, "\n", NULL);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat (_tmp46_, "                ", NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat (_tmp48_, _ ("Digits specify the rows of the two tiles to invert."), NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp50_, "\n", NULL);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strconcat (_tmp52_, "\n", NULL);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strconcat (_tmp54_, "  --cli         ", NULL);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat (_tmp56_, _ ("Show the current puzzle. Alias: “status” or “show”."), NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (_tmp58_, "\n", NULL);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strconcat (_tmp60_, "  --cli new     ", NULL);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strconcat (_tmp62_, _ ("Create a new puzzle; for changing size, use --size."), NULL);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strconcat (_tmp64_, "\n", NULL);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strconcat (_tmp66_, "  --cli solve   ", NULL);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strconcat (_tmp68_, _ ("Give up with current puzzle, and view the solution."), NULL);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strconcat (_tmp70_, "\n", NULL);
			_tmp72_ = _tmp71_;
			_tmp73_ = g_strconcat (_tmp72_, "\n", NULL);
			_tmp74_ = _tmp73_;
			_tmp75_ = g_strconcat (_tmp74_, "  --cli finish  ", NULL);
			_tmp76_ = _tmp75_;
			_tmp77_ = g_strconcat (_tmp76_, _ ("Finish current puzzle, automatically. Alias: “end”."), NULL);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strconcat (_tmp78_, "\n", NULL);
			_tmp80_ = _tmp79_;
			_tmp81_ = g_strconcat (_tmp80_, "                ", NULL);
			_tmp82_ = _tmp81_;
			_tmp83_ = g_strconcat (_tmp82_, _ ("Works for puzzles solved right or if one tile left."), NULL);
			_tmp84_ = _tmp83_;
			_tmp85_ = g_strconcat (_tmp84_, "\n", NULL);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strconcat (_tmp86_, "\n", NULL);
			_tmp88_ = _tmp87_;
			_tmp89_ = g_strconcat (_tmp88_, "  --cli up      ", NULL);
			_tmp90_ = _tmp89_;
			_tmp91_ = g_strconcat (_tmp90_, _ ("Move all left-board tiles up by one."), NULL);
			_tmp92_ = _tmp91_;
			_tmp93_ = g_strconcat (_tmp92_, "\n", NULL);
			_tmp94_ = _tmp93_;
			_tmp95_ = g_strconcat (_tmp94_, "  --cli down    ", NULL);
			_tmp96_ = _tmp95_;
			_tmp97_ = g_strconcat (_tmp96_, _ ("Move all left-board tiles down by one."), NULL);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strconcat (_tmp98_, "\n", NULL);
			_tmp100_ = _tmp99_;
			_tmp101_ = g_strconcat (_tmp100_, "  --cli left    ", NULL);
			_tmp102_ = _tmp101_;
			_tmp103_ = g_strconcat (_tmp102_, _ ("Move all left-board tiles left by one."), NULL);
			_tmp104_ = _tmp103_;
			_tmp105_ = g_strconcat (_tmp104_, "\n", NULL);
			_tmp106_ = _tmp105_;
			_tmp107_ = g_strconcat (_tmp106_, "  --cli right   ", NULL);
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strconcat (_tmp108_, _ ("Move all left-board tiles right by one."), NULL);
			_tmp110_ = _tmp109_;
			_tmp111_ = g_strconcat (_tmp110_, "\n", NULL);
			_tmp112_ = _tmp111_;
			_tmp113_ = g_strconcat (_tmp112_, "\n", NULL);
			_tmp114_ = _tmp113_;
			_tmp115_ = g_strconcat (_tmp114_, "  --cli r-up    ", NULL);
			_tmp116_ = _tmp115_;
			_tmp117_ = g_strconcat (_tmp116_, _ ("Move all right-board tiles up by one."), NULL);
			_tmp118_ = _tmp117_;
			_tmp119_ = g_strconcat (_tmp118_, "\n", NULL);
			_tmp120_ = _tmp119_;
			_tmp121_ = g_strconcat (_tmp120_, "  --cli r-down  ", NULL);
			_tmp122_ = _tmp121_;
			_tmp123_ = g_strconcat (_tmp122_, _ ("Move all right-board tiles down by one."), NULL);
			_tmp124_ = _tmp123_;
			_tmp125_ = g_strconcat (_tmp124_, "\n", NULL);
			_tmp126_ = _tmp125_;
			_tmp127_ = g_strconcat (_tmp126_, "  --cli r-left  ", NULL);
			_tmp128_ = _tmp127_;
			_tmp129_ = g_strconcat (_tmp128_, _ ("Move all right-board tiles left by one."), NULL);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_strconcat (_tmp130_, "\n", NULL);
			_tmp132_ = _tmp131_;
			_tmp133_ = g_strconcat (_tmp132_, "  --cli r-right ", NULL);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strconcat (_tmp134_, _ ("Move all right-board tiles right by one."), NULL);
			_tmp136_ = _tmp135_;
			_tmp137_ = g_strconcat (_tmp136_, "\n\n", NULL);
			_tmp138_ = _tmp137_;
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			_g_free0 (_tmp132_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp128_);
			_g_free0 (_tmp126_);
			_g_free0 (_tmp124_);
			_g_free0 (_tmp122_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp118_);
			_g_free0 (_tmp116_);
			_g_free0 (_tmp114_);
			_g_free0 (_tmp112_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp108_);
			_g_free0 (_tmp106_);
			_g_free0 (_tmp104_);
			_g_free0 (_tmp102_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp98_);
			_g_free0 (_tmp96_);
			_g_free0 (_tmp94_);
			_g_free0 (_tmp92_);
			_g_free0 (_tmp90_);
			_g_free0 (_tmp88_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp84_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp78_);
			_g_free0 (_tmp76_);
			_g_free0 (_tmp74_);
			_g_free0 (_tmp72_);
			_g_free0 (_tmp70_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp66_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp54_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			help_string = _tmp138_;
			_tmp139_ = stdout;
			_tmp140_ = help_string;
			fprintf (_tmp139_, "%s", _tmp140_);
			result = EXIT_SUCCESS;
			_g_free0 (help_string);
			return result;
		}
		_tmp141_ = tetravex_cli;
		_tmp146_ = cli_play_cli ((const gchar*) _tmp141_, "org.gnome.Tetravex", &_tmp142_, &_tmp143_, &_tmp144_, &_tmp145_, &tetravex_colors, &tetravex_game_size);
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp142_;
		_g_variant_unref0 (self->priv->saved_game);
		self->priv->saved_game = _tmp143_;
		self->priv->can_restore = _tmp144_;
		_g_object_unref0 (self->priv->puzzle);
		self->priv->puzzle = _tmp145_;
		result = _tmp146_;
		return result;
	}
	result = -1;
	return result;
}

static void
tetravex_real_startup (GApplication* base)
{
	Tetravex * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GSettings* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	gchar* _tmp44_;
	gchar** _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	self = (Tetravex*) base;
	G_APPLICATION_CLASS (tetravex_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.Tetravex");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "saved-game");
	_g_variant_unref0 (self->priv->saved_game);
	self->priv->saved_game = _tmp2_;
	_tmp3_ = self->priv->saved_game;
	self->priv->can_restore = puzzle_is_valid_saved_game (_tmp3_, FALSE);
	g_action_map_add_action_entries ((GActionMap*) self, TETRAVEX_action_entries, (gint) G_N_ELEMENTS (TETRAVEX_action_entries), self);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_create_action (_tmp4_, "theme");
	_tmp6_ = _tmp5_;
	g_action_map_add_action ((GActionMap*) self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = g_strdup ("<Primary>h");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.solve", _tmp9_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = g_strdup ("<Primary>i");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.scores", _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = g_strdup ("<Primary>n");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp15_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = g_strdup ("<Primary>p");
	_tmp17_ = g_strdup ("Pause");
	_tmp18_ = g_new0 (gchar*, 2 + 1);
	_tmp18_[0] = _tmp16_;
	_tmp18_[1] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = g_strdup ("<Primary>q");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_strdup ("<Primary>Up");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-up-l", _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = g_strdup ("<Primary>Down");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-down-l", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("<Primary>Left");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-left-l", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("<Primary>Right");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-right-l", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<Shift><Primary>Up");
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-up-r", _tmp37_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = g_strdup ("<Shift><Primary>Down");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-down-r", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = g_strdup ("<Shift><Primary>Left");
	_tmp42_ = g_new0 (gchar*, 1 + 1);
	_tmp42_[0] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-left-r", _tmp43_);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = g_strdup ("<Shift><Primary>Right");
	_tmp45_ = g_new0 (gchar*, 1 + 1);
	_tmp45_[0] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.move-right-r", _tmp46_);
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
	_tmp47_ = g_strdup ("<Primary>z");
	_tmp48_ = g_new0 (gchar*, 1 + 1);
	_tmp48_[0] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp49_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = g_strdup ("<Shift><Primary>z");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_strdup ("<Shift><Primary>r");
	_tmp54_ = g_new0 (gchar*, 1 + 1);
	_tmp54_[0] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reload", _tmp55_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = g_strdup ("F10");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.hamburger", _tmp58_);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_tetravex_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                               guint keyval,
                                                               guint keycode,
                                                               GdkModifierType state,
                                                               gpointer self)
{
	gboolean result;
	result = tetravex_on_key_pressed ((Tetravex*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_tetravex_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                     GtkAllocation* allocation,
                                                     gpointer self)
{
	tetravex_size_allocate_cb ((Tetravex*) self, allocation);
}

static gboolean
_tetravex_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                               GdkEventWindowState* event,
                                                               gpointer self)
{
	gboolean result;
	result = tetravex_window_state_event_cb ((Tetravex*) self, event);
	return result;
}

static GVariant*
_variant_new1 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_tetravex_restore_game_gtk_button_clicked (GtkButton* _sender,
                                           gpointer self)
{
	tetravex_restore_game ((Tetravex*) self);
}

static void
_tetravex_on_release_on_view_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                               gint n_press,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self)
{
	tetravex_on_release_on_view ((Tetravex*) self, _sender, n_press, x, y);
}

static void
_tetravex_on_new_game_button_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                    gint n_press,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self)
{
	tetravex_on_new_game_button_click ((Tetravex*) self, _sender, n_press, x, y);
}

static void
__lambda10_ (Tetravex* self)
{
	Puzzle* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	Puzzle* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GSimpleAction* _tmp15_;
	PuzzleView* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	if (!self->priv->puzzle_init_done) {
		return;
	}
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = puzzle_get_is_solved (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->puzzle;
	_tmp4_ = puzzle_get_is_solved_right (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GSimpleAction* _tmp6_;
		_tmp6_ = self->priv->solve_action;
		g_simple_action_set_enabled (_tmp6_, FALSE);
	} else {
		gboolean _tmp7_ = FALSE;
		PuzzleView* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		GSimpleAction* _tmp14_;
		_tmp8_ = self->priv->view;
		_tmp9_ = puzzle_view_get_tile_selected (_tmp8_);
		_tmp10_ = _tmp9_;
		if (!_tmp10_) {
			Puzzle* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = self->priv->puzzle;
			_tmp12_ = puzzle_get_paused (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = !_tmp13_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp14_ = self->priv->solve_action;
		g_simple_action_set_enabled (_tmp14_, _tmp7_);
	}
	_tmp15_ = self->priv->finish_action;
	_tmp16_ = self->priv->view;
	_tmp17_ = puzzle_view_get_tile_selected (_tmp16_);
	_tmp18_ = _tmp17_;
	g_simple_action_set_enabled (_tmp15_, !_tmp18_);
}

static void
___lambda10__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda10_ ((Tetravex*) self);
}

static void
tetravex_create_window (Tetravex* self)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	gchar* history_path = NULL;
	const gchar* _tmp9_;
	History* _tmp10_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp11_;
	GtkCssProvider* _tmp12_;
	GdkScreen* gdk_screen = NULL;
	GdkScreen* _tmp13_;
	GdkScreen* _tmp14_;
	GdkScreen* _tmp15_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkApplicationWindow* _tmp20_;
	GtkApplicationWindow* _tmp21_;
	GtkApplicationWindow* _tmp22_;
	GtkEventControllerKey* _tmp23_;
	GtkEventControllerKey* _tmp24_;
	GtkApplicationWindow* _tmp25_;
	GtkApplicationWindow* _tmp26_;
	GtkApplicationWindow* _tmp27_;
	GSettings* _tmp28_;
	GSettings* _tmp29_;
	GSettings* _tmp30_;
	GAction* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GVariant* _tmp37_;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp38_;
	GtkHeaderBar* _tmp39_;
	GtkHeaderBar* _tmp40_;
	GtkHeaderBar* _tmp41_;
	GtkApplicationWindow* _tmp42_;
	GtkHeaderBar* _tmp43_;
	GtkBuilder* menu_builder = NULL;
	GtkBuilder* _tmp44_;
	GMenuModel* appmenu = NULL;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_;
	GMenuModel* _tmp47_;
	GtkMenuButton* _tmp48_;
	GtkMenuButton* _tmp49_;
	GtkImage* _tmp50_;
	GtkImage* _tmp51_;
	GtkMenuButton* _tmp52_;
	GtkMenuButton* _tmp53_;
	GtkMenuButton* _tmp54_;
	GtkMenuButton* _tmp55_;
	GMenuModel* _tmp56_;
	GtkHeaderBar* _tmp57_;
	GtkMenuButton* _tmp58_;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkButton* redo_button = NULL;
	GtkButton* _tmp64_;
	GtkButton* _tmp65_;
	GtkButton* _tmp66_;
	GtkButton* _tmp67_;
	GtkButton* _tmp68_;
	GtkBox* undo_redo_box = NULL;
	GtkBox* _tmp69_;
	GtkBox* _tmp70_;
	GtkStyleContext* _tmp71_;
	GtkBox* _tmp72_;
	GtkButton* _tmp73_;
	GtkBox* _tmp74_;
	GtkButton* _tmp75_;
	GtkBox* _tmp76_;
	gboolean _tmp77_ = FALSE;
	GtkGrid* grid = NULL;
	GtkBuilder* _tmp96_;
	GObject* _tmp97_;
	GtkGrid* _tmp98_;
	PuzzleView* _tmp99_;
	PuzzleView* _tmp100_;
	PuzzleView* _tmp101_;
	PuzzleView* _tmp102_;
	PuzzleView* _tmp103_;
	PuzzleView* _tmp104_;
	GtkGestureMultiPress* _tmp105_;
	GtkGestureMultiPress* _tmp106_;
	GtkGestureMultiPress* _tmp107_;
	GSettings* _tmp108_;
	PuzzleView* _tmp109_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp110_;
	GtkOverlay* _tmp111_;
	PuzzleView* _tmp112_;
	GtkOverlay* _tmp113_;
	ScoreOverlay* _tmp114_;
	GtkOverlay* _tmp115_;
	ScoreOverlay* _tmp116_;
	GtkOverlay* _tmp117_;
	ScoreOverlay* _tmp118_;
	PuzzleView* _tmp119_;
	ScoreOverlay* _tmp120_;
	PuzzleView* _tmp121_;
	ScoreOverlay* _tmp122_;
	PuzzleView* _tmp123_;
	ScoreOverlay* _tmp124_;
	PuzzleView* _tmp125_;
	ScoreOverlay* _tmp126_;
	PuzzleView* _tmp127_;
	ScoreOverlay* _tmp128_;
	GtkGrid* _tmp129_;
	GtkOverlay* _tmp130_;
	GSettings* _tmp131_;
	PuzzleView* _tmp132_;
	GSettings* _tmp133_;
	PuzzleView* _tmp134_;
	GSettings* _tmp135_;
	PuzzleView* _tmp136_;
	GtkSizeGroup* sizegroup = NULL;
	GtkSizeGroup* _tmp137_;
	GtkButton* play_button = NULL;
	GtkSizeGroup* _tmp138_;
	TetravexBottomButton* _tmp139_;
	GtkSizeGroup* _tmp140_;
	TetravexBottomButton* _tmp141_;
	GtkStack* _tmp142_;
	GtkStack* _tmp143_;
	GtkButton* _tmp144_;
	GtkStack* _tmp145_;
	GtkButton* _tmp146_;
	GtkStack* _tmp147_;
	GtkGrid* _tmp148_;
	GtkStack* _tmp149_;
	GtkSizeGroup* _tmp150_;
	TetravexBottomButton* _tmp151_;
	GtkButton* solve_button = NULL;
	GtkSizeGroup* _tmp152_;
	TetravexBottomButton* _tmp153_;
	GtkButton* finish_button = NULL;
	GtkSizeGroup* _tmp154_;
	TetravexBottomButton* _tmp155_;
	GtkButton* _tmp156_;
	GtkGestureMultiPress* _tmp157_;
	GtkGestureMultiPress* _tmp158_;
	GtkStack* _tmp159_;
	GtkStack* _tmp160_;
	GtkButton* _tmp161_;
	GtkStack* _tmp162_;
	GtkButton* _tmp163_;
	GtkStack* _tmp164_;
	GtkButton* _tmp165_;
	GtkStack* _tmp166_;
	GtkGrid* _tmp167_;
	GtkStack* _tmp168_;
	GtkBox* _tmp169_;
	GtkImage* image = NULL;
	GtkImage* _tmp170_;
	GtkImage* _tmp171_;
	GtkBox* _tmp172_;
	GtkImage* _tmp173_;
	GtkLabel* _tmp174_;
	GtkLabel* _tmp175_;
	GtkBox* _tmp176_;
	GtkLabel* _tmp177_;
	GtkBox* _tmp178_;
	GtkBox* _tmp179_;
	GtkBox* _tmp180_;
	GtkBox* _tmp181_;
	GtkGrid* _tmp182_;
	GtkBox* _tmp183_;
	GAction* _tmp184_;
	GSimpleAction* _tmp185_;
	GAction* _tmp186_;
	GSimpleAction* _tmp187_;
	GAction* _tmp188_;
	GSimpleAction* _tmp189_;
	GAction* _tmp190_;
	GSimpleAction* _tmp191_;
	GAction* _tmp192_;
	GSimpleAction* _tmp193_;
	GSimpleAction* _tmp194_;
	GSimpleAction* _tmp195_;
	GSimpleAction* _tmp196_;
	PuzzleView* _tmp197_;
	gboolean _tmp198_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Tetravex/gnome-tetravex.ui");
	builder = _tmp0_;
	if (tetravex_colors == 10) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_get_user_data_dir ();
		_tmp2_ = g_build_filename (_tmp1_, "gnome-tetravex", "history", NULL);
		_g_free0 (history_path);
		history_path = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = g_get_user_data_dir ();
		_tmp4_ = g_strdup_printf ("%i", tetravex_colors);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("history-", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_filename (_tmp3_, "gnome-tetravex", _tmp7_, NULL);
		_g_free0 (history_path);
		history_path = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	}
	_tmp9_ = history_path;
	_tmp10_ = history_new (_tmp9_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp10_;
	_tmp11_ = gtk_css_provider_new ();
	css_provider = _tmp11_;
	_tmp12_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp12_, "/org/gnome/Tetravex/tetravex.css");
	_tmp13_ = gdk_screen_get_default ();
	_tmp14_ = _g_object_ref0 (_tmp13_);
	gdk_screen = _tmp14_;
	_tmp15_ = gdk_screen;
	if (_tmp15_ != NULL) {
		GdkScreen* _tmp16_;
		GtkCssProvider* _tmp17_;
		_tmp16_ = gdk_screen;
		_tmp17_ = css_provider;
		gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "gnome-tetravex-window");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp20_;
	_tmp21_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp21_);
	_tmp22_ = self->priv->window;
	_tmp23_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp22_);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp23_;
	_tmp24_ = self->priv->key_controller;
	g_signal_connect_object (_tmp24_, "key-pressed", (GCallback) _tetravex_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp25_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp25_, "size-allocate", (GCallback) _tetravex_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp26_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp26_, "window-state-event", (GCallback) _tetravex_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp27_ = self->priv->window;
	_tmp28_ = self->priv->settings;
	_tmp29_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) _tmp27_, g_settings_get_int (_tmp28_, "window-width"), g_settings_get_int (_tmp29_, "window-height"));
	_tmp30_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp30_, "window-is-maximized")) {
		GtkApplicationWindow* _tmp31_;
		_tmp31_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp31_);
	}
	if (tetravex_game_size != G_MININT) {
		GSettings* _tmp32_;
		_tmp32_ = self->priv->settings;
		g_settings_set_int (_tmp32_, KEY_GRID_SIZE, tetravex_game_size);
	} else {
		GSettings* _tmp33_;
		_tmp33_ = self->priv->settings;
		tetravex_game_size = g_settings_get_int (_tmp33_, KEY_GRID_SIZE);
	}
	_tmp34_ = g_action_map_lookup_action ((GActionMap*) self, "size");
	_tmp35_ = g_strdup_printf ("%d", tetravex_game_size);
	_tmp36_ = _tmp35_;
	_tmp37_ = _variant_new1 (_tmp36_);
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction), _tmp37_);
	_g_variant_unref0 (_tmp37_);
	_g_free0 (_tmp36_);
	_tmp38_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp38_);
	headerbar = _tmp38_;
	_tmp39_ = headerbar;
	gtk_header_bar_set_title (_tmp39_, TETRAVEX_PROGRAM_NAME);
	_tmp40_ = headerbar;
	gtk_header_bar_set_show_close_button (_tmp40_, TRUE);
	_tmp41_ = headerbar;
	gtk_widget_show ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->window;
	_tmp43_ = headerbar;
	gtk_window_set_titlebar ((GtkWindow*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = gtk_builder_new_from_resource ("/org/gnome/Tetravex/app-menu.ui");
	menu_builder = _tmp44_;
	_tmp45_ = menu_builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "app-menu");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, g_menu_model_get_type (), GMenuModel));
	appmenu = _tmp47_;
	_tmp48_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->hamburger_button);
	self->priv->hamburger_button = _tmp48_;
	_tmp49_ = self->priv->hamburger_button;
	_tmp50_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp50_);
	_tmp51_ = _tmp50_;
	gtk_button_set_image ((GtkButton*) _tmp49_, (GtkWidget*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	_tmp52_ = self->priv->hamburger_button;
	gtk_widget_set_focus_on_click (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp53_ = self->priv->hamburger_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp53_, GTK_ALIGN_CENTER);
	_tmp54_ = self->priv->hamburger_button;
	gtk_widget_show ((GtkWidget*) _tmp54_);
	_tmp55_ = self->priv->hamburger_button;
	_tmp56_ = appmenu;
	gtk_menu_button_set_menu_model (_tmp55_, _tmp56_);
	_tmp57_ = headerbar;
	_tmp58_ = self->priv->hamburger_button;
	gtk_header_bar_pack_end (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp59_);
	undo_button = _tmp59_;
	_tmp60_ = undo_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp60_, "app.undo");
	_tmp61_ = undo_button;
	gtk_widget_set_focus_on_click (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp62_ = undo_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp62_, GTK_ALIGN_CENTER);
	_tmp63_ = undo_button;
	gtk_widget_show ((GtkWidget*) _tmp63_);
	_tmp64_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-redo-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp64_);
	redo_button = _tmp64_;
	_tmp65_ = redo_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp65_, "app.redo");
	_tmp66_ = redo_button;
	gtk_widget_set_focus_on_click (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp67_ = redo_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp67_, GTK_ALIGN_CENTER);
	_tmp68_ = redo_button;
	gtk_widget_show ((GtkWidget*) _tmp68_);
	_tmp69_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp69_);
	undo_redo_box = _tmp69_;
	_tmp70_ = undo_redo_box;
	_tmp71_ = gtk_widget_get_style_context ((GtkWidget*) _tmp70_);
	gtk_style_context_add_class (_tmp71_, "linked");
	_tmp72_ = undo_redo_box;
	_tmp73_ = undo_button;
	gtk_box_pack_start (_tmp72_, (GtkWidget*) _tmp73_, TRUE, TRUE, (guint) 0);
	_tmp74_ = undo_redo_box;
	_tmp75_ = redo_button;
	gtk_box_pack_start (_tmp74_, (GtkWidget*) _tmp75_, TRUE, TRUE, (guint) 0);
	_tmp76_ = undo_redo_box;
	gtk_widget_show ((GtkWidget*) _tmp76_);
	if (self->priv->can_restore) {
		_tmp77_ = !tetravex_restore_on_start;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		GtkStack* _tmp78_;
		GtkStack* _tmp79_;
		GtkStack* _tmp80_;
		GtkBox* _tmp81_;
		GtkButton* restore_button = NULL;
		GtkButton* _tmp82_;
		GtkButton* _tmp83_;
		GtkButton* _tmp84_;
		GtkButton* _tmp85_;
		GtkButton* _tmp86_;
		GtkStack* _tmp87_;
		GtkButton* _tmp88_;
		GtkStack* _tmp89_;
		GtkButton* _tmp90_;
		GtkStack* _tmp91_;
		GtkHeaderBar* _tmp92_;
		GtkStack* _tmp93_;
		_tmp78_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp78_);
		_g_object_unref0 (self->priv->restore_stack);
		self->priv->restore_stack = _tmp78_;
		self->priv->restore_stack_created = TRUE;
		_tmp79_ = self->priv->restore_stack;
		gtk_stack_set_hhomogeneous (_tmp79_, FALSE);
		_tmp80_ = self->priv->restore_stack;
		_tmp81_ = undo_redo_box;
		gtk_stack_add_named (_tmp80_, (GtkWidget*) _tmp81_, "undo-redo-box");
		_tmp82_ = (GtkButton*) gtk_button_new_with_label (_ ("Restore last game"));
		g_object_ref_sink (_tmp82_);
		restore_button = _tmp82_;
		_tmp83_ = restore_button;
		g_signal_connect_object (_tmp83_, "clicked", (GCallback) _tetravex_restore_game_gtk_button_clicked, self, 0);
		_tmp84_ = restore_button;
		gtk_widget_set_focus_on_click (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp85_ = restore_button;
		gtk_widget_set_valign ((GtkWidget*) _tmp85_, GTK_ALIGN_CENTER);
		_tmp86_ = restore_button;
		gtk_widget_show ((GtkWidget*) _tmp86_);
		_tmp87_ = self->priv->restore_stack;
		_tmp88_ = restore_button;
		gtk_container_add ((GtkContainer*) _tmp87_, (GtkWidget*) _tmp88_);
		_tmp89_ = self->priv->restore_stack;
		_tmp90_ = restore_button;
		gtk_stack_set_visible_child (_tmp89_, (GtkWidget*) _tmp90_);
		_tmp91_ = self->priv->restore_stack;
		gtk_widget_set_visible ((GtkWidget*) _tmp91_, TRUE);
		_tmp92_ = headerbar;
		_tmp93_ = self->priv->restore_stack;
		gtk_header_bar_pack_start (_tmp92_, (GtkWidget*) _tmp93_);
		_g_object_unref0 (restore_button);
	} else {
		GtkHeaderBar* _tmp94_;
		GtkBox* _tmp95_;
		_tmp94_ = headerbar;
		_tmp95_ = undo_redo_box;
		gtk_header_bar_pack_start (_tmp94_, (GtkWidget*) _tmp95_);
	}
	_tmp96_ = builder;
	_tmp97_ = gtk_builder_get_object (_tmp96_, "grid");
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_grid_get_type (), GtkGrid));
	grid = _tmp98_;
	_tmp99_ = puzzle_view_new ();
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp99_;
	_tmp100_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp100_, TRUE);
	_tmp101_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp101_, TRUE);
	_tmp102_ = self->priv->view;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp102_, TRUE);
	_tmp103_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp103_);
	_tmp104_ = self->priv->view;
	_tmp105_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) _tmp104_);
	_g_object_unref0 (self->priv->view_click_controller);
	self->priv->view_click_controller = _tmp105_;
	_tmp106_ = self->priv->view_click_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp106_, (guint) 0);
	_tmp107_ = self->priv->view_click_controller;
	g_signal_connect_object (_tmp107_, "released", (GCallback) _tetravex_on_release_on_view_gtk_gesture_multi_press_released, self, 0);
	_tmp108_ = self->priv->settings;
	_tmp109_ = self->priv->view;
	g_settings_bind (_tmp108_, "theme", (GObject*) _tmp109_, "theme-id", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp110_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp110_);
	overlay = _tmp110_;
	_tmp111_ = overlay;
	_tmp112_ = self->priv->view;
	gtk_container_add ((GtkContainer*) _tmp111_, (GtkWidget*) _tmp112_);
	_tmp113_ = overlay;
	gtk_widget_show ((GtkWidget*) _tmp113_);
	_tmp114_ = score_overlay_new ();
	g_object_ref_sink (_tmp114_);
	_g_object_unref0 (self->priv->score_overlay);
	self->priv->score_overlay = _tmp114_;
	_tmp115_ = overlay;
	_tmp116_ = self->priv->score_overlay;
	gtk_overlay_add_overlay (_tmp115_, (GtkWidget*) _tmp116_);
	_tmp117_ = overlay;
	_tmp118_ = self->priv->score_overlay;
	gtk_overlay_set_overlay_pass_through (_tmp117_, (GtkWidget*) _tmp118_, TRUE);
	_tmp119_ = self->priv->view;
	_tmp120_ = self->priv->score_overlay;
	g_object_bind_property_with_closures ((GObject*) _tmp119_, "boardsize", (GObject*) _tmp120_, "boardsize", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp121_ = self->priv->view;
	_tmp122_ = self->priv->score_overlay;
	g_object_bind_property_with_closures ((GObject*) _tmp121_, "x-offset-right", (GObject*) _tmp122_, "margin-left", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp123_ = self->priv->view;
	_tmp124_ = self->priv->score_overlay;
	g_object_bind_property_with_closures ((GObject*) _tmp123_, "right-margin", (GObject*) _tmp124_, "margin-right", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp125_ = self->priv->view;
	_tmp126_ = self->priv->score_overlay;
	g_object_bind_property_with_closures ((GObject*) _tmp125_, "y-offset", (GObject*) _tmp126_, "margin-top", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp127_ = self->priv->view;
	_tmp128_ = self->priv->score_overlay;
	g_object_bind_property_with_closures ((GObject*) _tmp127_, "y-offset", (GObject*) _tmp128_, "margin-bottom", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp129_ = grid;
	_tmp130_ = overlay;
	gtk_grid_attach (_tmp129_, (GtkWidget*) _tmp130_, 0, 0, 3, 1);
	_tmp131_ = self->priv->settings;
	_tmp132_ = self->priv->view;
	g_settings_bind (_tmp131_, "mouse-use-extra-buttons", (GObject*) _tmp132_, "mouse-use-extra-buttons", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp133_ = self->priv->settings;
	_tmp134_ = self->priv->view;
	g_settings_bind (_tmp133_, "mouse-back-button", (GObject*) _tmp134_, "mouse-back-button", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp135_ = self->priv->settings;
	_tmp136_ = self->priv->view;
	g_settings_bind (_tmp135_, "mouse-forward-button", (GObject*) _tmp136_, "mouse-forward-button", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp137_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	sizegroup = _tmp137_;
	_tmp138_ = sizegroup;
	_tmp139_ = tetravex_bottom_button_new ("media-playback-start-symbolic", "app.pause", _ ("Resume the game"), FALSE, _tmp138_);
	g_object_ref_sink (_tmp139_);
	play_button = (GtkButton*) _tmp139_;
	_tmp140_ = sizegroup;
	_tmp141_ = tetravex_bottom_button_new ("media-playback-pause-symbolic", "app.pause", _ ("Pause the game"), FALSE, _tmp140_);
	g_object_ref_sink (_tmp141_);
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = (GtkButton*) _tmp141_;
	_tmp142_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp142_);
	_g_object_unref0 (self->priv->play_pause_stack);
	self->priv->play_pause_stack = _tmp142_;
	_tmp143_ = self->priv->play_pause_stack;
	_tmp144_ = play_button;
	gtk_stack_add_named (_tmp143_, (GtkWidget*) _tmp144_, "play");
	_tmp145_ = self->priv->play_pause_stack;
	_tmp146_ = self->priv->pause_button;
	gtk_stack_add_named (_tmp145_, (GtkWidget*) _tmp146_, "pause");
	_tmp147_ = self->priv->play_pause_stack;
	gtk_widget_show ((GtkWidget*) _tmp147_);
	_tmp148_ = grid;
	_tmp149_ = self->priv->play_pause_stack;
	gtk_grid_attach (_tmp148_, (GtkWidget*) _tmp149_, 0, 1, 1, 1);
	_tmp150_ = sizegroup;
	_tmp151_ = tetravex_bottom_button_new ("view-refresh-symbolic", "app.new-game", _ ("Start a new game"), TRUE, _tmp150_);
	g_object_ref_sink (_tmp151_);
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = (GtkButton*) _tmp151_;
	_tmp152_ = sizegroup;
	_tmp153_ = tetravex_bottom_button_new ("dialog-question-symbolic", "app.solve", _ ("Give up and view the solution"), TRUE, _tmp152_);
	g_object_ref_sink (_tmp153_);
	solve_button = (GtkButton*) _tmp153_;
	_tmp154_ = sizegroup;
	_tmp155_ = tetravex_bottom_button_new ("go-previous-symbolic", "app.finish", _ ("Move all tiles left"), TRUE, _tmp154_);
	g_object_ref_sink (_tmp155_);
	finish_button = (GtkButton*) _tmp155_;
	_tmp156_ = self->priv->new_game_button;
	_tmp157_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) _tmp156_);
	_g_object_unref0 (self->priv->new_game_button_click_controller);
	self->priv->new_game_button_click_controller = _tmp157_;
	_tmp158_ = self->priv->new_game_button_click_controller;
	g_signal_connect_object (_tmp158_, "pressed", (GCallback) _tetravex_on_new_game_button_click_gtk_gesture_multi_press_pressed, self, 0);
	_tmp159_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp159_);
	_g_object_unref0 (self->priv->new_game_solve_stack);
	self->priv->new_game_solve_stack = _tmp159_;
	_tmp160_ = self->priv->new_game_solve_stack;
	_tmp161_ = solve_button;
	gtk_stack_add_named (_tmp160_, (GtkWidget*) _tmp161_, "solve");
	_tmp162_ = self->priv->new_game_solve_stack;
	_tmp163_ = self->priv->new_game_button;
	gtk_stack_add_named (_tmp162_, (GtkWidget*) _tmp163_, "new-game");
	_tmp164_ = self->priv->new_game_solve_stack;
	_tmp165_ = finish_button;
	gtk_stack_add_named (_tmp164_, (GtkWidget*) _tmp165_, "finish");
	_tmp166_ = self->priv->new_game_solve_stack;
	gtk_widget_show ((GtkWidget*) _tmp166_);
	_tmp167_ = grid;
	_tmp168_ = self->priv->new_game_solve_stack;
	gtk_grid_attach (_tmp167_, (GtkWidget*) _tmp168_, 2, 1, 1, 1);
	_tmp169_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 8);
	g_object_ref_sink (_tmp169_);
	_g_object_unref0 (self->priv->clock_box);
	self->priv->clock_box = _tmp169_;
	_tmp170_ = (GtkImage*) gtk_image_new_from_icon_name ("preferences-system-time-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp170_);
	image = _tmp170_;
	_tmp171_ = image;
	gtk_widget_show ((GtkWidget*) _tmp171_);
	_tmp172_ = self->priv->clock_box;
	_tmp173_ = image;
	gtk_container_add ((GtkContainer*) _tmp172_, (GtkWidget*) _tmp173_);
	_tmp174_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp174_);
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp174_;
	_tmp175_ = self->priv->clock_label;
	gtk_widget_show ((GtkWidget*) _tmp175_);
	_tmp176_ = self->priv->clock_box;
	_tmp177_ = self->priv->clock_label;
	gtk_container_add ((GtkContainer*) _tmp176_, (GtkWidget*) _tmp177_);
	_tmp178_ = self->priv->clock_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp178_, GTK_ALIGN_CENTER);
	_tmp179_ = self->priv->clock_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp179_, GTK_ALIGN_BASELINE);
	_tmp180_ = self->priv->clock_box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp180_, 20);
	_tmp181_ = self->priv->clock_box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp181_, 20);
	_tmp182_ = grid;
	_tmp183_ = self->priv->clock_box;
	gtk_grid_attach (_tmp182_, (GtkWidget*) _tmp183_, 1, 1, 1, 1);
	_tmp184_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp185_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp184_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp185_;
	_tmp186_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp187_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp186_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp187_;
	_tmp188_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp189_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp189_;
	_tmp190_ = g_action_map_lookup_action ((GActionMap*) self, "solve");
	_tmp191_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->solve_action);
	self->priv->solve_action = _tmp191_;
	_tmp192_ = g_action_map_lookup_action ((GActionMap*) self, "finish");
	_tmp193_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->finish_action);
	self->priv->finish_action = _tmp193_;
	_tmp194_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp194_, FALSE);
	_tmp195_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp195_, FALSE);
	_tmp196_ = self->priv->finish_action;
	g_simple_action_set_enabled (_tmp196_, FALSE);
	_tmp197_ = self->priv->view;
	g_signal_connect_object ((GObject*) _tmp197_, "notify::tile-selected", (GCallback) ___lambda10__g_object_notify, self, 0);
	tetravex_tick_cb (self);
	if (self->priv->can_restore) {
		_tmp198_ = tetravex_restore_on_start;
	} else {
		_tmp198_ = FALSE;
	}
	if (_tmp198_) {
		GVariant* _tmp199_;
		_tmp199_ = self->priv->saved_game;
		tetravex_new_game (self, _tmp199_, NULL);
	} else {
		tetravex_new_game (self, NULL, NULL);
	}
	_g_object_unref0 (image);
	_g_object_unref0 (finish_button);
	_g_object_unref0 (solve_button);
	_g_object_unref0 (play_button);
	_g_object_unref0 (sizegroup);
	_g_object_unref0 (overlay);
	_g_object_unref0 (grid);
	_g_object_unref0 (undo_redo_box);
	_g_object_unref0 (redo_button);
	_g_object_unref0 (undo_button);
	_g_object_unref0 (appmenu);
	_g_object_unref0 (menu_builder);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (gdk_screen);
	_g_object_unref0 (css_provider);
	_g_free0 (history_path);
	_g_object_unref0 (builder);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
tetravex_size_allocate_cb (Tetravex* self,
                           GtkAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _window_width = NULL;
	gint* _window_height = NULL;
	GtkApplicationWindow* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp7_;
	gint* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gint* _tmp10_;
	gint* _tmp12_;
	gint* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	if (self->priv->window_is_maximized) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->window_is_tiled;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->window_is_fullscreen;
	}
	if (_tmp0_) {
		return;
	}
	_window_width = NULL;
	_window_height = NULL;
	_tmp2_ = self->priv->window;
	gtk_window_get_size ((GtkWindow*) _tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (_window_width);
	_tmp5_ = _tmp3_;
	_tmp6_ = __int_dup0 (&_tmp5_);
	_window_width = _tmp6_;
	_g_free0 (_window_height);
	_tmp7_ = _tmp4_;
	_tmp8_ = __int_dup0 (&_tmp7_);
	_window_height = _tmp8_;
	_tmp10_ = _window_width;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		gint* _tmp11_;
		_tmp11_ = _window_height;
		_tmp9_ = _tmp11_ == NULL;
	}
	if (_tmp9_) {
		_g_free0 (_window_height);
		_g_free0 (_window_width);
		return;
	}
	_tmp12_ = _window_width;
	self->priv->window_width = (gint) (*_tmp12_);
	_tmp13_ = _window_height;
	self->priv->window_height = (gint) (*_tmp13_);
	_g_free0 (_window_height);
	_g_free0 (_window_width);
}

static gboolean
tetravex_window_state_event_cb (Tetravex* self,
                                GdkEventWindowState* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_is_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	if ((event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		self->priv->window_is_fullscreen = (event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	if ((event->changed_mask & TETRAVEX_tiled_state) != 0) {
		self->priv->window_is_tiled = (event->new_window_state & TETRAVEX_tiled_state) != 0;
	}
	result = FALSE;
	return result;
}

static void
tetravex_real_shutdown (GApplication* base)
{
	Tetravex * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GSettings* _tmp4_;
	GSettings* _tmp16_;
	self = (Tetravex*) base;
	G_APPLICATION_CLASS (tetravex_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	if (self->priv->window_is_maximized) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->window_is_fullscreen;
	}
	_tmp4_ = self->priv->settings;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp3_);
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_game_in_progress (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			GSettings* _tmp8_;
			Puzzle* _tmp9_;
			Puzzle* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			GVariant* _tmp13_;
			GVariant* _tmp14_;
			_tmp8_ = self->priv->settings;
			_tmp9_ = self->priv->puzzle;
			_tmp10_ = self->priv->puzzle;
			_tmp11_ = puzzle_get_tainted_by_command_line (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = puzzle_to_variant (_tmp9_, !_tmp12_);
			_tmp14_ = _tmp13_;
			g_settings_set_value (_tmp8_, "saved-game", _tmp14_);
			_g_variant_unref0 (_tmp14_);
		} else {
			if (!self->priv->can_restore) {
				GSettings* _tmp15_;
				_tmp15_ = self->priv->settings;
				g_settings_set (_tmp15_, "saved-game", "m(yyda(yyyyyyyy)ua(yyyyu))", NULL);
			}
		}
	}
	_tmp16_ = self->priv->settings;
	g_settings_apply (_tmp16_);
}

static void
tetravex_real_activate (GApplication* base)
{
	Tetravex * self;
	GtkWindow* _tmp0_;
	GtkApplicationWindow* _tmp1_;
	self = (Tetravex*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		tetravex_create_window (self);
	}
	_tmp1_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp1_);
}

static void
tetravex_restore_game (Tetravex* self)
{
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->can_restore) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->saved_game;
	tetravex_new_game (self, _tmp0_, NULL);
	tetravex_hide_restore_button (self);
}

static void
tetravex_hide_restore_button (Tetravex* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->can_restore) {
		return;
	}
	if (self->priv->restore_stack_created) {
		GtkStack* _tmp0_;
		_tmp0_ = self->priv->restore_stack;
		gtk_stack_set_visible_child_name (_tmp0_, "undo-redo-box");
	}
	self->priv->can_restore = FALSE;
}

static void
_tetravex_tick_cb_puzzle_tick (Puzzle* _sender,
                               gpointer self)
{
	tetravex_tick_cb ((Tetravex*) self);
}

static void
_tetravex_solved_cb_puzzle_solved (Puzzle* _sender,
                                   gpointer self)
{
	tetravex_solved_cb ((Tetravex*) self, _sender);
}

static void
_tetravex_solved_right_cb_g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	tetravex_solved_right_cb ((Tetravex*) self);
}

static void
__lambda7_ (Tetravex* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GSimpleAction* _tmp11_;
	_tmp2_ = self->priv->puzzle;
	_tmp3_ = puzzle_get_can_undo (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_is_solved (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Puzzle* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->puzzle;
		_tmp9_ = puzzle_get_paused (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = !_tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp11_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp11_, _tmp0_);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ ((Tetravex*) self);
}

static void
__lambda8_ (Tetravex* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GSimpleAction* _tmp11_;
	_tmp2_ = self->priv->puzzle;
	_tmp3_ = puzzle_get_can_redo (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_is_solved (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Puzzle* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->puzzle;
		_tmp9_ = puzzle_get_paused (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = !_tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp11_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp11_, _tmp0_);
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((Tetravex*) self);
}

static void
___lambda9_ (Tetravex* self)
{
	if (!self->priv->has_been_solved) {
		tetravex_hide_restore_button (self);
	}
}

static void
____lambda9__puzzle_tile_moved (Puzzle* _sender,
                                Tile* tile,
                                guint8 x,
                                guint8 y,
                                gpointer self)
{
	___lambda9_ ((Tetravex*) self);
}

static void
_tetravex_show_end_game_cb_puzzle_show_end_game (Puzzle* _sender,
                                                 gpointer self)
{
	tetravex_show_end_game_cb ((Tetravex*) self, _sender);
}

static void
tetravex_new_game (Tetravex* self,
                   GVariant* saved_game,
                   gint* given_size)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GtkStack* _tmp3_;
	ScoreOverlay* _tmp4_;
	gboolean was_paused = FALSE;
	Puzzle* _tmp20_;
	Puzzle* _tmp21_;
	Puzzle* _tmp22_;
	Puzzle* _tmp23_;
	Puzzle* _tmp24_;
	gboolean _tmp25_ = FALSE;
	Puzzle* _tmp27_;
	PuzzleView* _tmp28_;
	Puzzle* _tmp29_;
	g_return_if_fail (self != NULL);
	self->priv->puzzle_is_finished = FALSE;
	self->priv->has_been_finished = FALSE;
	self->priv->has_been_solved = FALSE;
	_tmp0_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->solve_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	_tmp2_ = self->priv->finish_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->new_game_solve_stack;
	gtk_stack_set_visible_child_name (_tmp3_, "solve");
	_tmp4_ = self->priv->score_overlay;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		Puzzle* _tmp8_;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		was_paused = _tmp7_;
		_tmp8_ = self->priv->puzzle;
		g_signal_handlers_disconnect_by_func (_tmp8_, NULL, self);
		tetravex_hide_restore_button (self);
	} else {
		was_paused = FALSE;
	}
	if (saved_game == NULL) {
		gint size = 0;
		Puzzle* _tmp10_;
		GtkBox* _tmp11_;
		if (given_size == NULL) {
			GSettings* _tmp9_;
			_tmp9_ = self->priv->settings;
			size = g_settings_get_int (_tmp9_, KEY_GRID_SIZE);
		} else {
			size = (gint) (*given_size);
		}
		_tmp10_ = puzzle_new ((guint8) size, (guint8) tetravex_colors);
		_g_object_unref0 (self->priv->puzzle);
		self->priv->puzzle = _tmp10_;
		_tmp11_ = self->priv->clock_box;
		gtk_widget_show ((GtkWidget*) _tmp11_);
	} else {
		Puzzle* _tmp12_;
		Puzzle* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		Puzzle* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp12_ = puzzle_new_restore ((GVariant*) saved_game);
		_g_object_unref0 (self->priv->puzzle);
		self->priv->puzzle = _tmp12_;
		_tmp13_ = self->priv->puzzle;
		_tmp14_ = puzzle_get_is_solved_right (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_) {
			tetravex_solved_right_cb (self);
		}
		_tmp16_ = self->priv->puzzle;
		_tmp17_ = puzzle_get_tainted_by_command_line (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			GtkBox* _tmp19_;
			_tmp19_ = self->priv->clock_box;
			gtk_widget_hide ((GtkWidget*) _tmp19_);
		}
	}
	self->priv->puzzle_init_done = TRUE;
	_tmp20_ = self->priv->puzzle;
	g_signal_connect_object (_tmp20_, "tick", (GCallback) _tetravex_tick_cb_puzzle_tick, self, 0);
	_tmp21_ = self->priv->puzzle;
	g_signal_connect_object (_tmp21_, "solved", (GCallback) _tetravex_solved_cb_puzzle_solved, self, 0);
	_tmp22_ = self->priv->puzzle;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::is-solved-right", (GCallback) _tetravex_solved_right_cb_g_object_notify, self, 0);
	_tmp23_ = self->priv->puzzle;
	g_signal_connect_object ((GObject*) _tmp23_, "notify::can-undo", (GCallback) ___lambda7__g_object_notify, self, 0);
	_tmp24_ = self->priv->puzzle;
	g_signal_connect_object ((GObject*) _tmp24_, "notify::can-redo", (GCallback) ___lambda8__g_object_notify, self, 0);
	if (self->priv->can_restore) {
		_tmp25_ = !tetravex_restore_on_start;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		Puzzle* _tmp26_;
		_tmp26_ = self->priv->puzzle;
		g_signal_connect_object (_tmp26_, "tile-moved", (GCallback) ____lambda9__puzzle_tile_moved, self, 0);
	}
	_tmp27_ = self->priv->puzzle;
	g_signal_connect_object (_tmp27_, "show-end-game", (GCallback) _tetravex_show_end_game_cb_puzzle_show_end_game, self, 0);
	_tmp28_ = self->priv->view;
	_tmp29_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp28_, _tmp29_);
	tetravex_tick_cb (self);
	if (tetravex_start_paused) {
		Puzzle* _tmp30_;
		GtkButton* _tmp31_;
		_tmp30_ = self->priv->puzzle;
		puzzle_set_paused (_tmp30_, TRUE);
		tetravex_start_paused = FALSE;
		_tmp31_ = self->priv->pause_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp31_);
	} else {
		gboolean _tmp32_ = FALSE;
		if (was_paused) {
			_tmp32_ = saved_game != NULL;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			Puzzle* _tmp33_;
			GtkButton* _tmp34_;
			_tmp33_ = self->priv->puzzle;
			puzzle_set_paused (_tmp33_, TRUE);
			_tmp34_ = self->priv->pause_button;
			gtk_widget_grab_focus ((GtkWidget*) _tmp34_);
		} else {
			PuzzleView* _tmp35_;
			_tmp35_ = self->priv->view;
			gtk_widget_grab_focus ((GtkWidget*) _tmp35_);
		}
	}
	tetravex_update_bottom_button_states (self);
}

static void
tetravex_tick_cb (Tetravex* self)
{
	gboolean _tmp0_ = FALSE;
	gint elapsed = 0;
	gint hours = 0;
	gint minutes = 0;
	gint seconds = 0;
	g_return_if_fail (self != NULL);
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->puzzle;
		_tmp2_ = puzzle_get_tainted_by_command_line (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	elapsed = 0;
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = self->priv->puzzle;
		_tmp5_ = puzzle_get_elapsed (_tmp4_);
		_tmp6_ = _tmp5_;
		elapsed = (gint) _tmp6_;
	}
	hours = elapsed / 3600;
	minutes = (elapsed - (hours * 3600)) / 60;
	seconds = (elapsed - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		GtkLabel* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->clock_label;
		_tmp8_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", hours, minutes, seconds);
		_tmp9_ = _tmp8_;
		gtk_label_set_text (_tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
	} else {
		GtkLabel* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->priv->clock_label;
		_tmp11_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", minutes, seconds);
		_tmp12_ = _tmp11_;
		gtk_label_set_text (_tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
	}
}

static void
tetravex_solved_cb (Tetravex* self,
                    Puzzle* puzzle)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	self->priv->puzzle_is_finished = TRUE;
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->solve_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->finish_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
}

static void
tetravex_solved_right_cb (Tetravex* self)
{
	Puzzle* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = puzzle_get_is_solved_right (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		GtkStack* _tmp8_;
		_tmp3_ = self->priv->solve_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp4_ = self->priv->finish_action;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		g_simple_action_set_enabled (_tmp4_, !_tmp7_);
		_tmp8_ = self->priv->new_game_solve_stack;
		gtk_stack_set_visible_child_name (_tmp8_, "finish");
	} else {
		GSimpleAction* _tmp9_;
		Puzzle* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		GSimpleAction* _tmp13_;
		_tmp9_ = self->priv->solve_action;
		_tmp10_ = self->priv->puzzle;
		_tmp11_ = puzzle_get_paused (_tmp10_);
		_tmp12_ = _tmp11_;
		g_simple_action_set_enabled (_tmp9_, !_tmp12_);
		_tmp13_ = self->priv->finish_action;
		g_simple_action_set_enabled (_tmp13_, FALSE);
		if (!self->priv->has_been_finished) {
			GtkStack* _tmp14_;
			_tmp14_ = self->priv->new_game_solve_stack;
			gtk_stack_set_visible_child_name (_tmp14_, "solve");
		}
	}
}

static void
tetravex_show_end_game_cb (Tetravex* self,
                           Puzzle* puzzle)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkStack* _tmp38_;
	PuzzleView* _tmp39_;
	ScoreOverlay* _tmp40_;
	GtkButton* _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	_tmp0_ = puzzle_get_tainted_by_command_line (puzzle);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		HistoryEntry* best_score = NULL;
		HistoryEntry* second_score = NULL;
		HistoryEntry* third_score = NULL;
		HistoryEntry* worst_score = NULL;
		History* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		HistoryEntry* _tmp5_ = NULL;
		HistoryEntry* _tmp6_ = NULL;
		HistoryEntry* _tmp7_ = NULL;
		HistoryEntry* _tmp8_ = NULL;
		ScoreOverlay* _tmp9_;
		guint8 _tmp10_;
		guint8 _tmp11_;
		HistoryEntry* _tmp12_;
		HistoryEntry* _tmp13_;
		HistoryEntry* _tmp14_;
		HistoryEntry* _tmp15_;
		if (!self->priv->puzzle_is_finished) {
			return;
		}
		_tmp2_ = self->priv->history;
		_tmp3_ = puzzle_get_size (puzzle);
		_tmp4_ = _tmp3_;
		history_get_fallback_scores (_tmp2_, _tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
		_g_object_unref0 (best_score);
		best_score = _tmp5_;
		_g_object_unref0 (second_score);
		second_score = _tmp6_;
		_g_object_unref0 (third_score);
		third_score = _tmp7_;
		_g_object_unref0 (worst_score);
		worst_score = _tmp8_;
		_tmp9_ = self->priv->score_overlay;
		_tmp10_ = puzzle_get_size (puzzle);
		_tmp11_ = _tmp10_;
		_tmp12_ = best_score;
		_tmp13_ = second_score;
		_tmp14_ = third_score;
		_tmp15_ = worst_score;
		score_overlay_display_fallback_scores (_tmp9_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
		_g_object_unref0 (worst_score);
		_g_object_unref0 (third_score);
		_g_object_unref0 (second_score);
		_g_object_unref0 (best_score);
	} else {
		GDateTime* date = NULL;
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		guint8 _tmp18_;
		guint8 _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		HistoryEntry* _tmp22_;
		HistoryEntry* other_score_0 = NULL;
		HistoryEntry* other_score_1 = NULL;
		HistoryEntry* other_score_2 = NULL;
		guint position = 0U;
		History* _tmp23_;
		HistoryEntry* _tmp24_;
		guint8 _tmp25_;
		guint8 _tmp26_;
		HistoryEntry* _tmp27_ = NULL;
		HistoryEntry* _tmp28_ = NULL;
		HistoryEntry* _tmp29_ = NULL;
		guint _tmp30_;
		ScoreOverlay* _tmp31_;
		guint8 _tmp32_;
		guint8 _tmp33_;
		HistoryEntry* _tmp34_;
		HistoryEntry* _tmp35_;
		HistoryEntry* _tmp36_;
		HistoryEntry* _tmp37_;
		_tmp16_ = g_date_time_new_now_local ();
		date = _tmp16_;
		_tmp17_ = date;
		_tmp18_ = puzzle_get_size (puzzle);
		_tmp19_ = _tmp18_;
		_tmp20_ = puzzle_get_elapsed (puzzle);
		_tmp21_ = _tmp20_;
		_tmp22_ = history_entry_new (_tmp17_, _tmp19_, _tmp21_, FALSE);
		_g_object_unref0 (self->priv->last_history_entry);
		self->priv->last_history_entry = _tmp22_;
		if (!self->priv->puzzle_is_finished) {
			_g_date_time_unref0 (date);
			return;
		}
		_tmp23_ = self->priv->history;
		_tmp24_ = self->priv->last_history_entry;
		_tmp25_ = puzzle_get_size (puzzle);
		_tmp26_ = _tmp25_;
		_tmp30_ = history_get_place (_tmp23_, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_HISTORY_ENTRY, HistoryEntry), _tmp26_, &_tmp27_, &_tmp28_, &_tmp29_);
		_g_object_unref0 (other_score_0);
		other_score_0 = _tmp27_;
		_g_object_unref0 (other_score_1);
		other_score_1 = _tmp28_;
		_g_object_unref0 (other_score_2);
		other_score_2 = _tmp29_;
		position = _tmp30_;
		_tmp31_ = self->priv->score_overlay;
		_tmp32_ = puzzle_get_size (puzzle);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->priv->last_history_entry;
		_tmp35_ = other_score_0;
		_tmp36_ = other_score_1;
		_tmp37_ = other_score_2;
		score_overlay_set_score (_tmp31_, _tmp33_, position, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_HISTORY_ENTRY, HistoryEntry), _tmp35_, _tmp36_, _tmp37_);
		_g_object_unref0 (other_score_2);
		_g_object_unref0 (other_score_1);
		_g_object_unref0 (other_score_0);
		_g_date_time_unref0 (date);
	}
	_tmp38_ = self->priv->new_game_solve_stack;
	gtk_stack_set_visible_child_name (_tmp38_, "new-game");
	_tmp39_ = self->priv->view;
	puzzle_view_hide_right_sockets (_tmp39_);
	_tmp40_ = self->priv->score_overlay;
	gtk_widget_show ((GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->new_game_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp41_);
}

static void
tetravex_new_game_cb (Tetravex* self)
{
	gint size = 0;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	size = g_settings_get_int (_tmp0_, KEY_GRID_SIZE);
	_tmp2_ = self->priv->puzzle;
	_tmp3_ = puzzle_get_game_in_progress (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_is_solved (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkMessageDialog* dialog = NULL;
		GtkApplicationWindow* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkMessageDialog* _tmp11_;
		GtkMessageDialog* _tmp12_;
		GtkMessageDialog* _tmp13_;
		gint response = 0;
		GtkMessageDialog* _tmp14_;
		GtkMessageDialog* _tmp15_;
		_tmp8_ = self->priv->window;
		_tmp9_ = g_strdup_printf (_ ("Are you sure you want to start a new %u × %u game?"), (guint) size, (guint) size);
		_tmp10_ = _tmp9_;
		_tmp11_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp10_);
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		dialog = _tmp12_;
		_tmp13_ = dialog;
		gtk_dialog_add_buttons ((GtkDialog*) _tmp13_, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Start New Game"), GTK_RESPONSE_ACCEPT, NULL);
		_tmp14_ = dialog;
		response = gtk_dialog_run ((GtkDialog*) _tmp14_);
		_tmp15_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
		if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
			_g_object_unref0 (dialog);
			return;
		}
		_g_object_unref0 (dialog);
	}
	tetravex_new_game (self, NULL, &size);
}

static void
tetravex_scores_cb (Tetravex* self)
{
	GtkDialog* dialog = NULL;
	History* _tmp0_;
	GtkDialog* _tmp16_;
	GtkDialog* _tmp17_;
	g_return_if_fail (self != NULL);
	if (self->priv->scores_dialog_visible) {
		return;
	}
	self->priv->scores_dialog_visible = TRUE;
	_tmp0_ = self->priv->history;
	if (history_is_empty (_tmp0_)) {
		GtkApplicationWindow* _tmp1_;
		GtkMessageDialog* _tmp2_;
		_tmp1_ = self->priv->window;
		_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, "%s", _ ("Looks like you haven’t finished a game yet.\n" \
"\n" \
"Maybe try a 2 × 2 grid, they are easy. 🙂️"));
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (dialog);
		dialog = (GtkDialog*) _tmp2_;
	} else {
		HistoryEntry* _tmp3_ = NULL;
		Puzzle* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		History* _tmp8_;
		Puzzle* _tmp9_;
		guint8 _tmp10_;
		guint8 _tmp11_;
		ScoreDialog* _tmp12_;
		GtkDialog* _tmp13_;
		GtkDialog* _tmp14_;
		GtkApplicationWindow* _tmp15_;
		_tmp4_ = self->priv->puzzle;
		_tmp5_ = puzzle_get_is_solved (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			HistoryEntry* _tmp7_;
			_tmp7_ = self->priv->last_history_entry;
			_tmp3_ = _tmp7_;
		} else {
			_tmp3_ = NULL;
		}
		_tmp8_ = self->priv->history;
		_tmp9_ = self->priv->puzzle;
		_tmp10_ = puzzle_get_size (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = score_dialog_new (_tmp8_, _tmp11_, _tmp3_);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (dialog);
		dialog = (GtkDialog*) _tmp12_;
		_tmp13_ = dialog;
		gtk_window_set_modal ((GtkWindow*) _tmp13_, TRUE);
		_tmp14_ = dialog;
		_tmp15_ = self->priv->window;
		gtk_window_set_transient_for ((GtkWindow*) _tmp14_, (GtkWindow*) _tmp15_);
	}
	_tmp16_ = dialog;
	gtk_dialog_run (_tmp16_);
	_tmp17_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
	self->priv->scores_dialog_visible = FALSE;
	_g_object_unref0 (dialog);
}

static void
tetravex_solve_cb (Tetravex* self)
{
	gboolean _tmp0_ = FALSE;
	Puzzle* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	Puzzle* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	Puzzle* _tmp15_;
	GtkStack* _tmp16_;
	GtkButton* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->puzzle;
	_tmp2_ = puzzle_get_tainted_by_command_line (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		Puzzle* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = self->priv->puzzle;
		_tmp5_ = puzzle_get_elapsed (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ < 0.2;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = self->priv->puzzle;
	_tmp8_ = puzzle_get_game_in_progress (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GtkMessageDialog* dialog = NULL;
		GtkApplicationWindow* _tmp10_;
		GtkMessageDialog* _tmp11_;
		GtkMessageDialog* _tmp12_;
		gint response = 0;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* _tmp14_;
		_tmp10_ = self->priv->window;
		_tmp11_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp10_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Are you sure you want to give up and view the solution?"));
		g_object_ref_sink (_tmp11_);
		dialog = _tmp11_;
		_tmp12_ = dialog;
		gtk_dialog_add_buttons ((GtkDialog*) _tmp12_, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Give Up"), GTK_RESPONSE_ACCEPT, NULL);
		_tmp13_ = dialog;
		response = gtk_dialog_run ((GtkDialog*) _tmp13_);
		_tmp14_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp14_);
		if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
			_g_object_unref0 (dialog);
			return;
		}
		_g_object_unref0 (dialog);
	}
	self->priv->has_been_solved = TRUE;
	_tmp15_ = self->priv->puzzle;
	puzzle_solve (_tmp15_);
	_tmp16_ = self->priv->new_game_solve_stack;
	gtk_stack_set_visible_child_name (_tmp16_, "new-game");
	_tmp17_ = self->priv->new_game_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp17_);
}

static void
tetravex_finish_cb (Tetravex* self)
{
	GSimpleAction* _tmp0_;
	PuzzleView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->finish_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	self->priv->has_been_finished = TRUE;
	_tmp1_ = self->priv->view;
	puzzle_view_finish (_tmp1_);
}

static void
tetravex_size_changed (Tetravex* self,
                       GSimpleAction* action,
                       GVariant* variant)
{
	gint size = 0;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_string (variant, NULL);
	size = atoi (_tmp0_);
	if (size < 2) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = size > 6;
	}
	if (_tmp1_) {
		g_assert_not_reached ();
	}
	_tmp2_ = self->priv->settings;
	if (size == g_settings_get_int (_tmp2_, KEY_GRID_SIZE)) {
		return;
	}
	_tmp3_ = self->priv->settings;
	g_settings_set_int (_tmp3_, KEY_GRID_SIZE, size);
	g_simple_action_set_state (action, variant);
}

static void
tetravex_move_up_l (Tetravex* self)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_move_up (_tmp0_, TRUE);
}

static void
tetravex_move_down_l (Tetravex* self)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_move_down (_tmp0_, TRUE);
}

static void
tetravex_move_left_l (Tetravex* self)
{
	Puzzle* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = puzzle_get_is_solved_right (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		PuzzleView* _tmp3_;
		_tmp3_ = self->priv->view;
		puzzle_view_move_left (_tmp3_, TRUE);
	} else {
		gboolean _tmp4_ = FALSE;
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			PuzzleView* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->view;
			_tmp9_ = puzzle_view_get_tile_selected (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			tetravex_finish_cb (self);
		}
	}
}

static void
tetravex_move_right_l (Tetravex* self)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_move_right (_tmp0_, TRUE);
}

static void
tetravex_move_up_r (Tetravex* self)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_move_up (_tmp0_, FALSE);
}

static void
tetravex_move_down_r (Tetravex* self)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_move_down (_tmp0_, FALSE);
}

static void
tetravex_move_left_r (Tetravex* self)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_move_left (_tmp0_, FALSE);
}

static void
tetravex_move_right_r (Tetravex* self)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_move_right (_tmp0_, FALSE);
}

static void
tetravex_undo_cb (Tetravex* self)
{
	PuzzleView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = puzzle_view_get_tile_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PuzzleView* _tmp3_;
		_tmp3_ = self->priv->view;
		puzzle_view_release_selected_tile (_tmp3_);
	} else {
		PuzzleView* _tmp4_;
		_tmp4_ = self->priv->view;
		puzzle_view_undo (_tmp4_);
	}
}

static void
tetravex_redo_cb (Tetravex* self)
{
	PuzzleView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = puzzle_view_get_tile_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PuzzleView* _tmp3_;
		_tmp3_ = self->priv->view;
		puzzle_view_release_selected_tile (_tmp3_);
	} else {
		PuzzleView* _tmp4_;
		_tmp4_ = self->priv->view;
		puzzle_view_redo (_tmp4_);
	}
}

static void
tetravex_reload_cb (Tetravex* self)
{
	PuzzleView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = puzzle_view_get_tile_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PuzzleView* _tmp3_;
		_tmp3_ = self->priv->view;
		puzzle_view_release_selected_tile (_tmp3_);
	} else {
		PuzzleView* _tmp4_;
		_tmp4_ = self->priv->view;
		puzzle_view_reload (_tmp4_);
	}
}

static void
tetravex_pause_cb (Tetravex* self)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Puzzle* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GSimpleAction* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Puzzle* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GSimpleAction* _tmp27_;
	Puzzle* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = self->priv->puzzle;
	_tmp2_ = puzzle_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	puzzle_set_paused (_tmp0_, !_tmp3_);
	_tmp6_ = self->priv->puzzle;
	_tmp7_ = puzzle_get_can_undo (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		Puzzle* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->puzzle;
		_tmp10_ = puzzle_get_is_solved (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !_tmp11_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Puzzle* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = self->priv->puzzle;
		_tmp13_ = puzzle_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp4_ = !_tmp14_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp15_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp15_, _tmp4_);
	_tmp18_ = self->priv->puzzle;
	_tmp19_ = puzzle_get_can_redo (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		Puzzle* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->priv->puzzle;
		_tmp22_ = puzzle_get_is_solved (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = !_tmp23_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		Puzzle* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = self->priv->puzzle;
		_tmp25_ = puzzle_get_paused (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp16_ = !_tmp26_;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp27_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp27_, _tmp16_);
	tetravex_update_bottom_button_states (self);
	_tmp28_ = self->priv->puzzle;
	_tmp29_ = puzzle_get_paused (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		GtkButton* _tmp31_;
		_tmp31_ = self->priv->pause_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp31_);
	} else {
		PuzzleView* _tmp32_;
		_tmp32_ = self->priv->view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp32_);
	}
}

static void
tetravex_update_bottom_button_states (Tetravex* self)
{
	Puzzle* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp21_ = NULL;
	Puzzle* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GtkStack* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = puzzle_get_is_solved_right (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		gboolean _tmp4_ = FALSE;
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		GSimpleAction* _tmp11_;
		_tmp3_ = self->priv->solve_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			PuzzleView* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->view;
			_tmp9_ = puzzle_view_get_tile_selected (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp11_ = self->priv->finish_action;
		g_simple_action_set_enabled (_tmp11_, _tmp4_);
	} else {
		gboolean _tmp12_ = FALSE;
		Puzzle* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		GSimpleAction* _tmp19_;
		GSimpleAction* _tmp20_;
		_tmp13_ = self->priv->puzzle;
		_tmp14_ = puzzle_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		if (!_tmp15_) {
			PuzzleView* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = self->priv->view;
			_tmp17_ = puzzle_view_get_tile_selected (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = !_tmp18_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp19_ = self->priv->solve_action;
		g_simple_action_set_enabled (_tmp19_, _tmp12_);
		_tmp20_ = self->priv->finish_action;
		g_simple_action_set_enabled (_tmp20_, FALSE);
	}
	_tmp22_ = self->priv->puzzle;
	_tmp23_ = puzzle_get_paused (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		_tmp21_ = "play";
	} else {
		_tmp21_ = "pause";
	}
	_tmp25_ = self->priv->play_pause_stack;
	gtk_stack_set_visible_child_name (_tmp25_, _tmp21_);
}

static inline gboolean
tetravex_on_key_pressed (Tetravex* self,
                         GtkEventControllerKey* _key_controller,
                         guint keyval,
                         guint keycode,
                         GdkModifierType state)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	name = _tmp2_;
	_tmp4_ = name;
	if (g_strcmp0 (_tmp4_, "Escape") == 0) {
		Puzzle* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->puzzle;
		_tmp6_ = puzzle_get_is_solved (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = !_tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Puzzle* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->puzzle;
		_tmp9_ = puzzle_get_paused (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			tetravex_pause_cb (self);
			result = TRUE;
			_g_free0 (name);
			return result;
		} else {
			PuzzleView* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = self->priv->view;
			_tmp12_ = puzzle_view_get_tile_selected (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_) {
				PuzzleView* _tmp14_;
				_tmp14_ = self->priv->view;
				puzzle_view_release_selected_tile (_tmp14_);
				result = TRUE;
				_g_free0 (name);
				return result;
			}
		}
	} else {
		const gchar* _tmp15_;
		_tmp15_ = name;
		if (g_strcmp0 (_tmp15_, "F1") == 0) {
			result = tetravex_on_f1_pressed (self, state);
			_g_free0 (name);
			return result;
		}
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static inline void
tetravex_on_new_game_button_click (Tetravex* self,
                                   GtkGestureMultiPress* _new_game_button_click_controller,
                                   gint n_press,
                                   gdouble event_x,
                                   gdouble event_y)
{
	PuzzleView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_new_game_button_click_controller != NULL);
	_tmp0_ = self->priv->view;
	puzzle_view_disable_highlight (_tmp0_);
}

static inline void
tetravex_on_release_on_view (Tetravex* self,
                             GtkGestureMultiPress* _view_click_controller,
                             gint n_press,
                             gdouble event_x,
                             gdouble event_y)
{
	Puzzle* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_view_click_controller != NULL);
	_tmp0_ = self->priv->puzzle;
	_tmp1_ = puzzle_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Puzzle* _tmp3_;
		_tmp3_ = self->priv->puzzle;
		puzzle_set_paused (_tmp3_, FALSE);
		tetravex_update_bottom_button_states (self);
	}
}

static gboolean
tetravex_on_f1_pressed (Tetravex* self,
                        GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((state & GDK_CONTROL_MASK) != 0) {
		result = FALSE;
		return result;
	}
	if ((state & GDK_SHIFT_MASK) == 0) {
		tetravex_help_cb (self);
		result = TRUE;
		return result;
	}
	tetravex_about_cb (self);
	result = TRUE;
	return result;
}

static void
tetravex_hamburger_cb (Tetravex* self)
{
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hamburger_button;
	_tmp1_ = self->priv->hamburger_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, !_tmp3_);
}

static void
tetravex_help_cb (Tetravex* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkApplicationWindow* _tmp0_;
		_tmp0_ = self->priv->window;
		gtk_show_uri_on_window ((GtkWindow*) _tmp0_, "help:gnome-tetravex", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gnome-tetravex.vala:1022: Failed to show help: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
tetravex_about_cb (Tetravex* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint authors_length1;
	gint _authors_size_;
	gchar** documenters = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint documenters_length1;
	gint _documenters_size_;
	gchar* comments = NULL;
	gchar* _tmp5_;
	gchar* copyright = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* website_label = NULL;
	gchar* _tmp14_;
	GtkApplicationWindow* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Lars Rydlinge"));
	_tmp1_ = g_strdup (_ ("Robert Ancell"));
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup (_ ("Rob Bradford"));
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	documenters = _tmp4_;
	documenters_length1 = 1;
	_documenters_size_ = documenters_length1;
	_tmp5_ = g_strdup (_ ("Position pieces so that the same numbers are touching each other"));
	comments = _tmp5_;
	_tmp6_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Lars Rydlinge"), (guint) 1999, (guint) 2008);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2019, (guint) 2020);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	copyright = _tmp13_;
	_tmp14_ = g_strdup (_ ("Page on GNOME wiki"));
	website_label = _tmp14_;
	_tmp15_ = self->priv->window;
	gtk_show_about_dialog ((GtkWindow*) _tmp15_, "program-name", TETRAVEX_PROGRAM_NAME, "version", VERSION, "comments", comments, "copyright", copyright, "license-type", GTK_LICENSE_GPL_2_0, "wrap-license", TRUE, "authors", authors, "documenters", documenters, "translator-credits", _ ("translator-credits"), "logo-icon-name", "org.gnome.Tetravex", "website", "https://gitlab.gnome.org/GNOME/gnome-tetravex", "website-label", website_label, NULL, NULL);
	_g_free0 (website_label);
	_g_free0 (copyright);
	_g_free0 (comments);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static TetravexBottomButton*
tetravex_bottom_button_construct (GType object_type,
                                  const gchar* icon_name,
                                  const gchar* action_name,
                                  const gchar* tooltip_text,
                                  gboolean align_end,
                                  GtkSizeGroup* sizegroup)
{
	TetravexBottomButton * self = NULL;
	GtkImage* _image = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkAlign _tmp2_ = 0;
	GtkImage* _tmp3_;
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	g_return_val_if_fail (tooltip_text != NULL, NULL);
	g_return_val_if_fail (sizegroup != NULL, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name, (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp0_);
	_image = _tmp0_;
	_tmp1_ = _image;
	g_object_set ((GtkWidget*) _tmp1_, "margin", 10, NULL);
	if (align_end) {
		_tmp2_ = GTK_ALIGN_END;
	} else {
		_tmp2_ = GTK_ALIGN_START;
	}
	_tmp3_ = _image;
	self = (TetravexBottomButton*) g_object_new (object_type, "action-name", action_name, "tooltip-text", tooltip_text, "halign", _tmp2_, "valign", GTK_ALIGN_CENTER, "margin-start", 35, "margin-end", 35, "image", _tmp3_, "focus-on-click", FALSE, "visible", TRUE, NULL);
	gtk_size_group_add_widget (sizegroup, (GtkWidget*) self);
	_g_object_unref0 (_image);
	return self;
}

static TetravexBottomButton*
tetravex_bottom_button_new (const gchar* icon_name,
                            const gchar* action_name,
                            const gchar* tooltip_text,
                            gboolean align_end,
                            GtkSizeGroup* sizegroup)
{
	return tetravex_bottom_button_construct (TETRAVEX_TYPE_BOTTOM_BUTTON, icon_name, action_name, tooltip_text, align_end, sizegroup);
}

static GObject *
tetravex_bottom_button_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TetravexBottomButton * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (tetravex_bottom_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TETRAVEX_TYPE_BOTTOM_BUTTON, TetravexBottomButton);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "image-button");
	return obj;
}

static void
tetravex_bottom_button_class_init (TetravexBottomButtonClass * klass,
                                   gpointer klass_data)
{
	tetravex_bottom_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = tetravex_bottom_button_constructor;
}

static void
tetravex_bottom_button_instance_init (TetravexBottomButton * self,
                                      gpointer klass)
{
}

static GType
tetravex_bottom_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TetravexBottomButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tetravex_bottom_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TetravexBottomButton), 0, (GInstanceInitFunc) tetravex_bottom_button_instance_init, NULL };
	GType tetravex_bottom_button_type_id;
	tetravex_bottom_button_type_id = g_type_register_static (gtk_button_get_type (), "TetravexBottomButton", &g_define_type_info, 0);
	return tetravex_bottom_button_type_id;
}

static GType
tetravex_bottom_button_get_type (void)
{
	static volatile gsize tetravex_bottom_button_type_id__once = 0;
	if (g_once_init_enter (&tetravex_bottom_button_type_id__once)) {
		GType tetravex_bottom_button_type_id;
		tetravex_bottom_button_type_id = tetravex_bottom_button_get_type_once ();
		g_once_init_leave (&tetravex_bottom_button_type_id__once, tetravex_bottom_button_type_id);
	}
	return tetravex_bottom_button_type_id__once;
}

static void
tetravex_class_init (TetravexClass * klass,
                     gpointer klass_data)
{
	gchar** _tmp0_;
	tetravex_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Tetravex_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) tetravex_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) tetravex_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) tetravex_real_shutdown;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) tetravex_real_activate;
	G_OBJECT_CLASS (klass)->finalize = tetravex_finalize;
	_tmp0_ = g_new0 (gchar*, 1 + 1);
	tetravex_remaining = _tmp0_;
	tetravex_remaining_length1 = 1;
	_tetravex_remaining_size_ = tetravex_remaining_length1;
}

static void
tetravex_instance_init (Tetravex * self,
                        gpointer klass)
{
	self->priv = tetravex_get_instance_private (self);
	self->priv->puzzle_init_done = FALSE;
	self->priv->can_restore = FALSE;
	self->priv->restore_stack_created = FALSE;
	self->priv->puzzle_is_finished = FALSE;
	self->priv->last_history_entry = NULL;
	self->priv->scores_dialog_visible = FALSE;
	self->priv->has_been_solved = FALSE;
	self->priv->has_been_finished = FALSE;
}

static void
tetravex_finalize (GObject * obj)
{
	Tetravex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TETRAVEX, Tetravex);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->puzzle);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->clock_box);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->new_game_solve_stack);
	_g_object_unref0 (self->priv->play_pause_stack);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->solve_action);
	_g_object_unref0 (self->priv->finish_action);
	_g_object_unref0 (self->priv->score_overlay);
	_g_object_unref0 (self->priv->hamburger_button);
	_g_object_unref0 (self->priv->restore_stack);
	_g_variant_unref0 (self->priv->saved_game);
	_g_object_unref0 (self->priv->last_history_entry);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->new_game_button_click_controller);
	_g_object_unref0 (self->priv->view_click_controller);
	G_OBJECT_CLASS (tetravex_parent_class)->finalize (obj);
}

static GType
tetravex_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TetravexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tetravex_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tetravex), 0, (GInstanceInitFunc) tetravex_instance_init, NULL };
	GType tetravex_type_id;
	tetravex_type_id = g_type_register_static (gtk_application_get_type (), "Tetravex", &g_define_type_info, 0);
	Tetravex_private_offset = g_type_add_instance_private (tetravex_type_id, sizeof (TetravexPrivate));
	return tetravex_type_id;
}

GType
tetravex_get_type (void)
{
	static volatile gsize tetravex_type_id__once = 0;
	if (g_once_init_enter (&tetravex_type_id__once)) {
		GType tetravex_type_id;
		tetravex_type_id = tetravex_get_type_once ();
		g_once_init_leave (&tetravex_type_id__once, tetravex_type_id);
	}
	return tetravex_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

