/* cli.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from cli.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <errno.h>

#define KEY_GRID_SIZE "grid-size"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	DIRECTION_NONE,
	DIRECTION_UP,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_RIGHT
} Direction;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	guint8 north;
	guint8 west;
	guint8 east;
	guint8 south;
};

struct _TileClass {
	GObjectClass parent_class;
};

VALA_EXTERN GType puzzle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Puzzle, g_object_unref)
VALA_EXTERN gint cli_play_cli (const gchar* cli,
                   const gchar* schema_name,
                   GSettings** settings,
                   GVariant** saved_game,
                   gboolean* can_restore,
                   Puzzle** puzzle,
                   gint* colors,
                   gint* game_size);
VALA_EXTERN gboolean puzzle_is_valid_saved_game (GVariant* maybe_variant,
                                     gboolean restore_finished_game);
VALA_EXTERN Puzzle* puzzle_new (guint8 size,
                    guint8 colors);
VALA_EXTERN Puzzle* puzzle_construct (GType object_type,
                          guint8 size,
                          guint8 colors);
VALA_EXTERN Puzzle* puzzle_new_restore (GVariant* maybe_variant);
VALA_EXTERN Puzzle* puzzle_construct_restore (GType object_type,
                                  GVariant* maybe_variant);
VALA_EXTERN guint8 puzzle_get_size (Puzzle* self);
VALA_EXTERN void cli_print_board (Puzzle* puzzle,
                      guint8 size);
VALA_EXTERN GType direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean cli_cli_move_tiles (Puzzle* puzzle,
                             gboolean new_puzzle,
                             gboolean left_board,
                             Direction direction,
                             const gchar* warning_string);
VALA_EXTERN gboolean puzzle_get_is_solved (Puzzle* self);
VALA_EXTERN void cli_puzzle_is_solved_message (gboolean alternative_message);
VALA_EXTERN gboolean puzzle_get_is_solved_right (Puzzle* self);
VALA_EXTERN void puzzle_finish (Puzzle* self,
                    guint duration);
VALA_EXTERN gboolean puzzle_move_last_tile_if_possible (Puzzle* self);
VALA_EXTERN void puzzle_solve (Puzzle* self);
VALA_EXTERN gboolean cli_parse_cli (const gchar* cli,
                        guint8 size,
                        guint8* tile_1_x,
                        guint8* tile_1_y,
                        guint8* tile_2_x,
                        guint8* tile_2_y);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN Tile* puzzle_get_tile (Puzzle* self,
                       guint8 x,
                       guint8 y);
VALA_EXTERN gboolean puzzle_can_switch (Puzzle* self,
                            guint8 x0,
                            guint8 y0,
                            guint8 x1,
                            guint8 y1);
VALA_EXTERN void puzzle_switch_tiles (Puzzle* self,
                          guint8 x0,
                          guint8 y0,
                          guint8 x1,
                          guint8 y1,
                          guint delay_if_finished);
VALA_EXTERN GVariant* puzzle_to_variant (Puzzle* self,
                             gboolean save_time);
VALA_EXTERN gboolean puzzle_move_up (Puzzle* self,
                         gboolean left_board);
VALA_EXTERN gboolean puzzle_move_down (Puzzle* self,
                           gboolean left_board);
VALA_EXTERN gboolean puzzle_move_left (Puzzle* self,
                           gboolean left_board);
VALA_EXTERN gboolean puzzle_move_right (Puzzle* self,
                            gboolean left_board);
VALA_EXTERN gboolean cli_is_valid_column (gchar column_char,
                              guint8 size,
                              guint8* column);

gint
cli_play_cli (const gchar* cli,
              const gchar* schema_name,
              GSettings** settings,
              GVariant** saved_game,
              gboolean* can_restore,
              Puzzle** puzzle,
              gint* colors,
              gint* game_size)
{
	GSettings* _vala_settings = NULL;
	GVariant* _vala_saved_game = NULL;
	gboolean _vala_can_restore = FALSE;
	Puzzle* _vala_puzzle = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	guint8 size = 0U;
	gboolean new_puzzle = FALSE;
	const gchar* _tmp21_;
	GQuark _tmp23_ = 0U;
	static GQuark _tmp22_label0 = 0;
	static GQuark _tmp22_label1 = 0;
	static GQuark _tmp22_label2 = 0;
	static GQuark _tmp22_label3 = 0;
	static GQuark _tmp22_label4 = 0;
	static GQuark _tmp22_label5 = 0;
	static GQuark _tmp22_label6 = 0;
	static GQuark _tmp22_label7 = 0;
	static GQuark _tmp22_label8 = 0;
	static GQuark _tmp22_label9 = 0;
	static GQuark _tmp22_label10 = 0;
	static GQuark _tmp22_label11 = 0;
	static GQuark _tmp22_label12 = 0;
	static GQuark _tmp22_label13 = 0;
	static GQuark _tmp22_label14 = 0;
	static GQuark _tmp22_label15 = 0;
	static GQuark _tmp22_label16 = 0;
	static GQuark _tmp22_label17 = 0;
	static GQuark _tmp22_label18 = 0;
	static GQuark _tmp22_label19 = 0;
	static GQuark _tmp22_label20 = 0;
	Puzzle* _tmp75_;
	GSettings* _tmp76_;
	Puzzle* _tmp77_;
	GVariant* _tmp78_;
	GVariant* _tmp79_;
	gint result;
	g_return_val_if_fail (cli != NULL, 0);
	g_return_val_if_fail (schema_name != NULL, 0);
	_tmp0_ = g_settings_new (schema_name);
	_g_object_unref0 (_vala_settings);
	_vala_settings = _tmp0_;
	_tmp1_ = _vala_settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "saved-game");
	_g_variant_unref0 (_vala_saved_game);
	_vala_saved_game = _tmp2_;
	_tmp3_ = _vala_saved_game;
	_vala_can_restore = puzzle_is_valid_saved_game (_tmp3_, TRUE);
	if ((*game_size) != G_MININT) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = (*colors) != 10;
	}
	if (_tmp5_) {
		_tmp4_ = g_strcmp0 (cli, "new") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		Puzzle* _tmp8_;
		_tmp6_ = g_strconcat (_ ("Game size and colors number can only be given for new puzzles."), "\n", NULL);
		_tmp7_ = _tmp6_;
		g_warning ("cli.vala:35: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = puzzle_new ((guint8) 2, (guint8) 10);
		_g_object_unref0 (_vala_puzzle);
		_vala_puzzle = _tmp8_;
		result = EXIT_FAILURE;
		if (settings) {
			*settings = _vala_settings;
		} else {
			_g_object_unref0 (_vala_settings);
		}
		if (saved_game) {
			*saved_game = _vala_saved_game;
		} else {
			_g_variant_unref0 (_vala_saved_game);
		}
		if (can_restore) {
			*can_restore = _vala_can_restore;
		}
		if (puzzle) {
			*puzzle = _vala_puzzle;
		} else {
			_g_object_unref0 (_vala_puzzle);
		}
		return result;
	}
	if ((*game_size) != G_MININT) {
		GSettings* _tmp9_;
		Puzzle* _tmp10_;
		_tmp9_ = _vala_settings;
		g_settings_set_int (_tmp9_, KEY_GRID_SIZE, *game_size);
		size = (guint8) (*game_size);
		_tmp10_ = puzzle_new (size, (guint8) (*colors));
		_g_object_unref0 (_vala_puzzle);
		_vala_puzzle = _tmp10_;
		new_puzzle = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		if ((*colors) != 10) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = g_strcmp0 (cli, "new") == 0;
		}
		if (_tmp11_) {
			GSettings* _tmp12_;
			Puzzle* _tmp13_;
			_tmp12_ = _vala_settings;
			size = (guint8) g_settings_get_int (_tmp12_, KEY_GRID_SIZE);
			_tmp13_ = puzzle_new (size, (guint8) (*colors));
			_g_object_unref0 (_vala_puzzle);
			_vala_puzzle = _tmp13_;
			new_puzzle = TRUE;
		} else {
			if (_vala_can_restore) {
				GVariant* _tmp14_;
				Puzzle* _tmp15_;
				Puzzle* _tmp16_;
				guint8 _tmp17_;
				guint8 _tmp18_;
				_tmp14_ = _vala_saved_game;
				_tmp15_ = puzzle_new_restore ((GVariant*) _tmp14_);
				_g_object_unref0 (_vala_puzzle);
				_vala_puzzle = _tmp15_;
				_tmp16_ = _vala_puzzle;
				_tmp17_ = puzzle_get_size (_tmp16_);
				_tmp18_ = _tmp17_;
				size = _tmp18_;
				new_puzzle = FALSE;
			} else {
				GSettings* _tmp19_;
				Puzzle* _tmp20_;
				_tmp19_ = _vala_settings;
				size = (guint8) g_settings_get_int (_tmp19_, KEY_GRID_SIZE);
				_tmp20_ = puzzle_new (size, (guint8) 10);
				_g_object_unref0 (_vala_puzzle);
				_vala_puzzle = _tmp20_;
				new_puzzle = TRUE;
			}
		}
	}
	_tmp21_ = cli;
	_tmp23_ = (NULL == _tmp21_) ? 0 : g_quark_from_string (_tmp21_);
	if ((_tmp23_ == ((0 != _tmp22_label0) ? _tmp22_label0 : (_tmp22_label0 = g_quark_from_static_string ("help")))) || (_tmp23_ == ((0 != _tmp22_label1) ? _tmp22_label1 : (_tmp22_label1 = g_quark_from_static_string ("HELP"))))) {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	} else if (((_tmp23_ == ((0 != _tmp22_label2) ? _tmp22_label2 : (_tmp22_label2 = g_quark_from_static_string ("")))) || (_tmp23_ == ((0 != _tmp22_label3) ? _tmp22_label3 : (_tmp22_label3 = g_quark_from_static_string ("show"))))) || (_tmp23_ == ((0 != _tmp22_label4) ? _tmp22_label4 : (_tmp22_label4 = g_quark_from_static_string ("status"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp24_;
				if (new_puzzle) {
					break;
				}
				_tmp24_ = _vala_puzzle;
				cli_print_board (_tmp24_, size);
				result = EXIT_SUCCESS;
				if (settings) {
					*settings = _vala_settings;
				} else {
					_g_object_unref0 (_vala_settings);
				}
				if (saved_game) {
					*saved_game = _vala_saved_game;
				} else {
					_g_variant_unref0 (_vala_saved_game);
				}
				if (can_restore) {
					*can_restore = _vala_can_restore;
				}
				if (puzzle) {
					*puzzle = _vala_puzzle;
				} else {
					_g_object_unref0 (_vala_puzzle);
				}
				return result;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label5) ? _tmp22_label5 : (_tmp22_label5 = g_quark_from_static_string ("new")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp23_ == ((0 != _tmp22_label6) ? _tmp22_label6 : (_tmp22_label6 = g_quark_from_static_string ("up")))) || (_tmp23_ == ((0 != _tmp22_label7) ? _tmp22_label7 : (_tmp22_label7 = g_quark_from_static_string ("l-up"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp25_;
				_tmp25_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp25_, new_puzzle, TRUE, DIRECTION_UP, _ ("Cannot move up left-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if ((_tmp23_ == ((0 != _tmp22_label8) ? _tmp22_label8 : (_tmp22_label8 = g_quark_from_static_string ("down")))) || (_tmp23_ == ((0 != _tmp22_label9) ? _tmp22_label9 : (_tmp22_label9 = g_quark_from_static_string ("l-down"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp26_;
				_tmp26_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp26_, new_puzzle, TRUE, DIRECTION_DOWN, _ ("Cannot move down left-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if ((_tmp23_ == ((0 != _tmp22_label10) ? _tmp22_label10 : (_tmp22_label10 = g_quark_from_static_string ("left")))) || (_tmp23_ == ((0 != _tmp22_label11) ? _tmp22_label11 : (_tmp22_label11 = g_quark_from_static_string ("l-left"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp27_;
				_tmp27_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp27_, new_puzzle, TRUE, DIRECTION_LEFT, _ ("Cannot move left left-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if ((_tmp23_ == ((0 != _tmp22_label12) ? _tmp22_label12 : (_tmp22_label12 = g_quark_from_static_string ("right")))) || (_tmp23_ == ((0 != _tmp22_label13) ? _tmp22_label13 : (_tmp22_label13 = g_quark_from_static_string ("l-right"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp28_;
				_tmp28_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp28_, new_puzzle, TRUE, DIRECTION_RIGHT, _ ("Cannot move right left-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label14) ? _tmp22_label14 : (_tmp22_label14 = g_quark_from_static_string ("r-up")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp29_;
				_tmp29_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp29_, new_puzzle, FALSE, DIRECTION_UP, _ ("Cannot move up right-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label15) ? _tmp22_label15 : (_tmp22_label15 = g_quark_from_static_string ("r-down")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp30_;
				_tmp30_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp30_, new_puzzle, FALSE, DIRECTION_DOWN, _ ("Cannot move down right-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label16) ? _tmp22_label16 : (_tmp22_label16 = g_quark_from_static_string ("r-left")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp31_;
				_tmp31_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp31_, new_puzzle, FALSE, DIRECTION_LEFT, _ ("Cannot move left right-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label17) ? _tmp22_label17 : (_tmp22_label17 = g_quark_from_static_string ("r-right")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp32_;
				_tmp32_ = _vala_puzzle;
				if (!cli_cli_move_tiles (_tmp32_, new_puzzle, FALSE, DIRECTION_RIGHT, _ ("Cannot move right right-board tiles."))) {
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				break;
			}
		}
	} else if ((_tmp23_ == ((0 != _tmp22_label18) ? _tmp22_label18 : (_tmp22_label18 = g_quark_from_static_string ("end")))) || (_tmp23_ == ((0 != _tmp22_label19) ? _tmp22_label19 : (_tmp22_label19 = g_quark_from_static_string ("finish"))))) {
		switch (0) {
			default:
			{
				gboolean _tmp33_ = FALSE;
				Puzzle* _tmp37_;
				gboolean _tmp38_;
				gboolean _tmp39_;
				if (new_puzzle) {
					_tmp33_ = TRUE;
				} else {
					Puzzle* _tmp34_;
					gboolean _tmp35_;
					gboolean _tmp36_;
					_tmp34_ = _vala_puzzle;
					_tmp35_ = puzzle_get_is_solved (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp33_ = _tmp36_;
				}
				if (_tmp33_) {
					cli_puzzle_is_solved_message (TRUE);
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				_tmp37_ = _vala_puzzle;
				_tmp38_ = puzzle_get_is_solved_right (_tmp37_);
				_tmp39_ = _tmp38_;
				if (_tmp39_) {
					Puzzle* _tmp40_;
					_tmp40_ = _vala_puzzle;
					puzzle_finish (_tmp40_, (guint) 0);
				} else {
					Puzzle* _tmp41_;
					_tmp41_ = _vala_puzzle;
					if (!puzzle_move_last_tile_if_possible (_tmp41_)) {
						gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp42_ = g_strconcat (_ ("Cannot finish automatically. If you want to give up and view the solut" \
"ion, use “solve”."), "\n", NULL);
						_tmp43_ = _tmp42_;
						g_warning ("cli.vala:145: %s", _tmp43_);
						_g_free0 (_tmp43_);
						result = EXIT_FAILURE;
						if (settings) {
							*settings = _vala_settings;
						} else {
							_g_object_unref0 (_vala_settings);
						}
						if (saved_game) {
							*saved_game = _vala_saved_game;
						} else {
							_g_variant_unref0 (_vala_saved_game);
						}
						if (can_restore) {
							*can_restore = _vala_can_restore;
						}
						if (puzzle) {
							*puzzle = _vala_puzzle;
						} else {
							_g_object_unref0 (_vala_puzzle);
						}
						return result;
					}
				}
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label20) ? _tmp22_label20 : (_tmp22_label20 = g_quark_from_static_string ("solve")))) {
		switch (0) {
			default:
			{
				gboolean _tmp44_ = FALSE;
				Puzzle* _tmp48_;
				if (new_puzzle) {
					_tmp44_ = TRUE;
				} else {
					Puzzle* _tmp45_;
					gboolean _tmp46_;
					gboolean _tmp47_;
					_tmp45_ = _vala_puzzle;
					_tmp46_ = puzzle_get_is_solved (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp44_ = _tmp47_;
				}
				if (_tmp44_) {
					cli_puzzle_is_solved_message (TRUE);
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				_tmp48_ = _vala_puzzle;
				puzzle_solve (_tmp48_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gboolean _tmp49_ = FALSE;
				guint8 tile_1_x = 0U;
				guint8 tile_1_y = 0U;
				guint8 tile_2_x = 0U;
				guint8 tile_2_y = 0U;
				guint8 _tmp53_ = 0U;
				guint8 _tmp54_ = 0U;
				guint8 _tmp55_ = 0U;
				guint8 _tmp56_ = 0U;
				gboolean _tmp57_;
				gboolean _tmp60_ = FALSE;
				Puzzle* _tmp61_;
				Tile* _tmp62_;
				Tile* _tmp63_;
				gboolean _tmp64_;
				Puzzle* _tmp70_;
				Puzzle* _tmp74_;
				if (new_puzzle) {
					_tmp49_ = TRUE;
				} else {
					Puzzle* _tmp50_;
					gboolean _tmp51_;
					gboolean _tmp52_;
					_tmp50_ = _vala_puzzle;
					_tmp51_ = puzzle_get_is_solved (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp49_ = _tmp52_;
				}
				if (_tmp49_) {
					cli_puzzle_is_solved_message (FALSE);
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				_tmp57_ = cli_parse_cli (cli, size, &_tmp53_, &_tmp54_, &_tmp55_, &_tmp56_);
				tile_1_x = _tmp53_;
				tile_1_y = _tmp54_;
				tile_2_x = _tmp55_;
				tile_2_y = _tmp56_;
				if (!_tmp57_) {
					gchar* _tmp58_;
					gchar* _tmp59_;
					_tmp58_ = g_strconcat (_ ("Cannot parse instruction, aborting."), "\n", NULL);
					_tmp59_ = _tmp58_;
					g_warning ("cli.vala:174: %s", _tmp59_);
					_g_free0 (_tmp59_);
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				_tmp61_ = _vala_puzzle;
				_tmp62_ = puzzle_get_tile (_tmp61_, tile_1_x, tile_1_y);
				_tmp63_ = _tmp62_;
				_tmp64_ = _tmp63_ == NULL;
				_g_object_unref0 (_tmp63_);
				if (_tmp64_) {
					Puzzle* _tmp65_;
					Tile* _tmp66_;
					Tile* _tmp67_;
					_tmp65_ = _vala_puzzle;
					_tmp66_ = puzzle_get_tile (_tmp65_, tile_2_x, tile_2_y);
					_tmp67_ = _tmp66_;
					_tmp60_ = _tmp67_ == NULL;
					_g_object_unref0 (_tmp67_);
				} else {
					_tmp60_ = FALSE;
				}
				if (_tmp60_) {
					gchar* _tmp68_;
					gchar* _tmp69_;
					_tmp68_ = g_strconcat (_ ("Both given tiles are empty, aborting."), "\n", NULL);
					_tmp69_ = _tmp68_;
					g_warning ("cli.vala:181: %s", _tmp69_);
					_g_free0 (_tmp69_);
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				_tmp70_ = _vala_puzzle;
				if (!puzzle_can_switch (_tmp70_, tile_1_x, tile_1_y, tile_2_x, tile_2_y)) {
					gchar* _tmp71_;
					gchar* _tmp72_;
					Puzzle* _tmp73_;
					_tmp71_ = g_strconcat (_ ("Cannot swap the given tiles, aborting."), "\n", NULL);
					_tmp72_ = _tmp71_;
					g_warning ("cli.vala:187: %s", _tmp72_);
					_g_free0 (_tmp72_);
					_tmp73_ = _vala_puzzle;
					cli_print_board (_tmp73_, size);
					result = EXIT_FAILURE;
					if (settings) {
						*settings = _vala_settings;
					} else {
						_g_object_unref0 (_vala_settings);
					}
					if (saved_game) {
						*saved_game = _vala_saved_game;
					} else {
						_g_variant_unref0 (_vala_saved_game);
					}
					if (can_restore) {
						*can_restore = _vala_can_restore;
					}
					if (puzzle) {
						*puzzle = _vala_puzzle;
					} else {
						_g_object_unref0 (_vala_puzzle);
					}
					return result;
				}
				_tmp74_ = _vala_puzzle;
				puzzle_switch_tiles (_tmp74_, tile_1_x, tile_1_y, tile_2_x, tile_2_y, (guint) 0);
				break;
			}
		}
	}
	_tmp75_ = _vala_puzzle;
	cli_print_board (_tmp75_, size);
	_tmp76_ = _vala_settings;
	_tmp77_ = _vala_puzzle;
	_tmp78_ = puzzle_to_variant (_tmp77_, FALSE);
	_tmp79_ = _tmp78_;
	g_settings_set_value (_tmp76_, "saved-game", _tmp79_);
	_g_variant_unref0 (_tmp79_);
	result = EXIT_SUCCESS;
	if (settings) {
		*settings = _vala_settings;
	} else {
		_g_object_unref0 (_vala_settings);
	}
	if (saved_game) {
		*saved_game = _vala_saved_game;
	} else {
		_g_variant_unref0 (_vala_saved_game);
	}
	if (can_restore) {
		*can_restore = _vala_can_restore;
	}
	if (puzzle) {
		*puzzle = _vala_puzzle;
	} else {
		_g_object_unref0 (_vala_puzzle);
	}
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
cli_cli_move_tiles (Puzzle* puzzle,
                    gboolean new_puzzle,
                    gboolean left_board,
                    Direction direction,
                    const gchar* warning_string)
{
	gboolean _tmp0_ = FALSE;
	gboolean success = FALSE;
	gboolean result;
	g_return_val_if_fail (puzzle != NULL, FALSE);
	g_return_val_if_fail (warning_string != NULL, FALSE);
	if (new_puzzle) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = puzzle_get_is_solved (puzzle);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		cli_puzzle_is_solved_message (FALSE);
		result = FALSE;
		return result;
	}
	switch (direction) {
		case DIRECTION_UP:
		{
			success = puzzle_move_up (puzzle, left_board);
			break;
		}
		case DIRECTION_DOWN:
		{
			success = puzzle_move_down (puzzle, left_board);
			break;
		}
		case DIRECTION_LEFT:
		{
			success = puzzle_move_left (puzzle, left_board);
			break;
		}
		case DIRECTION_RIGHT:
		{
			success = puzzle_move_right (puzzle, left_board);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	if (!success) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = string_to_string (warning_string);
		_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
		_tmp5_ = _tmp4_;
		g_warning ("cli.vala:220: %s", _tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

void
cli_puzzle_is_solved_message (gboolean alternative_message)
{
	if (alternative_message) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strconcat (_ ("Puzzle is already solved! If you want to start a new one, use “new”."), "\n", NULL);
		_tmp1_ = _tmp0_;
		g_warning ("cli.vala:230: %s", _tmp1_);
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strconcat (_ ("Puzzle is solved! If you want to start a new one, use “new”."), "\n", NULL);
		_tmp3_ = _tmp2_;
		g_warning ("cli.vala:233: %s", _tmp3_);
		_g_free0 (_tmp3_);
	}
}

void
cli_print_board (Puzzle* puzzle,
                 guint8 size)
{
	FILE* _tmp0_;
	FILE* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	g_return_if_fail (puzzle != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "\n");
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FILE* _tmp15_;
				FILE* _tmp31_;
				FILE* _tmp44_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = y;
					y = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(y < size)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							Tile* tile = NULL;
							Tile* _tmp5_;
							Tile* _tmp6_;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = x;
								x = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(((gint) x) < (2 * size))) {
								break;
							}
							_tmp5_ = puzzle_get_tile (puzzle, x, y);
							tile = _tmp5_;
							_tmp6_ = tile;
							if (_tmp6_ == NULL) {
								FILE* _tmp7_;
								_tmp7_ = stdout;
								fprintf (_tmp7_, " ╭╴ ╶╮");
							} else {
								FILE* _tmp8_;
								Tile* _tmp9_;
								gchar* _tmp10_;
								gchar* _tmp11_;
								gchar* _tmp12_;
								gchar* _tmp13_;
								_tmp8_ = stdout;
								_tmp9_ = tile;
								_tmp10_ = g_strdup_printf ("%hhu", G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TILE, Tile)->north);
								_tmp11_ = _tmp10_;
								_tmp12_ = g_strconcat (" ┌╴", _tmp11_, "╶┐", NULL);
								_tmp13_ = _tmp12_;
								fprintf (_tmp8_, "%s", _tmp13_);
								_g_free0 (_tmp13_);
								_g_free0 (_tmp11_);
							}
							if (((gint) x) == (size - 1)) {
								FILE* _tmp14_;
								_tmp14_ = stdout;
								fprintf (_tmp14_, "  ");
							}
							_g_object_unref0 (tile);
						}
					}
				}
				_tmp15_ = stdout;
				fprintf (_tmp15_, "\n");
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							Tile* tile = NULL;
							Tile* _tmp18_;
							Tile* _tmp19_;
							if (!_tmp16_) {
								guint8 _tmp17_;
								_tmp17_ = x;
								x = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							if (!(((gint) x) < (2 * size))) {
								break;
							}
							_tmp18_ = puzzle_get_tile (puzzle, x, y);
							tile = _tmp18_;
							_tmp19_ = tile;
							if (_tmp19_ == NULL) {
								FILE* _tmp20_;
								_tmp20_ = stdout;
								fprintf (_tmp20_, "      ");
							} else {
								FILE* _tmp21_;
								Tile* _tmp22_;
								gchar* _tmp23_;
								gchar* _tmp24_;
								Tile* _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								gchar* _tmp29_;
								_tmp21_ = stdout;
								_tmp22_ = tile;
								_tmp23_ = g_strdup_printf ("%hhu", G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_TILE, Tile)->west);
								_tmp24_ = _tmp23_;
								_tmp25_ = tile;
								_tmp26_ = g_strdup_printf ("%hhu", G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_TILE, Tile)->east);
								_tmp27_ = _tmp26_;
								_tmp28_ = g_strconcat (" ", _tmp24_, " · ", _tmp27_, NULL);
								_tmp29_ = _tmp28_;
								fprintf (_tmp21_, "%s", _tmp29_);
								_g_free0 (_tmp29_);
								_g_free0 (_tmp27_);
								_g_free0 (_tmp24_);
							}
							if (((gint) x) == (size - 1)) {
								FILE* _tmp30_;
								_tmp30_ = stdout;
								fprintf (_tmp30_, "  ");
							}
							_g_object_unref0 (tile);
						}
					}
				}
				_tmp31_ = stdout;
				fprintf (_tmp31_, "\n");
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							Tile* tile = NULL;
							Tile* _tmp34_;
							Tile* _tmp35_;
							if (!_tmp32_) {
								guint8 _tmp33_;
								_tmp33_ = x;
								x = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							if (!(((gint) x) < (2 * size))) {
								break;
							}
							_tmp34_ = puzzle_get_tile (puzzle, x, y);
							tile = _tmp34_;
							_tmp35_ = tile;
							if (_tmp35_ == NULL) {
								FILE* _tmp36_;
								_tmp36_ = stdout;
								fprintf (_tmp36_, " ╰╴ ╶╯");
							} else {
								FILE* _tmp37_;
								Tile* _tmp38_;
								gchar* _tmp39_;
								gchar* _tmp40_;
								gchar* _tmp41_;
								gchar* _tmp42_;
								_tmp37_ = stdout;
								_tmp38_ = tile;
								_tmp39_ = g_strdup_printf ("%hhu", G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_TILE, Tile)->south);
								_tmp40_ = _tmp39_;
								_tmp41_ = g_strconcat (" └╴", _tmp40_, "╶┘", NULL);
								_tmp42_ = _tmp41_;
								fprintf (_tmp37_, "%s", _tmp42_);
								_g_free0 (_tmp42_);
								_g_free0 (_tmp40_);
							}
							if (((gint) x) == (size - 1)) {
								FILE* _tmp43_;
								_tmp43_ = stdout;
								fprintf (_tmp43_, "  ");
							}
							_g_object_unref0 (tile);
						}
					}
				}
				_tmp44_ = stdout;
				fprintf (_tmp44_, "\n");
			}
		}
	}
	_tmp45_ = stdout;
	fprintf (_tmp45_, "\n");
	_tmp46_ = puzzle_get_is_solved (puzzle);
	_tmp47_ = _tmp46_;
	if (_tmp47_) {
		FILE* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		_tmp48_ = stdout;
		_tmp49_ = g_strconcat (_ ("Puzzle is solved!"), "\n\n", NULL);
		_tmp50_ = _tmp49_;
		fprintf (_tmp48_, "%s", _tmp50_);
		_g_free0 (_tmp50_);
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

gboolean
cli_parse_cli (const gchar* cli,
               guint8 size,
               guint8* tile_1_x,
               guint8* tile_1_y,
               guint8* tile_2_x,
               guint8* tile_2_y)
{
	guint8 _vala_tile_1_x = 0U;
	guint8 _vala_tile_1_y = 0U;
	guint8 _vala_tile_2_x = 0U;
	guint8 _vala_tile_2_y = 0U;
	gint _tmp0_;
	gint _tmp1_;
	gchar column_char = '\0';
	guint8 _tmp2_ = 0U;
	gboolean _tmp3_;
	guint8 _tmp4_ = 0U;
	gboolean _tmp5_;
	guint64 test = 0ULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	guint64 _tmp8_ = 0ULL;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_ = FALSE;
	gchar* _tmp12_;
	gchar* _tmp13_;
	guint64 _tmp14_ = 0ULL;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean result;
	g_return_val_if_fail (cli != NULL, FALSE);
	_vala_tile_1_x = G_MAXUINT8;
	_vala_tile_1_y = G_MAXUINT8;
	_vala_tile_2_x = G_MAXUINT8;
	_vala_tile_2_y = G_MAXUINT8;
	_tmp0_ = strlen (cli);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 4) {
		result = FALSE;
		if (tile_1_x) {
			*tile_1_x = _vala_tile_1_x;
		}
		if (tile_1_y) {
			*tile_1_y = _vala_tile_1_y;
		}
		if (tile_2_x) {
			*tile_2_x = _vala_tile_2_x;
		}
		if (tile_2_y) {
			*tile_2_y = _vala_tile_2_y;
		}
		return result;
	}
	column_char = string_get (cli, (glong) 0);
	_tmp3_ = cli_is_valid_column (column_char, size, &_tmp2_);
	_vala_tile_1_x = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		if (tile_1_x) {
			*tile_1_x = _vala_tile_1_x;
		}
		if (tile_1_y) {
			*tile_1_y = _vala_tile_1_y;
		}
		if (tile_2_x) {
			*tile_2_x = _vala_tile_2_x;
		}
		if (tile_2_y) {
			*tile_2_y = _vala_tile_2_y;
		}
		return result;
	}
	column_char = string_get (cli, (glong) 2);
	_tmp5_ = cli_is_valid_column (column_char, size, &_tmp4_);
	_vala_tile_2_x = _tmp4_;
	if (!_tmp5_) {
		result = FALSE;
		if (tile_1_x) {
			*tile_1_x = _vala_tile_1_x;
		}
		if (tile_1_y) {
			*tile_1_y = _vala_tile_1_y;
		}
		if (tile_2_x) {
			*tile_2_x = _vala_tile_2_x;
		}
		if (tile_2_y) {
			*tile_2_y = _vala_tile_2_y;
		}
		return result;
	}
	_tmp6_ = g_strdup_printf ("%c", string_get (cli, (glong) 1));
	_tmp7_ = _tmp6_;
	_tmp9_ = uint64_try_parse (_tmp7_, &_tmp8_, NULL, (guint) 0);
	test = _tmp8_;
	_tmp10_ = !_tmp9_;
	_g_free0 (_tmp7_);
	if (_tmp10_) {
		result = FALSE;
		if (tile_1_x) {
			*tile_1_x = _vala_tile_1_x;
		}
		if (tile_1_y) {
			*tile_1_y = _vala_tile_1_y;
		}
		if (tile_2_x) {
			*tile_2_x = _vala_tile_2_x;
		}
		if (tile_2_y) {
			*tile_2_y = _vala_tile_2_y;
		}
		return result;
	}
	if (test <= ((guint64) 0)) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = test > ((guint64) size);
	}
	if (_tmp11_) {
		result = FALSE;
		if (tile_1_x) {
			*tile_1_x = _vala_tile_1_x;
		}
		if (tile_1_y) {
			*tile_1_y = _vala_tile_1_y;
		}
		if (tile_2_x) {
			*tile_2_x = _vala_tile_2_x;
		}
		if (tile_2_y) {
			*tile_2_y = _vala_tile_2_y;
		}
		return result;
	}
	_vala_tile_1_y = (guint8) (((guint8) test) - 1);
	_tmp12_ = g_strdup_printf ("%c", string_get (cli, (glong) 3));
	_tmp13_ = _tmp12_;
	_tmp15_ = uint64_try_parse (_tmp13_, &_tmp14_, NULL, (guint) 0);
	test = _tmp14_;
	_tmp16_ = !_tmp15_;
	_g_free0 (_tmp13_);
	if (_tmp16_) {
		result = FALSE;
		if (tile_1_x) {
			*tile_1_x = _vala_tile_1_x;
		}
		if (tile_1_y) {
			*tile_1_y = _vala_tile_1_y;
		}
		if (tile_2_x) {
			*tile_2_x = _vala_tile_2_x;
		}
		if (tile_2_y) {
			*tile_2_y = _vala_tile_2_y;
		}
		return result;
	}
	if (test <= ((guint64) 0)) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = test > ((guint64) size);
	}
	if (_tmp17_) {
		result = FALSE;
		if (tile_1_x) {
			*tile_1_x = _vala_tile_1_x;
		}
		if (tile_1_y) {
			*tile_1_y = _vala_tile_1_y;
		}
		if (tile_2_x) {
			*tile_2_x = _vala_tile_2_x;
		}
		if (tile_2_y) {
			*tile_2_y = _vala_tile_2_y;
		}
		return result;
	}
	_vala_tile_2_y = (guint8) (((guint8) test) - 1);
	result = TRUE;
	if (tile_1_x) {
		*tile_1_x = _vala_tile_1_x;
	}
	if (tile_1_y) {
		*tile_1_y = _vala_tile_1_y;
	}
	if (tile_2_x) {
		*tile_2_x = _vala_tile_2_x;
	}
	if (tile_2_y) {
		*tile_2_y = _vala_tile_2_y;
	}
	return result;
}

gboolean
cli_is_valid_column (gchar column_char,
                     guint8 size,
                     guint8* column)
{
	guint8 _vala_column = 0U;
	gboolean result;
	switch (column_char) {
		case 'a':
		{
			_vala_column = (guint8) 0;
			result = TRUE;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'b':
		{
			_vala_column = (guint8) 1;
			result = TRUE;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'c':
		{
			_vala_column = (guint8) 2;
			result = ((gint) size) >= 3;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'd':
		{
			_vala_column = (guint8) 3;
			result = ((gint) size) >= 4;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'e':
		{
			_vala_column = (guint8) 4;
			result = ((gint) size) >= 5;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'f':
		{
			_vala_column = (guint8) 5;
			result = ((gint) size) == 6;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'A':
		{
			_vala_column = size;
			result = TRUE;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'B':
		{
			_vala_column = (guint8) (size + 1);
			result = TRUE;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'C':
		{
			_vala_column = (guint8) (size + 2);
			result = ((gint) size) >= 3;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'D':
		{
			_vala_column = (guint8) (size + 3);
			result = ((gint) size) >= 4;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'E':
		{
			_vala_column = (guint8) (size + 4);
			result = ((gint) size) >= 5;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		case 'F':
		{
			_vala_column = (guint8) (size + 5);
			result = ((gint) size) == 6;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
		default:
		{
			_vala_column = G_MAXUINT8;
			result = FALSE;
			if (column) {
				*column = _vala_column;
			}
			return result;
		}
	}
}

