/* warp.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from warp.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 *
 * Rewrite of the original by Sean MacIsaac, Ian Peters, Guillaume Béland
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 * Copyright (C) 2022-24 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 * grep -ne ' $' *.vala
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <string.h>

#define WARP_MANAGER_MAX_WARPS ((guint8) 200)
#define NIBBLES_GAME_EMPTYCHAR 'a'
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;

#define WARP_MANAGER_TYPE_WARP (warp_manager_warp_get_type ())
#define WARP_MANAGER_WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WARP_MANAGER_TYPE_WARP, WarpManagerWarp))
#define WARP_MANAGER_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WARP_MANAGER_TYPE_WARP, WarpManagerWarpClass))
#define WARP_MANAGER_IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WARP_MANAGER_TYPE_WARP))
#define WARP_MANAGER_IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WARP_MANAGER_TYPE_WARP))
#define WARP_MANAGER_WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WARP_MANAGER_TYPE_WARP, WarpManagerWarpClass))

typedef struct _WarpManagerWarp WarpManagerWarp;
typedef struct _WarpManagerWarpClass WarpManagerWarpClass;
enum  {
	WARP_MANAGER_0_PROPERTY,
	WARP_MANAGER_NUM_PROPERTIES
};
static GParamSpec* warp_manager_properties[WARP_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_EAST = WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_SOUTH = WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_WEST = WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP,
	WORM_DIRECTION_NORTH = WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;
typedef struct _WarpManagerWarpPrivate WarpManagerWarpPrivate;
enum  {
	WARP_MANAGER_WARP_0_PROPERTY,
	WARP_MANAGER_WARP_MANAGER_PROPERTY,
	WARP_MANAGER_WARP_ID_PROPERTY,
	WARP_MANAGER_WARP_SOURCE_X_PROPERTY,
	WARP_MANAGER_WARP_SOURCE_Y_PROPERTY,
	WARP_MANAGER_WARP_TARGET_X_PROPERTY,
	WARP_MANAGER_WARP_TARGET_Y_PROPERTY,
	WARP_MANAGER_WARP_RANDOM_PROPERTY,
	WARP_MANAGER_WARP_BIDI_PROPERTY,
	WARP_MANAGER_WARP_NUM_PROPERTIES
};
static GParamSpec* warp_manager_warp_properties[WARP_MANAGER_WARP_NUM_PROPERTIES];

#define TYPE_WORM_MAP (worm_map_get_type ())
#define WORM_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_MAP, WormMap))
#define WORM_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_MAP, WormMapClass))
#define IS_WORM_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_MAP))
#define IS_WORM_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_MAP))
#define WORM_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_MAP, WormMapClass))

typedef struct _WormMap WormMap;
typedef struct _WormMapClass WormMapClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
	guint16* all_empty_board_positions;
	gint all_empty_board_positions_length1;
	gint _all_empty_board_positions_size_;
	gint* board;
	gint board_length1;
	gint board_length2;
	guint8 board_max_x;
	guint8 board_max_y;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};

struct _WarpManagerPrivate {
	GeeLinkedList* warps;
};

struct _Position {
	guint8 x;
	guint8 y;
};

struct _WarpManagerWarp {
	GObject parent_instance;
	WarpManagerWarpPrivate * priv;
};

struct _WarpManagerWarpClass {
	GObjectClass parent_class;
};

struct _WarpManagerWarpPrivate {
	gboolean init_finished;
	WarpManager* _manager;
	gint _id;
	guint8 _source_x;
	guint8 _source_y;
	guint8 _target_x;
	guint8 _target_y;
	gboolean _random;
	gboolean _bidi;
};

static gint WarpManager_private_offset;
static gpointer warp_manager_parent_class = NULL;
static gint WarpManagerWarp_private_offset;
static gpointer warp_manager_warp_parent_class = NULL;

VALA_EXTERN GType warp_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WarpManager, g_object_unref)
static GType warp_manager_warp_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WarpManagerWarp, g_object_unref)
VALA_EXTERN void warp_manager_add_warp_source (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y,
                                   gboolean random);
static gint warp_manager_warp_get_id (WarpManagerWarp* self);
static void warp_manager_warp_set_source (WarpManagerWarp* self,
                                   guint8 x,
                                   guint8 y);
static gboolean warp_manager_warp_get_bidi (WarpManagerWarp* self);
static WarpManagerWarp* warp_manager_warp_new_from_source (WarpManager* manager,
                                                    gint id,
                                                    guint8 source_x,
                                                    guint8 source_y,
                                                    gboolean random);
static WarpManagerWarp* warp_manager_warp_construct_from_source (GType object_type,
                                                          WarpManager* manager,
                                                          gint id,
                                                          guint8 source_x,
                                                          guint8 source_y,
                                                          gboolean random);
static guint8 warp_manager_warp_get_source_x (WarpManagerWarp* self);
static guint8 warp_manager_warp_get_source_y (WarpManagerWarp* self);
VALA_EXTERN void warp_manager_add_warp_target (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y);
static void warp_manager_warp_set_target (WarpManagerWarp* self,
                                   guint8 x,
                                   guint8 y);
static WarpManagerWarp* warp_manager_warp_new_from_target (WarpManager* manager,
                                                    gint id,
                                                    guint8 target_x,
                                                    guint8 target_y);
static WarpManagerWarp* warp_manager_warp_construct_from_target (GType object_type,
                                                          WarpManager* manager,
                                                          gint id,
                                                          guint8 target_x,
                                                          guint8 target_y);
VALA_EXTERN GType worm_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN gboolean warp_manager_get_warp_target (WarpManager* self,
                                       guint8 x,
                                       guint8 y,
                                       WormDirection worm_direction,
                                       gint worm_length,
                                       gboolean ai_worm,
                                       GeeLinkedList* worms,
                                       guint8* target_x,
                                       guint8* target_y,
                                       gboolean* bonus);
static gboolean warp_manager_warp_get_target (WarpManagerWarp* self,
                                       guint8 x,
                                       guint8 y,
                                       WormDirection direction,
                                       gint length,
                                       gboolean ai_worm,
                                       GeeLinkedList* worms,
                                       guint8* target_x,
                                       guint8* target_y,
                                       gboolean* bonus);
VALA_EXTERN void warp_manager_clear_warps (WarpManager* self);
VALA_EXTERN void warp_manager_initilise (WarpManager* self,
                             gint* board,
                             gint board_length1,
                             gint board_length2);
VALA_EXTERN GType position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Position* position_dup (const Position* self);
VALA_EXTERN void position_free (Position* self);
static void _vala_array_add7 (guint16* * array,
                       gint* length,
                       gint* size,
                       guint16 value);
VALA_EXTERN WarpManager* warp_manager_new (void);
VALA_EXTERN WarpManager* warp_manager_construct (GType object_type);
static void warp_manager_warp_set_target_x (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_target_y (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_source_x (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_source_y (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_bidi (WarpManagerWarp* self,
                                 gboolean value);
static gboolean warp_manager_warp_get_random (WarpManagerWarp* self);
VALA_EXTERN GType worm_map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormMap, g_object_unref)
static WarpManager* warp_manager_warp_get_manager (WarpManagerWarp* self);
VALA_EXTERN WormMap* worm_map_new (GeeList* worms,
                       guint8 map_width,
                       guint8 map_height);
VALA_EXTERN WormMap* worm_map_construct (GType object_type,
                             GeeList* worms,
                             guint8 map_width,
                             guint8 map_height);
static guint16* _vala_array_dup1 (guint16* self,
                           gssize length);
VALA_EXTERN void position_move (Position *self,
                    WormDirection direction,
                    guint8 width,
                    guint8 height);
VALA_EXTERN gboolean worm_map_contain_position (WormMap* self,
                                    Position* p);
VALA_EXTERN gint worm_ai_deadend_after (gint* board,
                            gint board_length1,
                            gint board_length2,
                            GeeLinkedList* worms,
                            WormMap* worm_map,
                            Position* old_position,
                            WormDirection direction,
                            gint length);
static guint8 warp_manager_warp_get_target_x (WarpManagerWarp* self);
static guint8 warp_manager_warp_get_target_y (WarpManagerWarp* self);
static WarpManagerWarp* warp_manager_warp_new (void);
static WarpManagerWarp* warp_manager_warp_construct (GType object_type);
static void warp_manager_warp_set_manager (WarpManagerWarp* self,
                                    WarpManager* value);
static void warp_manager_warp_set_id (WarpManagerWarp* self,
                               gint value);
static void warp_manager_warp_set_random (WarpManagerWarp* self,
                                   gboolean value);
static void warp_manager_warp_finalize (GObject * obj);
static GType warp_manager_warp_get_type_once (void);
static void _vala_warp_manager_warp_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_warp_manager_warp_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void warp_manager_finalize (GObject * obj);
static GType warp_manager_get_type_once (void);
static void _vala_array_move (gpointer array,
                       gsize element_size,
                       gssize src,
                       gssize dest,
                       gssize length);

static inline gpointer
warp_manager_get_instance_private (WarpManager* self)
{
	return G_STRUCT_MEMBER_P (self, WarpManager_private_offset);
}

void
warp_manager_add_warp_source (WarpManager* self,
                              gint id,
                              guint8 x,
                              guint8 y,
                              gboolean random)
{
	GeeLinkedList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeLinkedList* _tmp28_;
	WarpManagerWarp* _tmp29_;
	WarpManagerWarp* _tmp30_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _warp_index = 0;
		_tmp0_ = self->priv->warps;
		_warp_list = _tmp0_;
		_tmp1_ = _warp_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_warp_size = _tmp3_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			WarpManagerWarp* warp = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			WarpManagerWarp* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			WarpManagerWarp* _tmp11_;
			WarpManagerWarp* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_warp_index = _warp_index + 1;
			_tmp4_ = _warp_index;
			_tmp5_ = _warp_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _warp_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _warp_index);
			warp = (WarpManagerWarp*) _tmp7_;
			_tmp8_ = warp;
			_tmp9_ = warp_manager_warp_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != id) {
				_g_object_unref0 (warp);
				continue;
			}
			_tmp11_ = warp;
			warp_manager_warp_set_source (_tmp11_, x, y);
			_tmp12_ = warp;
			_tmp13_ = warp_manager_warp_get_bidi (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				WarpManagerWarp* bidi_warp = NULL;
				WarpManagerWarp* _tmp15_;
				WarpManagerWarp* _tmp16_;
				WarpManagerWarp* _tmp17_;
				guint8 _tmp18_;
				guint8 _tmp19_;
				WarpManagerWarp* _tmp20_;
				guint8 _tmp21_;
				guint8 _tmp22_;
				GeeLinkedList* _tmp23_;
				WarpManagerWarp* _tmp24_;
				_tmp15_ = warp_manager_warp_new_from_source (self, id, x, y, FALSE);
				bidi_warp = _tmp15_;
				_tmp16_ = bidi_warp;
				_tmp17_ = warp;
				_tmp18_ = warp_manager_warp_get_source_x (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = warp;
				_tmp21_ = warp_manager_warp_get_source_y (_tmp20_);
				_tmp22_ = _tmp21_;
				warp_manager_warp_set_source (_tmp16_, _tmp19_, _tmp22_);
				_tmp23_ = self->priv->warps;
				_tmp24_ = bidi_warp;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
				_g_object_unref0 (bidi_warp);
			}
			_g_object_unref0 (warp);
			return;
		}
	}
	_tmp25_ = self->priv->warps;
	_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ >= ((gint) WARP_MANAGER_MAX_WARPS)) {
		return;
	}
	_tmp28_ = self->priv->warps;
	_tmp29_ = warp_manager_warp_new_from_source (self, id, x, y, random);
	_tmp30_ = _tmp29_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp30_);
	_g_object_unref0 (_tmp30_);
}

void
warp_manager_add_warp_target (WarpManager* self,
                              gint id,
                              guint8 x,
                              guint8 y)
{
	GeeLinkedList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeLinkedList* _tmp15_;
	WarpManagerWarp* _tmp16_;
	WarpManagerWarp* _tmp17_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _warp_index = 0;
		_tmp0_ = self->priv->warps;
		_warp_list = _tmp0_;
		_tmp1_ = _warp_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_warp_size = _tmp3_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			WarpManagerWarp* warp = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			WarpManagerWarp* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			WarpManagerWarp* _tmp11_;
			_warp_index = _warp_index + 1;
			_tmp4_ = _warp_index;
			_tmp5_ = _warp_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _warp_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _warp_index);
			warp = (WarpManagerWarp*) _tmp7_;
			_tmp8_ = warp;
			_tmp9_ = warp_manager_warp_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != id) {
				_g_object_unref0 (warp);
				continue;
			}
			_tmp11_ = warp;
			warp_manager_warp_set_target (_tmp11_, x, y);
			_g_object_unref0 (warp);
			return;
		}
	}
	_tmp12_ = self->priv->warps;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ >= ((gint) WARP_MANAGER_MAX_WARPS)) {
		return;
	}
	_tmp15_ = self->priv->warps;
	_tmp16_ = warp_manager_warp_new_from_target (self, id, x, y);
	_tmp17_ = _tmp16_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
	_g_object_unref0 (_tmp17_);
}

gboolean
warp_manager_get_warp_target (WarpManager* self,
                              guint8 x,
                              guint8 y,
                              WormDirection worm_direction,
                              gint worm_length,
                              gboolean ai_worm,
                              GeeLinkedList* worms,
                              guint8* target_x,
                              guint8* target_y,
                              gboolean* bonus)
{
	guint8 _vala_target_x = 0U;
	guint8 _vala_target_y = 0U;
	gboolean _vala_bonus = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (worms != NULL, FALSE);
	_vala_target_x = (guint8) 0;
	_vala_target_y = (guint8) 0;
	_vala_bonus = FALSE;
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _warp_index = 0;
		_tmp0_ = self->priv->warps;
		_warp_list = _tmp0_;
		_tmp1_ = _warp_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_warp_size = _tmp3_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			WarpManagerWarp* warp = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			WarpManagerWarp* _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_;
			_warp_index = _warp_index + 1;
			_tmp4_ = _warp_index;
			_tmp5_ = _warp_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _warp_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _warp_index);
			warp = (WarpManagerWarp*) _tmp7_;
			_tmp8_ = warp;
			_tmp10_ = warp_manager_warp_get_target (_tmp8_, x, y, worm_direction, worm_length, ai_worm, worms, &_vala_target_x, &_vala_target_y, &_tmp9_);
			_vala_bonus = _tmp9_;
			if (_tmp10_) {
				result = TRUE;
				_g_object_unref0 (warp);
				if (target_x) {
					*target_x = _vala_target_x;
				}
				if (target_y) {
					*target_y = _vala_target_y;
				}
				if (bonus) {
					*bonus = _vala_bonus;
				}
				return result;
			}
			_g_object_unref0 (warp);
		}
	}
	result = FALSE;
	if (target_x) {
		*target_x = _vala_target_x;
	}
	if (target_y) {
		*target_y = _vala_target_y;
	}
	if (bonus) {
		*bonus = _vala_bonus;
	}
	return result;
}

void
warp_manager_clear_warps (WarpManager* self)
{
	GeeLinkedList* _tmp0_;
	guint16* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->warps;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = g_new0 (guint16, 0);
	self->all_empty_board_positions = (g_free (self->all_empty_board_positions), NULL);
	self->all_empty_board_positions = _tmp1_;
	self->all_empty_board_positions_length1 = 0;
	self->_all_empty_board_positions_size_ = self->all_empty_board_positions_length1;
}

static void
_vala_array_add7 (guint16* * array,
                  gint* length,
                  gint* size,
                  guint16 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint16, *array, *size);
	}
	(*array)[(*length)++] = value;
}

void
warp_manager_initilise (WarpManager* self,
                        gint* board,
                        gint board_length1,
                        gint board_length2)
{
	gint _tmp0_;
	gint _tmp1_;
	Position p = {0};
	Position _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	self->board = board;
	self->board_length1 = board_length1;
	self->board_length2 = board_length2;
	_tmp0_ = board_length1;
	self->board_max_x = (guint8) _tmp0_;
	_tmp1_ = board_length2;
	self->board_max_y = (guint8) _tmp1_;
	_tmp2_.x = (guint8) 0;
	_tmp2_.y = (guint8) 0;
	p = _tmp2_;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			Position _tmp5_;
			if (!_tmp3_) {
				guint8 _tmp4_;
				_tmp4_ = p.y;
				p.y = _tmp4_ + 1;
			}
			_tmp3_ = FALSE;
			_tmp5_ = p;
			if (!(_tmp5_.y < self->board_max_y)) {
				break;
			}
			{
				gboolean _tmp6_ = FALSE;
				p.x = (guint8) 0;
				_tmp6_ = TRUE;
				while (TRUE) {
					Position _tmp8_;
					Position _tmp9_;
					Position _tmp10_;
					gint _tmp11_;
					if (!_tmp6_) {
						guint8 _tmp7_;
						_tmp7_ = p.x;
						p.x = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = p;
					if (!(_tmp8_.x < self->board_max_x)) {
						break;
					}
					_tmp9_ = p;
					_tmp10_ = p;
					_tmp11_ = board[(_tmp9_.x * board_length2) + _tmp10_.y];
					if (_tmp11_ == ((gint) NIBBLES_GAME_EMPTYCHAR)) {
						Position _tmp12_;
						Position _tmp13_;
						_tmp12_ = p;
						_tmp13_ = p;
						_vala_array_add7 (&self->all_empty_board_positions, &self->all_empty_board_positions_length1, &self->_all_empty_board_positions_size_, (guint16) ((((guint16) _tmp12_.x) << 8) | _tmp13_.y));
					}
				}
			}
		}
	}
}

WarpManager*
warp_manager_construct (GType object_type)
{
	WarpManager * self = NULL;
	self = (WarpManager*) g_object_new (object_type, NULL);
	return self;
}

WarpManager*
warp_manager_new (void)
{
	return warp_manager_construct (TYPE_WARP_MANAGER);
}

static inline gpointer
warp_manager_warp_get_instance_private (WarpManagerWarp* self)
{
	return G_STRUCT_MEMBER_P (self, WarpManagerWarp_private_offset);
}

static WarpManagerWarp*
warp_manager_warp_construct_from_source (GType object_type,
                                         WarpManager* manager,
                                         gint id,
                                         guint8 source_x,
                                         guint8 source_y,
                                         gboolean random)
{
	WarpManagerWarp * self = NULL;
	g_return_val_if_fail (manager != NULL, NULL);
	self = (WarpManagerWarp*) g_object_new (object_type, "manager", manager, "id", id, "source-x", source_x, "source-y", source_y, "random", random, "bidi", TRUE, NULL);
	return self;
}

static WarpManagerWarp*
warp_manager_warp_new_from_source (WarpManager* manager,
                                   gint id,
                                   guint8 source_x,
                                   guint8 source_y,
                                   gboolean random)
{
	return warp_manager_warp_construct_from_source (WARP_MANAGER_TYPE_WARP, manager, id, source_x, source_y, random);
}

static WarpManagerWarp*
warp_manager_warp_construct_from_target (GType object_type,
                                         WarpManager* manager,
                                         gint id,
                                         guint8 target_x,
                                         guint8 target_y)
{
	WarpManagerWarp * self = NULL;
	g_return_val_if_fail (manager != NULL, NULL);
	self = (WarpManagerWarp*) g_object_new (object_type, "manager", manager, "id", id, "target-x", target_x, "target-y", target_y, "bidi", FALSE, NULL);
	return self;
}

static WarpManagerWarp*
warp_manager_warp_new_from_target (WarpManager* manager,
                                   gint id,
                                   guint8 target_x,
                                   guint8 target_y)
{
	return warp_manager_warp_construct_from_target (WARP_MANAGER_TYPE_WARP, manager, id, target_x, target_y);
}

static void
warp_manager_warp_set_source (WarpManagerWarp* self,
                              guint8 x,
                              guint8 y)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->init_finished == FALSE, "init_finished == false");
	_tmp0_ = self->priv->_bidi;
	if (_tmp0_) {
		warp_manager_warp_set_target_x (self, x);
		warp_manager_warp_set_target_y (self, y);
	} else {
		warp_manager_warp_set_source_x (self, x);
		warp_manager_warp_set_source_y (self, y);
	}
	self->priv->init_finished = TRUE;
}

static void
warp_manager_warp_set_target (WarpManagerWarp* self,
                              guint8 x,
                              guint8 y)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->init_finished == FALSE, "init_finished == false");
	_tmp0_ = self->priv->_bidi;
	_vala_return_if_fail (_tmp0_ == TRUE, "bidi == true");
	warp_manager_warp_set_target_x (self, x);
	warp_manager_warp_set_target_y (self, y);
	warp_manager_warp_set_bidi (self, FALSE);
	self->priv->init_finished = TRUE;
}

static guint16*
_vala_array_dup1 (guint16* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint16));
	}
	return NULL;
}

static gboolean
warp_manager_warp_get_target (WarpManagerWarp* self,
                              guint8 x,
                              guint8 y,
                              WormDirection direction,
                              gint length,
                              gboolean ai_worm,
                              GeeLinkedList* worms,
                              guint8* target_x,
                              guint8* target_y,
                              gboolean* bonus)
{
	gboolean _vala_bonus = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint8 _tmp2_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (worms != NULL, FALSE);
	_vala_return_val_if_fail (self->priv->init_finished == TRUE, "init_finished == true", FALSE);
	_vala_bonus = FALSE;
	_tmp2_ = self->priv->_source_x;
	if (x != _tmp2_) {
		guint8 _tmp3_;
		_tmp3_ = self->priv->_source_x;
		_tmp1_ = ((gint) x) != (_tmp3_ + 1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		guint8 _tmp5_;
		_tmp5_ = self->priv->_source_y;
		if (y != _tmp5_) {
			guint8 _tmp6_;
			_tmp6_ = self->priv->_source_y;
			_tmp4_ = ((gint) y) != (_tmp6_ + 1);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		result = FALSE;
		if (bonus) {
			*bonus = _vala_bonus;
		}
		return result;
	}
	_tmp7_ = warp_manager_warp_get_random (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		WormMap* worm_map = NULL;
		WarpManager* _tmp9_;
		WarpManager* _tmp10_;
		WormMap* _tmp11_;
		guint16* P = NULL;
		WarpManager* _tmp12_;
		guint16* _tmp13_;
		gint _tmp13__length1;
		guint16* _tmp14_;
		gint _tmp14__length1;
		gint P_length1;
		gint _P_size_;
		Position p = {0};
		Position _tmp15_ = {0};
		gint lowest_deadend = 0;
		guint16 lowest_deadend_position = 0U;
		gint i = 0;
		gint count = 0;
		gint clear_count = 0;
		gint _tmp16_ = 0;
		gint array_length = 0;
		guint16* _tmp17_;
		gint _tmp17__length1;
		_tmp9_ = self->priv->_manager;
		_tmp10_ = self->priv->_manager;
		_tmp11_ = worm_map_new ((GeeList*) worms, _tmp9_->board_max_x, _tmp10_->board_max_y);
		worm_map = _tmp11_;
		_tmp12_ = self->priv->_manager;
		_tmp13_ = _tmp12_->all_empty_board_positions;
		_tmp13__length1 = _tmp12_->all_empty_board_positions_length1;
		_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup1 (_tmp13_, _tmp13__length1) : _tmp13_;
		_tmp14__length1 = _tmp13__length1;
		P = _tmp14_;
		P_length1 = _tmp14__length1;
		_P_size_ = P_length1;
		_tmp15_.x = (guint8) 0;
		_tmp15_.y = (guint8) 0;
		p = _tmp15_;
		lowest_deadend = G_MAXINT;
		lowest_deadend_position = (guint16) 0;
		if (ai_worm) {
			_tmp16_ = 2;
		} else {
			_tmp16_ = 12;
		}
		clear_count = _tmp16_;
		_tmp17_ = P;
		_tmp17__length1 = P_length1;
		array_length = _tmp17__length1;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp54_;
				if (!_tmp18_) {
				}
				_tmp18_ = FALSE;
				if (!(array_length > 0)) {
					break;
				}
				i = (gint) g_random_int_range ((gint32) 0, (gint32) array_length);
				{
					guint16* _tmp19_;
					gint _tmp19__length1;
					guint16 _tmp20_;
					guint16* _tmp21_;
					gint _tmp21__length1;
					guint16 _tmp22_;
					gboolean _tmp23_ = FALSE;
					count = 0;
					_tmp19_ = P;
					_tmp19__length1 = P_length1;
					_tmp20_ = _tmp19_[i];
					p.x = (guint8) (_tmp20_ >> 8);
					_tmp21_ = P;
					_tmp21__length1 = P_length1;
					_tmp22_ = _tmp21_[i];
					p.y = (guint8) _tmp22_;
					_tmp23_ = TRUE;
					while (TRUE) {
						gboolean _tmp27_ = FALSE;
						gboolean _tmp28_ = FALSE;
						if (!_tmp23_) {
							gint _tmp24_;
							WarpManager* _tmp25_;
							WarpManager* _tmp26_;
							_tmp24_ = count;
							count = _tmp24_ + 1;
							_tmp25_ = self->priv->_manager;
							_tmp26_ = self->priv->_manager;
							position_move (&p, direction, _tmp25_->board_max_x, _tmp26_->board_max_y);
						}
						_tmp23_ = FALSE;
						if (count < clear_count) {
							WarpManager* _tmp29_;
							gint* _tmp30_;
							gint _tmp30__length1;
							gint _tmp30__length2;
							Position _tmp31_;
							Position _tmp32_;
							gint _tmp33_;
							_tmp29_ = self->priv->_manager;
							_tmp30_ = _tmp29_->board;
							_tmp30__length1 = _tmp29_->board_length1;
							_tmp30__length2 = _tmp29_->board_length2;
							_tmp31_ = p;
							_tmp32_ = p;
							_tmp33_ = _tmp30_[(_tmp31_.x * _tmp30__length2) + _tmp32_.y];
							_tmp28_ = _tmp33_ == ((gint) NIBBLES_GAME_EMPTYCHAR);
						} else {
							_tmp28_ = FALSE;
						}
						if (_tmp28_) {
							WormMap* _tmp34_;
							Position _tmp35_;
							_tmp34_ = worm_map;
							_tmp35_ = p;
							_tmp27_ = !worm_map_contain_position (_tmp34_, &_tmp35_);
						} else {
							_tmp27_ = FALSE;
						}
						if (!_tmp27_) {
							break;
						}
					}
				}
				if (count >= clear_count) {
					if (ai_worm) {
						guint16* _tmp36_;
						gint _tmp36__length1;
						guint16 _tmp37_;
						guint16* _tmp38_;
						gint _tmp38__length1;
						guint16 _tmp39_;
						_tmp36_ = P;
						_tmp36__length1 = P_length1;
						_tmp37_ = _tmp36_[i];
						*target_x = (guint8) (_tmp37_ >> 8);
						_tmp38_ = P;
						_tmp38__length1 = P_length1;
						_tmp39_ = _tmp38_[i];
						*target_y = (guint8) _tmp39_;
						break;
					} else {
						gint deadend = 0;
						WarpManager* _tmp40_;
						gint* _tmp41_;
						gint _tmp41__length1;
						gint _tmp41__length2;
						WormMap* _tmp42_;
						guint16* _tmp43_;
						gint _tmp43__length1;
						guint16 _tmp44_;
						guint16* _tmp45_;
						gint _tmp45__length1;
						guint16 _tmp46_;
						Position _tmp47_ = {0};
						_tmp40_ = self->priv->_manager;
						_tmp41_ = _tmp40_->board;
						_tmp41__length1 = _tmp40_->board_length1;
						_tmp41__length2 = _tmp40_->board_length2;
						_tmp42_ = worm_map;
						_tmp43_ = P;
						_tmp43__length1 = P_length1;
						_tmp44_ = _tmp43_[i];
						_tmp45_ = P;
						_tmp45__length1 = P_length1;
						_tmp46_ = _tmp45_[i];
						_tmp47_.x = (guint8) (_tmp44_ >> 8);
						_tmp47_.y = (guint8) _tmp46_;
						deadend = worm_ai_deadend_after (_tmp41_, (gint) _tmp41__length1, (gint) _tmp41__length2, worms, _tmp42_, &_tmp47_, direction, length);
						if (deadend <= 0) {
							guint16* _tmp48_;
							gint _tmp48__length1;
							guint16 _tmp49_;
							guint16* _tmp50_;
							gint _tmp50__length1;
							guint16 _tmp51_;
							_tmp48_ = P;
							_tmp48__length1 = P_length1;
							_tmp49_ = _tmp48_[i];
							*target_x = (guint8) (_tmp49_ >> 8);
							_tmp50_ = P;
							_tmp50__length1 = P_length1;
							_tmp51_ = _tmp50_[i];
							*target_y = (guint8) _tmp51_;
							break;
						}
						if (deadend < lowest_deadend) {
							guint16* _tmp52_;
							gint _tmp52__length1;
							guint16 _tmp53_;
							lowest_deadend = deadend;
							_tmp52_ = P;
							_tmp52__length1 = P_length1;
							_tmp53_ = _tmp52_[i];
							lowest_deadend_position = _tmp53_;
						}
					}
				}
				if (i < (array_length - 1)) {
					_vala_array_move (P, sizeof (guint16), i + 1, i, array_length - (i + 1));
				}
				_tmp54_ = array_length;
				array_length = _tmp54_ - 1;
			}
		}
		if (array_length <= 0) {
			if (lowest_deadend < G_MAXINT) {
				*target_x = (guint8) (lowest_deadend_position >> 8);
				*target_y = (guint8) lowest_deadend_position;
			} else {
				result = FALSE;
				P = (g_free (P), NULL);
				_g_object_unref0 (worm_map);
				if (bonus) {
					*bonus = _vala_bonus;
				}
				return result;
			}
		}
		_vala_bonus = TRUE;
		P = (g_free (P), NULL);
		_g_object_unref0 (worm_map);
	} else {
		gboolean _tmp55_;
		_tmp55_ = self->priv->_bidi;
		if (!_tmp55_) {
			guint8 _tmp56_;
			guint8 _tmp57_;
			_tmp56_ = self->priv->_target_x;
			*target_x = _tmp56_;
			_tmp57_ = self->priv->_target_y;
			*target_y = _tmp57_;
		} else {
			gboolean _tmp58_ = FALSE;
			if (direction == WORM_DIRECTION_LEFT) {
				_tmp58_ = TRUE;
			} else {
				_tmp58_ = direction == WORM_DIRECTION_RIGHT;
			}
			if (_tmp58_) {
				guint8 _tmp59_;
				guint8 _tmp63_;
				_tmp59_ = self->priv->_source_x;
				if (x == _tmp59_) {
					guint8 _tmp60_;
					_tmp60_ = self->priv->_target_x;
					*target_x = (guint8) (_tmp60_ + 2);
				} else {
					guint8 _tmp61_;
					_tmp61_ = self->priv->_target_x;
					if (((gint) _tmp61_) == 0) {
						g_assert_not_reached ();
					} else {
						guint8 _tmp62_;
						_tmp62_ = self->priv->_target_x;
						*target_x = (guint8) (_tmp62_ - 1);
					}
				}
				_tmp63_ = self->priv->_source_y;
				if (y == _tmp63_) {
					guint8 _tmp64_;
					_tmp64_ = self->priv->_target_y;
					*target_y = _tmp64_;
				} else {
					guint8 _tmp65_;
					_tmp65_ = self->priv->_target_y;
					*target_y = (guint8) (_tmp65_ + 1);
				}
			} else {
				guint8 _tmp66_;
				guint8 _tmp69_;
				_tmp66_ = self->priv->_source_x;
				if (x == _tmp66_) {
					guint8 _tmp67_;
					_tmp67_ = self->priv->_target_x;
					*target_x = _tmp67_;
				} else {
					guint8 _tmp68_;
					_tmp68_ = self->priv->_target_x;
					*target_x = (guint8) (_tmp68_ + 1);
				}
				_tmp69_ = self->priv->_source_y;
				if (y == _tmp69_) {
					guint8 _tmp70_;
					_tmp70_ = self->priv->_target_y;
					*target_y = (guint8) (_tmp70_ + 2);
				} else {
					guint8 _tmp71_;
					_tmp71_ = self->priv->_target_y;
					if (((gint) _tmp71_) == 0) {
						g_assert_not_reached ();
					} else {
						guint8 _tmp72_;
						_tmp72_ = self->priv->_target_y;
						*target_y = (guint8) (_tmp72_ - 1);
					}
				}
			}
		}
	}
	result = TRUE;
	if (bonus) {
		*bonus = _vala_bonus;
	}
	return result;
}

static WarpManagerWarp*
warp_manager_warp_construct (GType object_type)
{
	WarpManagerWarp * self = NULL;
	self = (WarpManagerWarp*) g_object_new (object_type, NULL);
	return self;
}

static WarpManagerWarp*
warp_manager_warp_new (void)
{
	return warp_manager_warp_construct (WARP_MANAGER_TYPE_WARP);
}

static WarpManager*
warp_manager_warp_get_manager (WarpManagerWarp* self)
{
	WarpManager* result;
	WarpManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manager;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
warp_manager_warp_set_manager (WarpManagerWarp* self,
                               WarpManager* value)
{
	WarpManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_manager (self);
	if (old_value != value) {
		WarpManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_manager);
		self->priv->_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_MANAGER_PROPERTY]);
	}
}

static gint
warp_manager_warp_get_id (WarpManagerWarp* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_id;
	return result;
}

static void
warp_manager_warp_set_id (WarpManagerWarp* self,
                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_ID_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_source_x (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_source_x;
	return result;
}

static void
warp_manager_warp_set_source_x (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_source_x (self);
	if (old_value != value) {
		self->priv->_source_x = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_X_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_source_y (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_source_y;
	return result;
}

static void
warp_manager_warp_set_source_y (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_source_y (self);
	if (old_value != value) {
		self->priv->_source_y = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_Y_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_target_x (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_target_x;
	return result;
}

static void
warp_manager_warp_set_target_x (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_target_x (self);
	if (old_value != value) {
		self->priv->_target_x = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_X_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_target_y (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_target_y;
	return result;
}

static void
warp_manager_warp_set_target_y (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_target_y (self);
	if (old_value != value) {
		self->priv->_target_y = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_Y_PROPERTY]);
	}
}

static gboolean
warp_manager_warp_get_random (WarpManagerWarp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_random;
	return result;
}

static void
warp_manager_warp_set_random (WarpManagerWarp* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_random = value;
	if (value) {
		self->priv->init_finished = TRUE;
	}
	g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_RANDOM_PROPERTY]);
}

static gboolean
warp_manager_warp_get_bidi (WarpManagerWarp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_bidi;
	return result;
}

static void
warp_manager_warp_set_bidi (WarpManagerWarp* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_bidi (self);
	if (old_value != value) {
		self->priv->_bidi = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_BIDI_PROPERTY]);
	}
}

static void
warp_manager_warp_class_init (WarpManagerWarpClass * klass,
                              gpointer klass_data)
{
	warp_manager_warp_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WarpManagerWarp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_warp_manager_warp_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_warp_manager_warp_set_property;
	G_OBJECT_CLASS (klass)->finalize = warp_manager_warp_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_MANAGER_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_MANAGER_PROPERTY] = g_param_spec_object ("manager", "manager", "manager", TYPE_WARP_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_ID_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_SOURCE_X_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_X_PROPERTY] = g_param_spec_uchar ("source-x", "source-x", "source-x", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_SOURCE_Y_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_Y_PROPERTY] = g_param_spec_uchar ("source-y", "source-y", "source-y", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_TARGET_X_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_X_PROPERTY] = g_param_spec_uchar ("target-x", "target-x", "target-x", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_TARGET_Y_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_Y_PROPERTY] = g_param_spec_uchar ("target-y", "target-y", "target-y", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_RANDOM_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_RANDOM_PROPERTY] = g_param_spec_boolean ("random", "random", "random", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_BIDI_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_BIDI_PROPERTY] = g_param_spec_boolean ("bidi", "bidi", "bidi", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
warp_manager_warp_instance_init (WarpManagerWarp * self,
                                 gpointer klass)
{
	self->priv = warp_manager_warp_get_instance_private (self);
	self->priv->init_finished = FALSE;
}

static void
warp_manager_warp_finalize (GObject * obj)
{
	WarpManagerWarp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WARP_MANAGER_TYPE_WARP, WarpManagerWarp);
	_g_object_unref0 (self->priv->_manager);
	G_OBJECT_CLASS (warp_manager_warp_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
warp_manager_warp_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WarpManagerWarpClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_manager_warp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpManagerWarp), 0, (GInstanceInitFunc) warp_manager_warp_instance_init, NULL };
	GType warp_manager_warp_type_id;
	warp_manager_warp_type_id = g_type_register_static (G_TYPE_OBJECT, "WarpManagerWarp", &g_define_type_info, 0);
	WarpManagerWarp_private_offset = g_type_add_instance_private (warp_manager_warp_type_id, sizeof (WarpManagerWarpPrivate));
	return warp_manager_warp_type_id;
}

static GType
warp_manager_warp_get_type (void)
{
	static gsize warp_manager_warp_type_id__once = 0;
	if (g_once_init_enter (&warp_manager_warp_type_id__once)) {
		GType warp_manager_warp_type_id;
		warp_manager_warp_type_id = warp_manager_warp_get_type_once ();
		g_once_init_leave (&warp_manager_warp_type_id__once, warp_manager_warp_type_id);
	}
	return warp_manager_warp_type_id__once;
}

static void
_vala_warp_manager_warp_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	WarpManagerWarp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WARP_MANAGER_TYPE_WARP, WarpManagerWarp);
	switch (property_id) {
		case WARP_MANAGER_WARP_MANAGER_PROPERTY:
		g_value_set_object (value, warp_manager_warp_get_manager (self));
		break;
		case WARP_MANAGER_WARP_ID_PROPERTY:
		g_value_set_int (value, warp_manager_warp_get_id (self));
		break;
		case WARP_MANAGER_WARP_SOURCE_X_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_source_x (self));
		break;
		case WARP_MANAGER_WARP_SOURCE_Y_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_source_y (self));
		break;
		case WARP_MANAGER_WARP_TARGET_X_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_target_x (self));
		break;
		case WARP_MANAGER_WARP_TARGET_Y_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_target_y (self));
		break;
		case WARP_MANAGER_WARP_RANDOM_PROPERTY:
		g_value_set_boolean (value, warp_manager_warp_get_random (self));
		break;
		case WARP_MANAGER_WARP_BIDI_PROPERTY:
		g_value_set_boolean (value, warp_manager_warp_get_bidi (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_warp_manager_warp_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	WarpManagerWarp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WARP_MANAGER_TYPE_WARP, WarpManagerWarp);
	switch (property_id) {
		case WARP_MANAGER_WARP_MANAGER_PROPERTY:
		warp_manager_warp_set_manager (self, g_value_get_object (value));
		break;
		case WARP_MANAGER_WARP_ID_PROPERTY:
		warp_manager_warp_set_id (self, g_value_get_int (value));
		break;
		case WARP_MANAGER_WARP_SOURCE_X_PROPERTY:
		warp_manager_warp_set_source_x (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_SOURCE_Y_PROPERTY:
		warp_manager_warp_set_source_y (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_TARGET_X_PROPERTY:
		warp_manager_warp_set_target_x (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_TARGET_Y_PROPERTY:
		warp_manager_warp_set_target_y (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_RANDOM_PROPERTY:
		warp_manager_warp_set_random (self, g_value_get_boolean (value));
		break;
		case WARP_MANAGER_WARP_BIDI_PROPERTY:
		warp_manager_warp_set_bidi (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
warp_manager_class_init (WarpManagerClass * klass,
                         gpointer klass_data)
{
	warp_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WarpManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = warp_manager_finalize;
}

static void
warp_manager_instance_init (WarpManager * self,
                            gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = warp_manager_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (WARP_MANAGER_TYPE_WARP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->warps = _tmp0_;
}

static void
warp_manager_finalize (GObject * obj)
{
	WarpManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WARP_MANAGER, WarpManager);
	self->all_empty_board_positions = (g_free (self->all_empty_board_positions), NULL);
	_g_object_unref0 (self->priv->warps);
	G_OBJECT_CLASS (warp_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
warp_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WarpManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpManager), 0, (GInstanceInitFunc) warp_manager_instance_init, NULL };
	GType warp_manager_type_id;
	warp_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WarpManager", &g_define_type_info, 0);
	WarpManager_private_offset = g_type_add_instance_private (warp_manager_type_id, sizeof (WarpManagerPrivate));
	return warp_manager_type_id;
}

GType
warp_manager_get_type (void)
{
	static gsize warp_manager_type_id__once = 0;
	if (g_once_init_enter (&warp_manager_type_id__once)) {
		GType warp_manager_type_id;
		warp_manager_type_id = warp_manager_get_type_once ();
		g_once_init_leave (&warp_manager_type_id__once, warp_manager_type_id);
	}
	return warp_manager_type_id__once;
}

static void
_vala_array_move (gpointer array,
                  gsize element_size,
                  gssize src,
                  gssize dest,
                  gssize length)
{
	memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}

