/* board-progress.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from board-progress.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   Gnome Nibbles: Gnome Worm Game
   Copyright (C) 2024 Ben Corby

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define NIBBLES_GAME_MAX_LEVEL 26
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BOARD_PROGRESS (board_progress_get_type ())
#define BOARD_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_PROGRESS, BoardProgress))
#define BOARD_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_PROGRESS, BoardProgressClass))
#define IS_BOARD_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_PROGRESS))
#define IS_BOARD_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_PROGRESS))
#define BOARD_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_PROGRESS, BoardProgressClass))

typedef struct _BoardProgress BoardProgress;
typedef struct _BoardProgressClass BoardProgressClass;
typedef struct _BoardProgressPrivate BoardProgressPrivate;
enum  {
	BOARD_PROGRESS_0_PROPERTY,
	BOARD_PROGRESS_NUM_PROPERTIES
};
static GParamSpec* board_progress_properties[BOARD_PROGRESS_NUM_PROPERTIES];
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoardProgress {
	GtkBox parent_instance;
	BoardProgressPrivate * priv;
};

struct _BoardProgressClass {
	GtkBoxClass parent_class;
};

struct _BoardProgressPrivate {
	GtkToggleButton* linier;
	GtkToggleButton* random;
	GtkToggleButton* fixed;
	GtkButton* next;
	GtkOverlay* overlay;
	GtkSpinButton* spin;
	gboolean spin_in_use;
	GSimpleAction* progress_action;
};

static gint BoardProgress_private_offset;
static gpointer board_progress_parent_class = NULL;

VALA_EXTERN GType board_progress_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoardProgress, g_object_unref)
static void board_progress_change_progress (BoardProgress* self,
                                     GSimpleAction* _action,
                                     GVariant* variant);
static void _board_progress_change_progress_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                           GVariant* value,
                                                                           gpointer self);
static void board_progress_setup_label (BoardProgress* self,
                                 GtkWidget* w);
VALA_EXTERN void board_progress_set_values (BoardProgress* self,
                                gint progress,
                                gint level);
static GVariant* _variant_new1 (gint value);
static void board_progress_set_frames (BoardProgress* self,
                                gint progress);
VALA_EXTERN void board_progress_get_values (BoardProgress* self,
                                gint* progress,
                                gint* level);
static GVariant* _variant_new2 (gint value);
VALA_EXTERN BoardProgress* board_progress_new (void);
VALA_EXTERN BoardProgress* board_progress_construct (GType object_type);
static GObject * board_progress_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void board_progress_finalize (GObject * obj);
static GType board_progress_get_type_once (void);

static const GActionEntry BOARD_PROGRESS_players_action_entries[1] = {{"change-progress", NULL, "i", "3", _board_progress_change_progress_gsimple_action_change_state_callback}};

static inline gpointer
board_progress_get_instance_private (BoardProgress* self)
{
	return G_STRUCT_MEMBER_P (self, BoardProgress_private_offset);
}

static void
_board_progress_change_progress_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                      GVariant* value,
                                                                      gpointer self)
{
	board_progress_change_progress ((BoardProgress*) self, action, value);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
board_progress_setup_label (BoardProgress* self,
                            GtkWidget* w)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (w, gtk_label_get_type (), GtkLabel));
	label = _tmp0_;
	_tmp1_ = gtk_label_get_text (label);
	_tmp2_ = g_strconcat ("<b><span size=\"14.0pt\" font-family=\"Sans\">", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "</span></b>", NULL);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (label, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	gtk_widget_set_margin_top ((GtkWidget*) label, 14);
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 14);
	gtk_widget_set_margin_start ((GtkWidget*) label, 14);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	_g_object_unref0 (label);
}

static GVariant*
_variant_new1 (gint value)
{
	return g_variant_ref_sink (g_variant_new_int32 (value));
}

void
board_progress_set_values (BoardProgress* self,
                           gint progress,
                           gint level)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GSimpleAction* _tmp2_;
	GVariant* _tmp3_;
	GtkSpinButton* _tmp4_;
	g_return_if_fail (self != NULL);
	if (progress < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = progress > 2;
	}
	if (_tmp0_) {
		progress = 0;
	}
	if (level < 1) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = level > NIBBLES_GAME_MAX_LEVEL;
	}
	if (_tmp1_) {
		level = 1;
	}
	_tmp2_ = self->priv->progress_action;
	_tmp3_ = _variant_new1 (progress);
	g_simple_action_set_state (_tmp2_, _tmp3_);
	_g_variant_unref0 (_tmp3_);
	_tmp4_ = self->priv->spin;
	gtk_spin_button_set_value (_tmp4_, (gdouble) level);
	board_progress_set_frames (self, progress);
}

void
board_progress_get_values (BoardProgress* self,
                           gint* progress,
                           gint* level)
{
	gint _vala_progress = 0;
	gint _vala_level = 0;
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GtkSpinButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_progress = (gint) g_variant_get_int32 (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	_tmp3_ = self->priv->spin;
	_vala_level = gtk_spin_button_get_value_as_int (_tmp3_);
	if (progress) {
		*progress = _vala_progress;
	}
	if (level) {
		*level = _vala_level;
	}
}

static GVariant*
_variant_new2 (gint value)
{
	return g_variant_ref_sink (g_variant_new_int32 (value));
}

static void
board_progress_change_progress (BoardProgress* self,
                                GSimpleAction* _action,
                                GVariant* variant)
{
	gint progress = 0;
	gboolean _tmp0_ = FALSE;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_action != NULL);
	g_return_if_fail (variant != NULL);
	progress = (gint) g_variant_get_int32 (variant);
	if (progress >= 0) {
		_tmp0_ = progress <= 2;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "progress >= 0 && progress <= 2");
	_tmp1_ = _variant_new2 (progress);
	g_simple_action_set_state (_action, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	board_progress_set_frames (self, progress);
}

static void
board_progress_set_frames (BoardProgress* self,
                           gint progress)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->linier;
	gtk_button_set_has_frame ((GtkButton*) _tmp0_, progress == 0);
	_tmp1_ = self->priv->random;
	gtk_button_set_has_frame ((GtkButton*) _tmp1_, progress == 1);
	_tmp2_ = self->priv->fixed;
	gtk_button_set_has_frame ((GtkButton*) _tmp2_, progress == 2);
	if (progress == 2) {
		if (!self->priv->spin_in_use) {
			GtkOverlay* _tmp3_;
			GtkSpinButton* _tmp4_;
			_tmp3_ = self->priv->overlay;
			_tmp4_ = self->priv->spin;
			gtk_overlay_add_overlay (_tmp3_, (GtkWidget*) _tmp4_);
		}
		self->priv->spin_in_use = TRUE;
	} else {
		if (self->priv->spin_in_use) {
			GtkOverlay* _tmp5_;
			GtkSpinButton* _tmp6_;
			_tmp5_ = self->priv->overlay;
			_tmp6_ = self->priv->spin;
			gtk_overlay_remove_overlay (_tmp5_, (GtkWidget*) _tmp6_);
		}
		self->priv->spin_in_use = FALSE;
	}
}

BoardProgress*
board_progress_construct (GType object_type)
{
	BoardProgress * self = NULL;
	self = (BoardProgress*) g_object_new (object_type, NULL);
	return self;
}

BoardProgress*
board_progress_new (void)
{
	return board_progress_construct (TYPE_BOARD_PROGRESS);
}

static GObject *
board_progress_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoardProgress * self;
	GtkToggleButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkWidget* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkSpinButton* _tmp10_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp11_;
	GSimpleActionGroup* _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GSimpleActionGroup* _tmp14_;
	GAction* _tmp15_;
	GSimpleAction* _tmp16_;
	parent_class = G_OBJECT_CLASS (board_progress_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOARD_PROGRESS, BoardProgress);
	_tmp0_ = self->priv->linier;
	_tmp1_ = gtk_button_get_child ((GtkButton*) _tmp0_);
	board_progress_setup_label (self, _tmp1_);
	_tmp2_ = self->priv->random;
	_tmp3_ = gtk_button_get_child ((GtkButton*) _tmp2_);
	board_progress_setup_label (self, _tmp3_);
	_tmp4_ = self->priv->fixed;
	_tmp5_ = gtk_button_get_child ((GtkButton*) _tmp4_);
	board_progress_setup_label (self, _tmp5_);
	_tmp6_ = self->priv->next;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 14);
	_tmp7_ = self->priv->next;
	if (gtk_widget_has_css_class ((GtkWidget*) _tmp7_, "play")) {
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		_tmp8_ = self->priv->next;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp8_, "play");
		_tmp9_ = self->priv->next;
		gtk_widget_add_css_class ((GtkWidget*) _tmp9_, "pill");
	}
	_tmp10_ = self->priv->spin;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_END);
	_tmp11_ = g_simple_action_group_new ();
	action_group = _tmp11_;
	_tmp12_ = action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp12_, BOARD_PROGRESS_players_action_entries, (gint) G_N_ELEMENTS (BOARD_PROGRESS_players_action_entries), self);
	_tmp13_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "progress", (GActionGroup*) _tmp13_);
	_tmp14_ = action_group;
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) _tmp14_, "change-progress");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->progress_action);
	self->priv->progress_action = _tmp16_;
	_g_object_unref0 (action_group);
	return obj;
}

static void
board_progress_class_init (BoardProgressClass * klass,
                           gpointer klass_data)
{
	board_progress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoardProgress_private_offset);
	G_OBJECT_CLASS (klass)->constructor = board_progress_constructor;
	G_OBJECT_CLASS (klass)->finalize = board_progress_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/board-progress.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "linier", FALSE, BoardProgress_private_offset + G_STRUCT_OFFSET (BoardProgressPrivate, linier));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "random", FALSE, BoardProgress_private_offset + G_STRUCT_OFFSET (BoardProgressPrivate, random));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fixed", FALSE, BoardProgress_private_offset + G_STRUCT_OFFSET (BoardProgressPrivate, fixed));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "next", FALSE, BoardProgress_private_offset + G_STRUCT_OFFSET (BoardProgressPrivate, next));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, BoardProgress_private_offset + G_STRUCT_OFFSET (BoardProgressPrivate, overlay));
}

static void
board_progress_instance_init (BoardProgress * self,
                              gpointer klass)
{
	GtkSpinButton* _tmp0_;
	self->priv = board_progress_get_instance_private (self);
	_tmp0_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) NIBBLES_GAME_MAX_LEVEL, (gdouble) 1);
	g_object_ref_sink (_tmp0_);
	self->priv->spin = _tmp0_;
	self->priv->spin_in_use = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
board_progress_finalize (GObject * obj)
{
	BoardProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOARD_PROGRESS, BoardProgress);
	_g_object_unref0 (self->priv->spin);
	_g_object_unref0 (self->priv->progress_action);
	G_OBJECT_CLASS (board_progress_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
board_progress_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoardProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) board_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoardProgress), 0, (GInstanceInitFunc) board_progress_instance_init, NULL };
	GType board_progress_type_id;
	board_progress_type_id = g_type_register_static (gtk_box_get_type (), "BoardProgress", &g_define_type_info, 0);
	BoardProgress_private_offset = g_type_add_instance_private (board_progress_type_id, sizeof (BoardProgressPrivate));
	return board_progress_type_id;
}

GType
board_progress_get_type (void)
{
	static gsize board_progress_type_id__once = 0;
	if (g_once_init_enter (&board_progress_type_id__once)) {
		GType board_progress_type_id;
		board_progress_type_id = board_progress_get_type_once ();
		g_once_init_leave (&board_progress_type_id__once, board_progress_type_id);
	}
	return board_progress_type_id__once;
}

