/* util.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include "common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "config.h"
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <archive.h>
#include <archive_entry.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesOutputStreamWriteData BoxesOutputStreamWriteData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _BoxesForeachFilenameFromDirData BoxesForeachFilenameFromDirData;
typedef struct _Block3Data Block3Data;
#define _boxes_async_launcher_unref0(var) ((var == NULL) ? NULL : (var = (boxes_async_launcher_unref (var), NULL)))
typedef struct _BoxesExecData BoxesExecData;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _BoxesParamSpecPair BoxesParamSpecPair;
enum  {
	BOXES_QUERY_0_PROPERTY,
	BOXES_QUERY_NUM_PROPERTIES
};
static GParamSpec* boxes_query_properties[BOXES_QUERY_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	BOXES_ACTIVITY_PROGRESS_0_PROPERTY,
	BOXES_ACTIVITY_PROGRESS_PROGRESS_PROPERTY,
	BOXES_ACTIVITY_PROGRESS_INFO_PROPERTY,
	BOXES_ACTIVITY_PROGRESS_NUM_PROPERTIES
};
static GParamSpec* boxes_activity_progress_properties[BOXES_ACTIVITY_PROGRESS_NUM_PROPERTIES];
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _BoxesOutputStreamWriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GOutputStream* stream;
	guint8* buffer;
	gint buffer_length1;
	gint length;
	gssize i;
	gssize _tmp0_;
	GError* _inner_error0_;
};

struct _BoxesForeachFilenameFromDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* dir;
	BoxesForeachFilenameFromDirFunc func;
	gpointer func_target;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp0_;
	GList* files;
	GFileEnumerator* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* file_collection;
	GList* file_it;
	GFileInfo* _tmp5_;
	GFileInfo* file;
	gboolean _tmp6_;
	GFileInfo* _tmp7_;
	const gchar* _tmp8_;
	GError* _error_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	gchar* std_output;
	gchar* std_error;
	gchar** argv_copy;
	gint argv_copy_length1;
	gint _argv_copy_size_;
	gpointer _async_data_;
};

struct _BoxesExecData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar** argv;
	gint argv_length1;
	GCancellable* cancellable;
	gchar* standard_output;
	gchar* standard_error;
	Block3Data* _data3_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	BoxesAsyncLauncher* _tmp3_;
	BoxesAsyncLauncher* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _BoxesPairPrivate {
	GType t1_type;
	GBoxedCopyFunc t1_dup_func;
	GDestroyNotify t1_destroy_func;
	GType t2_type;
	GBoxedCopyFunc t2_dup_func;
	GDestroyNotify t2_destroy_func;
};

struct _BoxesParamSpecPair {
	GParamSpec parent_instance;
};

struct _BoxesQueryPrivate {
	gchar* query;
	GHashTable* params;
};

struct _BoxesActivityProgressPrivate {
	gdouble _progress;
	gchar* _info;
};

struct _Block4Data {
	int _ref_count_;
	BoxesActivityProgress* self;
	BoxesActivityProgress* child_progress;
	gdouble last_child_progress;
	gdouble scale;
};

struct _Block5Data {
	int _ref_count_;
	struct archive_entry* local_iterator;
	struct archive* archive;
};

static gint BoxesPair_private_offset;
static gpointer boxes_pair_parent_class = NULL;
static gint BoxesQuery_private_offset;
static gpointer boxes_query_parent_class = NULL;
static gint BoxesActivityProgress_private_offset;
static gpointer boxes_activity_progress_parent_class = NULL;

static void boxes_output_stream_write_data_free (gpointer _data);
static gboolean boxes_output_stream_write_co (BoxesOutputStreamWriteData* _data_);
static void boxes_output_stream_write_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void boxes_foreach_filename_from_dir_data_free (gpointer _data);
static gboolean boxes_foreach_filename_from_dir_co (BoxesForeachFilenameFromDirData* _data_);
static void boxes_foreach_filename_from_dir_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_exec_data_free (gpointer _data);
static gboolean boxes_exec_co (BoxesExecData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void __lambda6_ (Block3Data* _data3_,
                 GError** error);
static void ___lambda6__boxes_async_launcher_run_in_thread_func (gpointer self,
                                                          GError** error);
static void boxes_exec_ready (GObject* source_object,
                       GAsyncResult* _res_,
                       gpointer _user_data_);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
static void boxes_pair_finalize (BoxesPair * obj);
static GType boxes_pair_get_type_once (void);
static GObject * boxes_query_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void boxes_query_finalize (GObject * obj);
static GType boxes_query_get_type_once (void);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda7_ (Block4Data* _data4_);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void boxes_activity_progress_finalize (GObject * obj);
static GType boxes_activity_progress_get_type_once (void);
static void _vala_boxes_activity_progress_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_boxes_activity_progress_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static int ___lambda8_ (Block5Data* _data5_);
static int ____lambda8__boxes_libarchive_function (gpointer self);
VALA_EXTERN gunichar boxes_strip_char (gunichar ch);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
boxes_error_quark (void)
{
	return g_quark_from_static_string ("boxes-error-quark");
}

static GType
boxes_error_get_type_once (void)
{
	static const GEnumValue values[] = {{BOXES_ERROR_INVALID, "BOXES_ERROR_INVALID", "invalid"}, {BOXES_ERROR_RESTORE_FAILED, "BOXES_ERROR_RESTORE_FAILED", "restore-failed"}, {BOXES_ERROR_START_FAILED, "BOXES_ERROR_START_FAILED", "start-failed"}, {BOXES_ERROR_COMMAND_FAILED, "BOXES_ERROR_COMMAND_FAILED", "command-failed"}, {0, NULL, NULL}};
	GType boxes_error_type_id;
	boxes_error_type_id = g_enum_register_static ("BoxesError", values);
	return boxes_error_type_id;
}

GType
boxes_error_get_type (void)
{
	static volatile gsize boxes_error_type_id__once = 0;
	if (g_once_init_enter (&boxes_error_type_id__once)) {
		GType boxes_error_type_id;
		boxes_error_type_id = boxes_error_get_type_once ();
		g_once_init_leave (&boxes_error_type_id__once, boxes_error_type_id);
	}
	return boxes_error_type_id__once;
}

gchar*
boxes_get_pkgdata (const gchar* file_name)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_build_filename (DATADIR, PACKAGE_TARNAME, file_name, NULL);
	result = _tmp0_;
	return result;
}

gchar*
boxes_get_pixmap (const gchar* file_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = boxes_get_pkgdata (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "pixmaps", file_name, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
boxes_get_unattended (const gchar* file_name)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = boxes_get_pkgdata (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "unattended", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dir = _tmp3_;
	_tmp4_ = g_build_filename (dir, file_name, NULL);
	result = _tmp4_;
	_g_free0 (dir);
	return result;
}

gchar*
boxes_get_pkgdata_source (const gchar* file_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = boxes_get_pkgdata (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "sources", file_name, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
boxes_get_custom_osinfo_db (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = boxes_get_pkgdata ("osinfo");
	result = _tmp0_;
	return result;
}

gchar*
boxes_get_user_agent (void)
{
	gchar* user_agent = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (DISTRIBUTOR_NAME "/" DISTRIBUTOR_VERSION " " PACKAGE_TARNAME "/" PACKAGE_VERSION);
	user_agent = _tmp0_;
	result = user_agent;
	return result;
}

gchar*
boxes_get_user_unattended (const gchar* file_name)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = boxes_get_user_pkgconfig (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "unattended", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dir = _tmp3_;
	boxes_ensure_directory (dir);
	_tmp4_ = g_build_filename (dir, file_name, NULL);
	result = _tmp4_;
	_g_free0 (dir);
	return result;
}

gchar*
boxes_get_user_pkgcache (const gchar* file_name)
{
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	dir = _tmp1_;
	boxes_ensure_directory (dir);
	_tmp2_ = g_build_filename (dir, file_name, NULL);
	result = _tmp2_;
	_g_free0 (dir);
	return result;
}

gchar*
boxes_get_system_pkgcache (const gchar* file_name)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_build_filename (CACHEDIR, PACKAGE_TARNAME, NULL);
	dir = _tmp0_;
	_tmp1_ = dir;
	if (!g_file_test (_tmp1_, G_FILE_TEST_EXISTS)) {
		result = NULL;
		_g_free0 (dir);
		return result;
	}
	_tmp2_ = dir;
	_tmp3_ = g_build_filename (_tmp2_, file_name, NULL);
	result = _tmp3_;
	_g_free0 (dir);
	return result;
}

gchar*
boxes_get_user_pkgconfig (const gchar* file_name)
{
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	dir = _tmp1_;
	boxes_ensure_directory (dir);
	_tmp2_ = g_build_filename (dir, file_name, NULL);
	result = _tmp2_;
	_g_free0 (dir);
	return result;
}

gchar*
boxes_get_user_pkgdata (const gchar* file_name)
{
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	dir = _tmp1_;
	boxes_ensure_directory (dir);
	_tmp2_ = g_build_filename (dir, file_name, NULL);
	result = _tmp2_;
	_g_free0 (dir);
	return result;
}

gboolean
boxes_has_user_pkgconfig_sources (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	_tmp0_ = boxes_get_user_pkgconfig (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "sources", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_IS_DIR);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gchar*
boxes_get_user_pkgconfig_source (const gchar* file_name)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = boxes_get_user_pkgconfig (NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "sources", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dir = _tmp3_;
	boxes_ensure_directory (dir);
	_tmp4_ = g_build_filename (dir, file_name, NULL);
	result = _tmp4_;
	_g_free0 (dir);
	return result;
}

gchar*
boxes_get_utf8_basename (const gchar* path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* name = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	_tmp1_ = g_file_get_parse_name (file);
	name = _tmp1_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, 0, NULL, &_inner_error0_);
		info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = g_file_info_get_display_name (info);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (name);
		name = _tmp4_;
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = name;
	_g_object_unref0 (file);
	return result;
}

gchar*
boxes_get_system_logo_cache (const gchar* file_name)
{
	gchar* system_pkgcache = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	_tmp0_ = boxes_get_system_pkgcache (NULL);
	system_pkgcache = _tmp0_;
	_tmp1_ = system_pkgcache;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (system_pkgcache);
		return result;
	}
	_tmp2_ = system_pkgcache;
	_tmp3_ = g_build_filename (_tmp2_, "logos", NULL);
	dir = _tmp3_;
	_tmp4_ = dir;
	if (!g_file_test (_tmp4_, G_FILE_TEST_EXISTS)) {
		result = NULL;
		_g_free0 (dir);
		_g_free0 (system_pkgcache);
		return result;
	}
	_tmp5_ = dir;
	_tmp6_ = g_build_filename (_tmp5_, file_name, NULL);
	result = _tmp6_;
	_g_free0 (dir);
	_g_free0 (system_pkgcache);
	return result;
}

gchar*
boxes_get_logo_cache (const gchar* file_name)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = boxes_get_cache ("logos", file_name);
	result = _tmp0_;
	return result;
}

gchar*
boxes_get_drivers_cache (const gchar* file_name)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = boxes_get_cache ("drivers", file_name);
	result = _tmp0_;
	return result;
}

gchar*
boxes_get_cache (const gchar* cache_name,
                 const gchar* file_name)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (cache_name != NULL, NULL);
	_tmp0_ = boxes_get_user_pkgcache (cache_name);
	dir = _tmp0_;
	boxes_ensure_directory (dir);
	_tmp1_ = g_build_filename (dir, file_name, NULL);
	result = _tmp1_;
	_g_free0 (dir);
	return result;
}

gchar*
boxes_get_system_drivers_cache (const gchar* file_name)
{
	gchar* system_pkgcache = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* dir = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	_tmp0_ = boxes_get_system_pkgcache (NULL);
	system_pkgcache = _tmp0_;
	_tmp1_ = system_pkgcache;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (system_pkgcache);
		return result;
	}
	_tmp2_ = boxes_get_system_pkgcache (NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp3_, "drivers", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	dir = _tmp5_;
	_tmp6_ = dir;
	if (!g_file_test (_tmp6_, G_FILE_TEST_EXISTS)) {
		result = NULL;
		_g_free0 (dir);
		_g_free0 (system_pkgcache);
		return result;
	}
	_tmp7_ = dir;
	_tmp8_ = g_build_filename (_tmp7_, file_name, NULL);
	result = _tmp8_;
	_g_free0 (dir);
	_g_free0 (system_pkgcache);
	return result;
}

gchar*
boxes_get_screenshot_filename (const gchar* prefix)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = g_strconcat (prefix, "-screenshot.png", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = boxes_get_user_pkgcache (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
boxes_ensure_directory (const gchar* dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dir != NULL);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = g_file_new_for_path (dir);
		file = _tmp0_;
		_tmp1_ = file;
		g_file_make_directory_with_parents (_tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch0_g_io_error_exists;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_io_error_exists:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("util.vala:156: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
boxes_keyfile_save (GKeyFile* key_file,
                    const gchar* file_name,
                    gboolean overwrite)
{
	gboolean _tmp7_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (key_file != NULL, FALSE);
	g_return_val_if_fail (file_name != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		if (!overwrite) {
			_tmp0_ = g_file_test (file_name, G_FILE_TEST_EXISTS);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = g_key_file_to_data (key_file, NULL, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_set_contents (file_name, _tmp3_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp1_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning ("util.vala:167: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp7_;
}

static void
boxes_output_stream_write_data_free (gpointer _data)
{
	BoxesOutputStreamWriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->stream);
	g_slice_free (BoxesOutputStreamWriteData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
boxes_output_stream_write (GOutputStream* stream,
                           guint8* buffer,
                           gint buffer_length1,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	BoxesOutputStreamWriteData* _data_;
	GOutputStream* _tmp0_;
	g_return_if_fail (stream != NULL);
	_data_ = g_slice_new0 (BoxesOutputStreamWriteData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_output_stream_write_data_free);
	_tmp0_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data_->stream);
	_data_->stream = _tmp0_;
	_data_->buffer = buffer;
	_data_->buffer_length1 = buffer_length1;
	boxes_output_stream_write_co (_data_);
}

void
boxes_output_stream_write_finish (GAsyncResult* _res_,
                                  GError** error)
{
	BoxesOutputStreamWriteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
boxes_output_stream_write_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	BoxesOutputStreamWriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_output_stream_write_co (_data_);
}

static gboolean
boxes_output_stream_write_co (BoxesOutputStreamWriteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->length = _data_->buffer_length1;
	_data_->i = (gssize) 0;
	while (TRUE) {
		if (!(_data_->i < ((gssize) _data_->length))) {
			break;
		}
		_data_->_state_ = 1;
		g_output_stream_write_async (_data_->stream, _data_->buffer + ((gint) _data_->i), (gsize) (_data_->length - ((gint) _data_->i)), G_PRIORITY_DEFAULT, NULL, boxes_output_stream_write_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_output_stream_write_finish (_data_->stream, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->i += _data_->_tmp0_;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
boxes_replace_regex (const gchar* str,
                     const gchar* old,
                     const gchar* replacement)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		GRegex* _tmp0_;
		gchar* _tmp1_ = NULL;
		GRegex* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = g_regex_new (old, 0, 0, &_inner_error0_);
		regex = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = regex;
		_tmp3_ = g_regex_replace_literal (_tmp2_, str, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp4_;
		_g_free0 (_tmp1_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_critical ("util.vala:185: %s", _tmp6_);
		_tmp7_ = g_strdup (str);
		result = _tmp7_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
boxes_make_filename (const gchar* name)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	gchar* tryname = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = boxes_replace_regex (name, "[\\\\/:()<>|?*]", "_");
	filename = _tmp0_;
	_tmp1_ = filename;
	_tmp2_ = g_strdup (_tmp1_);
	tryname = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = tryname;
				if (!g_file_test (_tmp5_, G_FILE_TEST_EXISTS)) {
					break;
				}
				_tmp6_ = filename;
				_tmp7_ = g_strdup_printf ("%s-%d", _tmp6_, i);
				_g_free0 (tryname);
				tryname = _tmp7_;
			}
		}
	}
	result = tryname;
	_g_free0 (filename);
	return result;
}

void
boxes_delete_file (GFile* file,
                   GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_file_get_path (file);
		_tmp1_ = _tmp0_;
		g_debug ("util.vala:203: Removing '%s'..", _tmp1_);
		_g_free0 (_tmp1_);
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __finally0;
		}
		_tmp2_ = g_file_get_path (file);
		_tmp3_ = _tmp2_;
		g_debug ("util.vala:205: Removed '%s'.", _tmp3_);
		_g_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = g_file_get_path (file);
		_tmp5_ = _tmp4_;
		g_debug ("util.vala:207: File '%s' was already deleted", _tmp5_);
		_g_free0 (_tmp5_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
boxes_foreach_filename_from_dir_data_free (gpointer _data)
{
	BoxesForeachFilenameFromDirData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->dir);
	g_slice_free (BoxesForeachFilenameFromDirData, _data_);
}

void
boxes_foreach_filename_from_dir (GFile* dir,
                                 BoxesForeachFilenameFromDirFunc func,
                                 gpointer func_target,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	BoxesForeachFilenameFromDirData* _data_;
	GFile* _tmp0_;
	g_return_if_fail (dir != NULL);
	_data_ = g_slice_new0 (BoxesForeachFilenameFromDirData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_foreach_filename_from_dir_data_free);
	_tmp0_ = _g_object_ref0 (dir);
	_g_object_unref0 (_data_->dir);
	_data_->dir = _tmp0_;
	_data_->func = func;
	_data_->func_target = func_target;
	boxes_foreach_filename_from_dir_co (_data_);
}

void
boxes_foreach_filename_from_dir_finish (GAsyncResult* _res_)
{
	BoxesForeachFilenameFromDirData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
boxes_foreach_filename_from_dir_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	BoxesForeachFilenameFromDirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_foreach_filename_from_dir_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
boxes_foreach_filename_from_dir_co (BoxesForeachFilenameFromDirData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->dir, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, boxes_foreach_filename_from_dir_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_file_enumerate_children_finish (_data_->dir, _data_->_res_, &_data_->_inner_error0_);
		_data_->enumerator = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp1_ = _data_->enumerator;
			_data_->_state_ = 2;
			g_file_enumerator_next_files_async (_data_->_tmp1_, 10, G_PRIORITY_DEFAULT, NULL, boxes_foreach_filename_from_dir_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp2_ = g_file_enumerator_next_files_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
			_data_->files = _data_->_tmp2_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->enumerator);
				goto __catch0_g_error;
			}
			_data_->_tmp3_ = _data_->files;
			if (_data_->_tmp3_ == NULL) {
				(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
				break;
			}
			_data_->_tmp4_ = _data_->files;
			{
				_data_->file_collection = _data_->_tmp4_;
				for (_data_->file_it = _data_->file_collection; _data_->file_it != NULL; _data_->file_it = _data_->file_it->next) {
					_data_->_tmp5_ = _g_object_ref0 ((GFileInfo*) _data_->file_it->data);
					_data_->file = _data_->_tmp5_;
					{
						_data_->_tmp7_ = _data_->file;
						_data_->_tmp8_ = g_file_info_get_name (_data_->_tmp7_);
						_data_->_tmp6_ = _data_->func (_data_->_tmp8_, _data_->func_target, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							_g_object_unref0 (_data_->file);
							(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
							_g_object_unref0 (_data_->enumerator);
							goto __catch0_g_error;
						}
						if (_data_->_tmp6_) {
							_g_object_unref0 (_data_->file);
							break;
						}
						_g_object_unref0 (_data_->file);
					}
				}
			}
			(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
		}
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->_error_;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("util.vala:227: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_exec_data_free (gpointer _data)
{
	BoxesExecData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (BoxesExecData, _data_);
}

void
boxes_exec (gchar** argv,
            gint argv_length1,
            GCancellable* cancellable,
            GAsyncReadyCallback _callback_,
            gpointer _user_data_)
{
	BoxesExecData* _data_;
	GCancellable* _tmp0_;
	_data_ = g_slice_new0 (BoxesExecData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_exec_data_free);
	_data_->argv = argv;
	_data_->argv_length1 = argv_length1;
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp0_;
	boxes_exec_co (_data_);
}

void
boxes_exec_finish (GAsyncResult* _res_,
                   gchar** standard_output,
                   gchar** standard_error,
                   GError** error)
{
	BoxesExecData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (standard_output) {
		*standard_output = _data_->standard_output;
	} else {
		_g_free0 (_data_->standard_output);
	}
	_data_->standard_output = NULL;
	if (standard_error) {
		*standard_error = _data_->standard_error;
	} else {
		_g_free0 (_data_->standard_error);
	}
	_data_->standard_error = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_data3_->argv_copy = (_vala_array_free (_data3_->argv_copy, _data3_->argv_copy_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data3_->std_error);
		_g_free0 (_data3_->std_output);
		g_slice_free (Block3Data, _data3_);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda6_ (Block3Data* _data3_,
            GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError* _inner_error0_ = NULL;
	boxes_exec_sync (_data3_->argv_copy, (gint) _data3_->argv_copy_length1, &_tmp0_, &_tmp1_, &_inner_error0_);
	_g_free0 (_data3_->std_output);
	_data3_->std_output = _tmp0_;
	_g_free0 (_data3_->std_error);
	_data3_->std_error = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda6__boxes_async_launcher_run_in_thread_func (gpointer self,
                                                     GError** error)
{
	__lambda6_ (self, error);
}

static void
boxes_exec_ready (GObject* source_object,
                  GAsyncResult* _res_,
                  gpointer _user_data_)
{
	BoxesExecData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_exec_co (_data_);
}

static gboolean
boxes_exec_co (BoxesExecData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = g_strdup ("");
	_data_->_data3_->std_output = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup ("");
	_data_->_data3_->std_error = _data_->_tmp1_;
	_data_->_tmp2_ = (_data_->argv != NULL) ? _vala_array_dup1 (_data_->argv, _data_->argv_length1) : _data_->argv;
	_data_->_tmp2__length1 = _data_->argv_length1;
	_data_->_data3_->argv_copy = _data_->_tmp2_;
	_data_->_data3_->argv_copy_length1 = _data_->_tmp2__length1;
	_data_->_data3_->_argv_copy_size_ = _data_->_data3_->argv_copy_length1;
	_data_->_tmp3_ = boxes_async_launcher_get_default ();
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	boxes_async_launcher_launch (_data_->_tmp4_, ___lambda6__boxes_async_launcher_run_in_thread_func, block3_data_ref (_data_->_data3_), block3_data_unref, boxes_exec_ready, _data_);
	return FALSE;
	_state_1:
	boxes_async_launcher_launch_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	_boxes_async_launcher_unref0 (_data_->_tmp4_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		_g_free0 (_data_->standard_output);
		_g_free0 (_data_->standard_error);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = g_strdup (_data_->_data3_->std_output);
	_g_free0 (_data_->standard_output);
	_data_->standard_output = _data_->_tmp5_;
	_data_->_tmp6_ = g_strdup (_data_->_data3_->std_error);
	_g_free0 (_data_->standard_error);
	_data_->standard_error = _data_->_tmp6_;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

void
boxes_exec_sync (gchar** argv,
                 gint argv_length1,
                 gchar** standard_output,
                 gchar** standard_error,
                 GError** error)
{
	gchar* _vala_standard_output = NULL;
	gchar* _vala_standard_error = NULL;
	gint exit_status = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GError* _inner_error0_ = NULL;
	exit_status = -1;
	g_spawn_sync (NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
	_g_free0 (_vala_standard_output);
	_vala_standard_output = _tmp0_;
	_g_free0 (_vala_standard_error);
	_vala_standard_error = _tmp1_;
	exit_status = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_vala_standard_output);
		_g_free0 (_vala_standard_error);
		return;
	}
	if (exit_status != 0) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp3_ = _vala_g_strjoinv (" ", argv, (gint) argv_length1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (BOXES_ERROR, BOXES_ERROR_COMMAND_FAILED, "Failed to execute: %s", _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_vala_standard_output);
		_g_free0 (_vala_standard_error);
		return;
	}
	if (standard_output) {
		*standard_output = _vala_standard_output;
	} else {
		_g_free0 (_vala_standard_output);
	}
	if (standard_error) {
		*standard_error = _vala_standard_error;
	} else {
		_g_free0 (_vala_standard_error);
	}
}

static GEnumValue*
_g_enum_value_dup (GEnumValue* self)
{
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}

static gpointer
__g_enum_value_dup0 (gpointer self)
{
	return self ? _g_enum_value_dup (self) : NULL;
}

gint
boxes_get_enum_value (const gchar* value_nick,
                      GType enum_type)
{
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_;
	GEnumValue* val = NULL;
	GEnumValue* _tmp1_;
	gint result;
	g_return_val_if_fail (value_nick != NULL, 0);
	_tmp0_ = g_type_class_ref (enum_type);
	enum_class = (GEnumClass*) _tmp0_;
	_tmp1_ = __g_enum_value_dup0 (g_enum_get_value_by_nick (enum_class, value_nick));
	val = _tmp1_;
	g_return_val_if_fail (val != NULL, -1);
	result = (*val).value;
	_g_free0 (val);
	_g_type_class_unref0 (enum_class);
	return result;
}

static inline gpointer
boxes_pair_get_instance_private (BoxesPair* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesPair_private_offset);
}

BoxesPair*
boxes_pair_construct (GType object_type,
                      GType t1_type,
                      GBoxedCopyFunc t1_dup_func,
                      GDestroyNotify t1_destroy_func,
                      GType t2_type,
                      GBoxedCopyFunc t2_dup_func,
                      GDestroyNotify t2_destroy_func,
                      gconstpointer first,
                      gconstpointer second)
{
	BoxesPair* self = NULL;
	gpointer _tmp0_;
	gpointer _tmp1_;
	self = (BoxesPair*) g_type_create_instance (object_type);
	self->priv->t1_type = t1_type;
	self->priv->t1_dup_func = t1_dup_func;
	self->priv->t1_destroy_func = t1_destroy_func;
	self->priv->t2_type = t2_type;
	self->priv->t2_dup_func = t2_dup_func;
	self->priv->t2_destroy_func = t2_destroy_func;
	_tmp0_ = ((first != NULL) && (t1_dup_func != NULL)) ? t1_dup_func ((gpointer) first) : ((gpointer) first);
	((self->first == NULL) || (t1_destroy_func == NULL)) ? NULL : (self->first = (t1_destroy_func (self->first), NULL));
	self->first = _tmp0_;
	_tmp1_ = ((second != NULL) && (t2_dup_func != NULL)) ? t2_dup_func ((gpointer) second) : ((gpointer) second);
	((self->second == NULL) || (t2_destroy_func == NULL)) ? NULL : (self->second = (t2_destroy_func (self->second), NULL));
	self->second = _tmp1_;
	return self;
}

BoxesPair*
boxes_pair_new (GType t1_type,
                GBoxedCopyFunc t1_dup_func,
                GDestroyNotify t1_destroy_func,
                GType t2_type,
                GBoxedCopyFunc t2_dup_func,
                GDestroyNotify t2_destroy_func,
                gconstpointer first,
                gconstpointer second)
{
	return boxes_pair_construct (BOXES_TYPE_PAIR, t1_type, t1_dup_func, t1_destroy_func, t2_type, t2_dup_func, t2_destroy_func, first, second);
}

static void
boxes_value_pair_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
boxes_value_pair_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		boxes_pair_unref (value->data[0].v_pointer);
	}
}

static void
boxes_value_pair_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
boxes_value_pair_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
boxes_value_pair_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BoxesPair * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
boxes_value_pair_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	BoxesPair ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
boxes_param_spec_pair (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	BoxesParamSpecPair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
boxes_value_get_pair (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_PAIR), NULL);
	return value->data[0].v_pointer;
}

void
boxes_value_set_pair (GValue* value,
                      gpointer v_object)
{
	BoxesPair * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_pair_unref (old);
	}
}

void
boxes_value_take_pair (GValue* value,
                       gpointer v_object)
{
	BoxesPair * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_pair_unref (old);
	}
}

static void
boxes_pair_class_init (BoxesPairClass * klass,
                       gpointer klass_data)
{
	boxes_pair_parent_class = g_type_class_peek_parent (klass);
	((BoxesPairClass *) klass)->finalize = boxes_pair_finalize;
	g_type_class_adjust_private_offset (klass, &BoxesPair_private_offset);
}

static void
boxes_pair_instance_init (BoxesPair * self,
                          gpointer klass)
{
	self->priv = boxes_pair_get_instance_private (self);
	self->ref_count = 1;
}

static void
boxes_pair_finalize (BoxesPair * obj)
{
	BoxesPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_PAIR, BoxesPair);
	g_signal_handlers_destroy (self);
	((self->first == NULL) || (self->priv->t1_destroy_func == NULL)) ? NULL : (self->first = (self->priv->t1_destroy_func (self->first), NULL));
	((self->second == NULL) || (self->priv->t2_destroy_func == NULL)) ? NULL : (self->second = (self->priv->t2_destroy_func (self->second), NULL));
}

static GType
boxes_pair_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { boxes_value_pair_init, boxes_value_pair_free_value, boxes_value_pair_copy_value, boxes_value_pair_peek_pointer, "p", boxes_value_pair_collect_value, "p", boxes_value_pair_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BoxesPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesPair), 0, (GInstanceInitFunc) boxes_pair_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType boxes_pair_type_id;
	boxes_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BoxesPair_private_offset = g_type_add_instance_private (boxes_pair_type_id, sizeof (BoxesPairPrivate));
	return boxes_pair_type_id;
}

GType
boxes_pair_get_type (void)
{
	static volatile gsize boxes_pair_type_id__once = 0;
	if (g_once_init_enter (&boxes_pair_type_id__once)) {
		GType boxes_pair_type_id;
		boxes_pair_type_id = boxes_pair_get_type_once ();
		g_once_init_leave (&boxes_pair_type_id__once, boxes_pair_type_id);
	}
	return boxes_pair_type_id__once;
}

gpointer
boxes_pair_ref (gpointer instance)
{
	BoxesPair * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
boxes_pair_unref (gpointer instance)
{
	BoxesPair * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
boxes_query_get_instance_private (BoxesQuery* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesQuery_private_offset);
}

BoxesQuery*
boxes_query_construct (GType object_type,
                       const gchar* query)
{
	BoxesQuery * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (query != NULL, NULL);
	self = (BoxesQuery*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (query);
	_g_free0 (self->priv->query);
	self->priv->query = _tmp0_;
	boxes_query_parse (self);
	return self;
}

BoxesQuery*
boxes_query_new (const gchar* query)
{
	return boxes_query_construct (BOXES_TYPE_QUERY, query);
}

void
boxes_query_parse (BoxesQuery* self)
{
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->query;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "&", 0);
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp2_;
		p_collection_length1 = _vala_array_length (_tmp1_);
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp3_;
			gchar* p = NULL;
			_tmp3_ = g_strdup (p_collection[p_it]);
			p = _tmp3_;
			{
				gchar** pair = NULL;
				const gchar* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				gint pair_length1;
				gint _pair_size_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				GHashTable* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp4_ = p;
				_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "=", 0);
				pair = _tmp6_;
				pair_length1 = _vala_array_length (_tmp5_);
				_pair_size_ = pair_length1;
				_tmp7_ = pair;
				_tmp7__length1 = pair_length1;
				if (_tmp7__length1 != 2) {
					pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (p);
					continue;
				}
				_tmp8_ = self->priv->params;
				_tmp9_ = pair;
				_tmp9__length1 = pair_length1;
				_tmp10_ = _tmp9_[0];
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = pair;
				_tmp12__length1 = pair_length1;
				_tmp13_ = _tmp12_[1];
				_tmp14_ = g_strdup (_tmp13_);
				g_hash_table_insert (_tmp8_, _tmp11_, _tmp14_);
				pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (p);
			}
		}
		p_collection = (_vala_array_free (p_collection, p_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

gchar*
boxes_query_get (BoxesQuery* self,
                 const gchar* key)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->params;
	_tmp1_ = g_hash_table_lookup (_tmp0_, key);
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	result = _tmp2_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
boxes_query_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesQuery * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (boxes_query_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_QUERY, BoxesQuery);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->params);
	self->priv->params = _tmp2_;
	return obj;
}

static void
boxes_query_class_init (BoxesQueryClass * klass,
                        gpointer klass_data)
{
	boxes_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesQuery_private_offset);
	G_OBJECT_CLASS (klass)->constructor = boxes_query_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_query_finalize;
}

static void
boxes_query_instance_init (BoxesQuery * self,
                           gpointer klass)
{
	self->priv = boxes_query_get_instance_private (self);
}

static void
boxes_query_finalize (GObject * obj)
{
	BoxesQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_QUERY, BoxesQuery);
	_g_free0 (self->priv->query);
	_g_hash_table_unref0 (self->priv->params);
	G_OBJECT_CLASS (boxes_query_parent_class)->finalize (obj);
}

static GType
boxes_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesQuery), 0, (GInstanceInitFunc) boxes_query_instance_init, NULL };
	GType boxes_query_type_id;
	boxes_query_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesQuery", &g_define_type_info, 0);
	BoxesQuery_private_offset = g_type_add_instance_private (boxes_query_type_id, sizeof (BoxesQueryPrivate));
	return boxes_query_type_id;
}

GType
boxes_query_get_type (void)
{
	static volatile gsize boxes_query_type_id__once = 0;
	if (g_once_init_enter (&boxes_query_type_id__once)) {
		GType boxes_query_type_id;
		boxes_query_type_id = boxes_query_get_type_once ();
		g_once_init_leave (&boxes_query_type_id__once, boxes_query_type_id);
	}
	return boxes_query_type_id__once;
}

static inline gpointer
boxes_activity_progress_get_instance_private (BoxesActivityProgress* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesActivityProgress_private_offset);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BoxesActivityProgress* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->child_progress);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda7_ (Block4Data* _data4_)
{
	BoxesActivityProgress* self;
	gdouble child_progress_delta = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = _data4_->self;
	_tmp0_ = _data4_->child_progress->priv->_progress;
	child_progress_delta = _tmp0_ - _data4_->last_child_progress;
	_tmp1_ = self->priv->_progress;
	boxes_activity_progress_set_progress (self, _tmp1_ + (child_progress_delta * _data4_->scale));
	_tmp2_ = _data4_->child_progress->priv->_progress;
	_data4_->last_child_progress = _tmp2_;
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ (self);
}

BoxesActivityProgress*
boxes_activity_progress_add_child_activity (BoxesActivityProgress* self,
                                            gdouble scale)
{
	Block4Data* _data4_;
	BoxesActivityProgress* _tmp0_;
	BoxesActivityProgress* _tmp1_;
	BoxesActivityProgress* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->scale = scale;
	_tmp0_ = boxes_activity_progress_new ();
	_data4_->child_progress = _tmp0_;
	_data4_->last_child_progress = 0.;
	g_signal_connect_data ((GObject*) _data4_->child_progress, "notify::progress", (GCallback) ___lambda7__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp1_ = _g_object_ref0 (_data4_->child_progress);
	result = _tmp1_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

BoxesActivityProgress*
boxes_activity_progress_construct (GType object_type)
{
	BoxesActivityProgress * self = NULL;
	self = (BoxesActivityProgress*) g_object_new (object_type, NULL);
	return self;
}

BoxesActivityProgress*
boxes_activity_progress_new (void)
{
	return boxes_activity_progress_construct (BOXES_TYPE_ACTIVITY_PROGRESS);
}

gdouble
boxes_activity_progress_get_progress (BoxesActivityProgress* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}

void
boxes_activity_progress_set_progress (BoxesActivityProgress* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_activity_progress_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_activity_progress_properties[BOXES_ACTIVITY_PROGRESS_PROGRESS_PROPERTY]);
	}
}

const gchar*
boxes_activity_progress_get_info (BoxesActivityProgress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	result = _tmp0_;
	return result;
}

void
boxes_activity_progress_set_info (BoxesActivityProgress* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_activity_progress_get_info (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_info);
		self->priv->_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_activity_progress_properties[BOXES_ACTIVITY_PROGRESS_INFO_PROPERTY]);
	}
}

static void
boxes_activity_progress_class_init (BoxesActivityProgressClass * klass,
                                    gpointer klass_data)
{
	boxes_activity_progress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesActivityProgress_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_activity_progress_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_activity_progress_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_activity_progress_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_ACTIVITY_PROGRESS_PROGRESS_PROPERTY, boxes_activity_progress_properties[BOXES_ACTIVITY_PROGRESS_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_ACTIVITY_PROGRESS_INFO_PROPERTY, boxes_activity_progress_properties[BOXES_ACTIVITY_PROGRESS_INFO_PROPERTY] = g_param_spec_string ("info", "info", "info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
boxes_activity_progress_instance_init (BoxesActivityProgress * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	self->priv = boxes_activity_progress_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_info = _tmp0_;
}

static void
boxes_activity_progress_finalize (GObject * obj)
{
	BoxesActivityProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ACTIVITY_PROGRESS, BoxesActivityProgress);
	_g_free0 (self->priv->_info);
	G_OBJECT_CLASS (boxes_activity_progress_parent_class)->finalize (obj);
}

static GType
boxes_activity_progress_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesActivityProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_activity_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesActivityProgress), 0, (GInstanceInitFunc) boxes_activity_progress_instance_init, NULL };
	GType boxes_activity_progress_type_id;
	boxes_activity_progress_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesActivityProgress", &g_define_type_info, 0);
	BoxesActivityProgress_private_offset = g_type_add_instance_private (boxes_activity_progress_type_id, sizeof (BoxesActivityProgressPrivate));
	return boxes_activity_progress_type_id;
}

GType
boxes_activity_progress_get_type (void)
{
	static volatile gsize boxes_activity_progress_type_id__once = 0;
	if (g_once_init_enter (&boxes_activity_progress_type_id__once)) {
		GType boxes_activity_progress_type_id;
		boxes_activity_progress_type_id = boxes_activity_progress_get_type_once ();
		g_once_init_leave (&boxes_activity_progress_type_id__once, boxes_activity_progress_type_id);
	}
	return boxes_activity_progress_type_id__once;
}

static void
_vala_boxes_activity_progress_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	BoxesActivityProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_ACTIVITY_PROGRESS, BoxesActivityProgress);
	switch (property_id) {
		case BOXES_ACTIVITY_PROGRESS_PROGRESS_PROPERTY:
		g_value_set_double (value, boxes_activity_progress_get_progress (self));
		break;
		case BOXES_ACTIVITY_PROGRESS_INFO_PROPERTY:
		g_value_set_string (value, boxes_activity_progress_get_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_activity_progress_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	BoxesActivityProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_ACTIVITY_PROGRESS, BoxesActivityProgress);
	switch (property_id) {
		case BOXES_ACTIVITY_PROGRESS_PROGRESS_PROPERTY:
		boxes_activity_progress_set_progress (self, g_value_get_double (value));
		break;
		case BOXES_ACTIVITY_PROGRESS_INFO_PROPERTY:
		boxes_activity_progress_set_info (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gboolean
boxes_is_set (const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (str != NULL) {
		_tmp0_ = g_strcmp0 (str, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
boxes_yes_no (gboolean value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	if (value) {
		_tmp0_ = _ ("yes");
	} else {
		_tmp0_ = _ ("no");
	}
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
boxes_indent (const gchar* space,
              const gchar* text)
{
	gchar* indented = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar* result;
	g_return_val_if_fail (space != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_strdup ("");
	indented = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (text, "\n", 0);
	{
		gchar** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint _l_collection_size_ = 0;
		gint l_it = 0;
		l_collection = _tmp2_;
		l_collection_length1 = _vala_array_length (_tmp1_);
		for (l_it = 0; l_it < l_collection_length1; l_it = l_it + 1) {
			gchar* _tmp3_;
			gchar* l = NULL;
			_tmp3_ = g_strdup (l_collection[l_it]);
			l = _tmp3_;
			{
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp4_ = indented;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ != 0) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = indented;
					_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
					_g_free0 (indented);
					indented = _tmp8_;
				}
				_tmp9_ = l;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_ != 0) {
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = indented;
					_tmp13_ = l;
					_tmp14_ = g_strconcat (space, _tmp13_, NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
					_g_free0 (indented);
					indented = _tmp16_;
					_g_free0 (_tmp15_);
				}
				_g_free0 (l);
			}
		}
		l_collection = (_vala_array_free (l_collection, l_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = indented;
	return result;
}

void
boxes_execute_libarchive_function (struct archive* archive,
                                   BoxesLibarchiveFunction function,
                                   gpointer function_target,
                                   guint num_retries,
                                   GError** error)
{
	gchar* msg = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (archive != NULL);
	switch (function (function_target)) {
		case ARCHIVE_OK:
		{
			return;
		}
		case ARCHIVE_EOF:
		{
			GError* _tmp0_;
			_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CLOSED, "End of file reached.");
			_inner_error0_ = _tmp0_;
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		case ARCHIVE_RETRY:
		{
			if (num_retries < ((guint) 1)) {
				break;
			}
			boxes_execute_libarchive_function (archive, function, function_target, num_retries - 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			return;
		}
		case ARCHIVE_WARN:
		{
			const gchar* _tmp1_;
			_tmp1_ = archive_error_string (archive);
			g_warning ("util.vala:372: %s", _tmp1_);
			return;
		}
		default:
		{
			break;
		}
	}
	_tmp2_ = archive_error_string (archive);
	_tmp3_ = g_strdup (_tmp2_);
	msg = _tmp3_;
	_tmp4_ = msg;
	if (g_strcmp0 (_tmp4_, "Unrecognized archive format") == 0) {
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp5_ = msg;
		_tmp6_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "%s", _tmp5_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			return;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = msg;
	_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _tmp7_);
	_inner_error0_ = _tmp8_;
	if (_inner_error0_->domain == G_IO_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		return;
	} else {
		_g_free0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		g_slice_free (Block5Data, _data5_);
	}
}

static int
___lambda8_ (Block5Data* _data5_)
{
	struct archive_entry* _tmp0_ = NULL;
	int _tmp1_;
	int result;
	_tmp1_ = archive_read_next_header (_data5_->archive, &_tmp0_);
	_data5_->local_iterator = _tmp0_;
	result = _tmp1_;
	return result;
}

static int
____lambda8__boxes_libarchive_function (gpointer self)
{
	int result;
	result = ___lambda8_ (self);
	return result;
}

gboolean
boxes_get_next_header (struct archive* archive,
                       struct archive_entry** iterator,
                       guint num_retries,
                       GError** error)
{
	struct archive_entry* _vala_iterator = NULL;
	Block5Data* _data5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (archive != NULL, FALSE);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->archive = archive;
	_data5_->local_iterator = NULL;
	{
		boxes_execute_libarchive_function (_data5_->archive, ____lambda8__boxes_libarchive_function, _data5_, num_retries, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_CLOSED)) {
				goto __catch0_g_io_error_closed;
			}
			goto __finally0;
		}
		_vala_iterator = _data5_->local_iterator;
		result = TRUE;
		block5_data_unref (_data5_);
		_data5_ = NULL;
		if (iterator) {
			*iterator = _vala_iterator;
		}
		return result;
	}
	goto __finally0;
	__catch0_g_io_error_closed:
	{
		g_clear_error (&_inner_error0_);
		_vala_iterator = _data5_->local_iterator;
		result = FALSE;
		block5_data_unref (_data5_);
		_data5_ = NULL;
		if (iterator) {
			*iterator = _vala_iterator;
		}
		return result;
	}
	__finally0:
	if (_inner_error0_->domain == G_IO_ERROR) {
		gboolean _tmp0_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return _tmp0_;
	} else {
		gboolean _tmp1_ = FALSE;
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
}

gunichar
boxes_strip_char (gunichar ch)
{
	gunichar result;
	switch (g_unichar_type (ch)) {
		case G_UNICODE_CONTROL:
		case G_UNICODE_FORMAT:
		case G_UNICODE_UNASSIGNED:
		case G_UNICODE_NON_SPACING_MARK:
		case G_UNICODE_COMBINING_MARK:
		case G_UNICODE_ENCLOSING_MARK:
		{
			result = (gunichar) 0;
			return result;
		}
		default:
		{
			result = g_unichar_tolower (ch);
			return result;
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gchar*
boxes_canonicalize_for_search (const gchar* str)
{
	const gchar* s = NULL;
	gunichar* buf = NULL;
	gunichar* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	GString* res = NULL;
	GString* _tmp1_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_new0 (gunichar, 18);
	buf = _tmp0_;
	buf_length1 = 18;
	_buf_size_ = buf_length1;
	_tmp1_ = g_string_new ("");
	res = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		s = str;
		_tmp2_ = TRUE;
		while (TRUE) {
			const gchar* _tmp5_;
			gunichar c = 0U;
			const gchar* _tmp6_;
			if (!_tmp2_) {
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = s;
				_tmp4_ = g_utf8_next_char (_tmp3_);
				s = _tmp4_;
			}
			_tmp2_ = FALSE;
			_tmp5_ = s;
			if (!(((gint) string_get (_tmp5_, (glong) 0)) != 0)) {
				break;
			}
			_tmp6_ = s;
			c = boxes_strip_char (string_get_char (_tmp6_, (glong) 0));
			if (c != ((gunichar) 0)) {
				gsize size = 0UL;
				gunichar* _tmp7_;
				gint _tmp7__length1;
				_tmp7_ = buf;
				_tmp7__length1 = buf_length1;
				size = g_unichar_fully_decompose (c, FALSE, _tmp7_, (gint) _tmp7__length1);
				if (size > ((gsize) 0)) {
					GString* _tmp8_;
					gunichar* _tmp9_;
					gint _tmp9__length1;
					gunichar _tmp10_;
					_tmp8_ = res;
					_tmp9_ = buf;
					_tmp9__length1 = buf_length1;
					_tmp10_ = _tmp9_[0];
					g_string_append_unichar (_tmp8_, _tmp10_);
				}
			}
		}
	}
	_tmp11_ = res;
	_tmp12_ = _tmp11_->str;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_string_free0 (res);
	buf = (g_free (buf), NULL);
	return result;
}

gchar*
boxes_get_user_special_dir_with_fallback (GUserDirectory id)
{
	gchar* name = NULL;
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean use_current_dir = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp11_;
	gchar* result;
	name = NULL;
	_tmp0_ = g_get_user_special_dir (id);
	_tmp1_ = g_strdup (_tmp0_);
	dir = _tmp1_;
	use_current_dir = FALSE;
	switch (id) {
		case G_USER_DIRECTORY_DOWNLOAD:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("DOWNLOAD");
			_g_free0 (name);
			name = _tmp2_;
			break;
		}
		case G_USER_DIRECTORY_PICTURES:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("PICTURES");
			_g_free0 (name);
			name = _tmp3_;
			break;
		}
		case G_USER_DIRECTORY_PUBLIC_SHARE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("PUBLIC_SHARE");
			_g_free0 (name);
			name = _tmp4_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp5_ = dir;
	if (!boxes_is_set (_tmp5_)) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = name;
		g_warning ("util.vala:459: XDG directory '%s' not set. Install 'xdg-user-dirs' pac" \
"kage and run 'xdg-user-dirs-update' command.", _tmp6_);
		_tmp7_ = g_get_home_dir ();
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (dir);
		dir = _tmp8_;
		_tmp9_ = dir;
		if (boxes_is_set (_tmp9_)) {
			const gchar* _tmp10_;
			_tmp10_ = dir;
			g_debug ("util.vala:465: Using home directory '%s' as fallback.", _tmp10_);
		} else {
			g_warning ("util.vala:467: Home directory not set. Falling back to current dir.");
			use_current_dir = TRUE;
		}
	}
	_tmp11_ = dir;
	if (boxes_is_set (_tmp11_)) {
		const gchar* _tmp12_;
		GFile* file = NULL;
		const gchar* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		_tmp12_ = dir;
		boxes_ensure_directory (_tmp12_);
		_tmp13_ = dir;
		_tmp14_ = g_file_new_for_path (_tmp13_);
		file = _tmp14_;
		_tmp15_ = file;
		if (!g_file_query_exists (_tmp15_, NULL)) {
			const gchar* _tmp16_;
			_tmp16_ = dir;
			g_warning ("util.vala:479: Expected directory '%s' doesn't exist. Falling back to " \
"current dir.", _tmp16_);
			use_current_dir = TRUE;
		}
		_g_object_unref0 (file);
	}
	if (use_current_dir) {
		gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = g_get_current_dir ();
		_g_free0 (dir);
		dir = _tmp17_;
		_tmp18_ = dir;
		g_debug ("util.vala:489: Using current directory '%s' as fallback.", _tmp18_);
	}
	result = dir;
	_g_free0 (name);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

