/* gitg-remove-remote-action.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-remove-remote-action.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2022 - Adwait Rawat
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libgitg.h"
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>

#define GITG_REMOVE_REMOTE_ACTION_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_REMOVE_REMOTE_ACTION (gitg_remove_remote_action_get_type ())
#define GITG_REMOVE_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteAction))
#define GITG_REMOVE_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteActionClass))
#define GITG_IS_REMOVE_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOVE_REMOTE_ACTION))
#define GITG_IS_REMOVE_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOVE_REMOTE_ACTION))
#define GITG_REMOVE_REMOTE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteActionClass))

typedef struct _GitgRemoveRemoteAction GitgRemoveRemoteAction;
typedef struct _GitgRemoveRemoteActionClass GitgRemoveRemoteActionClass;
typedef struct _GitgRemoveRemoteActionPrivate GitgRemoveRemoteActionPrivate;
enum  {
	GITG_REMOVE_REMOTE_ACTION_0_PROPERTY,
	GITG_REMOVE_REMOTE_ACTION_APPLICATION_PROPERTY,
	GITG_REMOVE_REMOTE_ACTION_ACTION_INTERFACE_PROPERTY,
	GITG_REMOVE_REMOTE_ACTION_ID_PROPERTY,
	GITG_REMOVE_REMOTE_ACTION_DISPLAY_NAME_PROPERTY,
	GITG_REMOVE_REMOTE_ACTION_DESCRIPTION_PROPERTY,
	GITG_REMOVE_REMOTE_ACTION_NUM_PROPERTIES
};
static GParamSpec* gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgRemoveRemoteAction {
	GObject parent_instance;
	GitgRemoveRemoteActionPrivate * priv;
};

struct _GitgRemoveRemoteActionClass {
	GObjectClass parent_class;
};

struct _GitgRemoveRemoteActionPrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
	gchar* remote_name;
	GitgRemote* d_remote;
};

static gint GitgRemoveRemoteAction_private_offset;
static gpointer gitg_remove_remote_action_parent_class = NULL;
static GitgExtUIElementIface * gitg_remove_remote_action_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_remove_remote_action_gitg_ext_action_parent_iface = NULL;

VALA_EXTERN GType gitg_remove_remote_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRemoveRemoteAction, g_object_unref)
VALA_EXTERN GitgRemoveRemoteAction* gitg_remove_remote_action_new (GitgExtApplication* application,
                                                       GitgExtRefActionInterface* action_interface,
                                                       const gchar* remote_name);
VALA_EXTERN GitgRemoveRemoteAction* gitg_remove_remote_action_construct (GType object_type,
                                                             GitgExtApplication* application,
                                                             GitgExtRefActionInterface* action_interface,
                                                             const gchar* remote_name);
static void gitg_remove_remote_action_real_activate (GitgExtUIElement* base);
static gboolean gitg_remove_remote_action_on_response (GitgRemoveRemoteAction* self,
                                                GtkResponseType response);
static gboolean _gitg_remove_remote_action_on_response_gitg_ext_user_query_response (GitgExtUserQuery* _sender,
                                                                              GtkResponseType response_type,
                                                                              gpointer self);
VALA_EXTERN GitgExtRefActionInterface* gitg_remove_remote_action_get_action_interface (GitgRemoveRemoteAction* self);
VALA_EXTERN void gitg_remove_remote_action_set_action_interface (GitgRemoveRemoteAction* self,
                                                     GitgExtRefActionInterface* value);
static void gitg_remove_remote_action_finalize (GObject * obj);
static GType gitg_remove_remote_action_get_type_once (void);
static void _vala_gitg_remove_remote_action_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_gitg_remove_remote_action_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_remove_remote_action_get_instance_private (GitgRemoveRemoteAction* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRemoveRemoteAction_private_offset);
}

GitgRemoveRemoteAction*
gitg_remove_remote_action_construct (GType object_type,
                                     GitgExtApplication* application,
                                     GitgExtRefActionInterface* action_interface,
                                     const gchar* remote_name)
{
	GitgRemoveRemoteAction * self = NULL;
	gchar* _tmp0_;
	GitgExtRemoteLookup* _tmp1_;
	GitgExtRemoteLookup* _tmp2_;
	GitgExtRemoteLookup* _tmp3_;
	GitgRemote* _tmp4_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	g_return_val_if_fail (remote_name != NULL, NULL);
	self = (GitgRemoveRemoteAction*) g_object_new (object_type, "application", application, "action-interface", action_interface, NULL);
	_tmp0_ = g_strdup (remote_name);
	_g_free0 (self->priv->remote_name);
	self->priv->remote_name = _tmp0_;
	_tmp1_ = gitg_ext_application_get_remote_lookup (application);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_ext_remote_lookup_lookup (_tmp3_, remote_name);
	_g_object_unref0 (self->priv->d_remote);
	self->priv->d_remote = _tmp4_;
	_g_object_unref0 (_tmp3_);
	return self;
}

GitgRemoveRemoteAction*
gitg_remove_remote_action_new (GitgExtApplication* application,
                               GitgExtRefActionInterface* action_interface,
                               const gchar* remote_name)
{
	return gitg_remove_remote_action_construct (GITG_TYPE_REMOVE_REMOTE_ACTION, application, action_interface, remote_name);
}

static gboolean
_gitg_remove_remote_action_on_response_gitg_ext_user_query_response (GitgExtUserQuery* _sender,
                                                                     GtkResponseType response_type,
                                                                     gpointer self)
{
	gboolean result;
	result = gitg_remove_remote_action_on_response ((GitgRemoveRemoteAction*) self, response_type);
	return result;
}

static void
gitg_remove_remote_action_real_activate (GitgExtUIElement* base)
{
	GitgRemoveRemoteAction * self;
	GitgExtUserQuery* query = NULL;
	GitgExtUserQuery* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GitgExtUserQueryResponse* _tmp7_;
	GitgExtUserQueryResponse* _tmp8_;
	GitgExtUserQueryResponse** _tmp9_;
	GitgExtUserQueryResponse** _tmp10_;
	gint _tmp10__length1;
	GitgExtRefActionInterface* _tmp11_;
	GitgExtApplication* _tmp12_;
	GitgExtApplication* _tmp13_;
	GitgExtApplication* _tmp14_;
	self = (GitgRemoveRemoteAction*) base;
	_tmp0_ = gitg_ext_user_query_new ();
	query = _tmp0_;
	_tmp1_ = self->priv->remote_name;
	_tmp2_ = g_strdup_printf (_ ("Delete remote %s"), _tmp1_);
	_tmp3_ = _tmp2_;
	gitg_ext_user_query_set_title (query, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->remote_name;
	_tmp5_ = g_strdup_printf (_ ("Are you sure that you want to remove the remote %s?"), _tmp4_);
	_tmp6_ = _tmp5_;
	gitg_ext_user_query_set_message (query, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = gitg_ext_user_query_response_new (_ ("Cancel"), GTK_RESPONSE_CANCEL);
	_tmp8_ = gitg_ext_user_query_response_new (_ ("Remove"), GTK_RESPONSE_OK);
	_tmp9_ = g_new0 (GitgExtUserQueryResponse*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	gitg_ext_user_query_set_responses (query, _tmp10_, (gint) 2);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_object_unref), NULL);
	gitg_ext_user_query_set_default_response (query, GTK_RESPONSE_OK);
	g_signal_connect_object (query, "response", (GCallback) _gitg_remove_remote_action_on_response_gitg_ext_user_query_response, self, 0);
	_tmp11_ = self->priv->_action_interface;
	_tmp12_ = gitg_ext_ref_action_interface_get_application (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	gitg_ext_application_user_query (_tmp14_, query);
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (query);
}

static gboolean
gitg_remove_remote_action_on_response (GitgRemoveRemoteAction* self,
                                       GtkResponseType response)
{
	GitgRepository* repo = NULL;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GitgExtApplication* _tmp14_;
	GitgExtApplication* _tmp15_;
	GtkApplicationWindow* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (response != GTK_RESPONSE_OK) {
		result = TRUE;
		return result;
	}
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gitg_ext_application_get_repository (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	repo = _tmp5_;
	{
		GitgRepository* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = repo;
		_tmp7_ = self->priv->remote_name;
		ggit_repository_remove_remote ((GgitRepository*) _tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GitgExtApplication* _tmp8_;
		GitgExtApplication* _tmp9_;
		GitgExtApplication* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		gitg_ext_application_show_infobar (_tmp10_, _ ("Failed to remove remote"), _tmp12_, GTK_MESSAGE_ERROR);
		_g_object_unref0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		_g_object_unref0 (repo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	_tmp14_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_application_window_get_type (), GtkApplicationWindow);
	g_action_group_activate_action ((GActionGroup*) _tmp16_, "reload", NULL);
	_g_object_unref0 (_tmp16_);
	result = TRUE;
	_g_object_unref0 (repo);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GitgExtApplication*
gitg_remove_remote_action_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgRemoveRemoteAction* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgRemoveRemoteAction*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_remove_remote_action_real_set_application (GitgExtUIElement* base,
                                                GitgExtApplication* value)
{
	GitgRemoveRemoteAction* self;
	GitgExtApplication* old_value;
	self = (GitgRemoveRemoteAction*) base;
	old_value = gitg_remove_remote_action_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

GitgExtRefActionInterface*
gitg_remove_remote_action_get_action_interface (GitgRemoveRemoteAction* self)
{
	GitgExtRefActionInterface* result;
	GitgExtRefActionInterface* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_interface;
	result = _tmp0_;
	return result;
}

void
gitg_remove_remote_action_set_action_interface (GitgRemoveRemoteAction* self,
                                                GitgExtRefActionInterface* value)
{
	GitgExtRefActionInterface* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_remove_remote_action_get_action_interface (self);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_ACTION_INTERFACE_PROPERTY]);
	}
}

static gchar*
gitg_remove_remote_action_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgRemoveRemoteAction* self;
	gchar* _tmp0_;
	self = (GitgRemoveRemoteAction*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/ref-actions/remove-remote");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_remove_remote_action_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgRemoveRemoteAction* self;
	gchar* _tmp0_;
	self = (GitgRemoveRemoteAction*) base;
	_tmp0_ = g_strdup (_ ("Remove remote"));
	result = _tmp0_;
	return result;
}

static gchar*
gitg_remove_remote_action_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgRemoveRemoteAction* self;
	gchar* _tmp0_;
	self = (GitgRemoveRemoteAction*) base;
	_tmp0_ = g_strdup (_ ("Removes remote from the remotes list"));
	result = _tmp0_;
	return result;
}

static void
gitg_remove_remote_action_class_init (GitgRemoveRemoteActionClass * klass,
                                      gpointer klass_data)
{
	gitg_remove_remote_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRemoveRemoteAction_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_remove_remote_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_remove_remote_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_remove_remote_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOVE_REMOTE_ACTION_APPLICATION_PROPERTY, gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOVE_REMOTE_ACTION_ACTION_INTERFACE_PROPERTY, gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOVE_REMOTE_ACTION_ID_PROPERTY, gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOVE_REMOTE_ACTION_DISPLAY_NAME_PROPERTY, gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOVE_REMOTE_ACTION_DESCRIPTION_PROPERTY, gitg_remove_remote_action_properties[GITG_REMOVE_REMOTE_ACTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_remove_remote_action_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                              gpointer iface_data)
{
	gitg_remove_remote_action_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (GitgExtUIElement*)) gitg_remove_remote_action_real_activate;
	iface->get_application = gitg_remove_remote_action_real_get_application;
	iface->set_application = gitg_remove_remote_action_real_set_application;
	iface->get_id = gitg_remove_remote_action_real_get_id;
	iface->get_display_name = gitg_remove_remote_action_real_get_display_name;
	iface->get_description = gitg_remove_remote_action_real_get_description;
}

static void
gitg_remove_remote_action_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                          gpointer iface_data)
{
	gitg_remove_remote_action_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gitg_remove_remote_action_instance_init (GitgRemoveRemoteAction * self,
                                         gpointer klass)
{
	self->priv = gitg_remove_remote_action_get_instance_private (self);
}

static void
gitg_remove_remote_action_finalize (GObject * obj)
{
	GitgRemoveRemoteAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteAction);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	_g_free0 (self->priv->remote_name);
	_g_object_unref0 (self->priv->d_remote);
	G_OBJECT_CLASS (gitg_remove_remote_action_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_remove_remote_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRemoveRemoteActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remove_remote_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemoveRemoteAction), 0, (GInstanceInitFunc) gitg_remove_remote_action_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_remove_remote_action_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_remove_remote_action_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_remove_remote_action_type_id;
	gitg_remove_remote_action_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgRemoveRemoteAction", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_remove_remote_action_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_remove_remote_action_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	GitgRemoveRemoteAction_private_offset = g_type_add_instance_private (gitg_remove_remote_action_type_id, sizeof (GitgRemoveRemoteActionPrivate));
	return gitg_remove_remote_action_type_id;
}

GType
gitg_remove_remote_action_get_type (void)
{
	static gsize gitg_remove_remote_action_type_id__once = 0;
	if (g_once_init_enter (&gitg_remove_remote_action_type_id__once)) {
		GType gitg_remove_remote_action_type_id;
		gitg_remove_remote_action_type_id = gitg_remove_remote_action_get_type_once ();
		g_once_init_leave (&gitg_remove_remote_action_type_id__once, gitg_remove_remote_action_type_id);
	}
	return gitg_remove_remote_action_type_id__once;
}

static void
_vala_gitg_remove_remote_action_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GitgRemoveRemoteAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteAction);
	switch (property_id) {
		case GITG_REMOVE_REMOTE_ACTION_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_REMOVE_REMOTE_ACTION_ACTION_INTERFACE_PROPERTY:
		g_value_set_object (value, gitg_remove_remote_action_get_action_interface (self));
		break;
		case GITG_REMOVE_REMOTE_ACTION_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_REMOVE_REMOTE_ACTION_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_REMOVE_REMOTE_ACTION_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_remove_remote_action_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GitgRemoveRemoteAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteAction);
	switch (property_id) {
		case GITG_REMOVE_REMOTE_ACTION_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_REMOVE_REMOTE_ACTION_ACTION_INTERFACE_PROPERTY:
		gitg_remove_remote_action_set_action_interface (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

