/* Generated by wayland-scanner 1.24.0 */

#ifndef GAMESCOPE_INPUT_METHOD_CLIENT_PROTOCOL_H
#define GAMESCOPE_INPUT_METHOD_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_gamescope_input_method The gamescope_input_method protocol
 * Protocol for creating input methods
 *
 * @section page_desc_gamescope_input_method Description
 *
 * This protocol allows applications to act as input methods for compositors.
 *
 * An input method context is used to manage the state of the input method.
 *
 * Text strings are UTF-8 encoded, their indices and lengths are in bytes.
 *
 * This iteration of the protocol is a subset of this work-in-progress proposal:
 * https://gitlab.freedesktop.org/wayland/wayland-protocols/-/merge_requests/112
 *
 * This is a private Gamescope protocol. Regular Wayland clients must not use
 * it.
 *
 * @section page_ifaces_gamescope_input_method Interfaces
 * - @subpage page_iface_gamescope_input_method_manager - input method manager
 * - @subpage page_iface_gamescope_input_method - input method
 * @section page_copyright_gamescope_input_method Copyright
 * <pre>
 *
 * Copyright © 2008-2011 Kristian Høgsberg
 * Copyright © 2010-2011 Intel Corporation
 * Copyright © 2012-2013 Collabora, Ltd.
 * Copyright © 2012, 2013 Intel Corporation
 * Copyright © 2015, 2016 Jan Arne Petersen
 * Copyright © 2017, 2018 Red Hat, Inc.
 * Copyright © 2018       Purism SPC
 * Copyright © 2021       Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_input_method;
struct gamescope_input_method_manager;
struct wl_seat;

#ifndef GAMESCOPE_INPUT_METHOD_MANAGER_INTERFACE
#define GAMESCOPE_INPUT_METHOD_MANAGER_INTERFACE
/**
 * @page page_iface_gamescope_input_method_manager gamescope_input_method_manager
 * @section page_iface_gamescope_input_method_manager_desc Description
 *
 * The input method manager allows the client to become the input method on
 * a chosen seat.
 *
 * No more than one input method must be associated with any seat at any
 * given time.
 * @section page_iface_gamescope_input_method_manager_api API
 * See @ref iface_gamescope_input_method_manager.
 */
/**
 * @defgroup iface_gamescope_input_method_manager The gamescope_input_method_manager interface
 *
 * The input method manager allows the client to become the input method on
 * a chosen seat.
 *
 * No more than one input method must be associated with any seat at any
 * given time.
 */
extern const struct wl_interface gamescope_input_method_manager_interface;
#endif
#ifndef GAMESCOPE_INPUT_METHOD_INTERFACE
#define GAMESCOPE_INPUT_METHOD_INTERFACE
/**
 * @page page_iface_gamescope_input_method gamescope_input_method
 * @section page_iface_gamescope_input_method_desc Description
 *
 * An input method object allows for clients to compose text.
 *
 * The objects connects the client to a text input in an application, and
 * lets the client to serve as an input method for a seat.
 *
 * There must be no more than one input method object per seat.
 * @section page_iface_gamescope_input_method_api API
 * See @ref iface_gamescope_input_method.
 */
/**
 * @defgroup iface_gamescope_input_method The gamescope_input_method interface
 *
 * An input method object allows for clients to compose text.
 *
 * The objects connects the client to a text input in an application, and
 * lets the client to serve as an input method for a seat.
 *
 * There must be no more than one input method object per seat.
 */
extern const struct wl_interface gamescope_input_method_interface;
#endif

#define GAMESCOPE_INPUT_METHOD_MANAGER_DESTROY 0
#define GAMESCOPE_INPUT_METHOD_MANAGER_CREATE_INPUT_METHOD 1


/**
 * @ingroup iface_gamescope_input_method_manager
 */
#define GAMESCOPE_INPUT_METHOD_MANAGER_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_input_method_manager
 */
#define GAMESCOPE_INPUT_METHOD_MANAGER_CREATE_INPUT_METHOD_SINCE_VERSION 1

/** @ingroup iface_gamescope_input_method_manager */
static inline void
gamescope_input_method_manager_set_user_data(struct gamescope_input_method_manager *gamescope_input_method_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gamescope_input_method_manager, user_data);
}

/** @ingroup iface_gamescope_input_method_manager */
static inline void *
gamescope_input_method_manager_get_user_data(struct gamescope_input_method_manager *gamescope_input_method_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gamescope_input_method_manager);
}

static inline uint32_t
gamescope_input_method_manager_get_version(struct gamescope_input_method_manager *gamescope_input_method_manager)
{
	return wl_proxy_get_version((struct wl_proxy *) gamescope_input_method_manager);
}

/**
 * @ingroup iface_gamescope_input_method_manager
 *
 * Destroys the gamescope_input_method_manager object.
 *
 * The gamescope_input_method objects originating from it remain valid.
 */
static inline void
gamescope_input_method_manager_destroy(struct gamescope_input_method_manager *gamescope_input_method_manager)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method_manager,
			 GAMESCOPE_INPUT_METHOD_MANAGER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method_manager), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gamescope_input_method_manager
 *
 * Create a new gamescope_input_method object associated with a given
 * seat.
 */
static inline struct gamescope_input_method *
gamescope_input_method_manager_create_input_method(struct gamescope_input_method_manager *gamescope_input_method_manager, struct wl_seat *seat)
{
	struct wl_proxy *input_method;

	input_method = wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method_manager,
			 GAMESCOPE_INPUT_METHOD_MANAGER_CREATE_INPUT_METHOD, &gamescope_input_method_interface, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method_manager), 0, seat, NULL);

	return (struct gamescope_input_method *) input_method;
}

#ifndef GAMESCOPE_INPUT_METHOD_ACTION_ENUM
#define GAMESCOPE_INPUT_METHOD_ACTION_ENUM
/**
 * @ingroup iface_gamescope_input_method
 * action
 *
 * A possible action to perform on a text input.
 *
 * The backspace and delete actions should be handled in a similar manner
 * to backpace and delete keys being pressed on a keyboard.
 */
enum gamescope_input_method_action {
	/**
	 * no action
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_NONE = 0,
	/**
	 * submit
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_SUBMIT = 1,
	/**
	 * delete one unit before the cursor
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_DELETE_LEFT = 2,
	/**
	 * delete one unit after the cursor
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_DELETE_RIGHT = 3,
	/**
	 * move the cursor to the left by one unit
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_MOVE_LEFT = 4,
	/**
	 * move the cursor to the right by one unit
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_MOVE_RIGHT = 5,
	/**
	 * move the cursor up by one unit
	 * @since 2
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_MOVE_UP = 6,
	/**
	 * move the cursor down by one unit
	 * @since 2
	 */
	GAMESCOPE_INPUT_METHOD_ACTION_MOVE_DOWN = 7,
};
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_ACTION_MOVE_UP_SINCE_VERSION 2
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_ACTION_MOVE_DOWN_SINCE_VERSION 2
#endif /* GAMESCOPE_INPUT_METHOD_ACTION_ENUM */

#ifndef GAMESCOPE_INPUT_METHOD_BUTTON_STATE_ENUM
#define GAMESCOPE_INPUT_METHOD_BUTTON_STATE_ENUM
/**
 * @ingroup iface_gamescope_input_method
 * physical button state
 *
 * Describes the physical state of a button that produced the button
 * event.
 */
enum gamescope_input_method_button_state {
	/**
	 * the button is not pressed
	 */
	GAMESCOPE_INPUT_METHOD_BUTTON_STATE_RELEASED = 0,
	/**
	 * the button is pressed
	 */
	GAMESCOPE_INPUT_METHOD_BUTTON_STATE_PRESSED = 1,
};
#endif /* GAMESCOPE_INPUT_METHOD_BUTTON_STATE_ENUM */

/**
 * @ingroup iface_gamescope_input_method
 * @struct gamescope_input_method_listener
 */
struct gamescope_input_method_listener {
	/**
	 * input method unavailable
	 *
	 * The input method ceased to be available.
	 *
	 * The compositor must issue this event as the only event on the
	 * object if there was another input_method object associated with
	 * the same seat at the time of its creation.
	 *
	 * The compositor must issue this request when the object is no
	 * longer useable, e.g. due to seat removal.
	 *
	 * The input method context becomes inert and should be destroyed.
	 * Any further requests and events except for the destroy request
	 * must be ignored.
	 */
	void (*unavailable)(void *data,
			    struct gamescope_input_method *gamescope_input_method);
	/**
	 * compositor state change notification
	 *
	 * Notify the client that the compositor state has changed.
	 *
	 * The serial is used to synchronize compositor state changes and
	 * client state changes. The serial allows the compositor to ignore
	 * requests meant for a previous text input.
	 *
	 * In the future, will be used to atomically apply compositor state
	 * changes sent to the client (but currently there's no such
	 * state).
	 */
	void (*done)(void *data,
		     struct gamescope_input_method *gamescope_input_method,
		     uint32_t serial);
};

/**
 * @ingroup iface_gamescope_input_method
 */
static inline int
gamescope_input_method_add_listener(struct gamescope_input_method *gamescope_input_method,
				    const struct gamescope_input_method_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) gamescope_input_method,
				     (void (**)(void)) listener, data);
}

#define GAMESCOPE_INPUT_METHOD_DESTROY 0
#define GAMESCOPE_INPUT_METHOD_COMMIT 1
#define GAMESCOPE_INPUT_METHOD_SET_STRING 2
#define GAMESCOPE_INPUT_METHOD_SET_ACTION 3
#define GAMESCOPE_INPUT_METHOD_POINTER_MOTION 4
#define GAMESCOPE_INPUT_METHOD_POINTER_WARP 5
#define GAMESCOPE_INPUT_METHOD_POINTER_WHEEL 6
#define GAMESCOPE_INPUT_METHOD_POINTER_BUTTON 7

/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_UNAVAILABLE_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_SET_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_SET_ACTION_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_POINTER_MOTION_SINCE_VERSION 3
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_POINTER_WARP_SINCE_VERSION 3
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_POINTER_WHEEL_SINCE_VERSION 3
/**
 * @ingroup iface_gamescope_input_method
 */
#define GAMESCOPE_INPUT_METHOD_POINTER_BUTTON_SINCE_VERSION 3

/** @ingroup iface_gamescope_input_method */
static inline void
gamescope_input_method_set_user_data(struct gamescope_input_method *gamescope_input_method, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gamescope_input_method, user_data);
}

/** @ingroup iface_gamescope_input_method */
static inline void *
gamescope_input_method_get_user_data(struct gamescope_input_method *gamescope_input_method)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gamescope_input_method);
}

static inline uint32_t
gamescope_input_method_get_version(struct gamescope_input_method *gamescope_input_method)
{
	return wl_proxy_get_version((struct wl_proxy *) gamescope_input_method);
}

/**
 * @ingroup iface_gamescope_input_method
 *
 * Destroys the gamescope_text_input object.
 */
static inline void
gamescope_input_method_destroy(struct gamescope_input_method *gamescope_input_method)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gamescope_input_method
 *
 * Apply state changes from set_string and set_action requests.
 *
 * The state relating to these events is double-buffered, and each one
 * modifies the pending state. This request replaces the current state
 * with the pending state.
 *
 * The client must set the serial to the last received serial in the done
 * event.
 */
static inline void
gamescope_input_method_commit(struct gamescope_input_method *gamescope_input_method, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), 0, serial);
}

/**
 * @ingroup iface_gamescope_input_method
 *
 * Send the string text for insertion to the application.
 *
 * Inserts a string at current cursor position (see commit event
 * sequence). The string to commit could be either just a single character
 * after a key press or the result of some composing.
 *
 * Values set with this event are double-buffered. They must be applied
 * and reset to initial on the next gamescope_text_input.commit request.
 *
 * The initial value of text is an empty string.
 */
static inline void
gamescope_input_method_set_string(struct gamescope_input_method *gamescope_input_method, const char *text)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_SET_STRING, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), 0, text);
}

/**
 * @ingroup iface_gamescope_input_method
 *
 * Set the action to be performed on commit.
 *
 * Values set with this event are double-buffered. They must be applied
 * and reset to initial on the next gamescope_text_input.commit request.
 */
static inline void
gamescope_input_method_set_action(struct gamescope_input_method *gamescope_input_method, uint32_t action)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_SET_ACTION, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), 0, action);
}

/**
 * @ingroup iface_gamescope_input_method
 */
static inline void
gamescope_input_method_pointer_motion(struct gamescope_input_method *gamescope_input_method, wl_fixed_t dx, wl_fixed_t dy)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_POINTER_MOTION, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), 0, dx, dy);
}

/**
 * @ingroup iface_gamescope_input_method
 */
static inline void
gamescope_input_method_pointer_warp(struct gamescope_input_method *gamescope_input_method, wl_fixed_t x, wl_fixed_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_POINTER_WARP, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), 0, x, y);
}

/**
 * @ingroup iface_gamescope_input_method
 */
static inline void
gamescope_input_method_pointer_wheel(struct gamescope_input_method *gamescope_input_method, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_POINTER_WHEEL, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), 0, x, y);
}

/**
 * @ingroup iface_gamescope_input_method
 */
static inline void
gamescope_input_method_pointer_button(struct gamescope_input_method *gamescope_input_method, uint32_t button, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_input_method,
			 GAMESCOPE_INPUT_METHOD_POINTER_BUTTON, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_input_method), 0, button, state);
}

#ifdef  __cplusplus
}
#endif

#endif
