/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-usb-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"




const gchar *
fu_usb_class_to_string(FuUsbClass val)
{
    if (val == FU_USB_CLASS_INTERFACE_DESC)
        return "interface-desc";
    if (val == FU_USB_CLASS_AUDIO)
        return "audio";
    if (val == FU_USB_CLASS_COMMUNICATIONS)
        return "communications";
    if (val == FU_USB_CLASS_HID)
        return "hid";
    if (val == FU_USB_CLASS_PHYSICAL)
        return "physical";
    if (val == FU_USB_CLASS_IMAGE)
        return "image";
    if (val == FU_USB_CLASS_PRINTER)
        return "printer";
    if (val == FU_USB_CLASS_MASS_STORAGE)
        return "mass-storage";
    if (val == FU_USB_CLASS_HUB)
        return "hub";
    if (val == FU_USB_CLASS_CDC_DATA)
        return "cdc-data";
    if (val == FU_USB_CLASS_SMART_CARD)
        return "smart-card";
    if (val == FU_USB_CLASS_CONTENT_SECURITY)
        return "content-security";
    if (val == FU_USB_CLASS_VIDEO)
        return "video";
    if (val == FU_USB_CLASS_PERSONAL_HEALTHCARE)
        return "personal-healthcare";
    if (val == FU_USB_CLASS_AUDIO_VIDEO)
        return "audio-video";
    if (val == FU_USB_CLASS_BILLBOARD)
        return "billboard";
    if (val == FU_USB_CLASS_DIAGNOSTIC)
        return "diagnostic";
    if (val == FU_USB_CLASS_WIRELESS_CONTROLLER)
        return "wireless-controller";
    if (val == FU_USB_CLASS_MISCELLANEOUS)
        return "miscellaneous";
    if (val == FU_USB_CLASS_APPLICATION_SPECIFIC)
        return "application-specific";
    if (val == FU_USB_CLASS_VENDOR_SPECIFIC)
        return "vendor-specific";
    return NULL;
}


const gchar *
fu_usb_descriptor_kind_to_string(FuUsbDescriptorKind val)
{
    if (val == FU_USB_DESCRIPTOR_KIND_INVALID)
        return "invalid";
    if (val == FU_USB_DESCRIPTOR_KIND_DEVICE)
        return "device";
    if (val == FU_USB_DESCRIPTOR_KIND_CONFIG)
        return "config";
    if (val == FU_USB_DESCRIPTOR_KIND_STRING)
        return "string";
    if (val == FU_USB_DESCRIPTOR_KIND_INTERFACE)
        return "interface";
    if (val == FU_USB_DESCRIPTOR_KIND_ENDPOINT)
        return "endpoint";
    if (val == FU_USB_DESCRIPTOR_KIND_INTERFACE_ASSOCIATION)
        return "interface-association";
    if (val == FU_USB_DESCRIPTOR_KIND_BOS)
        return "bos";
    if (val == FU_USB_DESCRIPTOR_KIND_DEVICE_CAPABILITY)
        return "device-capability";
    if (val == FU_USB_DESCRIPTOR_KIND_HID)
        return "hid";
    if (val == FU_USB_DESCRIPTOR_KIND_REPORT)
        return "report";
    if (val == FU_USB_DESCRIPTOR_KIND_PHYSICAL)
        return "physical";
    if (val == FU_USB_DESCRIPTOR_KIND_HUB)
        return "hub";
    if (val == FU_USB_DESCRIPTOR_KIND_SUPERSPEED_HUB)
        return "superspeed-hub";
    if (val == FU_USB_DESCRIPTOR_KIND_SS_ENDPOINT_COMPANION)
        return "ss-endpoint-companion";
    return NULL;
}
FuUsbDescriptorKind
fu_usb_descriptor_kind_from_string(const gchar *val)
{
    if (g_strcmp0(val, "invalid") == 0)
        return FU_USB_DESCRIPTOR_KIND_INVALID;
    if (g_strcmp0(val, "device") == 0)
        return FU_USB_DESCRIPTOR_KIND_DEVICE;
    if (g_strcmp0(val, "config") == 0)
        return FU_USB_DESCRIPTOR_KIND_CONFIG;
    if (g_strcmp0(val, "string") == 0)
        return FU_USB_DESCRIPTOR_KIND_STRING;
    if (g_strcmp0(val, "interface") == 0)
        return FU_USB_DESCRIPTOR_KIND_INTERFACE;
    if (g_strcmp0(val, "endpoint") == 0)
        return FU_USB_DESCRIPTOR_KIND_ENDPOINT;
    if (g_strcmp0(val, "interface-association") == 0)
        return FU_USB_DESCRIPTOR_KIND_INTERFACE_ASSOCIATION;
    if (g_strcmp0(val, "bos") == 0)
        return FU_USB_DESCRIPTOR_KIND_BOS;
    if (g_strcmp0(val, "device-capability") == 0)
        return FU_USB_DESCRIPTOR_KIND_DEVICE_CAPABILITY;
    if (g_strcmp0(val, "hid") == 0)
        return FU_USB_DESCRIPTOR_KIND_HID;
    if (g_strcmp0(val, "report") == 0)
        return FU_USB_DESCRIPTOR_KIND_REPORT;
    if (g_strcmp0(val, "physical") == 0)
        return FU_USB_DESCRIPTOR_KIND_PHYSICAL;
    if (g_strcmp0(val, "hub") == 0)
        return FU_USB_DESCRIPTOR_KIND_HUB;
    if (g_strcmp0(val, "superspeed-hub") == 0)
        return FU_USB_DESCRIPTOR_KIND_SUPERSPEED_HUB;
    if (g_strcmp0(val, "ss-endpoint-companion") == 0)
        return FU_USB_DESCRIPTOR_KIND_SS_ENDPOINT_COMPANION;
    return FU_USB_DESCRIPTOR_KIND_INVALID;
}
/**
 * fu_usb_base_hdr_ref: (skip):
 **/
FuUsbBaseHdr *
fu_usb_base_hdr_ref(FuUsbBaseHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_base_hdr_unref: (skip):
 **/
void
fu_usb_base_hdr_unref(FuUsbBaseHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbBaseHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_base_hdr_new_internal: (skip):
 **/
static FuUsbBaseHdr *
fu_usb_base_hdr_new_internal(void)
{
    FuUsbBaseHdr *st = g_new0(FuUsbBaseHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_base_hdr_get_length: (skip):
 **/
guint8
fu_usb_base_hdr_get_length(const FuUsbBaseHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_base_hdr_get_descriptor_type: (skip):
 **/
FuUsbDescriptorKind
fu_usb_base_hdr_get_descriptor_type(const FuUsbBaseHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_usb_base_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_base_hdr_to_string(const FuUsbBaseHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbBaseHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_base_hdr_get_length(st));
    {
        const gchar *tmp = fu_usb_descriptor_kind_to_string(fu_usb_base_hdr_get_descriptor_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  descriptor_type: 0x%x [%s]\n", (guint) fu_usb_base_hdr_get_descriptor_type(st), tmp);
        } else {
            g_string_append_printf(str, "  descriptor_type: 0x%x\n", (guint) fu_usb_base_hdr_get_descriptor_type(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_base_hdr_validate_internal(FuUsbBaseHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_usb_base_hdr_parse_internal(FuUsbBaseHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_base_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_base_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_usb_base_hdr_parse: (skip):
 **/
FuUsbBaseHdr *
fu_usb_base_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuUsbBaseHdr) st = fu_usb_base_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuUsbBaseHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_usb_base_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_base_hdr_parse_bytes: (skip):
 **/
FuUsbBaseHdr *
fu_usb_base_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_usb_base_hdr_parse(buf, bufsz, offset, error);
}
/**
 * fu_usb_base_hdr_parse_stream: (skip):
 **/
FuUsbBaseHdr *
fu_usb_base_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuUsbBaseHdr) st = fu_usb_base_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 2, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuUsbBaseHdr failed read of 0x%x: ", (guint) 2);
        return NULL;
    }
    if (st->buf->len != 2) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuUsbBaseHdr requested 0x%x and got 0x%x",
                    (guint) 2,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_usb_base_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_device_hdr_ref: (skip):
 **/
FuUsbDeviceHdr *
fu_usb_device_hdr_ref(FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_device_hdr_unref: (skip):
 **/
void
fu_usb_device_hdr_unref(FuUsbDeviceHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbDeviceHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_device_hdr_new_internal: (skip):
 **/
static FuUsbDeviceHdr *
fu_usb_device_hdr_new_internal(void)
{
    FuUsbDeviceHdr *st = g_new0(FuUsbDeviceHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_device_hdr_get_length: (skip):
 **/
guint8
fu_usb_device_hdr_get_length(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_device_hdr_get_descriptor_type: (skip):
 **/
static FuUsbDescriptorKind
fu_usb_device_hdr_get_descriptor_type(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_usb_device_hdr_get_usb: (skip):
 **/
guint16
fu_usb_device_hdr_get_usb(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_device_hdr_get_device_class: (skip):
 **/
FuUsbClass
fu_usb_device_hdr_get_device_class(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_usb_device_hdr_get_device_sub_class: (skip):
 **/
guint8
fu_usb_device_hdr_get_device_sub_class(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_usb_device_hdr_get_device_protocol: (skip):
 **/
guint8
fu_usb_device_hdr_get_device_protocol(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_usb_device_hdr_get_max_packet_size0: (skip):
 **/
guint8
fu_usb_device_hdr_get_max_packet_size0(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_usb_device_hdr_get_vendor: (skip):
 **/
guint16
fu_usb_device_hdr_get_vendor(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_device_hdr_get_product: (skip):
 **/
guint16
fu_usb_device_hdr_get_product(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_device_hdr_get_device: (skip):
 **/
guint16
fu_usb_device_hdr_get_device(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_device_hdr_get_manufacturer_idx: (skip):
 **/
guint8
fu_usb_device_hdr_get_manufacturer_idx(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[14];
}
/**
 * fu_usb_device_hdr_get_product_idx: (skip):
 **/
guint8
fu_usb_device_hdr_get_product_idx(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[15];
}
/**
 * fu_usb_device_hdr_get_serial_number_idx: (skip):
 **/
guint8
fu_usb_device_hdr_get_serial_number_idx(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}
/**
 * fu_usb_device_hdr_get_num_configurations: (skip):
 **/
guint8
fu_usb_device_hdr_get_num_configurations(const FuUsbDeviceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[17];
}

/* setters */
/**
 * fu_usb_device_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_device_hdr_to_string(const FuUsbDeviceHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbDeviceHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_length(st));
    g_string_append_printf(str, "  usb: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_usb(st));
    {
        const gchar *tmp = fu_usb_class_to_string(fu_usb_device_hdr_get_device_class(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  device_class: 0x%x [%s]\n", (guint) fu_usb_device_hdr_get_device_class(st), tmp);
        } else {
            g_string_append_printf(str, "  device_class: 0x%x\n", (guint) fu_usb_device_hdr_get_device_class(st));
        }
    }
    g_string_append_printf(str, "  device_sub_class: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_device_sub_class(st));
    g_string_append_printf(str, "  device_protocol: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_device_protocol(st));
    g_string_append_printf(str, "  max_packet_size0: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_max_packet_size0(st));
    g_string_append_printf(str, "  vendor: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_vendor(st));
    g_string_append_printf(str, "  product: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_product(st));
    g_string_append_printf(str, "  device: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_device(st));
    g_string_append_printf(str, "  manufacturer_idx: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_manufacturer_idx(st));
    g_string_append_printf(str, "  product_idx: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_product_idx(st));
    g_string_append_printf(str, "  serial_number_idx: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_serial_number_idx(st));
    g_string_append_printf(str, "  num_configurations: 0x%x\n",
                           (guint) fu_usb_device_hdr_get_num_configurations(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_device_hdr_validate_internal(FuUsbDeviceHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_usb_device_hdr_get_descriptor_type(st) != FU_USB_DESCRIPTOR_KIND_DEVICE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuUsbDeviceHdr.descriptor_type was not valid, "
                    "expected 'FuUsbDescriptorKind' and got '%s'",
                    fu_usb_descriptor_kind_to_string(fu_usb_device_hdr_get_descriptor_type(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_usb_device_hdr_parse_internal(FuUsbDeviceHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_device_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_device_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_usb_device_hdr_parse: (skip):
 **/
static FuUsbDeviceHdr *
fu_usb_device_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuUsbDeviceHdr) st = fu_usb_device_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 18, error)) {
        g_prefix_error_literal(error, "invalid struct FuUsbDeviceHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 18);
    if (!fu_usb_device_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_device_hdr_parse_bytes: (skip):
 **/
FuUsbDeviceHdr *
fu_usb_device_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_usb_device_hdr_parse(buf, bufsz, offset, error);
}
/**
 * fu_usb_descriptor_hdr_ref: (skip):
 **/
FuUsbDescriptorHdr *
fu_usb_descriptor_hdr_ref(FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_descriptor_hdr_unref: (skip):
 **/
void
fu_usb_descriptor_hdr_unref(FuUsbDescriptorHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbDescriptorHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_descriptor_hdr_new_internal: (skip):
 **/
static FuUsbDescriptorHdr *
fu_usb_descriptor_hdr_new_internal(void)
{
    FuUsbDescriptorHdr *st = g_new0(FuUsbDescriptorHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_descriptor_hdr_get_length: (skip):
 **/
guint8
fu_usb_descriptor_hdr_get_length(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_descriptor_hdr_get_descriptor_type: (skip):
 **/
static FuUsbDescriptorKind
fu_usb_descriptor_hdr_get_descriptor_type(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_usb_descriptor_hdr_get_total_length: (skip):
 **/
guint16
fu_usb_descriptor_hdr_get_total_length(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_descriptor_hdr_get_num_interfaces: (skip):
 **/
guint8
fu_usb_descriptor_hdr_get_num_interfaces(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_usb_descriptor_hdr_get_configuration_value: (skip):
 **/
guint8
fu_usb_descriptor_hdr_get_configuration_value(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_usb_descriptor_hdr_get_configuration: (skip):
 **/
guint8
fu_usb_descriptor_hdr_get_configuration(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_usb_descriptor_hdr_get_attributes: (skip):
 **/
guint8
fu_usb_descriptor_hdr_get_attributes(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_usb_descriptor_hdr_get_max_power: (skip):
 **/
guint8
fu_usb_descriptor_hdr_get_max_power(const FuUsbDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}

/* setters */
/**
 * fu_usb_descriptor_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_descriptor_hdr_to_string(const FuUsbDescriptorHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbDescriptorHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_descriptor_hdr_get_length(st));
    g_string_append_printf(str, "  total_length: 0x%x\n",
                           (guint) fu_usb_descriptor_hdr_get_total_length(st));
    g_string_append_printf(str, "  num_interfaces: 0x%x\n",
                           (guint) fu_usb_descriptor_hdr_get_num_interfaces(st));
    g_string_append_printf(str, "  configuration_value: 0x%x\n",
                           (guint) fu_usb_descriptor_hdr_get_configuration_value(st));
    g_string_append_printf(str, "  configuration: 0x%x\n",
                           (guint) fu_usb_descriptor_hdr_get_configuration(st));
    g_string_append_printf(str, "  attributes: 0x%x\n",
                           (guint) fu_usb_descriptor_hdr_get_attributes(st));
    g_string_append_printf(str, "  max_power: 0x%x\n",
                           (guint) fu_usb_descriptor_hdr_get_max_power(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_descriptor_hdr_validate_internal(FuUsbDescriptorHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_usb_descriptor_hdr_get_descriptor_type(st) != FU_USB_DESCRIPTOR_KIND_CONFIG) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuUsbDescriptorHdr.descriptor_type was not valid, "
                    "expected 'FuUsbDescriptorKind' and got '%s'",
                    fu_usb_descriptor_kind_to_string(fu_usb_descriptor_hdr_get_descriptor_type(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_usb_descriptor_hdr_parse_internal(FuUsbDescriptorHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_descriptor_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_descriptor_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_usb_descriptor_hdr_parse_stream: (skip):
 **/
FuUsbDescriptorHdr *
fu_usb_descriptor_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuUsbDescriptorHdr) st = fu_usb_descriptor_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 9, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuUsbDescriptorHdr failed read of 0x%x: ", (guint) 9);
        return NULL;
    }
    if (st->buf->len != 9) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuUsbDescriptorHdr requested 0x%x and got 0x%x",
                    (guint) 9,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_usb_descriptor_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_hid_descriptor_hdr_ref: (skip):
 **/
FuUsbHidDescriptorHdr *
fu_usb_hid_descriptor_hdr_ref(FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_hid_descriptor_hdr_unref: (skip):
 **/
void
fu_usb_hid_descriptor_hdr_unref(FuUsbHidDescriptorHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbHidDescriptorHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_hid_descriptor_hdr_new_internal: (skip):
 **/
static FuUsbHidDescriptorHdr *
fu_usb_hid_descriptor_hdr_new_internal(void)
{
    FuUsbHidDescriptorHdr *st = g_new0(FuUsbHidDescriptorHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_hid_descriptor_hdr_get_length: (skip):
 **/
guint8
fu_usb_hid_descriptor_hdr_get_length(const FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_hid_descriptor_hdr_get_descriptor_type: (skip):
 **/
static FuUsbDescriptorKind
fu_usb_hid_descriptor_hdr_get_descriptor_type(const FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_usb_hid_descriptor_hdr_get_hid: (skip):
 **/
guint16
fu_usb_hid_descriptor_hdr_get_hid(const FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_hid_descriptor_hdr_get_country_code: (skip):
 **/
guint8
fu_usb_hid_descriptor_hdr_get_country_code(const FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_usb_hid_descriptor_hdr_get_num_descriptors: (skip):
 **/
guint8
fu_usb_hid_descriptor_hdr_get_num_descriptors(const FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_usb_hid_descriptor_hdr_get_class_descriptor_type: (skip):
 **/
guint8
fu_usb_hid_descriptor_hdr_get_class_descriptor_type(const FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_usb_hid_descriptor_hdr_get_class_descriptor_length: (skip):
 **/
guint16
fu_usb_hid_descriptor_hdr_get_class_descriptor_length(const FuUsbHidDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 7, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_usb_hid_descriptor_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_hid_descriptor_hdr_to_string(const FuUsbHidDescriptorHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbHidDescriptorHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_hid_descriptor_hdr_get_length(st));
    g_string_append_printf(str, "  hid: 0x%x\n",
                           (guint) fu_usb_hid_descriptor_hdr_get_hid(st));
    g_string_append_printf(str, "  country_code: 0x%x\n",
                           (guint) fu_usb_hid_descriptor_hdr_get_country_code(st));
    g_string_append_printf(str, "  num_descriptors: 0x%x\n",
                           (guint) fu_usb_hid_descriptor_hdr_get_num_descriptors(st));
    g_string_append_printf(str, "  class_descriptor_type: 0x%x\n",
                           (guint) fu_usb_hid_descriptor_hdr_get_class_descriptor_type(st));
    g_string_append_printf(str, "  class_descriptor_length: 0x%x\n",
                           (guint) fu_usb_hid_descriptor_hdr_get_class_descriptor_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_hid_descriptor_hdr_validate_internal(FuUsbHidDescriptorHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_usb_hid_descriptor_hdr_get_descriptor_type(st) != FU_USB_DESCRIPTOR_KIND_HID) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuUsbHidDescriptorHdr.descriptor_type was not valid, "
                    "expected 'FuUsbDescriptorKind' and got '%s'",
                    fu_usb_descriptor_kind_to_string(fu_usb_hid_descriptor_hdr_get_descriptor_type(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_usb_hid_descriptor_hdr_parse_internal(FuUsbHidDescriptorHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_hid_descriptor_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_hid_descriptor_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_usb_hid_descriptor_hdr_parse_stream: (skip):
 **/
FuUsbHidDescriptorHdr *
fu_usb_hid_descriptor_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuUsbHidDescriptorHdr) st = fu_usb_hid_descriptor_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 9, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuUsbHidDescriptorHdr failed read of 0x%x: ", (guint) 9);
        return NULL;
    }
    if (st->buf->len != 9) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuUsbHidDescriptorHdr requested 0x%x and got 0x%x",
                    (guint) 9,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_usb_hid_descriptor_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_dfu_descriptor_hdr_ref: (skip):
 **/
FuUsbDfuDescriptorHdr *
fu_usb_dfu_descriptor_hdr_ref(FuUsbDfuDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_dfu_descriptor_hdr_unref: (skip):
 **/
void
fu_usb_dfu_descriptor_hdr_unref(FuUsbDfuDescriptorHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbDfuDescriptorHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_dfu_descriptor_hdr_new_internal: (skip):
 **/
static FuUsbDfuDescriptorHdr *
fu_usb_dfu_descriptor_hdr_new_internal(void)
{
    FuUsbDfuDescriptorHdr *st = g_new0(FuUsbDfuDescriptorHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_dfu_descriptor_hdr_get_length: (skip):
 **/
guint8
fu_usb_dfu_descriptor_hdr_get_length(const FuUsbDfuDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_dfu_descriptor_hdr_get_descriptor_type: (skip):
 **/
static FuUsbDescriptorKind
fu_usb_dfu_descriptor_hdr_get_descriptor_type(const FuUsbDfuDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_usb_dfu_descriptor_hdr_get_attributes: (skip):
 **/
guint8
fu_usb_dfu_descriptor_hdr_get_attributes(const FuUsbDfuDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_usb_dfu_descriptor_hdr_get_detach_timeout: (skip):
 **/
guint16
fu_usb_dfu_descriptor_hdr_get_detach_timeout(const FuUsbDfuDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_dfu_descriptor_hdr_get_transfer_size: (skip):
 **/
guint16
fu_usb_dfu_descriptor_hdr_get_transfer_size(const FuUsbDfuDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 5, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_dfu_descriptor_hdr_get_dfu_version: (skip):
 **/
guint16
fu_usb_dfu_descriptor_hdr_get_dfu_version(const FuUsbDfuDescriptorHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 7, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_usb_dfu_descriptor_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_dfu_descriptor_hdr_to_string(const FuUsbDfuDescriptorHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbDfuDescriptorHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_dfu_descriptor_hdr_get_length(st));
    g_string_append_printf(str, "  attributes: 0x%x\n",
                           (guint) fu_usb_dfu_descriptor_hdr_get_attributes(st));
    g_string_append_printf(str, "  detach_timeout: 0x%x\n",
                           (guint) fu_usb_dfu_descriptor_hdr_get_detach_timeout(st));
    g_string_append_printf(str, "  transfer_size: 0x%x\n",
                           (guint) fu_usb_dfu_descriptor_hdr_get_transfer_size(st));
    g_string_append_printf(str, "  dfu_version: 0x%x\n",
                           (guint) fu_usb_dfu_descriptor_hdr_get_dfu_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_dfu_descriptor_hdr_validate_internal(FuUsbDfuDescriptorHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_usb_dfu_descriptor_hdr_get_descriptor_type(st) != FU_USB_DESCRIPTOR_KIND_HID) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuUsbDfuDescriptorHdr.descriptor_type was not valid, "
                    "expected 'FuUsbDescriptorKind' and got '%s'",
                    fu_usb_descriptor_kind_to_string(fu_usb_dfu_descriptor_hdr_get_descriptor_type(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_usb_dfu_descriptor_hdr_parse_internal(FuUsbDfuDescriptorHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_dfu_descriptor_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_dfu_descriptor_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_usb_dfu_descriptor_hdr_parse: (skip):
 **/
static FuUsbDfuDescriptorHdr *
fu_usb_dfu_descriptor_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuUsbDfuDescriptorHdr) st = fu_usb_dfu_descriptor_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 9, error)) {
        g_prefix_error_literal(error, "invalid struct FuUsbDfuDescriptorHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 9);
    if (!fu_usb_dfu_descriptor_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_dfu_descriptor_hdr_parse_bytes: (skip):
 **/
FuUsbDfuDescriptorHdr *
fu_usb_dfu_descriptor_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_usb_dfu_descriptor_hdr_parse(buf, bufsz, offset, error);
}
/**
 * fu_usb_interface_hdr_ref: (skip):
 **/
FuUsbInterfaceHdr *
fu_usb_interface_hdr_ref(FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_interface_hdr_unref: (skip):
 **/
void
fu_usb_interface_hdr_unref(FuUsbInterfaceHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbInterfaceHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_interface_hdr_new_internal: (skip):
 **/
static FuUsbInterfaceHdr *
fu_usb_interface_hdr_new_internal(void)
{
    FuUsbInterfaceHdr *st = g_new0(FuUsbInterfaceHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_interface_hdr_get_length: (skip):
 **/
guint8
fu_usb_interface_hdr_get_length(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_interface_hdr_get_descriptor_type: (skip):
 **/
static FuUsbDescriptorKind
fu_usb_interface_hdr_get_descriptor_type(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_usb_interface_hdr_get_interface_number: (skip):
 **/
guint8
fu_usb_interface_hdr_get_interface_number(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_usb_interface_hdr_get_alternate_setting: (skip):
 **/
guint8
fu_usb_interface_hdr_get_alternate_setting(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_usb_interface_hdr_get_num_endpoints: (skip):
 **/
guint8
fu_usb_interface_hdr_get_num_endpoints(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_usb_interface_hdr_get_interface_class: (skip):
 **/
FuUsbClass
fu_usb_interface_hdr_get_interface_class(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_usb_interface_hdr_get_interface_sub_class: (skip):
 **/
guint8
fu_usb_interface_hdr_get_interface_sub_class(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_usb_interface_hdr_get_interface_protocol: (skip):
 **/
guint8
fu_usb_interface_hdr_get_interface_protocol(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_usb_interface_hdr_get_interface: (skip):
 **/
guint8
fu_usb_interface_hdr_get_interface(const FuUsbInterfaceHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}

/* setters */
/**
 * fu_usb_interface_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_interface_hdr_to_string(const FuUsbInterfaceHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbInterfaceHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_interface_hdr_get_length(st));
    g_string_append_printf(str, "  interface_number: 0x%x\n",
                           (guint) fu_usb_interface_hdr_get_interface_number(st));
    g_string_append_printf(str, "  alternate_setting: 0x%x\n",
                           (guint) fu_usb_interface_hdr_get_alternate_setting(st));
    g_string_append_printf(str, "  num_endpoints: 0x%x\n",
                           (guint) fu_usb_interface_hdr_get_num_endpoints(st));
    {
        const gchar *tmp = fu_usb_class_to_string(fu_usb_interface_hdr_get_interface_class(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  interface_class: 0x%x [%s]\n", (guint) fu_usb_interface_hdr_get_interface_class(st), tmp);
        } else {
            g_string_append_printf(str, "  interface_class: 0x%x\n", (guint) fu_usb_interface_hdr_get_interface_class(st));
        }
    }
    g_string_append_printf(str, "  interface_sub_class: 0x%x\n",
                           (guint) fu_usb_interface_hdr_get_interface_sub_class(st));
    g_string_append_printf(str, "  interface_protocol: 0x%x\n",
                           (guint) fu_usb_interface_hdr_get_interface_protocol(st));
    g_string_append_printf(str, "  interface: 0x%x\n",
                           (guint) fu_usb_interface_hdr_get_interface(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_interface_hdr_validate_internal(FuUsbInterfaceHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_usb_interface_hdr_get_descriptor_type(st) != FU_USB_DESCRIPTOR_KIND_INTERFACE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuUsbInterfaceHdr.descriptor_type was not valid, "
                    "expected 'FuUsbDescriptorKind' and got '%s'",
                    fu_usb_descriptor_kind_to_string(fu_usb_interface_hdr_get_descriptor_type(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_usb_interface_hdr_parse_internal(FuUsbInterfaceHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_interface_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_interface_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_usb_interface_hdr_parse_stream: (skip):
 **/
FuUsbInterfaceHdr *
fu_usb_interface_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuUsbInterfaceHdr) st = fu_usb_interface_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 9, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuUsbInterfaceHdr failed read of 0x%x: ", (guint) 9);
        return NULL;
    }
    if (st->buf->len != 9) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuUsbInterfaceHdr requested 0x%x and got 0x%x",
                    (guint) 9,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_usb_interface_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_endpoint_hdr_ref: (skip):
 **/
FuUsbEndpointHdr *
fu_usb_endpoint_hdr_ref(FuUsbEndpointHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_endpoint_hdr_unref: (skip):
 **/
void
fu_usb_endpoint_hdr_unref(FuUsbEndpointHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbEndpointHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_endpoint_hdr_new_internal: (skip):
 **/
static FuUsbEndpointHdr *
fu_usb_endpoint_hdr_new_internal(void)
{
    FuUsbEndpointHdr *st = g_new0(FuUsbEndpointHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_endpoint_hdr_get_length: (skip):
 **/
guint8
fu_usb_endpoint_hdr_get_length(const FuUsbEndpointHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_endpoint_hdr_get_descriptor_type: (skip):
 **/
FuUsbDescriptorKind
fu_usb_endpoint_hdr_get_descriptor_type(const FuUsbEndpointHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_usb_endpoint_hdr_get_endpoint_address: (skip):
 **/
guint8
fu_usb_endpoint_hdr_get_endpoint_address(const FuUsbEndpointHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_usb_endpoint_hdr_get_attributes: (skip):
 **/
guint8
fu_usb_endpoint_hdr_get_attributes(const FuUsbEndpointHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_usb_endpoint_hdr_get_max_packet_size: (skip):
 **/
guint16
fu_usb_endpoint_hdr_get_max_packet_size(const FuUsbEndpointHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_usb_endpoint_hdr_get_interval: (skip):
 **/
guint8
fu_usb_endpoint_hdr_get_interval(const FuUsbEndpointHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}

/* setters */
/**
 * fu_usb_endpoint_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_endpoint_hdr_to_string(const FuUsbEndpointHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbEndpointHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_endpoint_hdr_get_length(st));
    {
        const gchar *tmp = fu_usb_descriptor_kind_to_string(fu_usb_endpoint_hdr_get_descriptor_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  descriptor_type: 0x%x [%s]\n", (guint) fu_usb_endpoint_hdr_get_descriptor_type(st), tmp);
        } else {
            g_string_append_printf(str, "  descriptor_type: 0x%x\n", (guint) fu_usb_endpoint_hdr_get_descriptor_type(st));
        }
    }
    g_string_append_printf(str, "  endpoint_address: 0x%x\n",
                           (guint) fu_usb_endpoint_hdr_get_endpoint_address(st));
    g_string_append_printf(str, "  attributes: 0x%x\n",
                           (guint) fu_usb_endpoint_hdr_get_attributes(st));
    g_string_append_printf(str, "  max_packet_size: 0x%x\n",
                           (guint) fu_usb_endpoint_hdr_get_max_packet_size(st));
    g_string_append_printf(str, "  interval: 0x%x\n",
                           (guint) fu_usb_endpoint_hdr_get_interval(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_endpoint_hdr_validate_internal(FuUsbEndpointHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_usb_endpoint_hdr_parse_internal(FuUsbEndpointHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_endpoint_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_endpoint_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_usb_endpoint_hdr_parse_stream: (skip):
 **/
FuUsbEndpointHdr *
fu_usb_endpoint_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuUsbEndpointHdr) st = fu_usb_endpoint_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 7, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuUsbEndpointHdr failed read of 0x%x: ", (guint) 7);
        return NULL;
    }
    if (st->buf->len != 7) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuUsbEndpointHdr requested 0x%x and got 0x%x",
                    (guint) 7,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_usb_endpoint_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_usb_bos_hdr_ref: (skip):
 **/
FuUsbBosHdr *
fu_usb_bos_hdr_ref(FuUsbBosHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_usb_bos_hdr_unref: (skip):
 **/
void
fu_usb_bos_hdr_unref(FuUsbBosHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuUsbBosHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_usb_bos_hdr_new_internal: (skip):
 **/
static FuUsbBosHdr *
fu_usb_bos_hdr_new_internal(void)
{
    FuUsbBosHdr *st = g_new0(FuUsbBosHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_usb_bos_hdr_get_length: (skip):
 **/
guint8
fu_usb_bos_hdr_get_length(const FuUsbBosHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_usb_bos_hdr_get_descriptor_type: (skip):
 **/
FuUsbDescriptorKind
fu_usb_bos_hdr_get_descriptor_type(const FuUsbBosHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_usb_bos_hdr_get_dev_capability_type: (skip):
 **/
guint8
fu_usb_bos_hdr_get_dev_capability_type(const FuUsbBosHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_usb_bos_hdr_set_length: (skip):
 **/
void
fu_usb_bos_hdr_set_length(FuUsbBosHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_usb_bos_hdr_set_descriptor_type: (skip):
 **/
void
fu_usb_bos_hdr_set_descriptor_type(FuUsbBosHdr *st, FuUsbDescriptorKind value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_usb_bos_hdr_set_dev_capability_type: (skip):
 **/
void
fu_usb_bos_hdr_set_dev_capability_type(FuUsbBosHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_usb_bos_hdr_new: (skip):
 **/
FuUsbBosHdr *
fu_usb_bos_hdr_new(void)
{
    FuUsbBosHdr *st = fu_usb_bos_hdr_new_internal();
    st->buf = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st->buf, 3, 0x0);
    fu_usb_bos_hdr_set_length(st, 3);
    fu_usb_bos_hdr_set_descriptor_type(st, FU_USB_DESCRIPTOR_KIND_BOS);
    return st;
}
/**
 * fu_usb_bos_hdr_to_string: (skip):
 **/
static gchar *
fu_usb_bos_hdr_to_string(const FuUsbBosHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuUsbBosHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_usb_bos_hdr_get_length(st));
    {
        const gchar *tmp = fu_usb_descriptor_kind_to_string(fu_usb_bos_hdr_get_descriptor_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  descriptor_type: 0x%x [%s]\n", (guint) fu_usb_bos_hdr_get_descriptor_type(st), tmp);
        } else {
            g_string_append_printf(str, "  descriptor_type: 0x%x\n", (guint) fu_usb_bos_hdr_get_descriptor_type(st));
        }
    }
    g_string_append_printf(str, "  dev_capability_type: 0x%x\n",
                           (guint) fu_usb_bos_hdr_get_dev_capability_type(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_usb_bos_hdr_validate_internal(FuUsbBosHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_usb_bos_hdr_parse_internal(FuUsbBosHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_usb_bos_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_usb_bos_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_usb_bos_hdr_parse_stream: (skip):
 **/
FuUsbBosHdr *
fu_usb_bos_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuUsbBosHdr) st = fu_usb_bos_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 3, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuUsbBosHdr failed read of 0x%x: ", (guint) 3);
        return NULL;
    }
    if (st->buf->len != 3) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuUsbBosHdr requested 0x%x and got 0x%x",
                    (guint) 3,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_usb_bos_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
