/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM AddonEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "AddonEvent.h"
#include "AddonEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/AddonManagerWebAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/AddonEvent.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


AddonEvent::AddonEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

AddonEvent::~AddonEvent()
{
}

AddonEvent*
AddonEvent::AsAddonEvent()
{
  return this;
}

JSObject*
AddonEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return AddonEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<AddonEvent>
AddonEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const AddonEventInit& aEventInitDict)
{
  RefPtr<AddonEvent> e = new AddonEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mId = aEventInitDict.mId;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<AddonEvent>
AddonEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const AddonEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
AddonEvent::GetId(nsString& aRetVal) const
{
  aRetVal = mId;
}


} // namespace mozilla::dom
