/*
 * Copyright (C) 2016 Open Broadcast Systems Ltd.
 * Author    (C) 2016 Rostislav Pehlivanov <atomnuker@gmail.com>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "diractab.h"

const uint8_t ff_dirac_default_qmat[7][4][4] = {
    { { 5,  3,  3,  0}, { 0,  4,  4,  1}, { 0,  5,  5,  2}, { 0,  6,  6,  3} },
    { { 4,  2,  2,  0}, { 0,  4,  4,  2}, { 0,  5,  5,  3}, { 0,  7,  7,  5} },
    { { 5,  3,  3,  0}, { 0,  4,  4,  1}, { 0,  5,  5,  2}, { 0,  6,  6,  3} },
    { { 8,  4,  4,  0}, { 0,  4,  4,  0}, { 0,  4,  4,  0}, { 0,  4,  4,  0} },
    { { 8,  4,  4,  0}, { 0,  4,  4,  0}, { 0,  4,  4,  0}, { 0,  4,  4,  0} },
    { { 0,  4,  4,  8}, { 0,  8,  8, 12}, { 0, 13, 13, 17}, { 0, 17, 17, 21} },
    { { 3,  1,  1,  0}, { 0,  4,  4,  2}, { 0,  6,  6,  5}, { 0,  9,  9,  7} },
};

const int32_t ff_dirac_qscale_tab[116] = {
    4,         5,         6,         7,         8,        10,        11,        13,
    16,        19,        23,        27,        32,        38,        45,        54,
    64,        76,        91,       108,       128,       152,       181,       215,
    256,       304,       362,       431,       512,       609,       724,       861,
    1024,      1218,      1448,      1722,      2048,      2435,      2896,      3444,
    4096,      4871,      5793,      6889,      8192,      9742,     11585,     13777,
    16384,     19484,     23170,     27554,     32768,     38968,     46341,     55109,
    65536,     77936,     92682,    110218,    131072,    155872,    185364,    220436,
    262144,    311744,    370728,    440872,    524288,    623487,    741455,    881744,
    1048576,   1246974,   1482910,   1763488,   2097152,   2493948,   2965821,   3526975,
    4194304,   4987896,   5931642,   7053950,   8388608,   9975792,  11863283,  14107901,
    16777216,  19951585,  23726566,  28215802,  33554432,  39903169,  47453133,  56431603,
    67108864,  79806339,  94906266, 112863206, 134217728, 159612677, 189812531, 225726413,
    268435456, 319225354, 379625062, 451452825, 536870912, 638450708, 759250125, 902905651,
    1073741824,1276901417,1518500250,1805811301,/*2147483648,2553802834,3037000500,3611622603,
    4294967296*/
};

const int32_t ff_dirac_qoffset_intra_tab[120] = {
    1,         2,         3,         4,         4,         5,         6,         7,
    8,        10,        12,        14,        16,        19,        23,        27,
    32,        38,        46,        54,        64,        76,        91,       108,
    128,       152,       181,       216,       256,       305,       362,       431,
    512,       609,       724,       861,      1024,      1218,      1448,      1722,
    2048,      2436,      2897,      3445,      4096,      4871,      5793,      6889,
    8192,      9742,     11585,     13777,     16384,     19484,     23171,     27555,
    32768,     38968,     46341,     55109,     65536,     77936,     92682,    110218,
    131072,    155872,    185364,    220436,    262144,    311744,    370728,    440872,
    524288,    623487,    741455,    881744,   1048576,   1246974,   1482911,   1763488,
    2097152,   2493948,   2965821,   3526975,   4194304,   4987896,   5931642,   7053951,
    8388608,   9975793,  11863283,  14107901,  16777216,  19951585,  23726567,  28215802,
    33554432,  39903170,  47453133,  56431603,  67108864,  79806339,  94906266, 112863207,
    134217728, 159612677, 189812531, 225726413, 268435456, 319225354, 379625063, 451452826,
    536870912, 638450709, 759250125, 902905651,1073741824,1276901417,1518500250,1805811302,
    /*2147483648, 2553802834, 3037000500, 3611622603, 4294967296,*/
};

const int ff_dirac_qoffset_inter_tab[122] = {
    1,         2,         2,         3,         3,         4,         4,         5,
    6,         7,         9,        10,        12,        14,        17,        20,
    24,        29,        34,        41,        48,        57,        68,        81,
    96,       114,       136,       162,       192,       228,       272,       323,
    384,       457,       543,       646,       768,       913,      1086,      1292,
    1536,      1827,      2172,      2583,      3072,      3653,      4344,      5166,
    6144,      7307,      8689,     10333,     12288,     14613,     17378,     20666,
    24576,     29226,     34756,     41332,     49152,     58452,     69512,     82664,
    98304,    116904,    139023,    165327,    196608,    233808,    278046,    330654,
    393216,    467615,    556091,    661308,    786432,    935231,   1112183,   1322616,
    1572864,   1870461,   2224366,   2645231,   3145728,   3740922,   4448731,   5290463,
    6291456,   7481844,   8897462,  10580926,  12582912,  14963688,  17794925,  21161851,
    25165824,  29927377,  35589850,  42323702,  50331648,  59854754,  71179699,  84647405,
    100663296, 119709508, 142359398, 169294809, 201326592, 239419016, 284718797, 338589619,
    402653184, 478838031, 569437594, 677179238, 805306368, 957676063,1138875188,1354358476,
    1610612736, 1915352125, /*2277750375, 2708716952, 3221225472, 3830704250,*/
};
