#ifndef SBK_WEBINSPECTORWRAPPER_H
#define SBK_WEBINSPECTORWRAPPER_H

#include <webinspector.h>


// Argument includes
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwebenginepage.h>
#include <qwebengineview.h>
#include <qwidget.h>
#include <webview.h>
#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class WebInspectorWrapper : public WebInspector
{
public:
    WebInspectorWrapper(::QWidget * parent = nullptr);
    WebInspectorWrapper(const WebInspectorWrapper &) = delete;
    WebInspectorWrapper& operator=(const WebInspectorWrapper &) = delete;
    WebInspectorWrapper(WebInspectorWrapper &&) = delete;
    WebInspectorWrapper& operator=(WebInspectorWrapper &&) = delete;
    ~WebInspectorWrapper() override;

    void actionEvent_protected(::QActionEvent * event) { QWidget::actionEvent(event); }
    void actionEvent(::QActionEvent * event) override;
    void changeEvent_protected(::QEvent * event) { QWidget::changeEvent(event); }
    void changeEvent(::QEvent * event) override;
    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void closeEvent_protected(::QCloseEvent * arg__1) { QWebEngineView::closeEvent(arg__1); }
    void closeEvent(::QCloseEvent * arg__1) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent_protected(::QContextMenuEvent * arg__1) { QWebEngineView::contextMenuEvent(arg__1); }
    void contextMenuEvent(::QContextMenuEvent * arg__1) override;
    ::QWebEngineView * createWindow_protected(::QWebEnginePage::WebWindowType type) { return QWebEngineView::createWindow(QWebEnginePage::WebWindowType(type)); }
    ::QWebEngineView * createWindow(::QWebEnginePage::WebWindowType type) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent_protected(::QDragEnterEvent * e) { QWebEngineView::dragEnterEvent(e); }
    void dragEnterEvent(::QDragEnterEvent * e) override;
    void dragLeaveEvent_protected(::QDragLeaveEvent * e) { QWebEngineView::dragLeaveEvent(e); }
    void dragLeaveEvent(::QDragLeaveEvent * e) override;
    void dragMoveEvent_protected(::QDragMoveEvent * e) { QWebEngineView::dragMoveEvent(e); }
    void dragMoveEvent(::QDragMoveEvent * e) override;
    void dropEvent_protected(::QDropEvent * e) { QWebEngineView::dropEvent(e); }
    void dropEvent(::QDropEvent * e) override;
    void enterEvent_protected(::QEnterEvent * event) { QWidget::enterEvent(event); }
    void enterEvent(::QEnterEvent * event) override;
    bool event_protected(::QEvent * arg__1) { return QWebEngineView::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent_protected(::QFocusEvent * event) { QWidget::focusInEvent(event); }
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild_protected(bool next) { return QWidget::focusNextPrevChild(next); }
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent_protected(::QFocusEvent * event) { QWidget::focusOutEvent(event); }
    void focusOutEvent(::QFocusEvent * event) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent_protected(::QHideEvent * arg__1) { QWebEngineView::hideEvent(arg__1); }
    void hideEvent(::QHideEvent * arg__1) override;
    void initPainter_protected(::QPainter * painter) const { QWidget::initPainter(painter); }
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent_protected(::QInputMethodEvent * event) { QWidget::inputMethodEvent(event); }
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void leaveEvent_protected(::QEvent * event) { QWidget::leaveEvent(event); }
    void leaveEvent(::QEvent * event) override;
    int metric_protected(::QPaintDevice::PaintDeviceMetric arg__1) const { return QWidget::metric(QPaintDevice::PaintDeviceMetric(arg__1)); }
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent_protected(::QMouseEvent * event) { QWidget::mouseDoubleClickEvent(event); }
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent_protected(::QMouseEvent * event) { QWidget::mouseMoveEvent(event); }
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent_protected(::QMouseEvent * event) { QWidget::mousePressEvent(event); }
    void mousePressEvent(::QMouseEvent * event) override;
    void mouseReleaseEvent_protected(::QMouseEvent * event) { QWidget::mouseReleaseEvent(event); }
    void mouseReleaseEvent(::QMouseEvent * event) override;
    void moveEvent_protected(::QMoveEvent * event) { QWidget::moveEvent(event); }
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent_protected(const ::QByteArray & eventType, void * message, ::qintptr * result) { return QWidget::nativeEvent(eventType, message, result); }
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent_protected(::QPaintEvent * event) { QWidget::paintEvent(event); }
    void paintEvent(::QPaintEvent * event) override;
    ::QPaintDevice * redirected_protected(::QPoint * offset) const { return QWidget::redirected(offset); }
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent_protected(::QResizeEvent * event) { QWidget::resizeEvent(event); }
    void resizeEvent(::QResizeEvent * event) override;
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter_protected() const { return QWidget::sharedPainter(); }
    ::QPainter * sharedPainter() const override;
    void showEvent_protected(::QShowEvent * arg__1) { QWebEngineView::showEvent(arg__1); }
    void showEvent(::QShowEvent * arg__1) override;
    ::QSize sizeHint() const override;
    void tabletEvent_protected(::QTabletEvent * event) { QWidget::tabletEvent(event); }
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    void wheelEvent_protected(::QWheelEvent * event) { QWidget::wheelEvent(event); }
    void wheelEvent(::QWheelEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 46> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  ifndef SBK_QWEBENGINEVIEWWRAPPER_H
#  define SBK_QWEBENGINEVIEWWRAPPER_H

// Inherited base class:
class QWebEngineViewWrapper : public QWebEngineView
{
public:
    QWebEngineViewWrapper(::QWebEnginePage * page, ::QWidget * parent = nullptr);
    QWebEngineViewWrapper(::QWebEngineProfile * profile, ::QWidget * parent = nullptr);
    QWebEngineViewWrapper(::QWidget * parent = nullptr);
    QWebEngineViewWrapper(const QWebEngineViewWrapper &) = delete;
    QWebEngineViewWrapper& operator=(const QWebEngineViewWrapper &) = delete;
    QWebEngineViewWrapper(QWebEngineViewWrapper &&) = delete;
    QWebEngineViewWrapper& operator=(QWebEngineViewWrapper &&) = delete;
    ~QWebEngineViewWrapper() override;

    void actionEvent_protected(::QActionEvent * event) { QWidget::actionEvent(event); }
    void actionEvent(::QActionEvent * event) override;
    void changeEvent_protected(::QEvent * event) { QWidget::changeEvent(event); }
    void changeEvent(::QEvent * event) override;
    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void closeEvent_protected(::QCloseEvent * arg__1) { QWebEngineView::closeEvent(arg__1); }
    void closeEvent(::QCloseEvent * arg__1) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent_protected(::QContextMenuEvent * arg__1) { QWebEngineView::contextMenuEvent(arg__1); }
    void contextMenuEvent(::QContextMenuEvent * arg__1) override;
    ::QWebEngineView * createWindow_protected(::QWebEnginePage::WebWindowType type) { return QWebEngineView::createWindow(QWebEnginePage::WebWindowType(type)); }
    ::QWebEngineView * createWindow(::QWebEnginePage::WebWindowType type) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent_protected(::QDragEnterEvent * e) { QWebEngineView::dragEnterEvent(e); }
    void dragEnterEvent(::QDragEnterEvent * e) override;
    void dragLeaveEvent_protected(::QDragLeaveEvent * e) { QWebEngineView::dragLeaveEvent(e); }
    void dragLeaveEvent(::QDragLeaveEvent * e) override;
    void dragMoveEvent_protected(::QDragMoveEvent * e) { QWebEngineView::dragMoveEvent(e); }
    void dragMoveEvent(::QDragMoveEvent * e) override;
    void dropEvent_protected(::QDropEvent * e) { QWebEngineView::dropEvent(e); }
    void dropEvent(::QDropEvent * e) override;
    void enterEvent_protected(::QEnterEvent * event) { QWidget::enterEvent(event); }
    void enterEvent(::QEnterEvent * event) override;
    bool event_protected(::QEvent * arg__1) { return QWebEngineView::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent_protected(::QFocusEvent * event) { QWidget::focusInEvent(event); }
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild_protected(bool next) { return QWidget::focusNextPrevChild(next); }
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent_protected(::QFocusEvent * event) { QWidget::focusOutEvent(event); }
    void focusOutEvent(::QFocusEvent * event) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent_protected(::QHideEvent * arg__1) { QWebEngineView::hideEvent(arg__1); }
    void hideEvent(::QHideEvent * arg__1) override;
    void initPainter_protected(::QPainter * painter) const { QWidget::initPainter(painter); }
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent_protected(::QInputMethodEvent * event) { QWidget::inputMethodEvent(event); }
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent_protected(::QKeyEvent * event) { QWidget::keyPressEvent(event); }
    void keyPressEvent(::QKeyEvent * event) override;
    void keyReleaseEvent_protected(::QKeyEvent * event) { QWidget::keyReleaseEvent(event); }
    void keyReleaseEvent(::QKeyEvent * event) override;
    void leaveEvent_protected(::QEvent * event) { QWidget::leaveEvent(event); }
    void leaveEvent(::QEvent * event) override;
    int metric_protected(::QPaintDevice::PaintDeviceMetric arg__1) const { return QWidget::metric(QPaintDevice::PaintDeviceMetric(arg__1)); }
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent_protected(::QMouseEvent * event) { QWidget::mouseDoubleClickEvent(event); }
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent_protected(::QMouseEvent * event) { QWidget::mouseMoveEvent(event); }
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent_protected(::QMouseEvent * event) { QWidget::mousePressEvent(event); }
    void mousePressEvent(::QMouseEvent * event) override;
    void mouseReleaseEvent_protected(::QMouseEvent * event) { QWidget::mouseReleaseEvent(event); }
    void mouseReleaseEvent(::QMouseEvent * event) override;
    void moveEvent_protected(::QMoveEvent * event) { QWidget::moveEvent(event); }
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent_protected(const ::QByteArray & eventType, void * message, ::qintptr * result) { return QWidget::nativeEvent(eventType, message, result); }
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent_protected(::QPaintEvent * event) { QWidget::paintEvent(event); }
    void paintEvent(::QPaintEvent * event) override;
    ::QPaintDevice * redirected_protected(::QPoint * offset) const { return QWidget::redirected(offset); }
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent_protected(::QResizeEvent * event) { QWidget::resizeEvent(event); }
    void resizeEvent(::QResizeEvent * event) override;
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter_protected() const { return QWidget::sharedPainter(); }
    ::QPainter * sharedPainter() const override;
    void showEvent_protected(::QShowEvent * arg__1) { QWebEngineView::showEvent(arg__1); }
    void showEvent(::QShowEvent * arg__1) override;
    ::QSize sizeHint() const override;
    void tabletEvent_protected(::QTabletEvent * event) { QWidget::tabletEvent(event); }
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    void wheelEvent_protected(::QWheelEvent * event) { QWidget::wheelEvent(event); }
    void wheelEvent(::QWheelEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 48> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QWEBENGINEVIEWWRAPPER_H

#  ifndef SBK_QWIDGETWRAPPER_H
#  define SBK_QWIDGETWRAPPER_H

// Inherited base class:
class QWidgetWrapper : public QWidget
{
public:
    QWidgetWrapper(::QWidget * parent = nullptr, ::QFlags<Qt::WindowType> f = Qt::WindowFlags());
    QWidgetWrapper(const QWidgetWrapper &) = delete;
    QWidgetWrapper& operator=(const QWidgetWrapper &) = delete;
    QWidgetWrapper(QWidgetWrapper &&) = delete;
    QWidgetWrapper& operator=(QWidgetWrapper &&) = delete;
    ~QWidgetWrapper() override;

    void actionEvent_protected(::QActionEvent * event) { QWidget::actionEvent(event); }
    void actionEvent(::QActionEvent * event) override;
    static void sbk_o_actionEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QActionEvent * event);
    void changeEvent_protected(::QEvent * event) { QWidget::changeEvent(event); }
    void changeEvent(::QEvent * event) override;
    static void sbk_o_changeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void closeEvent_protected(::QCloseEvent * event) { QWidget::closeEvent(event); }
    void closeEvent(::QCloseEvent * event) override;
    static void sbk_o_closeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QCloseEvent * event);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent_protected(::QContextMenuEvent * event) { QWidget::contextMenuEvent(event); }
    void contextMenuEvent(::QContextMenuEvent * event) override;
    static void sbk_o_contextMenuEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QContextMenuEvent * event);
    void create_protected(::WId arg__1 = 0, bool initializeWindow = true, bool destroyOldWindow = true) { QWidget::create(arg__1, initializeWindow, destroyOldWindow); }
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void destroy_protected(bool destroyWindow = true, bool destroySubWindows = true) { QWidget::destroy(destroyWindow, destroySubWindows); }
    int devType() const override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent_protected(::QDragEnterEvent * event) { QWidget::dragEnterEvent(event); }
    void dragEnterEvent(::QDragEnterEvent * event) override;
    static void sbk_o_dragEnterEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragEnterEvent * event);
    void dragLeaveEvent_protected(::QDragLeaveEvent * event) { QWidget::dragLeaveEvent(event); }
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    static void sbk_o_dragLeaveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragLeaveEvent * event);
    void dragMoveEvent_protected(::QDragMoveEvent * event) { QWidget::dragMoveEvent(event); }
    void dragMoveEvent(::QDragMoveEvent * event) override;
    static void sbk_o_dragMoveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragMoveEvent * event);
    void dropEvent_protected(::QDropEvent * event) { QWidget::dropEvent(event); }
    void dropEvent(::QDropEvent * event) override;
    static void sbk_o_dropEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDropEvent * event);
    void enterEvent_protected(::QEnterEvent * event) { QWidget::enterEvent(event); }
    void enterEvent(::QEnterEvent * event) override;
    static void sbk_o_enterEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEnterEvent * event);
    bool event_protected(::QEvent * event) { return QWidget::event(event); }
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent_protected(::QFocusEvent * event) { QWidget::focusInEvent(event); }
    void focusInEvent(::QFocusEvent * event) override;
    static void sbk_o_focusInEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFocusEvent * event);
    bool focusNextChild_protected() { return QWidget::focusNextChild(); }
    bool focusNextPrevChild_protected(bool next) { return QWidget::focusNextPrevChild(next); }
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent_protected(::QFocusEvent * event) { QWidget::focusOutEvent(event); }
    void focusOutEvent(::QFocusEvent * event) override;
    static void sbk_o_focusOutEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFocusEvent * event);
    bool focusPreviousChild_protected() { return QWidget::focusPreviousChild(); }
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent_protected(::QHideEvent * event) { QWidget::hideEvent(event); }
    void hideEvent(::QHideEvent * event) override;
    static void sbk_o_hideEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QHideEvent * event);
    void initPainter_protected(::QPainter * painter) const { QWidget::initPainter(painter); }
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent_protected(::QInputMethodEvent * event) { QWidget::inputMethodEvent(event); }
    void inputMethodEvent(::QInputMethodEvent * event) override;
    static void sbk_o_inputMethodEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QInputMethodEvent * event);
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent_protected(::QKeyEvent * event) { QWidget::keyPressEvent(event); }
    void keyPressEvent(::QKeyEvent * event) override;
    static void sbk_o_keyPressEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QKeyEvent * event);
    void keyReleaseEvent_protected(::QKeyEvent * event) { QWidget::keyReleaseEvent(event); }
    void keyReleaseEvent(::QKeyEvent * event) override;
    static void sbk_o_keyReleaseEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QKeyEvent * event);
    void leaveEvent_protected(::QEvent * event) { QWidget::leaveEvent(event); }
    void leaveEvent(::QEvent * event) override;
    static void sbk_o_leaveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    int metric_protected(::QPaintDevice::PaintDeviceMetric arg__1) const { return QWidget::metric(QPaintDevice::PaintDeviceMetric(arg__1)); }
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent_protected(::QMouseEvent * event) { QWidget::mouseDoubleClickEvent(event); }
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    static void sbk_o_mouseDoubleClickEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * event);
    void mouseMoveEvent_protected(::QMouseEvent * event) { QWidget::mouseMoveEvent(event); }
    void mouseMoveEvent(::QMouseEvent * event) override;
    static void sbk_o_mouseMoveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * event);
    void mousePressEvent_protected(::QMouseEvent * event) { QWidget::mousePressEvent(event); }
    void mousePressEvent(::QMouseEvent * event) override;
    static void sbk_o_mousePressEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * event);
    void mouseReleaseEvent_protected(::QMouseEvent * event) { QWidget::mouseReleaseEvent(event); }
    void mouseReleaseEvent(::QMouseEvent * event) override;
    static void sbk_o_mouseReleaseEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * event);
    void moveEvent_protected(::QMoveEvent * event) { QWidget::moveEvent(event); }
    void moveEvent(::QMoveEvent * event) override;
    static void sbk_o_moveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMoveEvent * event);
    bool nativeEvent_protected(const ::QByteArray & eventType, void * message, ::qintptr * result) { return QWidget::nativeEvent(eventType, message, result); }
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    static bool sbk_o_nativeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QByteArray & eventType, void * message, ::qintptr * result);
    ::QPaintEngine * paintEngine() const override;
    void paintEvent_protected(::QPaintEvent * event) { QWidget::paintEvent(event); }
    void paintEvent(::QPaintEvent * event) override;
    static void sbk_o_paintEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPaintEvent * event);
    ::QPaintDevice * redirected_protected(::QPoint * offset) const { return QWidget::redirected(offset); }
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent_protected(::QResizeEvent * event) { QWidget::resizeEvent(event); }
    void resizeEvent(::QResizeEvent * event) override;
    static void sbk_o_resizeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QResizeEvent * event);
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter_protected() const { return QWidget::sharedPainter(); }
    ::QPainter * sharedPainter() const override;
    void showEvent_protected(::QShowEvent * event) { QWidget::showEvent(event); }
    void showEvent(::QShowEvent * event) override;
    static void sbk_o_showEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QShowEvent * event);
    ::QSize sizeHint() const override;
    void tabletEvent_protected(::QTabletEvent * event) { QWidget::tabletEvent(event); }
    void tabletEvent(::QTabletEvent * event) override;
    static void sbk_o_tabletEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTabletEvent * event);
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    void updateMicroFocus_protected(::Qt::InputMethodQuery query = Qt::ImQueryAll) { QWidget::updateMicroFocus(Qt::InputMethodQuery(query)); }
    void wheelEvent_protected(::QWheelEvent * event) { QWidget::wheelEvent(event); }
    void wheelEvent(::QWheelEvent * event) override;
    static void sbk_o_wheelEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWheelEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 47> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QWIDGETWRAPPER_H

#  ifndef SBK_QOBJECTWRAPPER_H
#  define SBK_QOBJECTWRAPPER_H

// Inherited base class:
class QObjectWrapper : public QObject
{
public:
    QObjectWrapper(::QObject * parent = nullptr);
    QObjectWrapper(const QObjectWrapper &) = delete;
    QObjectWrapper& operator=(const QObjectWrapper &) = delete;
    QObjectWrapper(QObjectWrapper &&) = delete;
    QObjectWrapper& operator=(QObjectWrapper &&) = delete;
    ~QObjectWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    bool isSignalConnected_protected(const ::QMetaMethod & signal) const { return QObject::isSignalConnected(signal); }
    int receivers_protected(const char * signal) const { return QObject::receivers(signal); }
    ::QObject * sender_protected() const { return QObject::sender(); }
    int senderSignalIndex_protected() const { return QObject::senderSignalIndex(); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QOBJECTWRAPPER_H

#  ifndef SBK_QPAINTDEVICEWRAPPER_H
#  define SBK_QPAINTDEVICEWRAPPER_H

// Inherited base class:
class QPaintDeviceWrapper : public QPaintDevice
{
public:
    QPaintDeviceWrapper() noexcept;
    QPaintDeviceWrapper(const QPaintDeviceWrapper &) = delete;
    QPaintDeviceWrapper& operator=(const QPaintDeviceWrapper &) = delete;
    QPaintDeviceWrapper(QPaintDeviceWrapper &&) = delete;
    QPaintDeviceWrapper& operator=(QPaintDeviceWrapper &&) = delete;
    ~QPaintDeviceWrapper() override;

    int devType() const override;
    double getDecodedMetricF_protected(::QPaintDevice::PaintDeviceMetric metricA, ::QPaintDevice::PaintDeviceMetric metricB) const { return QPaintDevice::getDecodedMetricF(QPaintDevice::PaintDeviceMetric(metricA), QPaintDevice::PaintDeviceMetric(metricB)); }
    void initPainter_protected(::QPainter * painter) const { QPaintDevice::initPainter(painter); }
    void initPainter(::QPainter * painter) const override;
    int metric_protected(::QPaintDevice::PaintDeviceMetric metric) const { return QPaintDevice::metric(QPaintDevice::PaintDeviceMetric(metric)); }
    int metric(::QPaintDevice::PaintDeviceMetric metric) const override;
    ::QPaintEngine * paintEngine() const override;
    ::QPaintDevice * redirected_protected(::QPoint * offset) const { return QPaintDevice::redirected(offset); }
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    ::QPainter * sharedPainter_protected() const { return QPaintDevice::sharedPainter(); }
    ::QPainter * sharedPainter() const override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

    // Make protected fields accessible
    using QPaintDevice::painters;

private:
    mutable std::array<PyObject *, 6> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QPAINTDEVICEWRAPPER_H

#endif // SBK_WEBINSPECTORWRAPPER_H
