
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "plugins_plugin_wrapper.h"

// Argument includes
#include <plugins.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_Plugins_Plugin_Type = nullptr;
static PyTypeObject *Sbk_Plugins_Plugin_TypeF(void)
{
    return _Sbk_Plugins_Plugin_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Plugins_Plugin_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Plugins::Plugin >()))
        return -1;

    ::Plugins::Plugin *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Plugin", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Plugin::Plugin()
    // 1: Plugin::Plugin(Plugins::Plugin)
    if (numArgs == 0) {
        overloadId = 0; // Plugin()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Plugin(Plugins::Plugin)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Plugin()
        {

            // Plugin()
            cptr = new ::Plugins::Plugin();
            break;
        }
        case 1: // Plugin(const Plugins::Plugin &Plugin)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Plugins::Plugin cppArg0_local;
            ::Plugins::Plugin *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // Plugin(Plugins::Plugin)
                cptr = new ::Plugins::Plugin(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Plugins::Plugin >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_Plugins_PluginFunc_isLoaded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isLoaded()const
        bool cppResult = const_cast<const ::Plugins::Plugin *>(cppSelf)->isLoaded();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_Plugins_PluginFunc_isRemovable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRemovable()const
        bool cppResult = const_cast<const ::Plugins::Plugin *>(cppSelf)->isRemovable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_Plugins_Plugin__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Plugins_Plugin_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_Plugins_Plugin_EnumFlagInfo[] = {
    "Type:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Plugins_Plugin_methods[] = {
    {"isLoaded", reinterpret_cast<PyCFunction>(Sbk_Plugins_PluginFunc_isLoaded), METH_NOARGS, nullptr},
    {"isRemovable", reinterpret_cast<PyCFunction>(Sbk_Plugins_PluginFunc_isRemovable), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_Plugins_Plugin__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_Plugins_Plugin_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), (pyArg)))) {
                // operator==(const Plugins::Plugin &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Plugins::Plugin cppArg0_local;
                ::Plugins::Plugin *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

static PyObject *Sbk_Plugins_Plugin_get_type(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Plugins::Plugin::Type cppOut_local = cppSelf->type;
    return Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_Type_IDX])))->converter, &cppOut_local);
}
static int Sbk_Plugins_Plugin_set_type(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("type");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_Type_IDX])))->converter, (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("type", "Type");
        return -1;
    }

    auto cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginId(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->pluginId);
}
static int Sbk_Plugins_Plugin_set_pluginId(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("pluginId");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("pluginId", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->pluginId;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginPath(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->pluginPath);
}
static int Sbk_Plugins_Plugin_set_pluginPath(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("pluginPath");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("pluginPath", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->pluginPath;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginSpec(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->pluginSpec), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->pluginSpec), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_pluginSpec(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("pluginSpec");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("pluginSpec", "PluginSpec");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->pluginSpec;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_instance(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), cppSelf->instance);
}
static int Sbk_Plugins_Plugin_set_instance(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("instance");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("instance", "PluginInterface");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->instance;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "instance", pyIn);
    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_internalInstance(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), cppSelf->internalInstance);
}
static int Sbk_Plugins_Plugin_set_internalInstance(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("internalInstance");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("internalInstance", "PluginInterface");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->internalInstance;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "internalInstance", pyIn);
    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginLoader(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPluginLoader_IDX]), cppSelf->pluginLoader);
}
static int Sbk_Plugins_Plugin_set_pluginLoader(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("pluginLoader");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPluginLoader_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("pluginLoader", "QPluginLoader");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->pluginLoader;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "pluginLoader", pyIn);
    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_data(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppSelf->data);
}
static int Sbk_Plugins_Plugin_set_data(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("data");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("data", "QVariant");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->data;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Plugin
static PyGetSetDef Sbk_Plugins_Plugin_getsetlist[] = {
    {const_cast<char *>("type"), Sbk_Plugins_Plugin_get_type, Sbk_Plugins_Plugin_set_type, nullptr, nullptr},
    {const_cast<char *>("pluginId"), Sbk_Plugins_Plugin_get_pluginId, Sbk_Plugins_Plugin_set_pluginId, nullptr, nullptr},
    {const_cast<char *>("pluginPath"), Sbk_Plugins_Plugin_get_pluginPath, Sbk_Plugins_Plugin_set_pluginPath, nullptr, nullptr},
    {const_cast<char *>("pluginSpec"), Sbk_Plugins_Plugin_get_pluginSpec, Sbk_Plugins_Plugin_set_pluginSpec, nullptr, nullptr},
    {const_cast<char *>("instance"), Sbk_Plugins_Plugin_get_instance, Sbk_Plugins_Plugin_set_instance, nullptr, nullptr},
    {const_cast<char *>("internalInstance"), Sbk_Plugins_Plugin_get_internalInstance, Sbk_Plugins_Plugin_set_internalInstance, nullptr, nullptr},
    {const_cast<char *>("pluginLoader"), Sbk_Plugins_Plugin_get_pluginLoader, Sbk_Plugins_Plugin_set_pluginLoader, nullptr, nullptr},
    {const_cast<char *>("data"), Sbk_Plugins_Plugin_get_data, Sbk_Plugins_Plugin_set_data, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Plugins_Plugin_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_Plugins_Plugin_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_Plugins_Plugin_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Plugins_Plugin_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Plugins_Plugin_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_Plugins_Plugin_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Plugins_Plugin_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_Plugins_Plugin_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Plugins_Plugin_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_Plugins_Plugin_spec = {
    "1:PyFalkon.Plugins.Plugin",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_Plugins_Plugin_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_Plugins_Plugin_Type(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::Plugins::Plugin::Type>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::Plugins::Plugin::Type *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_Plugins_Plugin_Type_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_Type_IDX])))
        return Enum_PythonToCpp_Plugins_Plugin_Type;
    return {};
}

static PyObject *Plugins_Plugin_Type_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::Plugins::Plugin::Type>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::Plugins::Plugin::Type *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Plugin_PythonToCpp_Plugin_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_Plugins_Plugin_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Plugin_PythonToCpp_Plugin_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_Plugins_Plugin_TypeF()))
        return Plugin_PythonToCpp_Plugin_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Plugin_PTR_CppToPython_Plugin(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_Plugins_Plugin_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_Plugins_Plugin_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *Plugin_COPY_CppToPython_Plugin(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::Plugins::Plugin *>(cppIn);
    return Shiboken::Object::newObject(Sbk_Plugins_Plugin_TypeF(), new ::Plugins::Plugin(*source), true, true);
}

// Python to C++ copy conversion.
static void Plugin_PythonToCpp_Plugin_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::Plugins::Plugin *>(cppOut) = *reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Plugin_PythonToCpp_Plugin_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_Plugins_Plugin_TypeF()))
        return Plugin_PythonToCpp_Plugin_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *Plugins_Plugin_SignatureStrings[] = {
    "1:PyFalkon.Plugins.Plugin(self)",
    "0:PyFalkon.Plugins.Plugin(self,Plugin:PyFalkon.Plugins.Plugin)",
    "PyFalkon.Plugins.Plugin.isLoaded(self)->bool",
    "PyFalkon.Plugins.Plugin.isRemovable(self)->bool",
    "PyFalkon.Plugins.Plugin.__copy__(self)->typing._Self",
    "PyFalkon.Plugins.Plugin.__eq__(self,other:PyFalkon.Plugins.Plugin)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t Plugins_Plugin_SignatureByteSize = 115;
static constexpr uint8_t Plugins_Plugin_SignatureBytes[115] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0xc8, 0x29,
    0x4d, 0xcf, 0xcc, 0x2b, 0x86, 0xd2, 0x1a, 0xc5, 0xa9, 0x39, 0x69, 0x9a, 0x5c, 0x06, 0x78, 0xe5,
    0x75, 0x20, 0x6c, 0x5c, 0x6a, 0x34, 0xb9, 0x70, 0x48, 0xe8, 0x65, 0x16, 0xfb, 0xe4, 0x27, 0xa6,
    0xa4, 0xa6, 0x40, 0x6c, 0xd1, 0xb5, 0x4b, 0xca, 0xcf, 0xcf, 0xc1, 0xa3, 0x38, 0x28, 0x35, 0x37,
    0xbf, 0x2c, 0x31, 0x29, 0x27, 0x95, 0x28, 0xf5, 0xf1, 0xf1, 0xc9, 0xf9, 0x05, 0x95, 0xf1, 0xf1,
    0x30, 0xc5, 0x25, 0x95, 0x05, 0x99, 0x79, 0xe9, 0x7a, 0xf1, 0xc1, 0x40, 0x2e, 0x1e, 0x4d, 0xa9,
    0x85, 0x50, 0x2d, 0x3a, 0xf9, 0x25, 0x19, 0xa9, 0x45, 0x38, 0x3d, 0x05, 0xb5, 0x1d, 0x00, 0x1a,
    0x19, 0x72, 0x1a
};
#endif

PyTypeObject *init_Plugins_Plugin(PyObject *enclosingClass)
{
    if (SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX].type;

    Shiboken::AutoDecRef Sbk_Plugins_Plugin_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_Plugins_Plugin_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Plugin",
        "Plugins::Plugin",
        &Sbk_Plugins_Plugin_spec,
        &Shiboken::callCppDestructor< ::Plugins::Plugin >,
        Sbk_Plugins_Plugin_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_Plugins_Plugin_TypeF(); // references _Sbk_Plugins_Plugin_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, Plugins_Plugin_SignatureStrings);
#else
    InitSignatureBytes(pyType, Plugins_Plugin_SignatureBytes, Plugins_Plugin_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_Plugins_Plugin_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Plugin_PythonToCpp_Plugin_PTR,
        is_Plugin_PythonToCpp_Plugin_PTR_Convertible,
        Plugin_PTR_CppToPython_Plugin,
        Plugin_COPY_CppToPython_Plugin);

    Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin");
    Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin*");
    Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin&");
    Shiboken::Conversions::registerConverterAlias(converter, "Plugin");
    Shiboken::Conversions::registerConverterAlias(converter, "Plugin*");
    Shiboken::Conversions::registerConverterAlias(converter, "Plugin&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Plugins::Plugin).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Plugin_PythonToCpp_Plugin_COPY,
        is_Plugin_PythonToCpp_Plugin_COPY_Convertible);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_Plugins_Plugin_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Type'.
    const char *Type_Initializer[] = {
        "Invalid",
        "InternalPlugin",
        "SharedLibraryPlugin",
        "PythonPlugin",
        "QmlPlugin",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Type_InitializerValues[] = {
        uint8_t(Plugins::Plugin::Type::Invalid),             //  0x00  0
        uint8_t(Plugins::Plugin::Type::InternalPlugin),      //  0x01  1
        uint8_t(Plugins::Plugin::Type::SharedLibraryPlugin), //  0x02  2
        uint8_t(Plugins::Plugin::Type::PythonPlugin),        //  0x03  3
        uint8_t(Plugins::Plugin::Type::QmlPlugin)            //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_Plugins_Plugin_TypeF(),
        "1:PyFalkon.Plugins.Plugin.Type",
        Type_Initializer, Type_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_Type_IDX].type = EType;
    // Register converter for enum 'Plugins::Plugin::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            Plugins_Plugin_Type_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_Plugins_Plugin_Type,
            is_Enum_PythonToCpp_Plugins_Plugin_Type_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "Plugin::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "Type");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::Plugins::Plugin >("Plugin");
    qRegisterMetaType< ::Plugins::Plugin >("Plugins::Plugin");
    qRegisterMetaType< ::Plugins::Plugin::Type >("Plugin::Type");
    qRegisterMetaType< ::Plugins::Plugin::Type >("Plugins::Plugin::Type");

    return pyType;
}
