/* spring-params.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from spring-params.vala, do not modify */

/* This file is part of Elastic. License: GPL-3.0+.*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <adwaita.h>

#define ELASTIC_SPRING_PARAMS_DEFAULT_DAMPING ((gdouble) 10)
#define ELASTIC_SPRING_PARAMS_DEFAULT_MASS ((gdouble) 1)
#define ELASTIC_SPRING_PARAMS_DEFAULT_STIFFNESS ((gdouble) 100)
#define ELASTIC_SPRING_PARAMS_DEFAULT_EPSILON 0.001
#define ELASTIC_SPRING_PARAMS_DEFAULT_VELOCITY ((gdouble) 0)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ELASTIC_TYPE_SPRING_PARAMS (elastic_spring_params_get_type ())
#define ELASTIC_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams))
#define ELASTIC_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))
#define ELASTIC_IS_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_IS_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_SPRING_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))

typedef struct _ElasticSpringParams ElasticSpringParams;
typedef struct _ElasticSpringParamsClass ElasticSpringParamsClass;
typedef struct _ElasticSpringParamsPrivate ElasticSpringParamsPrivate;
enum  {
	ELASTIC_SPRING_PARAMS_0_PROPERTY,
	ELASTIC_SPRING_PARAMS_DAMPING_PROPERTY,
	ELASTIC_SPRING_PARAMS_DAMPING_RATIO_PROPERTY,
	ELASTIC_SPRING_PARAMS_MASS_PROPERTY,
	ELASTIC_SPRING_PARAMS_STIFFNESS_PROPERTY,
	ELASTIC_SPRING_PARAMS_EPSILON_PROPERTY,
	ELASTIC_SPRING_PARAMS_VELOCITY_PROPERTY,
	ELASTIC_SPRING_PARAMS_IS_MODIFIED_PROPERTY,
	ELASTIC_SPRING_PARAMS_NUM_PROPERTIES
};
static GParamSpec* elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _adw_spring_params_unref0(var) ((var == NULL) ? NULL : (var = (adw_spring_params_unref (var), NULL)))
enum  {
	ELASTIC_SPRING_PARAMS_CHANGED_SIGNAL,
	ELASTIC_SPRING_PARAMS_NUM_SIGNALS
};
static guint elastic_spring_params_signals[ELASTIC_SPRING_PARAMS_NUM_SIGNALS] = {0};

struct _ElasticSpringParams {
	GObject parent_instance;
	ElasticSpringParamsPrivate * priv;
};

struct _ElasticSpringParamsClass {
	GObjectClass parent_class;
};

struct _ElasticSpringParamsPrivate {
	gdouble _damping;
	gdouble _mass;
	gdouble _stiffness;
	gdouble _epsilon;
	gdouble _velocity;
	GSettings* settings;
};

static gint ElasticSpringParams_private_offset;
static gpointer elastic_spring_params_parent_class = NULL;

VALA_EXTERN GType elastic_spring_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticSpringParams, g_object_unref)
VALA_EXTERN void elastic_spring_params_reset_to_defaults (ElasticSpringParams* self);
VALA_EXTERN void elastic_spring_params_set_mass (ElasticSpringParams* self,
                                     gdouble value);
VALA_EXTERN void elastic_spring_params_set_stiffness (ElasticSpringParams* self,
                                          gdouble value);
VALA_EXTERN void elastic_spring_params_set_damping (ElasticSpringParams* self,
                                        gdouble value);
VALA_EXTERN void elastic_spring_params_set_epsilon (ElasticSpringParams* self,
                                        gdouble value);
VALA_EXTERN void elastic_spring_params_set_velocity (ElasticSpringParams* self,
                                         gdouble value);
VALA_EXTERN gdouble elastic_spring_params_damping_ratio_for_damping (ElasticSpringParams* self,
                                                         gdouble damping);
VALA_EXTERN gdouble elastic_spring_params_get_mass (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_stiffness (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_damping_for_damping_ratio (ElasticSpringParams* self,
                                                         gdouble damping_ratio);
VALA_EXTERN void elastic_spring_params_apply (ElasticSpringParams* self,
                                  AdwSpringAnimation* animation);
VALA_EXTERN gdouble elastic_spring_params_get_damping (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_velocity (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_epsilon (ElasticSpringParams* self);
VALA_EXTERN gboolean elastic_spring_params_is_epsilon_modified (ElasticSpringParams* self);
VALA_EXTERN gboolean elastic_spring_params_is_velocity_modified (ElasticSpringParams* self);
VALA_EXTERN ElasticSpringParams* elastic_spring_params_new (void);
VALA_EXTERN ElasticSpringParams* elastic_spring_params_construct (GType object_type);
VALA_EXTERN gboolean elastic_spring_params_get_is_modified (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_damping_ratio (ElasticSpringParams* self);
VALA_EXTERN void elastic_spring_params_set_damping_ratio (ElasticSpringParams* self,
                                              gdouble value);
static GObject * elastic_spring_params_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void elastic_spring_params_finalize (GObject * obj);
static GType elastic_spring_params_get_type_once (void);
static void _vala_elastic_spring_params_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_elastic_spring_params_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
elastic_spring_params_get_instance_private (ElasticSpringParams* self)
{
	return G_STRUCT_MEMBER_P (self, ElasticSpringParams_private_offset);
}

void
elastic_spring_params_reset_to_defaults (ElasticSpringParams* self)
{
	g_return_if_fail (self != NULL);
	elastic_spring_params_set_mass (self, ELASTIC_SPRING_PARAMS_DEFAULT_MASS);
	elastic_spring_params_set_stiffness (self, ELASTIC_SPRING_PARAMS_DEFAULT_STIFFNESS);
	elastic_spring_params_set_damping (self, ELASTIC_SPRING_PARAMS_DEFAULT_DAMPING);
	elastic_spring_params_set_epsilon (self, ELASTIC_SPRING_PARAMS_DEFAULT_EPSILON);
	elastic_spring_params_set_velocity (self, ELASTIC_SPRING_PARAMS_DEFAULT_VELOCITY);
}

gdouble
elastic_spring_params_damping_ratio_for_damping (ElasticSpringParams* self,
                                                 gdouble damping)
{
	gdouble critical_damping = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = elastic_spring_params_get_mass (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = elastic_spring_params_get_stiffness (self);
	_tmp3_ = _tmp2_;
	critical_damping = 2 * sqrt (_tmp1_ * _tmp3_);
	result = damping / critical_damping;
	return result;
}

gdouble
elastic_spring_params_damping_for_damping_ratio (ElasticSpringParams* self,
                                                 gdouble damping_ratio)
{
	gdouble critical_damping = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = elastic_spring_params_get_mass (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = elastic_spring_params_get_stiffness (self);
	_tmp3_ = _tmp2_;
	critical_damping = 2 * sqrt (_tmp1_ * _tmp3_);
	result = damping_ratio * critical_damping;
	return result;
}

void
elastic_spring_params_apply (ElasticSpringParams* self,
                             AdwSpringAnimation* animation)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	AdwSpringParams* _tmp6_;
	AdwSpringParams* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (animation != NULL);
	_tmp0_ = elastic_spring_params_get_damping (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = elastic_spring_params_get_mass (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = elastic_spring_params_get_stiffness (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = adw_spring_params_new_full (_tmp1_, _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	adw_spring_animation_set_spring_params (animation, _tmp7_);
	_adw_spring_params_unref0 (_tmp7_);
	_tmp8_ = elastic_spring_params_get_velocity (self);
	_tmp9_ = _tmp8_;
	adw_spring_animation_set_initial_velocity (animation, _tmp9_);
	_tmp10_ = elastic_spring_params_get_epsilon (self);
	_tmp11_ = _tmp10_;
	adw_spring_animation_set_epsilon (animation, _tmp11_);
}

gboolean
elastic_spring_params_is_epsilon_modified (ElasticSpringParams* self)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = elastic_spring_params_get_epsilon (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != ELASTIC_SPRING_PARAMS_DEFAULT_EPSILON;
	return result;
}

gboolean
elastic_spring_params_is_velocity_modified (ElasticSpringParams* self)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = elastic_spring_params_get_velocity (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != ELASTIC_SPRING_PARAMS_DEFAULT_VELOCITY;
	return result;
}

ElasticSpringParams*
elastic_spring_params_construct (GType object_type)
{
	ElasticSpringParams * self = NULL;
	self = (ElasticSpringParams*) g_object_new (object_type, NULL);
	return self;
}

ElasticSpringParams*
elastic_spring_params_new (void)
{
	return elastic_spring_params_construct (ELASTIC_TYPE_SPRING_PARAMS);
}

gdouble
elastic_spring_params_get_damping (ElasticSpringParams* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_damping;
	return result;
}

void
elastic_spring_params_set_damping (ElasticSpringParams* self,
                                   gdouble value)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean was_modified = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_spring_params_get_damping (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_spring_params_get_is_modified (self);
	_tmp3_ = _tmp2_;
	was_modified = _tmp3_;
	self->priv->_damping = value;
	g_object_notify ((GObject*) self, "damping-ratio");
	_tmp4_ = elastic_spring_params_get_is_modified (self);
	_tmp5_ = _tmp4_;
	if (was_modified != _tmp5_) {
		g_object_notify ((GObject*) self, "is-modified");
	}
	g_signal_emit (self, elastic_spring_params_signals[ELASTIC_SPRING_PARAMS_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_DAMPING_PROPERTY]);
}

gdouble
elastic_spring_params_get_damping_ratio (ElasticSpringParams* self)
{
	gdouble result;
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = elastic_spring_params_get_damping (self);
	_tmp1_ = _tmp0_;
	result = elastic_spring_params_damping_ratio_for_damping (self, _tmp1_);
	return result;
}

void
elastic_spring_params_set_damping_ratio (ElasticSpringParams* self,
                                         gdouble value)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_spring_params_get_damping_ratio (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	elastic_spring_params_set_damping (self, elastic_spring_params_damping_for_damping_ratio (self, value));
	g_object_notify_by_pspec ((GObject *) self, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_DAMPING_RATIO_PROPERTY]);
}

gdouble
elastic_spring_params_get_mass (ElasticSpringParams* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_mass;
	return result;
}

void
elastic_spring_params_set_mass (ElasticSpringParams* self,
                                gdouble value)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble old_damping_ratio = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean was_modified = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_spring_params_get_mass (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_spring_params_get_damping_ratio (self);
	_tmp3_ = _tmp2_;
	old_damping_ratio = _tmp3_;
	_tmp4_ = elastic_spring_params_get_is_modified (self);
	_tmp5_ = _tmp4_;
	was_modified = _tmp5_;
	self->priv->_mass = value;
	_tmp6_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp6_, "use-damping")) {
		g_object_notify ((GObject*) self, "damping-ratio");
	} else {
		elastic_spring_params_set_damping (self, elastic_spring_params_damping_for_damping_ratio (self, old_damping_ratio));
	}
	_tmp7_ = elastic_spring_params_get_is_modified (self);
	_tmp8_ = _tmp7_;
	if (was_modified != _tmp8_) {
		g_object_notify ((GObject*) self, "is-modified");
	}
	g_signal_emit (self, elastic_spring_params_signals[ELASTIC_SPRING_PARAMS_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_MASS_PROPERTY]);
}

gdouble
elastic_spring_params_get_stiffness (ElasticSpringParams* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_stiffness;
	return result;
}

void
elastic_spring_params_set_stiffness (ElasticSpringParams* self,
                                     gdouble value)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble old_damping_ratio = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean was_modified = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_spring_params_get_stiffness (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_spring_params_get_damping_ratio (self);
	_tmp3_ = _tmp2_;
	old_damping_ratio = _tmp3_;
	_tmp4_ = elastic_spring_params_get_is_modified (self);
	_tmp5_ = _tmp4_;
	was_modified = _tmp5_;
	self->priv->_stiffness = value;
	_tmp6_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp6_, "use-damping")) {
		g_object_notify ((GObject*) self, "damping-ratio");
	} else {
		elastic_spring_params_set_damping (self, elastic_spring_params_damping_for_damping_ratio (self, old_damping_ratio));
	}
	_tmp7_ = elastic_spring_params_get_is_modified (self);
	_tmp8_ = _tmp7_;
	if (was_modified != _tmp8_) {
		g_object_notify ((GObject*) self, "is-modified");
	}
	g_signal_emit (self, elastic_spring_params_signals[ELASTIC_SPRING_PARAMS_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_STIFFNESS_PROPERTY]);
}

gdouble
elastic_spring_params_get_epsilon (ElasticSpringParams* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_epsilon;
	return result;
}

void
elastic_spring_params_set_epsilon (ElasticSpringParams* self,
                                   gdouble value)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean was_modified = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_spring_params_get_epsilon (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_spring_params_get_is_modified (self);
	_tmp3_ = _tmp2_;
	was_modified = _tmp3_;
	self->priv->_epsilon = value;
	_tmp4_ = elastic_spring_params_get_is_modified (self);
	_tmp5_ = _tmp4_;
	if (was_modified != _tmp5_) {
		g_object_notify ((GObject*) self, "is-modified");
	}
	g_signal_emit (self, elastic_spring_params_signals[ELASTIC_SPRING_PARAMS_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_EPSILON_PROPERTY]);
}

gdouble
elastic_spring_params_get_velocity (ElasticSpringParams* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_velocity;
	return result;
}

void
elastic_spring_params_set_velocity (ElasticSpringParams* self,
                                    gdouble value)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean was_modified = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_spring_params_get_velocity (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_spring_params_get_is_modified (self);
	_tmp3_ = _tmp2_;
	was_modified = _tmp3_;
	self->priv->_velocity = value;
	_tmp4_ = elastic_spring_params_get_is_modified (self);
	_tmp5_ = _tmp4_;
	if (was_modified != _tmp5_) {
		g_object_notify ((GObject*) self, "is-modified");
	}
	g_signal_emit (self, elastic_spring_params_signals[ELASTIC_SPRING_PARAMS_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_VELOCITY_PROPERTY]);
}

gboolean
elastic_spring_params_get_is_modified (ElasticSpringParams* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp4_ = elastic_spring_params_get_damping (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != ELASTIC_SPRING_PARAMS_DEFAULT_DAMPING) {
		_tmp3_ = TRUE;
	} else {
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = elastic_spring_params_get_mass (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != ELASTIC_SPRING_PARAMS_DEFAULT_MASS;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gdouble _tmp8_;
		gdouble _tmp9_;
		_tmp8_ = elastic_spring_params_get_stiffness (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = _tmp9_ != ELASTIC_SPRING_PARAMS_DEFAULT_STIFFNESS;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp10_ = elastic_spring_params_get_epsilon (self);
		_tmp11_ = _tmp10_;
		_tmp1_ = _tmp11_ != ELASTIC_SPRING_PARAMS_DEFAULT_EPSILON;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp12_;
		gdouble _tmp13_;
		_tmp12_ = elastic_spring_params_get_velocity (self);
		_tmp13_ = _tmp12_;
		_tmp0_ = _tmp13_ != ELASTIC_SPRING_PARAMS_DEFAULT_VELOCITY;
	}
	result = _tmp0_;
	return result;
}

static GObject *
elastic_spring_params_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ElasticSpringParams * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (elastic_spring_params_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams);
	_tmp0_ = g_settings_new ("app.drey.Elastic");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	return obj;
}

static void
elastic_spring_params_class_init (ElasticSpringParamsClass * klass,
                                  gpointer klass_data)
{
	elastic_spring_params_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ElasticSpringParams_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_elastic_spring_params_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_elastic_spring_params_set_property;
	G_OBJECT_CLASS (klass)->constructor = elastic_spring_params_constructor;
	G_OBJECT_CLASS (klass)->finalize = elastic_spring_params_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_SPRING_PARAMS_DAMPING_PROPERTY, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_DAMPING_PROPERTY] = g_param_spec_double ("damping", "damping", "damping", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_SPRING_PARAMS_DAMPING_RATIO_PROPERTY, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_DAMPING_RATIO_PROPERTY] = g_param_spec_double ("damping-ratio", "damping-ratio", "damping-ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_SPRING_PARAMS_MASS_PROPERTY, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_MASS_PROPERTY] = g_param_spec_double ("mass", "mass", "mass", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_SPRING_PARAMS_STIFFNESS_PROPERTY, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_STIFFNESS_PROPERTY] = g_param_spec_double ("stiffness", "stiffness", "stiffness", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_SPRING_PARAMS_EPSILON_PROPERTY, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_EPSILON_PROPERTY] = g_param_spec_double ("epsilon", "epsilon", "epsilon", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_SPRING_PARAMS_VELOCITY_PROPERTY, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_VELOCITY_PROPERTY] = g_param_spec_double ("velocity", "velocity", "velocity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_SPRING_PARAMS_IS_MODIFIED_PROPERTY, elastic_spring_params_properties[ELASTIC_SPRING_PARAMS_IS_MODIFIED_PROPERTY] = g_param_spec_boolean ("is-modified", "is-modified", "is-modified", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	elastic_spring_params_signals[ELASTIC_SPRING_PARAMS_CHANGED_SIGNAL] = g_signal_new ("changed", ELASTIC_TYPE_SPRING_PARAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
elastic_spring_params_instance_init (ElasticSpringParams * self,
                                     gpointer klass)
{
	self->priv = elastic_spring_params_get_instance_private (self);
	self->priv->_damping = ELASTIC_SPRING_PARAMS_DEFAULT_DAMPING;
	self->priv->_mass = ELASTIC_SPRING_PARAMS_DEFAULT_MASS;
	self->priv->_stiffness = ELASTIC_SPRING_PARAMS_DEFAULT_STIFFNESS;
	self->priv->_epsilon = ELASTIC_SPRING_PARAMS_DEFAULT_EPSILON;
	self->priv->_velocity = ELASTIC_SPRING_PARAMS_DEFAULT_VELOCITY;
}

static void
elastic_spring_params_finalize (GObject * obj)
{
	ElasticSpringParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (elastic_spring_params_parent_class)->finalize (obj);
}

static GType
elastic_spring_params_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ElasticSpringParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) elastic_spring_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ElasticSpringParams), 0, (GInstanceInitFunc) elastic_spring_params_instance_init, NULL };
	GType elastic_spring_params_type_id;
	elastic_spring_params_type_id = g_type_register_static (G_TYPE_OBJECT, "ElasticSpringParams", &g_define_type_info, 0);
	ElasticSpringParams_private_offset = g_type_add_instance_private (elastic_spring_params_type_id, sizeof (ElasticSpringParamsPrivate));
	return elastic_spring_params_type_id;
}

GType
elastic_spring_params_get_type (void)
{
	static volatile gsize elastic_spring_params_type_id__once = 0;
	if (g_once_init_enter (&elastic_spring_params_type_id__once)) {
		GType elastic_spring_params_type_id;
		elastic_spring_params_type_id = elastic_spring_params_get_type_once ();
		g_once_init_leave (&elastic_spring_params_type_id__once, elastic_spring_params_type_id);
	}
	return elastic_spring_params_type_id__once;
}

static void
_vala_elastic_spring_params_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ElasticSpringParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams);
	switch (property_id) {
		case ELASTIC_SPRING_PARAMS_DAMPING_PROPERTY:
		g_value_set_double (value, elastic_spring_params_get_damping (self));
		break;
		case ELASTIC_SPRING_PARAMS_DAMPING_RATIO_PROPERTY:
		g_value_set_double (value, elastic_spring_params_get_damping_ratio (self));
		break;
		case ELASTIC_SPRING_PARAMS_MASS_PROPERTY:
		g_value_set_double (value, elastic_spring_params_get_mass (self));
		break;
		case ELASTIC_SPRING_PARAMS_STIFFNESS_PROPERTY:
		g_value_set_double (value, elastic_spring_params_get_stiffness (self));
		break;
		case ELASTIC_SPRING_PARAMS_EPSILON_PROPERTY:
		g_value_set_double (value, elastic_spring_params_get_epsilon (self));
		break;
		case ELASTIC_SPRING_PARAMS_VELOCITY_PROPERTY:
		g_value_set_double (value, elastic_spring_params_get_velocity (self));
		break;
		case ELASTIC_SPRING_PARAMS_IS_MODIFIED_PROPERTY:
		g_value_set_boolean (value, elastic_spring_params_get_is_modified (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_elastic_spring_params_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ElasticSpringParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams);
	switch (property_id) {
		case ELASTIC_SPRING_PARAMS_DAMPING_PROPERTY:
		elastic_spring_params_set_damping (self, g_value_get_double (value));
		break;
		case ELASTIC_SPRING_PARAMS_DAMPING_RATIO_PROPERTY:
		elastic_spring_params_set_damping_ratio (self, g_value_get_double (value));
		break;
		case ELASTIC_SPRING_PARAMS_MASS_PROPERTY:
		elastic_spring_params_set_mass (self, g_value_get_double (value));
		break;
		case ELASTIC_SPRING_PARAMS_STIFFNESS_PROPERTY:
		elastic_spring_params_set_stiffness (self, g_value_get_double (value));
		break;
		case ELASTIC_SPRING_PARAMS_EPSILON_PROPERTY:
		elastic_spring_params_set_epsilon (self, g_value_get_double (value));
		break;
		case ELASTIC_SPRING_PARAMS_VELOCITY_PROPERTY:
		elastic_spring_params_set_velocity (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

