/** generated file, do not edit! */
#ifndef DT_PREFERENCES_H
#define DT_PREFERENCES_H

#pragma GCC diagnostic ignored "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-variable"

#include <gtk/gtk.h>
#include "control/conf.h"
#include "common/calculator.h"
#include "gui/preferences.h"

#define NON_DEF_CHAR "●"

static gboolean handle_enter_key(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  guint keyval;

  gdk_event_get_keyval ((GdkEvent*)event, &keyval);

  if(keyval == GDK_KEY_Return || keyval == GDK_KEY_KP_Enter)
    return TRUE;
  return FALSE;
}

static void set_widget_label_default(GtkWidget *widget, const char *confstr, GtkWidget *label, const float factor)
{
  gboolean is_default = TRUE;

  if(GTK_IS_CHECK_BUTTON(widget))
  {
    const gboolean c_default = dt_confgen_get_bool(confstr, DT_DEFAULT);
    const gboolean c_state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
    is_default = (c_state == c_default);
  }
  else if(DT_IS_BAUHAUS_WIDGET(widget))
  {
    const int v_default = dt_bauhaus_combobox_get_default(widget);
    const int v_state = GPOINTER_TO_INT(dt_bauhaus_combobox_get_data(widget));
    is_default = (v_state == v_default);
  }
  else if(GTK_IS_SPIN_BUTTON(widget))
  {
    const gchar *c_default = dt_confgen_get(confstr, DT_DEFAULT);
    const float v_default = dt_calculator_solve(1, c_default) * factor;
    const float v_state = gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget));
    is_default = (v_state == v_default);
  }
  else if(GTK_IS_ENTRY(widget))
  {
    const gchar *c_default = dt_confgen_get(confstr, DT_DEFAULT);
    const gchar *c_state = gtk_entry_get_text(GTK_ENTRY(widget));
    is_default = (g_strcmp0(c_state, c_default) == 0);
  }
  else if(GTK_IS_FILE_CHOOSER(widget))
  {
    const gchar *c_default = dt_confgen_get(confstr, DT_DEFAULT);
    const gchar *c_state = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget));
    is_default = (g_strcmp0(c_state, c_default) == 0);
  }
  else
  {
    // other unsupported widgets
    return;
  }

  if(is_default)
  {
    // replace * with space
    gtk_label_set_text(GTK_LABEL(label), "");
    gtk_widget_set_tooltip_text(label, NULL);
  }
  else
  {
    // replace space with *
    gtk_label_set_text(GTK_LABEL(label), NON_DEF_CHAR);
    gtk_widget_set_tooltip_text(label, _("this setting has been modified"));
  }
}

gboolean restart_required = FALSE;
static gboolean
reset_widget_id1 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id2 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id3 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id4 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id5 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id6 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id7 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id8 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id9 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id10 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id11 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id12 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 5 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id13 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id14 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id15 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id16 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id17 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id18 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id19 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id20 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id21 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id22 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id23 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id24 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id25 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id26 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id27 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id28 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id29 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id30 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id31 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id32 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id33 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id34 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id35 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id36 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id37 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id38 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id39 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 1 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id40 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id41 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id42 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id43 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id44 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id45 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id46 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id47 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id48 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "120|400");
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id49 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget)), "$(FILE_NAME).$(FILE_EXTENSION)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b> $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON) $(SIDECAR_TXT)", strlen("$(FILE_NAME).$(FILE_EXTENSION)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b> $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON) $(SIDECAR_TXT)"));
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id50 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget)), "<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b>", strlen("<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b>"));
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id51 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id52 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id53 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id54 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget)), "$(EXIF.EXPOSURE) • f/$(EXIF.APERTURE) • $(EXIF.FOCAL.LENGTH) mm • ISO $(EXIF.ISO) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)", strlen("$(EXIF.EXPOSURE) • f/$(EXIF.APERTURE) • $(EXIF.FOCAL.LENGTH) mm • ISO $(EXIF.ISO) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)"));
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id55 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id56 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id57 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id58 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id59 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id60 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "$(PICTURES_FOLDER)/Darktable");
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id61 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "$(YEAR)$(MONTH)$(DAY)_$(JOBCODE)");
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id62 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id63 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "$(YEAR)$(MONTH)$(DAY)_$(SEQUENCE).$(FILE_EXTENSION)");
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id64 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id65 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id66 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id67 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 50 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id68 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 20 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id69 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id70 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id71 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id72 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id73 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id74 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id75 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id76 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id77 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id78 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id79 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id80 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 10 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id81 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id82 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id83 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {  
    float factor = 1.0f;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 250 * factor);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id84 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id85 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id86 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id87 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id88 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id89 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id90 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id91 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id92 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id93 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id94 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id95 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id96 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id97 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "aplay");
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id98 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gchar *path = dt_conf_expand_default_dir("$(home)");
    dt_conf_set_string("plugins/darkroom/lut3d/def_path", path);
    g_free(path);
    path = dt_conf_get_string("plugins/darkroom/lut3d/def_path");
    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(widget), path);
    g_free(path);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id99 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gchar *path = dt_conf_expand_default_dir("$(home)");
    dt_conf_set_string("plugins/darkroom/segments/def_path", path);
    g_free(path);
    path = dt_conf_get_string("plugins/darkroom/segments/def_path");
    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(widget), path);
    g_free(path);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id100 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id101 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id102 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id103 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id104 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    dt_bauhaus_widget_reset(widget);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id105 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id106 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), FALSE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id107 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    return TRUE;
  }
  return FALSE;
}

static gboolean
reset_widget_id108 (GtkWidget *label, GdkEventButton *event, GtkWidget *widget)
{
  if(event->type == GDK_2BUTTON_PRESS)
  {
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    return TRUE;
  }
  return FALSE;
}

static void
preferences_response_callback_id1 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("accel/prefer_focused", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id2 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("accel/prefer_expanded", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id3 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("accel/prefer_enabled", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id4 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("accel/prefer_unmasked", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id5 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("accel/select_order", s);
  g_free(s);
}

static void
preferences_response_callback_id6 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("accel/assign_instance", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id7 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("show_splash_screen", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id8 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("accel/load_defaults", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id9 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("bauhaus/zoom_step", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id10 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("database/create_snapshot", s);
  g_free(s);
}

static void
preferences_response_callback_id11 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("database/keep_snapshots", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id12 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("slideshow_delay", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id13 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("resourcelevel", s);
  g_free(s);
}

static void
preferences_response_callback_id14 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("write_sidecar_files", s);
  g_free(s);
}

static void
preferences_response_callback_id15 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("compress_xmp_tags", s);
  g_free(s);
}

static void
preferences_response_callback_id16 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("autosave_interval", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id17 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("omit_tag_hierarchy", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id18 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/tagging/no_uncategorized", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id19 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/lighttable/tagging/case_sensitivity", s);
  g_free(s);
}

static void
preferences_response_callback_id20 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("opencl", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id21 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("opencl_scheduling_profile", s);
  g_free(s);
}

static void
preferences_response_callback_id22 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("opencl_tune_headroom", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id23 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("clplatform_intelropenclhdgraphics", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id24 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("clplatform_nvidiacuda", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id25 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("clplatform_amdacceleratedparallelprocessing", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id26 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("clplatform_rusticl", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id27 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("clplatform_apple", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id28 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("clplatform_openclon12", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id29 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("clplatform_other", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id30 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("ask_before_remove", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id31 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("ask_before_delete", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id32 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("ask_before_discard", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id33 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("send_to_trash", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id34 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("ask_before_move", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id35 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("ask_before_copy", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id36 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("ask_before_rmdir", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id37 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("plugins/lighttable/recentcollect/max_items", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id38 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("plugins/lighttable/collect/history_max", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id39 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("show_folder_levels", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id40 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/collect/filmroll_sort", s);
  g_free(s);
}

static void
preferences_response_callback_id41 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/lighttable/thumbnail_raw_min_level", s);
  g_free(s);
}

static void
preferences_response_callback_id42 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/lighttable/thumbnail_hq_min_level", s);
  g_free(s);
}

static void
preferences_response_callback_id43 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("cache_disk_backend", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id44 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("cache_disk_backend_full", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id45 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("thumbtable_fractional_scrolling", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id46 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("backthumbs_mipsize", s);
  g_free(s);
}

static void
preferences_response_callback_id47 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("backthumbs_initialize", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id48 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_string("plugins/lighttable/thumbnail_sizes", gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
preferences_response_callback_id49 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  GtkTextIter start, end;
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  dt_conf_set_string("plugins/lighttable/extended_pattern", gtk_text_buffer_get_text(buffer, &start, &end, FALSE));
}

static void
preferences_response_callback_id50 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  GtkTextIter start, end;
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  dt_conf_set_string("plugins/lighttable/thumbnail_tooltip_pattern", gtk_text_buffer_get_text(buffer, &start, &end, FALSE));
}

static void
preferences_response_callback_id51 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("masks_scroll_down_increases", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id52 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/mouse/middle_button_cycle_zoom_to_200_percent", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id53 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("channel_display", s);
  g_free(s);
}

static void
preferences_response_callback_id54 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  GtkTextIter start, end;
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  dt_conf_set_string("plugins/darkroom/image_infos_pattern", gtk_text_buffer_get_text(buffer, &start, &end, FALSE));
}

static void
preferences_response_callback_id55 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/darkroom/image_infos_position", s);
  g_free(s);
}

static void
preferences_response_callback_id56 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("modules/default_presets_first", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id57 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/darkroom/hide_default_presets", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id58 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/darkroom/show_guides_in_ui", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id59 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/hide_default_presets", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id60 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_string("session/base_directory_pattern", gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
preferences_response_callback_id61 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_string("session/sub_directory_pattern", gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
preferences_response_callback_id62 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("session/use_filename", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id63 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_string("session/filename_pattern", gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
preferences_response_callback_id64 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/collect/single-click", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id65 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/act_on", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id66 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/tagging/ask_before_delete_tag", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id67 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("plugins/lighttable/tagging/confidence", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id68 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("plugins/lighttable/tagging/nb_recent_tags", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id69 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/style/ask_before_delete_style", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id70 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/preset/ask_before_delete_preset", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id71 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/export/ask_before_export_overwrite", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id72 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/metadata_view/pretty_location", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id73 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("lighttable/ui/single_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id74 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/single_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id75 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/single_module_group_only", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id76 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/activate_expand", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id77 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("lighttable/ui/scroll_to_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id78 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/scroll_to_module", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id79 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/sidebar_scroll_default", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id80 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("plugins/darkroom/ui/border_size", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id81 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/scrollbars", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id82 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("panel_scrollbars_always_visible", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id83 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

    float factor = 1.0f;
  dt_conf_set_int("darkroom/ui/transition_duration", gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)) / factor);
}

static void
preferences_response_callback_id84 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/lighttable/export/force_lcms2", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id85 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("rating_one_double_tap", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id86 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("lighttable/ui/scrollbars", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id87 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("lighttable/ui/milliseconds", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id88 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/loading_screen", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id89 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/lighttable/export/pixel_interpolator_warp", s);
  g_free(s);
}

static void
preferences_response_callback_id90 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/lighttable/export/pixel_interpolator", s);
  g_free(s);
}

static void
preferences_response_callback_id91 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/pwstorage/pwstorage_backend", s);
  g_free(s);
}

static void
preferences_response_callback_id92 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/imageio/storage/export/auto_login", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id93 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/darkroom/histogram/panel_position", s);
  g_free(s);
}

static void
preferences_response_callback_id94 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/darkroom/panel_swap", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id95 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("ui_last/display_profile_source", s);
  g_free(s);
}

static void
preferences_response_callback_id96 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("run_crawler_on_start", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id97 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_string("plugins/lighttable/audio_player", gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
preferences_response_callback_id98 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  gchar *folder = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget));
  dt_conf_set_string("plugins/darkroom/lut3d/def_path", folder);
  g_free(folder);
}

static void
preferences_response_callback_id99 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  gchar *folder = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(widget));
  dt_conf_set_string("plugins/darkroom/segments/def_path", folder);
  g_free(folder);
}

static void
preferences_response_callback_id100 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("plugins/darkroom/workflow", s);
  g_free(s);
}

static void
preferences_response_callback_id101 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/darkroom/basecurve/auto_apply_percamera_presets", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id102 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("ui/detect_mono_exif", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id103 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("plugins/darkroom/show_warnings", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id104 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  const gchar *index = dt_bauhaus_combobox_get_data(widget);
  gchar *s = g_strndup(index, strchr(index, ']') - index);
  dt_conf_set_string("darkroom/ui/hide_header_buttons", s);
  g_free(s);
}

static void
preferences_response_callback_id105 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/show_mask_indicator", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id106 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/rename_new_instance", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id107 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_bool("darkroom/ui/auto_module_name_update", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}

static void
preferences_response_callback_id108 (GtkDialog *dialog, gint response_id, GtkWidget *widget)
{
  const gint dkind = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(dialog), "local-dialog"));
  if(dkind)
  {
    if(response_id == GTK_RESPONSE_NONE) return;
    if(response_id == GTK_RESPONSE_DELETE_EVENT) return;
  }
  else
  {
    if(response_id != GTK_RESPONSE_DELETE_EVENT) return;
  }
  gtk_widget_set_can_focus(GTK_WIDGET(dialog), TRUE);
  gtk_widget_grab_focus(GTK_WIDGET(dialog));

  dt_conf_set_string("plugins/midi/devices", gtk_entry_get_text(GTK_ENTRY(widget)));
}

static void
preferences_changed_callback_id1 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_focused", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id2 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_expanded", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id3 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_enabled", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id4 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "accel/prefer_unmasked", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id5 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "accel/select_order", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id6 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "accel/assign_instance", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id7 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "show_splash_screen", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id8 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "accel/load_defaults", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id9 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "bauhaus/zoom_step", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id10 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "database/create_snapshot", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id11 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "database/keep_snapshots", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id12 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "slideshow_delay", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id13 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "resourcelevel", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id14 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "write_sidecar_files", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id15 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "compress_xmp_tags", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id16 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "autosave_interval", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id17 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "omit_tag_hierarchy", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id18 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/no_uncategorized", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id19 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/case_sensitivity", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id20 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "opencl", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id21 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "opencl_scheduling_profile", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id22 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "opencl_tune_headroom", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id23 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_intelropenclhdgraphics", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id24 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_nvidiacuda", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id25 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_amdacceleratedparallelprocessing", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id26 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_rusticl", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id27 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_apple", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id28 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_openclon12", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id29 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "clplatform_other", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id30 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_remove", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id31 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_delete", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id32 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_discard", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id33 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "send_to_trash", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id34 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_move", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id35 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_copy", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id36 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ask_before_rmdir", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id37 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/recentcollect/max_items", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id38 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/collect/history_max", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id39 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "show_folder_levels", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id40 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/collect/filmroll_sort", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id41 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_raw_min_level", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id42 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_hq_min_level", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id43 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "cache_disk_backend", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id44 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "cache_disk_backend_full", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id45 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "thumbtable_fractional_scrolling", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id46 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "backthumbs_mipsize", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id47 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "backthumbs_initialize", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id48 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_sizes", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id49 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/extended_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id50 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/thumbnail_tooltip_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id51 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "masks_scroll_down_increases", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id52 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/mouse/middle_button_cycle_zoom_to_200_percent", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id53 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "channel_display", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id54 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/image_infos_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id55 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/image_infos_position", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id56 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "modules/default_presets_first", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id57 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/hide_default_presets", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id58 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/show_guides_in_ui", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id59 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/hide_default_presets", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id60 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "session/base_directory_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id61 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "session/sub_directory_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id62 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "session/use_filename", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id63 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "session/filename_pattern", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id64 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/collect/single-click", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id65 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/act_on", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id66 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/ask_before_delete_tag", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id67 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/confidence", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id68 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/tagging/nb_recent_tags", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id69 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/style/ask_before_delete_style", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id70 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/preset/ask_before_delete_preset", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id71 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/ask_before_export_overwrite", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id72 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/metadata_view/pretty_location", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id73 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/single_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id74 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/single_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id75 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/single_module_group_only", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id76 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/activate_expand", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id77 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/scroll_to_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id78 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/scroll_to_module", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id79 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/sidebar_scroll_default", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id80 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/ui/border_size", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id81 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/scrollbars", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id82 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "panel_scrollbars_always_visible", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id83 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/transition_duration", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id84 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/force_lcms2", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id85 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "rating_one_double_tap", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id86 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/scrollbars", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id87 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "lighttable/ui/milliseconds", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id88 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/loading_screen", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id89 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/pixel_interpolator_warp", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id90 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/export/pixel_interpolator", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id91 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/pwstorage/pwstorage_backend", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id92 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/imageio/storage/export/auto_login", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id93 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/histogram/panel_position", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id94 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/panel_swap", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id95 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ui_last/display_profile_source", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id96 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "run_crawler_on_start", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id97 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/lighttable/audio_player", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id98 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/lut3d/def_path", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id99 (GtkWidget *widget, gpointer user_data)
{
  restart_required = TRUE;

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/segments/def_path", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id100 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/workflow", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id101 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/basecurve/auto_apply_percamera_presets", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id102 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "ui/detect_mono_exif", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id103 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/darkroom/show_warnings", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id104 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/hide_header_buttons", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id105 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/show_mask_indicator", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id106 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/rename_new_instance", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id107 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "darkroom/ui/auto_module_name_update", GTK_WIDGET(user_data), factor);
}

static void
preferences_changed_callback_id108 (GtkWidget *widget, gpointer user_data)
{

    float factor = 1.0f;
  set_widget_label_default(widget, "plugins/midi/devices", GTK_WIDGET(user_data), factor);
}


static void init_tab_generated(GtkWidget *dialog, GtkWidget *stack)
{
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  {
    GtkWidget *widget, *label, *labelev, *viewport, *box;
    GtkWidget *grid = gtk_grid_new();
    gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
    gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
    gtk_widget_set_valign(grid, GTK_ALIGN_START);
    int line = 0;
    char tooltip[1024];
    GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    viewport = gtk_viewport_new(NULL, NULL);
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE); // doesn't seem to work from gtkrc
    GtkWidget *help = gtk_button_new_with_label(_("?"));
    gtk_widget_set_halign(help, GTK_ALIGN_END);
    g_object_set_data_full(G_OBJECT(help), "dt-help-url",
                          g_strdup("preferences-settings/import/"), g_free);
    g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
    gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), viewport);
    gtk_container_add(GTK_CONTAINER(viewport), grid);
    gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
    gtk_stack_add_titled(GTK_STACK(stack), tab_box,
                         _("import"), _("import"));
    {
      GtkWidget *seclabel = gtk_label_new(_("session options"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("session/base_directory_pattern");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("base filmroll's directory"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("session/base_directory_pattern");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id60), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id60), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(PICTURES_FOLDER)/Darktable");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("directory where new imported filmrolls are created"));
    gtk_widget_set_name(widget, "session/base_directory_pattern");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id60), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("session/sub_directory_pattern");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("filmroll name"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("session/sub_directory_pattern");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id61), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id61), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(YEAR)$(MONTH)$(DAY)_$(JOBCODE)");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("name of the imported filmroll"));
    gtk_widget_set_name(widget, "session/sub_directory_pattern");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id61), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("session/use_filename");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("keep original filename"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("session/use_filename"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id62), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id62), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("keep original filename instead of a pattern while importing from camera or card"));
    gtk_widget_set_name(widget, "session/use_filename");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id62), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("session/filename_pattern");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("file naming pattern"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("session/filename_pattern");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id63), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id63), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(YEAR)$(MONTH)$(DAY)_$(SEQUENCE).$(FILE_EXTENSION)");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("file naming pattern used for a import session"));
    gtk_widget_set_name(widget, "session/filename_pattern");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id63), (gpointer)widget);
  }
  }
  {
    GtkWidget *widget, *label, *labelev, *viewport, *box;
    GtkWidget *grid = gtk_grid_new();
    gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
    gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
    gtk_widget_set_valign(grid, GTK_ALIGN_START);
    int line = 0;
    char tooltip[1024];
    GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    viewport = gtk_viewport_new(NULL, NULL);
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE); // doesn't seem to work from gtkrc
    GtkWidget *help = gtk_button_new_with_label(_("?"));
    gtk_widget_set_halign(help, GTK_ALIGN_END);
    g_object_set_data_full(G_OBJECT(help), "dt-help-url",
                          g_strdup("preferences-settings/lighttable/"), g_free);
    g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
    gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), viewport);
    gtk_container_add(GTK_CONTAINER(viewport), grid);
    gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
    gtk_stack_add_titled(GTK_STACK(stack), tab_box,
                         _("lighttable"), _("lighttable"));
    {
      GtkWidget *seclabel = gtk_label_new(_("general"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/hide_default_presets");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("hide built-in presets for utility modules"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/hide_default_presets"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id59), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id59), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("hide built-in presets of utility modules in presets menu."));
    gtk_widget_set_name(widget, "plugins/lighttable/hide_default_presets");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id59), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/collect/single-click");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("use single-click in the collections module"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/collect/single-click"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id64), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id64), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("check this option to use single-click to select items in the collections module. this will allow you to do range selections for date-time and numeric values."));
    gtk_widget_set_name(widget, "plugins/lighttable/collect/single-click");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id64), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/act_on");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("prioritize the hovered image over the selected images"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/act_on"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id65), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id65), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this defines how the list of images to act on is constructed."));
    gtk_widget_set_name(widget, "plugins/lighttable/act_on");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id65), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("lighttable/ui/single_module");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("expand a single utility module at a time"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/single_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id73), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id73), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this option toggles the behavior of shift clicking in lighttable mode"));
    gtk_widget_set_name(widget, "lighttable/ui/single_module");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id73), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("lighttable/ui/scroll_to_module");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("scroll utility modules to the top when expanded"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/scroll_to_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id77), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id77), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("when this option is enabled then darktable will try to scroll the module to the top of the visible list"));
    gtk_widget_set_name(widget, "lighttable/ui/scroll_to_module");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id77), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("rating_one_double_tap");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("rating an image one star twice will not zero out the rating"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("rating_one_double_tap"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id85), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id85), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("defines whether rating an image one star twice will zero out star rating"));
    gtk_widget_set_name(widget, "rating_one_double_tap");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id85), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("lighttable/ui/scrollbars");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show scrollbars for central view"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/scrollbars"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id86), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id86), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("defines whether scrollbars should be displayed"));
    gtk_widget_set_name(widget, "lighttable/ui/scrollbars");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id86), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("lighttable/ui/milliseconds");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show image time with milliseconds"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("lighttable/ui/milliseconds"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id87), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id87), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("defines whether time should be displayed with milliseconds"));
    gtk_widget_set_name(widget, "lighttable/ui/milliseconds");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id87), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("thumbnails"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/thumbnail_raw_min_level");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("use raw file instead of embedded JPEG from size"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/thumbnail_raw_min_level");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id41), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id41), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "never"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if the thumbnail size is greater than this value, it will be processed using raw file instead of the embedded preview JPEG (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)"));
    gtk_widget_set_name(widget, "plugins/lighttable/thumbnail_raw_min_level");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id41), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/thumbnail_hq_min_level");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("high quality processing from size"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/thumbnail_hq_min_level");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id42), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id42), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "720p"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if the thumbnail size is greater than this value, it will be processed using the full quality rendering path (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)"));
    gtk_widget_set_name(widget, "plugins/lighttable/thumbnail_hq_min_level");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id42), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("cache_disk_backend");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("enable disk backend for thumbnail cache"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("cache_disk_backend"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id43), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id43), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if enabled, write thumbnails to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached thumbnails again.\nit's safe though to delete these manually, if you want.\nlight table performance will be increased greatly when browsing a lot.\nto generate all thumbnails of your entire collection offline, run 'darktable-generate-cache'."));
    gtk_widget_set_name(widget, "cache_disk_backend");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id43), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("cache_disk_backend_full");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("enable disk backend for full preview cache"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("cache_disk_backend_full"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id44), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id44), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if enabled, write full preview to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached full previews again.\nit's safe though to delete these manually, if you want.\nlight table performance will be increased greatly when zooming image in full preview mode."));
    gtk_widget_set_name(widget, "cache_disk_backend_full");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id44), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("thumbtable_fractional_scrolling");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("enable smooth scrolling for lighttable thumbnails"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("thumbtable_fractional_scrolling"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id45), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id45), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if enabled, scrolling the lighttable scrolls by some number of pixels, as expected with a touch pad.\ndisabled, the lighttable scrolls full rows of thumbnails, as befits a scroll wheel."));
    gtk_widget_set_name(widget, "thumbtable_fractional_scrolling");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id45), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("backthumbs_mipsize");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("generate thumbnails in background"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "backthumbs_mipsize");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id46), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id46), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "never"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if 'enable disk backend for thumbnail cache' is enabled thumbnails/mipmaps up to the selected size are generated while user is inactive in lighttable."));
    gtk_widget_set_name(widget, "backthumbs_mipsize");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id46), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("backthumbs_initialize");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("reset cached thumbnails"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("backthumbs_initialize"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id47), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id47), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("force thumbnails to be regenerated by resetting the database. this may be needed in case some thumbnails have been manually removed or corrupted."));
    gtk_widget_set_name(widget, "backthumbs_initialize");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id47), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/thumbnail_sizes");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("delimiters for size categories"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/thumbnail_sizes");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id48), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id48), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "120|400");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("size categories are used to be able to set different overlays and CSS values depending of the size of the thumbnail, separated by |.\nfor example, 120|400 means 3 categories of thumbnails: <120px, 120-400px, >400px"));
    gtk_widget_set_name(widget, "plugins/lighttable/thumbnail_sizes");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id48), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/extended_pattern");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("pattern for the thumbnail extended overlay text"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    GtkTextBuffer *buffer = gtk_text_buffer_new(NULL);
    widget = gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(widget), GTK_WRAP_WORD);
    gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(widget), FALSE);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/extended_pattern");
    gtk_text_buffer_set_text(buffer, setting, strlen(setting));
    g_free(setting);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id49), widget);
    g_signal_connect(G_OBJECT(widget), "key-press-event", G_CALLBACK(handle_enter_key), NULL);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(FILE_NAME).$(FILE_EXTENSION)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b> $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON) $(SIDECAR_TXT)");
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("see manual to know all the tags you can use."));
    gtk_widget_set_name(widget, "plugins/lighttable/extended_pattern");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id49), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/thumbnail_tooltip_pattern");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("pattern for the thumbnail tooltip (empty to disable)"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    GtkTextBuffer *buffer = gtk_text_buffer_new(NULL);
    widget = gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(widget), GTK_WRAP_WORD);
    gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(widget), FALSE);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/thumbnail_tooltip_pattern");
    gtk_text_buffer_set_text(buffer, setting, strlen(setting));
    g_free(setting);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id50), widget);
    g_signal_connect(G_OBJECT(widget), "key-press-event", G_CALLBACK(handle_enter_key), NULL);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b>");
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("see manual to know all the tags you can use."));
    gtk_widget_set_name(widget, "plugins/lighttable/thumbnail_tooltip_pattern");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id50), (gpointer)widget);
  }
  }
  {
    GtkWidget *widget, *label, *labelev, *viewport, *box;
    GtkWidget *grid = gtk_grid_new();
    gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
    gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
    gtk_widget_set_valign(grid, GTK_ALIGN_START);
    int line = 0;
    char tooltip[1024];
    GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    viewport = gtk_viewport_new(NULL, NULL);
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE); // doesn't seem to work from gtkrc
    GtkWidget *help = gtk_button_new_with_label(_("?"));
    gtk_widget_set_halign(help, GTK_ALIGN_END);
    g_object_set_data_full(G_OBJECT(help), "dt-help-url",
                          g_strdup("preferences-settings/darkroom/"), g_free);
    g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
    gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), viewport);
    gtk_container_add(GTK_CONTAINER(viewport), grid);
    gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
    gtk_stack_add_titled(GTK_STACK(stack), tab_box,
                         _("darkroom"), _("darkroom"));
    {
      GtkWidget *seclabel = gtk_label_new(_("general"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("masks_scroll_down_increases");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("scroll down to increase mask parameters"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("masks_scroll_down_increases"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id51), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id51), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("when using the mouse scroll wheel to change mask parameters, scroll down to increase the mask size, feather size, opacity, brush hardness and gradient curvature\nby default scrolling up increases these parameters"));
    gtk_widget_set_name(widget, "masks_scroll_down_increases");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id51), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/mouse/middle_button_cycle_zoom_to_200_percent");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("middle mouse button zooms to 200%"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/mouse/middle_button_cycle_zoom_to_200_percent"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id52), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id52), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    /* xgettext:no-c-format */
    gtk_widget_set_tooltip_text(widget, _("if enabled, the zoom level will cycle between 100%, 200% and fit to viewport on middle mouse clicks. if disabled, it will toggle between viewport size and 100%, and the 'ctrl' key can be used to control the zoom level."));
    gtk_widget_set_name(widget, "darkroom/mouse/middle_button_cycle_zoom_to_200_percent");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id52), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/image_infos_pattern");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("pattern for the image information line"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    GtkTextBuffer *buffer = gtk_text_buffer_new(NULL);
    widget = gtk_text_view_new_with_buffer(buffer);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(widget), GTK_WRAP_WORD);
    gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(widget), FALSE);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/darkroom/image_infos_pattern");
    gtk_text_buffer_set_text(buffer, setting, strlen(setting));
    g_free(setting);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id54), widget);
    g_signal_connect(G_OBJECT(widget), "key-press-event", G_CALLBACK(handle_enter_key), NULL);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "$(EXIF.EXPOSURE) • f/$(EXIF.APERTURE) • $(EXIF.FOCAL.LENGTH) mm • ISO $(EXIF.ISO) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)");
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("see manual for a list of the tags you can use."));
    gtk_widget_set_name(widget, "plugins/darkroom/image_infos_pattern");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id54), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/image_infos_position");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("position of the image information line"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/darkroom/image_infos_position");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id55), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id55), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "bottom"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_name(widget, "plugins/darkroom/image_infos_position");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id55), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/ui/border_size");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("border around image in darkroom mode"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/darkroom/ui/border_size") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id80), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id80), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("process the image in darkroom mode with a small border. set to 0 if you don't want any border."));
    gtk_widget_set_name(widget, "plugins/darkroom/ui/border_size");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id80), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/scrollbars");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show scrollbars for central view"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/scrollbars"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id81), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id81), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("defines whether scrollbars should be displayed"));
    gtk_widget_set_name(widget, "darkroom/ui/scrollbars");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id81), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/loading_screen");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show loading screen between images"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/loading_screen"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id88), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id88), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("show gray loading screen when navigating between images in the darkroom\ndisable to just show a toast message"));
    gtk_widget_set_name(widget, "darkroom/ui/loading_screen");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id88), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("modules"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("channel_display");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("display of individual color channels"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "channel_display");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id53), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id53), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "false color"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("defines how color channels are displayed when activated in the parametric masks feature."));
    gtk_widget_set_name(widget, "channel_display");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id53), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/hide_default_presets");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("hide built-in presets for processing modules"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/hide_default_presets"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id57), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id57), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("hide built-in presets of processing modules in presets menu."));
    gtk_widget_set_name(widget, "plugins/darkroom/hide_default_presets");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id57), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/show_guides_in_ui");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show the guides widget in modules UI"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/show_guides_in_ui"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id58), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id58), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("show the guides widget in modules UI"));
    gtk_widget_set_name(widget, "plugins/darkroom/show_guides_in_ui");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id58), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/single_module");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("expand a single processing module at a time"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/single_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id74), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id74), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this option toggles the behavior of shift clicking in darkroom mode"));
    gtk_widget_set_name(widget, "darkroom/ui/single_module");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id74), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/single_module_group_only");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("only collapse modules in current group"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/single_module_group_only"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id75), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id75), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if only expanding a single module at a time, only collapse other modules in the current group - ignore modules in other groups"));
    gtk_widget_set_name(widget, "darkroom/ui/single_module_group_only");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id75), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/activate_expand");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("expand the module when it is activated, and collapse it when disabled"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/activate_expand"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id76), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id76), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this option allows to expand or collapse automatically the module when it is enabled or disabled."));
    gtk_widget_set_name(widget, "darkroom/ui/activate_expand");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id76), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/scroll_to_module");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("scroll processing modules to the top when expanded"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/scroll_to_module"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id78), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id78), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("when this option is enabled then darktable will try to scroll the module to the top of the visible list"));
    gtk_widget_set_name(widget, "darkroom/ui/scroll_to_module");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id78), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/panel_swap");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("swap the utility and processing modules panels"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/panel_swap"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id94), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id94), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("move the list of processing modules to the left of the screen"));
    gtk_widget_set_name(widget, "plugins/darkroom/panel_swap");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id94), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/hide_header_buttons");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show right-side buttons in processing module headers"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "darkroom/ui/hide_header_buttons");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id104), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id104), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "always"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("when the mouse is not over a module, the multi-instance, reset and preset buttons can be hidden:\n - 'always': always show all buttons,\n - 'active': only show the buttons when the mouse is over the module,\n - 'dim': buttons are dimmed when mouse is away,\n - 'auto': hide the buttons when the panel is narrow,\n - 'fade': fade out all buttons when panel narrows,\n - 'fit': hide all the buttons if the module name doesn't fit,\n - 'smooth': fade out all buttons in one header simultaneously,\n - 'glide': gradually hide individual buttons as needed"));
    gtk_widget_set_name(widget, "darkroom/ui/hide_header_buttons");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id104), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/show_mask_indicator");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show mask indicator in module headers"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/show_mask_indicator"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id105), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id105), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if enabled, an icon will be shown in the header of any processing modules that have a mask applied"));
    gtk_widget_set_name(widget, "darkroom/ui/show_mask_indicator");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id105), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/rename_new_instance");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("prompt for name on addition of new instance"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/rename_new_instance"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id106), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id106), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if enabled, a rename prompt will be present for each new module instance (either new instance or duplicate)"));
    gtk_widget_set_name(widget, "darkroom/ui/rename_new_instance");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id106), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/auto_module_name_update");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("automatically update module name"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/auto_module_name_update"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id107), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id107), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if enabled, the module name will be automatically updated to match a preset name or a preset instance name if present."));
    gtk_widget_set_name(widget, "darkroom/ui/auto_module_name_update");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id107), (gpointer)widget);
  }
  }
  {
    GtkWidget *widget, *label, *labelev, *viewport, *box;
    GtkWidget *grid = gtk_grid_new();
    gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
    gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
    gtk_widget_set_valign(grid, GTK_ALIGN_START);
    int line = 0;
    char tooltip[1024];
    GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    viewport = gtk_viewport_new(NULL, NULL);
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE); // doesn't seem to work from gtkrc
    GtkWidget *help = gtk_button_new_with_label(_("?"));
    gtk_widget_set_halign(help, GTK_ALIGN_END);
    g_object_set_data_full(G_OBJECT(help), "dt-help-url",
                          g_strdup("preferences-settings/processing/"), g_free);
    g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
    gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), viewport);
    gtk_container_add(GTK_CONTAINER(viewport), grid);
    gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
    gtk_stack_add_titled(GTK_STACK(stack), tab_box,
                         _("processing"), _("processing"));
    {
      GtkWidget *seclabel = gtk_label_new(_("image processing"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/export/force_lcms2");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("always use LittleCMS 2 to apply output color profile"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/export/force_lcms2"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id84), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id84), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this is slower than the default."));
    gtk_widget_set_name(widget, "plugins/lighttable/export/force_lcms2");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id84), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/export/pixel_interpolator_warp");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("pixel interpolator (warp)"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/export/pixel_interpolator_warp");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id89), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id89), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "bicubic"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("pixel interpolator used in modules for rotation, lens correction, liquify, cropping and final scaling (bilinear, bicubic, lanczos2)."));
    gtk_widget_set_name(widget, "plugins/lighttable/export/pixel_interpolator_warp");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id89), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/export/pixel_interpolator");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("pixel interpolator (scaling)"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/export/pixel_interpolator");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id90), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id90), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "lanczos3"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("pixel interpolator used for scaling (bilinear, bicubic, lanczos2, lanczos3)."));
    gtk_widget_set_name(widget, "plugins/lighttable/export/pixel_interpolator");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id90), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/lut3d/def_path");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("LUT 3D root folder"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_file_chooser_button_new(_("select directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
    gtk_file_chooser_button_set_width_chars(GTK_FILE_CHOOSER_BUTTON(widget), 20);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/darkroom/lut3d/def_path");
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(widget), setting);
    g_free(setting);
    g_signal_connect(G_OBJECT(widget), "selection-changed", G_CALLBACK(preferences_changed_callback_id98), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id98), widget);
    gchar *default_path = dt_conf_expand_default_dir("$(home)");
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), default_path);
    g_free(default_path);
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this folder (and sub-folders) contains LUT files used by LUT 3D module. (restart required)"));
    gtk_widget_set_name(widget, "plugins/darkroom/lut3d/def_path");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id98), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/segments/def_path");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("raster mask files root folder"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_file_chooser_button_new(_("select directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
    gtk_file_chooser_button_set_width_chars(GTK_FILE_CHOOSER_BUTTON(widget), 20);
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/darkroom/segments/def_path");
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(widget), setting);
    g_free(setting);
    g_signal_connect(G_OBJECT(widget), "selection-changed", G_CALLBACK(preferences_changed_callback_id99), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id99), widget);
    gchar *default_path = dt_conf_expand_default_dir("$(home)");
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), default_path);
    g_free(default_path);
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this folder (and sub-folders) contains PFM files used by the raster mask import module. (restart required)"));
    gtk_widget_set_name(widget, "plugins/darkroom/segments/def_path");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id99), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/workflow");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("auto-apply pixel workflow defaults"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/darkroom/workflow");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id100), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id100), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "scene-referred (sigmoid)"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("scene-referred workflow is based on linear modules and will auto-apply filmic or sigmoid, color calibration and exposure,\ndisplay-referred workflow is based on Lab modules and will auto-apply base curve, white balance and the legacy module pipe order."));
    gtk_widget_set_name(widget, "plugins/darkroom/workflow");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id100), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/basecurve/auto_apply_percamera_presets");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("auto-apply per camera basecurve presets"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/basecurve/auto_apply_percamera_presets"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id101), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id101), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("use the per-camera basecurve by default instead of the generic manufacturer one if there is one available. (restart required)\nthis option is taken into account when the \"auto-apply pixel workflow defaults\" is set to \"display-referred\".\nto prevent auto-apply basecurve presets \"auto-apply pixel workflow defaults\" should be set to \"none\""));
    gtk_widget_set_name(widget, "plugins/darkroom/basecurve/auto_apply_percamera_presets");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id101), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("ui/detect_mono_exif");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("detect monochrome previews"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ui/detect_mono_exif"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id102), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id102), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("many monochrome images can be identified via EXIF and preview data. beware: this slows down imports and reading of EXIF data"));
    gtk_widget_set_name(widget, "ui/detect_mono_exif");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id102), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/show_warnings");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show warning messages"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/darkroom/show_warnings"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id103), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id103), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("display messages in modules to warn beginner users when non-standard and possibly harmful settings are used in the pipeline.\nthese messages can be false-positive and should be disregarded if you know what you are doing. this option will hide them all the time."));
    gtk_widget_set_name(widget, "plugins/darkroom/show_warnings");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id103), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("CPU / memory"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("resourcelevel");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("darktable resources"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "resourcelevel");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id13), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id13), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "default"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    /* xgettext:no-c-format */
    gtk_widget_set_tooltip_text(widget, _("defines how much darktable may take from your system resources:\n - 'default': darktable takes ~50% of your systems resources, which is enough to be performant.\n - 'small': should be used if you are simultaneously running applications taking large parts of your systems memory or OpenCL/GL applications like games or Hugin.\n - 'large': is the best option if you are not running other applications at the same time as darktable and want it to take most of your systems resources for performance."));
    gtk_widget_set_name(widget, "resourcelevel");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id13), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("OpenCL GPU acceleration"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("opencl");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("activate OpenCL support"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("opencl"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id20), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id20), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if found, use OpenCL runtime on your system to speed up processing by using your graphics card(s).\ncan be switched on and off at any time."));
    if(!dt_capabilities_check("opencl"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "opencl");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id20), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("opencl_scheduling_profile");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("OpenCL scheduling profile"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "opencl_scheduling_profile");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id21), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id21), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "default"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("defines how preview and full pixelpipe tasks are scheduled on OpenCL enabled systems:\n - 'default': GPU processes full and CPU processes preview pipe (adaptable by config parameters),\n - 'multiple GPUs': process both pixelpipes in parallel on two different GPUs,\n - 'very fast GPU': process both pixelpipes sequentially on the GPU."));
    if(!dt_capabilities_check("opencl"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "opencl_scheduling_profile");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id21), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("opencl_tune_headroom");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("tuned GPU memory"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("opencl_tune_headroom"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id22), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id22), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if enabled on a system with multiple OpenCL devices you may specify a safety margin per device (headroom, default is 600MB)"));
    if(!dt_capabilities_check("multiopencl"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "opencl_tune_headroom");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id22), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("OpenCL drivers"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("clplatform_intelropenclhdgraphics");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("Intel GPU"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_intelropenclhdgraphics"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id23), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id23), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("Intel(R) OpenCL Graphics for all supported platforms (vendor provided)"));
    if(!dt_capabilities_check("nonapple"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "clplatform_intelropenclhdgraphics");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id23), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("clplatform_nvidiacuda");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("Nvidia CUDA"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_nvidiacuda"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id24), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id24), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("Nvidia CUDA based OpenCL (vendor provided)"));
    if(!dt_capabilities_check("nonapple"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "clplatform_nvidiacuda");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id24), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("clplatform_amdacceleratedparallelprocessing");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("AMD ROCm"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_amdacceleratedparallelprocessing"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id25), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id25), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("AMD Accelerated Parallel Processing (vendor provided)"));
    if(!dt_capabilities_check("nonapple"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "clplatform_amdacceleratedparallelprocessing");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id25), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("clplatform_rusticl");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("RustiCL (experimental)"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_rusticl"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id26), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id26), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("RustiCL Mesa OpenCL, still unstable. if you want to use this, you should disable the vendor driver"));
    if(!dt_capabilities_check("nonapple"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "clplatform_rusticl");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id26), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("clplatform_apple");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("Apple"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_apple"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id27), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id27), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("Apple OpenCL (vendor provided)"));
    if(!dt_capabilities_check("apple"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "clplatform_apple");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id27), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("clplatform_openclon12");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("Microsoft OpenCLOn12"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_openclon12"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id28), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id28), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("Microsoft OpenCLOn12, only use this if the vendor provided driver does not work or there is none provided."));
    if(!dt_capabilities_check("windows"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "clplatform_openclon12");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id28), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("clplatform_other");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("other platforms"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("clplatform_other"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id29), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id29), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if set, all unspecified platforms are accepted. only do this if no vendor driver is available"));
    gtk_widget_set_name(widget, "clplatform_other");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id29), (gpointer)widget);
  }
  }
  {
    GtkWidget *widget, *label, *labelev, *viewport, *box;
    GtkWidget *grid = gtk_grid_new();
    gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
    gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
    gtk_widget_set_valign(grid, GTK_ALIGN_START);
    int line = 0;
    char tooltip[1024];
    GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    viewport = gtk_viewport_new(NULL, NULL);
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE); // doesn't seem to work from gtkrc
    GtkWidget *help = gtk_button_new_with_label(_("?"));
    gtk_widget_set_halign(help, GTK_ALIGN_END);
    g_object_set_data_full(G_OBJECT(help), "dt-help-url",
                          g_strdup("preferences-settings/security/"), g_free);
    g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
    gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), viewport);
    gtk_container_add(GTK_CONTAINER(viewport), grid);
    gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
    gtk_stack_add_titled(GTK_STACK(stack), tab_box,
                         _("security"), _("security"));
    {
      GtkWidget *seclabel = gtk_label_new(_("general"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("ask_before_remove");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before removing images from the library"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_remove"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id30), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id30), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before removing image information from the library"));
    gtk_widget_set_name(widget, "ask_before_remove");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id30), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("ask_before_delete");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before deleting images from disk"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_delete"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id31), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id31), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before any image file is deleted"));
    gtk_widget_set_name(widget, "ask_before_delete");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id31), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("ask_before_discard");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before discarding history stack"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_discard"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id32), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id32), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before history stack is discarded on any image"));
    gtk_widget_set_name(widget, "ask_before_discard");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id32), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("send_to_trash");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("try to use trash when deleting images"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("send_to_trash"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id33), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id33), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("send files to trash instead of permanently deleting files on system that supports it"));
    gtk_widget_set_name(widget, "send_to_trash");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id33), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("ask_before_move");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before moving images from film roll folder"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_move"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id34), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id34), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before any image file is moved."));
    gtk_widget_set_name(widget, "ask_before_move");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id34), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("ask_before_copy");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before copying images to new film roll folder"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_copy"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id35), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id35), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before any image file is copied."));
    gtk_widget_set_name(widget, "ask_before_copy");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id35), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("ask_before_rmdir");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before removing empty folders"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("ask_before_rmdir"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id36), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id36), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("always ask the user before removing any empty folder. this can happen after moving or deleting images."));
    gtk_widget_set_name(widget, "ask_before_rmdir");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id36), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/tagging/ask_before_delete_tag");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before deleting a tag"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/tagging/ask_before_delete_tag"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id66), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id66), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_name(widget, "plugins/lighttable/tagging/ask_before_delete_tag");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id66), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/style/ask_before_delete_style");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before deleting a style"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/style/ask_before_delete_style"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id69), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id69), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_name(widget, "plugins/lighttable/style/ask_before_delete_style");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id69), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/preset/ask_before_delete_preset");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before deleting a preset"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/preset/ask_before_delete_preset"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id70), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id70), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("will ask for confirmation before deleting or overwriting a preset"));
    gtk_widget_set_name(widget, "plugins/lighttable/preset/ask_before_delete_preset");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id70), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/export/ask_before_export_overwrite");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("ask before exporting in overwrite mode"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/export/ask_before_export_overwrite"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id71), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id71), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("will ask for confirmation before exporting files in overwrite mode"));
    gtk_widget_set_name(widget, "plugins/lighttable/export/ask_before_export_overwrite");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id71), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("other"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("plugins/pwstorage/pwstorage_backend");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("password storage backend to use"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/pwstorage/pwstorage_backend");
    if(!dt_capabilities_check("windows_credentials"))
      dt_bauhaus_combobox_remove_at(widget, 5);
    if(!dt_capabilities_check("apple_keychain"))
      dt_bauhaus_combobox_remove_at(widget, 4);
    if(!dt_capabilities_check("kwallet"))
      dt_bauhaus_combobox_remove_at(widget, 3);
    if(!dt_capabilities_check("libsecret"))
      dt_bauhaus_combobox_remove_at(widget, 2);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id91), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id91), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "auto"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("the storage backend for password storage: auto, none, libsecret, kwallet, apple_keychain, windows_credentials"));
    gtk_widget_set_name(widget, "plugins/pwstorage/pwstorage_backend");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id91), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/imageio/storage/export/auto_login");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("auto login to storage server"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/imageio/storage/export/auto_login"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id92), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id92), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("automatically login to the configured storage server. this requires that a password storage backend is set."));
    gtk_widget_set_name(widget, "plugins/imageio/storage/export/auto_login");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id92), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/audio_player");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("executable for playing audio files"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/lighttable/audio_player");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id97), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id97), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "aplay");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this external program is used to play audio files some cameras record to keep notes for images"));
    gtk_widget_set_name(widget, "plugins/lighttable/audio_player");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id97), (gpointer)widget);
  }
  }
  {
    GtkWidget *widget, *label, *labelev, *viewport, *box;
    GtkWidget *grid = gtk_grid_new();
    gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
    gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
    gtk_widget_set_valign(grid, GTK_ALIGN_START);
    int line = 0;
    char tooltip[1024];
    GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    viewport = gtk_viewport_new(NULL, NULL);
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE); // doesn't seem to work from gtkrc
    GtkWidget *help = gtk_button_new_with_label(_("?"));
    gtk_widget_set_halign(help, GTK_ALIGN_END);
    g_object_set_data_full(G_OBJECT(help), "dt-help-url",
                          g_strdup("preferences-settings/storage/"), g_free);
    g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
    gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), viewport);
    gtk_container_add(GTK_CONTAINER(viewport), grid);
    gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
    gtk_stack_add_titled(GTK_STACK(stack), tab_box,
                         _("storage"), _("storage"));
    {
      GtkWidget *seclabel = gtk_label_new(_("database"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("database/create_snapshot");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("create database snapshot"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "database/create_snapshot");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id10), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id10), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "once a week"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("database snapshots are created right before closing darktable. options allow you to choose how often to make snapshots:\n - 'never': simply don't do snapshots. that way the only snapshots done are mandatory version-upgrade snapshots\n - 'once a month': create snapshot if a month has passed since last snapshot\n - 'once a week': create snapshot if 7 days had passed since last snapshot\n - 'once a day': create snapshot if over 24h passed since last snapshot\n - 'on close': create snapshot every time darktable is closed"));
    gtk_widget_set_name(widget, "database/create_snapshot");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id10), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("database/keep_snapshots");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("how many snapshots to keep"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("database/keep_snapshots") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id11), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id11), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("after successfully creating snapshot, how many older snapshots to keep (excluding mandatory version update ones). enter -1 to keep all snapshots\nkeep in mind that snapshots do take some space and you only need the most recent one for successful restore"));
    gtk_widget_set_name(widget, "database/keep_snapshots");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id11), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("XMP sidecar files"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("write_sidecar_files");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("create XMP files"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "write_sidecar_files");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id14), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id14), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "on import"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("XMP sidecar files hold information about all your development steps to allow flawless re-importing of image files.\n\ndepending on the selected mode sidecar files will be created:\n - 'never': all development information will be stored only in the library database\n - 'on import': immediately after importing the image\n - 'after edit': after any user change on the image or adding tags."));
    gtk_widget_set_name(widget, "write_sidecar_files");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id14), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("compress_xmp_tags");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("store XMP tags in compressed format"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "compress_xmp_tags");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id15), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id15), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "only large entries"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("entries in XMP tags can get rather large and may exceed the available space to store the history stack in output files.\nthis option allows XMP tags to be compressed and save space."));
    gtk_widget_set_name(widget, "compress_xmp_tags");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id15), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("autosave_interval");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("auto-save interval"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("autosave_interval") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id16), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id16), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("automatically save history while developing using the given interval (in seconds); set to zero to disable auto-saving. auto-saving might be disabled on slow drives."));
    gtk_widget_set_name(widget, "autosave_interval");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id16), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("run_crawler_on_start");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("look for updated XMP files on startup"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("run_crawler_on_start"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id96), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id96), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("check file modification times of all XMP files on startup to check if any got updated in the meantime"));
    gtk_widget_set_name(widget, "run_crawler_on_start");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id96), (gpointer)widget);
  }
  }
  {
    GtkWidget *widget, *label, *labelev, *viewport, *box;
    GtkWidget *grid = gtk_grid_new();
    gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
    gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
    gtk_widget_set_valign(grid, GTK_ALIGN_START);
    int line = 0;
    char tooltip[1024];
    GtkWidget *tab_box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 0);
    GtkWidget *scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    viewport = gtk_viewport_new(NULL, NULL);
    gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE); // doesn't seem to work from gtkrc
    GtkWidget *help = gtk_button_new_with_label(_("?"));
    gtk_widget_set_halign(help, GTK_ALIGN_END);
    g_object_set_data_full(G_OBJECT(help), "dt-help-url",
                          g_strdup("preferences-settings/miscellaneous/"), g_free);
    g_signal_connect(help, "clicked", G_CALLBACK(dt_gui_show_help), NULL);
    gtk_box_pack_start(GTK_BOX(tab_box), scroll, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(scroll), viewport);
    gtk_container_add(GTK_CONTAINER(viewport), grid);
    gtk_box_pack_end(GTK_BOX(tab_box), help, FALSE, FALSE, 0);
    gtk_stack_add_titled(GTK_STACK(stack), tab_box,
                         _("miscellaneous"), _("miscellaneous"));
    {
      GtkWidget *seclabel = gtk_label_new(_("interface"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("show_splash_screen");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("show splash screen at startup"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("show_splash_screen"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id7), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id7), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("display a small window showing the progress of darktable startup before the main window appears"));
    gtk_widget_set_name(widget, "show_splash_screen");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id7), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("accel/load_defaults");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("load default shortcuts at startup"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/load_defaults"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id8), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id8), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("load default shortcuts before user settings. switch off to prevent deleted defaults returning"));
    gtk_widget_set_name(widget, "accel/load_defaults");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id8), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("bauhaus/zoom_step");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("scale slider step with min/max"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("bauhaus/zoom_step"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id9), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id9), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("vary slider step size with min/max range"));
    gtk_widget_set_name(widget, "bauhaus/zoom_step");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id9), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("modules/default_presets_first");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("sort built-in presets first"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("modules/default_presets_first"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id56), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id56), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("whether to show built-in presets first before user's presets in presets menu."));
    gtk_widget_set_name(widget, "modules/default_presets_first");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id56), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/sidebar_scroll_default");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("mouse wheel scrolls modules side panel by default"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("darkroom/ui/sidebar_scroll_default"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id79), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id79), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("when enabled, use mouse wheel to scroll modules side panel.  use ctrl+alt to use mouse wheel for data entry.  when disabled, this behavior is reversed"));
    gtk_widget_set_name(widget, "darkroom/ui/sidebar_scroll_default");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id79), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("panel_scrollbars_always_visible");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("always show panels' scrollbars"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("panel_scrollbars_always_visible"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id82), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id82), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("defines whether the panel scrollbars should be always visible or activated only depending on the content. (restart required)"));
    gtk_widget_set_name(widget, "panel_scrollbars_always_visible");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id82), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("darkroom/ui/transition_duration");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("duration of the UI transitions in ms"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    max = 1000;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("darkroom/ui/transition_duration") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id83), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id83), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(250 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("how long the transitions take (in ms) for expanding or collapsing modules and other UI elements"));
    gtk_widget_set_name(widget, "darkroom/ui/transition_duration");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id83), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/darkroom/histogram/panel_position");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("position of the scopes module"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/darkroom/histogram/panel_position");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id93), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id93), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "right"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("position the scopes at the top-left or top-right of the screen"));
    gtk_widget_set_name(widget, "plugins/darkroom/histogram/panel_position");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id93), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("ui_last/display_profile_source");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("method to use for getting the display profile"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "ui_last/display_profile_source");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id95), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id95), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "all"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("this option allows to force a specific means of getting the current display profile.\nthis is useful when one alternative gives wrong results"));
    gtk_widget_set_name(widget, "ui_last/display_profile_source");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id95), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/midi/devices");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("order or exclude MIDI devices"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_entry_new();
    gtk_widget_set_halign(widget, GTK_ALIGN_FILL);
    gtk_widget_set_hexpand(widget, TRUE);
    gchar *setting = dt_conf_get_string("plugins/midi/devices");
    gtk_entry_set_text(GTK_ENTRY(widget), setting);
    g_free(setting);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(preferences_changed_callback_id108), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id108), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), "");
    gtk_widget_set_tooltip_text(labelev,  tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("comma-separated list of device name fragments that if matched load MIDI device at id given by location in list\nor if preceded by '-' prevent matching devices from loading. add encoding and number of knobs like 'BeatStep:63:16'"));
    if(!dt_capabilities_check("midi"))
    {
      gtk_widget_destroy(widget);
      widget = gtk_label_new(_("not available"));
      gtk_widget_set_halign(widget, GTK_ALIGN_START);
      gtk_widget_set_tooltip_text(labelev, _("not available on this system"));
      gtk_widget_set_tooltip_text(widget, _("not available on this system"));
      gtk_widget_set_sensitive(labelev, FALSE);
      gtk_widget_set_sensitive(widget, FALSE);
    }
    gtk_widget_set_name(widget, "plugins/midi/devices");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id108), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("tags"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("omit_tag_hierarchy");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("omit hierarchy in simple tag lists"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("omit_tag_hierarchy"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id17), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id17), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("when creating an XMP sidecar file the hierarchical tags are also added as a simple list\nof non-hierarchical ones to make them visible to some other programs.\nwhen this option is checked darktable will only include their last part\nand ignore the rest. so 'foo|bar|baz' will only add 'baz'."));
    gtk_widget_set_name(widget, "omit_tag_hierarchy");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id17), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("shortcuts with multiple instances"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("accel/prefer_focused");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("prefer focused instance"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_focused"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id1), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id1), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("where multiple instances of a module are present, apply shortcuts to the instance that has focus\nif none are focused, the preferences below control rules that are followed (in order) to decide which module instance shortcuts will be applied to.\nnote: blending shortcuts always apply to the focused instance"));
    gtk_widget_set_name(widget, "accel/prefer_focused");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id1), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("accel/prefer_expanded");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("prefer expanded instances"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_expanded"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id2), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id2), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("if instances of the module are expanded, ignore collapsed instances"));
    gtk_widget_set_name(widget, "accel/prefer_expanded");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id2), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("accel/prefer_enabled");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("prefer enabled instances"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_enabled"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id3), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id3), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("after applying the above rule, if instances of the module are active, ignore inactive instances"));
    gtk_widget_set_name(widget, "accel/prefer_enabled");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id3), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("accel/prefer_unmasked");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("prefer unmasked instances"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/prefer_unmasked"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id4), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id4), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("after applying the above rules, if instances of the module are unmasked, ignore masked instances"));
    gtk_widget_set_name(widget, "accel/prefer_unmasked");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id4), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("accel/select_order");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("selection order"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "accel/select_order");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id5), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id5), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "last instance"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("after applying the above rules, apply the shortcut based on its position in the pixelpipe"));
    gtk_widget_set_name(widget, "accel/select_order");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id5), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("accel/assign_instance");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("allow visual assignment to specific instances"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("accel/assign_instance"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id6), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id6), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("when multiple instances are present on an image this allows shortcuts to be visually assigned to those specific instances\notherwise shortcuts will always be assigned to the preferred instance"));
    gtk_widget_set_name(widget, "accel/assign_instance");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id6), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("map / geolocalization view"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/metadata_view/pretty_location");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("pretty print the image location"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/metadata_view/pretty_location"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id72), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id72), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "TRUE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("show a more readable representation of the location in the image information module"));
    gtk_widget_set_name(widget, "plugins/lighttable/metadata_view/pretty_location");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id72), (gpointer)widget);
  }
    {
      GtkWidget *seclabel = gtk_label_new(_("slideshow view"));
      GtkWidget *lbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);
      gtk_box_pack_start(GTK_BOX(lbox), seclabel, FALSE, FALSE, 0);
      gtk_widget_set_name(lbox, "pref_section");
      gtk_grid_attach(GTK_GRID(grid), lbox, 0, line++, 2, 1);
    }
  {
    const gboolean is_default = dt_conf_is_default("slideshow_delay");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("waiting time between each image in slideshow"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("slideshow_delay") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id12), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id12), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(5 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_name(widget, "slideshow_delay");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id12), (gpointer)widget);
  }
  }

  g_object_unref(widget_group);
}
GtkWidget *dt_prefs_init_dialog_collect(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  GtkWidget *area = gtk_dialog_get_content_area(GTK_DIALOG(dialog));
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/tagging/no_uncategorized");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("do not set the 'uncategorized' entry for tags"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = gtk_check_button_new();
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), dt_conf_get_bool("plugins/lighttable/tagging/no_uncategorized"));
    g_signal_connect(G_OBJECT(widget), "toggled", G_CALLBACK(preferences_changed_callback_id18), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id18), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "FALSE"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("do not set the 'uncategorized' entry for tags which do not have children"));
    gtk_widget_set_name(widget, "plugins/lighttable/tagging/no_uncategorized");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id18), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/tagging/case_sensitivity");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("tags case sensitivity"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/lighttable/tagging/case_sensitivity");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id19), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id19), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "insensitive"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("tags case sensitivity. without the Sqlite ICU extension, insensitivity works only for the 26 latin letters"));
    gtk_widget_set_name(widget, "plugins/lighttable/tagging/case_sensitivity");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id19), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/collect/history_max");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("number of collections to be stored"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 1;
    max = 50;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/collect/history_max") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id38), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id38), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("the number of recent collections to store and show in this list"));
    gtk_widget_set_name(widget, "plugins/lighttable/collect/history_max");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id38), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("show_folder_levels");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("number of folder levels to show in lists"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 1;
    max = 5;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("show_folder_levels") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id39), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id39), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(1 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("the number of folder levels to show in film roll names, starting from the right"));
    gtk_widget_set_name(widget, "show_folder_levels");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id39), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/collect/filmroll_sort");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("sort film rolls by"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    widget = dt_gui_preferences_enum(NULL, "plugins/collect/filmroll_sort");
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id40), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id40), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%s'"), C_("preferences", "import time"));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("sets the collections-list order for film rolls"));
    gtk_widget_set_name(widget, "plugins/collect/filmroll_sort");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id40), (gpointer)widget);
  }
  g_object_unref(widget_group);
  gtk_box_pack_start(GTK_BOX(area), grid, FALSE, FALSE, 0);
  return grid;
}

GtkWidget *dt_prefs_init_dialog_recentcollect(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  GtkWidget *area = gtk_dialog_get_content_area(GTK_DIALOG(dialog));
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/recentcollect/max_items");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("number of collections to be stored"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 1;
    max = 50;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/recentcollect/max_items") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id37), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id37), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(10 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("the number of recent collections to store and show in this list"));
    gtk_widget_set_name(widget, "plugins/lighttable/recentcollect/max_items");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id37), (gpointer)widget);
  }
  g_object_unref(widget_group);
  gtk_box_pack_start(GTK_BOX(area), grid, FALSE, FALSE, 0);
  return grid;
}

GtkWidget *dt_prefs_init_dialog_import(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  GtkWidget *area = gtk_dialog_get_content_area(GTK_DIALOG(dialog));
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  g_object_unref(widget_group);
  gtk_box_pack_start(GTK_BOX(area), grid, FALSE, FALSE, 0);
  return grid;
}

GtkWidget *dt_prefs_init_dialog_tagging(GtkWidget *dialog)
{
  GtkWidget *widget, *label, *labelev, *viewport, *box;
  GtkWidget *grid = gtk_grid_new();
  GtkSizeGroup *widget_group = gtk_size_group_new(GTK_SIZE_GROUP_BOTH);
  gtk_grid_set_row_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(3));
  gtk_grid_set_column_spacing(GTK_GRID(grid), DT_PIXEL_APPLY_DPI(5));
  gtk_widget_set_valign(grid, GTK_ALIGN_START);
  int line = 0;
  char tooltip[1024];
  GtkWidget *area = gtk_dialog_get_content_area(GTK_DIALOG(dialog));
  g_object_set_data(G_OBJECT(dialog), "local-dialog", GUINT_TO_POINTER(1));

  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/tagging/confidence");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("suggested tags level of confidence"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = 0;
    max = 100;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/tagging/confidence") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id67), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id67), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(50 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    /* xgettext:no-c-format */
    gtk_widget_set_tooltip_text(widget, _("level of confidence to include the tag in the suggestions list, 0: all associated tags, 99: 99% matching associated tags, 100: no matching tag to show only recent tags (faster)"));
    gtk_widget_set_name(widget, "plugins/lighttable/tagging/confidence");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id67), (gpointer)widget);
  }
  {
    const gboolean is_default = dt_conf_is_default("plugins/lighttable/tagging/nb_recent_tags");
    GtkWidget *labdef;
    if(is_default)
    {
       labdef = gtk_label_new("");
    }
    else
    {
       labdef = gtk_label_new(NON_DEF_CHAR);
       gtk_widget_set_tooltip_text(labdef, _("this setting has been modified"));
    }
    gtk_widget_set_name(labdef, "preference_non_default");
    label = gtk_label_new_with_mnemonic(_("number of recently attached tags"));
    gtk_label_set_xalign(GTK_LABEL(label), .0);
    labelev = gtk_event_box_new();
    gtk_widget_add_events(labelev, GDK_BUTTON_PRESS_MASK);
    gtk_container_add(GTK_CONTAINER(labelev), label);

    gint min = G_MININT;
    gint max = G_MAXINT;
    min = -1;
    max = 1000;
    float factor = 1.0f;
    double tmp;
    tmp = min * (double)factor; min = tmp;
    tmp = max * (double)factor; max = tmp;
    widget = gtk_spin_button_new_with_range(min, max, 1);
    gtk_widget_set_halign(widget, GTK_ALIGN_START);
    gtk_size_group_add_widget(widget_group, widget);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), dt_conf_get_int("plugins/lighttable/tagging/nb_recent_tags") * factor);
    g_signal_connect(G_OBJECT(widget), "value-changed", G_CALLBACK(preferences_changed_callback_id68), labdef);
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(preferences_response_callback_id68), widget);
    snprintf(tooltip, 1024, _("double click to reset to `%d'"), (int)(20 * factor));
    gtk_widget_set_tooltip_text(labelev, tooltip);
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(labelev), FALSE);
    gtk_widget_set_tooltip_text(widget, _("number of recently attached tags which are included in the suggestions list. the value `-1' disables the recent list"));
    gtk_widget_set_name(widget, "plugins/lighttable/tagging/nb_recent_tags");
    gtk_grid_attach(GTK_GRID(grid), labelev, 0, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), labdef, 1, line, 1, 1);
    gtk_grid_attach(GTK_GRID(grid), widget, 2, line++, 1, 1);
    gtk_label_set_mnemonic_widget(GTK_LABEL(label), widget);
    g_signal_connect(G_OBJECT(labelev), "button-press-event", G_CALLBACK(reset_widget_id68), (gpointer)widget);
  }
  g_object_unref(widget_group);
  gtk_box_pack_start(GTK_BOX(area), grid, FALSE, FALSE, 0);
  return grid;
}

#endif
