/** generated file, do not edit! */
#ifndef DT_CONFGEN_H
#define DT_CONFGEN_H

#pragma GCC diagnostic ignored "-Wunused-variable"

#include "control/conf.h"

#define WRAP_TRANSLATION(text)

typedef struct {
   const char *name;		// configuration variable's name (path)
   const char *type;		// variable's type (int, string, enum, etc.)
   const char *def;		// default value
   const char *enum_values;	// listing of possible values for an enum, in format "[A][B][C]...[Z]"
   const char *min;		// minimum value (optional, may be NULL or empty string)
   const char *max;		// maximum value (optional, may be NULL or empty string)
   const char *shortdesc;	// short one-line description
   const char *longdesc;	// long, potentially multi-line description (optional)
} _default_config_t;

static void _clear_confgen_value(void *value)
{
  dt_confgen_value_t *s = (dt_confgen_value_t *)value;
  g_free(s->def);
  g_free(s->min);
  s->min = NULL;
  g_free(s->max);
  s->max = NULL;
  g_free(s->enum_values);
  s->enum_values = NULL;
  g_free(s->shortdesc);
  s->shortdesc = NULL;
  g_free(s->longdesc);
  s->longdesc = NULL;
}

static void _free_confgen_value(void *value)
{
  dt_confgen_value_t *s = (dt_confgen_value_t *)value;
  _clear_confgen_value(value);
  g_free(s);
}

static char *_copy_string(const char *s)
{
  return s && *s ? g_strdup(s) : NULL;
}

static _default_config_t _config_variables[] =
{
  {
    "themes/usercss",
    "bool", "false", "",
    "", "",
    "modify theme with user tweaks",
    
  },
  {
    "accel/prefer_focused",
    "bool", "true", "",
    "", "",
    "prefer focused instance",
    "where multiple instances of a module are present, apply shortcuts to the instance that has focus\nif none are focused, the preferences below control rules that are followed (in order) to decide which module instance shortcuts will be applied to.\nnote: blending shortcuts always apply to the focused instance"
  },
  {
    "accel/prefer_expanded",
    "bool", "false", "",
    "", "",
    "prefer expanded instances",
    "if instances of the module are expanded, ignore collapsed instances"
  },
  {
    "accel/prefer_enabled",
    "bool", "false", "",
    "", "",
    "prefer enabled instances",
    "after applying the above rule, if instances of the module are active, ignore inactive instances"
  },
  {
    "accel/prefer_unmasked",
    "bool", "false", "",
    "", "",
    "prefer unmasked instances",
    "after applying the above rules, if instances of the module are unmasked, ignore masked instances"
  },
  {
    "accel/select_order",
    "enum", "last instance", "[first instance][last instance]",
     WRAP_TRANSLATION(C_("preferences", "first instance"))
     WRAP_TRANSLATION(C_("preferences", "last instance"))
    "", "",
    "selection order",
    "after applying the above rules, apply the shortcut based on its position in the pixelpipe"
  },
  {
    "accel/assign_instance",
    "bool", "false", "",
    "", "",
    "allow visual assignment to specific instances",
    "when multiple instances are present on an image this allows shortcuts to be visually assigned to those specific instances\notherwise shortcuts will always be assigned to the preferred instance"
  },
  {
    "accel/slider_precision",
    "int", "0", "",
    "", "",
    "keyboard shortcut slider precision",
    
  },
  {
    "accel/enable_fallbacks",
    "bool", "false", "",
    "", "",
    "enable shortcut fallbacks",
    "enables default meanings for additional buttons, modifiers or moves when used in combination with a base shortcut"
  },
  {
    "show_splash_screen",
    "bool", "true", "",
    "", "",
    "show splash screen at startup",
    "display a small window showing the progress of darktable startup before the main window appears"
  },
  {
    "accel/load_defaults",
    "bool", "true", "",
    "", "",
    "load default shortcuts at startup",
    "load default shortcuts before user settings. switch off to prevent deleted defaults returning"
  },
  {
    "accel/show_tab_in_prefs",
    "bool", "true", "",
    "", "",
    "show the shortcuts configuration tab in the preferences dialog",
    
  },
  {
    "accel/hide_notice",
    "bool", "false", "",
    "", "",
    "don't show advice in shortcuts dialog",
    
  },
  {
    "bauhaus/scale",
    "float", "1.4", "",
    "", "",
    "widget scale",
    "scaling factor for bauhaus widgets, will affect font size"
  },
  {
    "bauhaus/zoom_step",
    "bool", "true", "",
    "", "",
    "scale slider step with min/max",
    "vary slider step size with min/max range"
  },
  {
    "database",
    "string", "library.db", "",
    "", "",
    "database location",
    "filename relative to ~/.config/darktable or starting with a slash (restart required)"
  },
  {
    "storage/piwigo/last_album",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "storage/piwigo/overwrite",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "database/maintenance_freepage_ratio",
    "int", "25", "",
    "", "",
    "database fragmentation ratio threshold",
    "fragmentation ratio above which to ask or carry out automatically database maintenance"
  },
  {
    "database/create_snapshot",
    "enum", "once a week", "[never][once a month][once a week][once a day][on close]",
     WRAP_TRANSLATION(C_("preferences", "never"))
     WRAP_TRANSLATION(C_("preferences", "once a month"))
     WRAP_TRANSLATION(C_("preferences", "once a week"))
     WRAP_TRANSLATION(C_("preferences", "once a day"))
     WRAP_TRANSLATION(C_("preferences", "on close"))
    "", "",
    "create database snapshot",
    "database snapshots are created right before closing darktable. options allow you to choose how often to make snapshots:\n - 'never': simply don't do snapshots. that way the only snapshots done are mandatory version-upgrade snapshots\n - 'once a month': create snapshot if a month has passed since last snapshot\n - 'once a week': create snapshot if 7 days had passed since last snapshot\n - 'once a day': create snapshot if over 24h passed since last snapshot\n - 'on close': create snapshot every time darktable is closed"
  },
  {
    "database/keep_snapshots",
    "int", "10", "",
    "", "",
    "how many snapshots to keep",
    "after successfully creating snapshot, how many older snapshots to keep (excluding mandatory version update ones). enter -1 to keep all snapshots\nkeep in mind that snapshots do take some space and you only need the most recent one for successful restore"
  },
  {
    "min_panel_height",
    "int", "64", "",
    "", "",
    "minimum height of the bottom panel in pixels",
    "(restart required)"
  },
  {
    "max_panel_height",
    "int", "400", "",
    "", "",
    "maximum height of the bottom panel in pixels",
    "(restart required)"
  },
  {
    "min_panel_width",
    "int", "150", "",
    "", "",
    "minimum width of the side panels in pixels",
    "(restart required)"
  },
  {
    "max_panel_width",
    "int", "1500", "",
    "", "",
    "maximum width of the side panels in pixels",
    "(restart required)"
  },
  {
    "slideshow_delay",
    "int", "5", "",
    "", "",
    "waiting time between each image in slideshow",
    
  },
  {
    "resourcelevel",
    "enum", "default", "[small][default][large]",
     WRAP_TRANSLATION(C_("preferences", "small"))
     WRAP_TRANSLATION(C_("preferences", "default"))
     WRAP_TRANSLATION(C_("preferences", "large"))
    "", "",
    "darktable resources",
    "defines how much darktable may take from your system resources:\n - 'default': darktable takes ~50% of your systems resources, which is enough to be performant.\n - 'small': should be used if you are simultaneously running applications taking large parts of your systems memory or OpenCL/GL applications like games or Hugin.\n - 'large': is the best option if you are not running other applications at the same time as darktable and want it to take most of your systems resources for performance."
  },
  {
    "backthumbs_inactivity",
    "float", "5.0", "",
    "", "",
    "inactivity time",
    "user inactivity time (seconds) while being in lighttable before a thumbnail generation might start"
  },
  {
    "cache_color_managed",
    "bool", "true", "",
    "", "",
    "color manage cached thumbnails",
    "if enabled, cached thumbnails will be color managed so that lighttable and filmstrip can show correct colors. otherwise the results may look wrong once the display profile gets changed."
  },
  {
    "opencl_device_priority",
    "string", "*/!0,*/*/*/!0,*", "",
    "", "",
    "priority of OpenCL devices for each pixelpipe type",
    "defines priorities on how (multiple) OpenCL devices are allocated to the different types of pixelpipe (full, preview, export, thumbnail, preview2). for more details visit our user manual. (restart required)"
  },
  {
    "opencl_mandatory_timeout",
    "int", "1000", "",
    "100", "",
    "timeout period for locking mandatory OpenCL device",
    "time period (in units of 5ms) after which we give up try-locking an OpenCL device for mandatory use. defaults to 400 (2 seconds)."
  },
  {
    "opencl_checksum",
    "string", "", "",
    "", "",
    "checksum representing the setup of OpenCL devices on this computer",
    "darktable re-checks the performance benchmarks of your system in case your setup has changed, which is indicated by a change versus the stored checksum in this config variable; darktable de-activates OpenCL if the GPU benchmark lies below the one of the CPU; initial value is the empty string; set to OFF if you want to deactivate any automatic checks and prefer to do all configurations manually."
  },
  {
    "pixelpipe_synchronization_timeout",
    "int", "200", "",
    "", "",
    "timeout period of pixelpipe synchronization",
    "time period (in units of 5ms) after which synchronization of preview and full pixelpipe is assumed to have failed. set to zero to omit pixelpipe synchronization. defaults to 200."
  },
  {
    "libraw_extensions",
    "string", "", "",
    "", "",
    "raw file extensions to be processed by libraw",
    "space-delimited list of raw file extensions (without a leading dot, in lowercase) to be processed by libraw instead of rawspeed."
  },
  {
    "write_sidecar_files",
    "enum", "on import", "[never][after edit][on import]",
     WRAP_TRANSLATION(C_("preferences", "never"))
     WRAP_TRANSLATION(C_("preferences", "after edit"))
     WRAP_TRANSLATION(C_("preferences", "on import"))
    "", "",
    "create XMP files",
    "XMP sidecar files hold information about all your development steps to allow flawless re-importing of image files.\n\ndepending on the selected mode sidecar files will be created:\n - 'never': all development information will be stored only in the library database\n - 'on import': immediately after importing the image\n - 'after edit': after any user change on the image or adding tags."
  },
  {
    "compress_xmp_tags",
    "enum", "only large entries", "[never][always][only large entries]",
     WRAP_TRANSLATION(C_("preferences", "never"))
     WRAP_TRANSLATION(C_("preferences", "always"))
     WRAP_TRANSLATION(C_("preferences", "only large entries"))
    "", "",
    "store XMP tags in compressed format",
    "entries in XMP tags can get rather large and may exceed the available space to store the history stack in output files.\nthis option allows XMP tags to be compressed and save space."
  },
  {
    "autosave_interval",
    "int", "10", "",
    "", "",
    "auto-save interval",
    "automatically save history while developing using the given interval (in seconds); set to zero to disable auto-saving. auto-saving might be disabled on slow drives."
  },
  {
    "omit_tag_hierarchy",
    "bool", "false", "",
    "", "",
    "omit hierarchy in simple tag lists",
    "when creating an XMP sidecar file the hierarchical tags are also added as a simple list\nof non-hierarchical ones to make them visible to some other programs.\nwhen this option is checked darktable will only include their last part\nand ignore the rest. so 'foo|bar|baz' will only add 'baz'."
  },
  {
    "plugins/lighttable/tagging/no_uncategorized",
    "bool", "false", "",
    "", "",
    "do not set the 'uncategorized' entry for tags",
    "do not set the 'uncategorized' entry for tags which do not have children"
  },
  {
    "plugins/lighttable/tagging/case_sensitivity",
    "enum", "insensitive", "[sensitive][insensitive]",
     WRAP_TRANSLATION(C_("preferences", "sensitive"))
     WRAP_TRANSLATION(C_("preferences", "insensitive"))
    "", "",
    "tags case sensitivity",
    "tags case sensitivity. without the Sqlite ICU extension, insensitivity works only for the 26 latin letters"
  },
  {
    "opencl",
    "bool", "true", "",
    "", "",
    "activate OpenCL support",
    "if found, use OpenCL runtime on your system to speed up processing by using your graphics card(s).\ncan be switched on and off at any time."
  },
  {
    "opencl_scheduling_profile",
    "enum", "default", "[default][multiple GPUs][very fast GPU]",
     WRAP_TRANSLATION(C_("preferences", "default"))
     WRAP_TRANSLATION(C_("preferences", "multiple GPUs"))
     WRAP_TRANSLATION(C_("preferences", "very fast GPU"))
    "", "",
    "OpenCL scheduling profile",
    "defines how preview and full pixelpipe tasks are scheduled on OpenCL enabled systems:\n - 'default': GPU processes full and CPU processes preview pipe (adaptable by config parameters),\n - 'multiple GPUs': process both pixelpipes in parallel on two different GPUs,\n - 'very fast GPU': process both pixelpipes sequentially on the GPU."
  },
  {
    "opencl_tune_headroom",
    "bool", "false", "",
    "", "",
    "tuned GPU memory",
    "if enabled on a system with multiple OpenCL devices you may specify a safety margin per device (headroom, default is 600MB)"
  },
  {
    "clplatform_intelropenclhdgraphics",
    "bool", "true", "",
    "", "",
    "Intel GPU",
    "Intel(R) OpenCL Graphics for all supported platforms (vendor provided)"
  },
  {
    "clplatform_nvidiacuda",
    "bool", "true", "",
    "", "",
    "Nvidia CUDA",
    "Nvidia CUDA based OpenCL (vendor provided)"
  },
  {
    "clplatform_amdacceleratedparallelprocessing",
    "bool", "true", "",
    "", "",
    "AMD ROCm",
    "AMD Accelerated Parallel Processing (vendor provided)"
  },
  {
    "clplatform_rusticl",
    "bool", "false", "",
    "", "",
    "RustiCL (experimental)",
    "RustiCL Mesa OpenCL, still unstable. if you want to use this, you should disable the vendor driver"
  },
  {
    "clplatform_apple",
    "bool", "false", "",
    "", "",
    "Apple",
    "Apple OpenCL (vendor provided)"
  },
  {
    "clplatform_openclon12",
    "bool", "false", "",
    "", "",
    "Microsoft OpenCLOn12",
    "Microsoft OpenCLOn12, only use this if the vendor provided driver does not work or there is none provided."
  },
  {
    "clplatform_other",
    "bool", "false", "",
    "", "",
    "other platforms",
    "if set, all unspecified platforms are accepted. only do this if no vendor driver is available"
  },
  {
    "opencl_library",
    "string", "", "",
    "", "",
    "system library with OpenCL runtime",
    "OpenCL runtime library is normally detected automatically by darktable. if your OpenCL runtime is at an unusual place and cannot be detected, enter the full pathname here. leave empty for default behavior."
  },
  {
    "ask_before_remove",
    "bool", "true", "",
    "", "",
    "ask before removing images from the library",
    "always ask the user before removing image information from the library"
  },
  {
    "ask_before_delete",
    "bool", "true", "",
    "", "",
    "ask before deleting images from disk",
    "always ask the user before any image file is deleted"
  },
  {
    "ask_before_discard",
    "bool", "true", "",
    "", "",
    "ask before discarding history stack",
    "always ask the user before history stack is discarded on any image"
  },
  {
    "send_to_trash",
    "bool", "true", "",
    "", "",
    "try to use trash when deleting images",
    "send files to trash instead of permanently deleting files on system that supports it"
  },
  {
    "ask_before_move",
    "bool", "true", "",
    "", "",
    "ask before moving images from film roll folder",
    "always ask the user before any image file is moved."
  },
  {
    "ask_before_copy",
    "bool", "true", "",
    "", "",
    "ask before copying images to new film roll folder",
    "always ask the user before any image file is copied."
  },
  {
    "ask_before_rmdir",
    "bool", "false", "",
    "", "",
    "ask before removing empty folders",
    "always ask the user before removing any empty folder. this can happen after moving or deleting images."
  },
  {
    "plugins/lighttable/recentcollect/max_items",
    "int", "10", "",
    "1", "50",
    "number of collections to be stored",
    "the number of recent collections to store and show in this list"
  },
  {
    "plugins/lighttable/collect/history_max",
    "int", "10", "",
    "1", "50",
    "number of collections to be stored",
    "the number of recent collections to store and show in this list"
  },
  {
    "plugins/lighttable/filtering/history_max",
    "int", "10", "",
    "1", "50",
    "number of filters to be stored",
    "the number of recent filters to store and show in history list"
  },
  {
    "plugins/lighttable/filtering/sort_history_max",
    "int", "10", "",
    "1", "50",
    "number of sort orders to be stored",
    "the number of recent sort orders to store and show in history list"
  },
  {
    "plugins/lighttable/filtering/num_sort",
    "int", "1", "",
    "", "",
    "nb of sort orders by default",
    ""
  },
  {
    "plugins/lighttable/filtering/sort0",
    "int", "0", "",
    "", "",
    "first sort orders",
    ""
  },
  {
    "plugins/lighttable/filtering/num_rules",
    "int", "3", "",
    "1", "12",
    "nb of rules by default",
    ""
  },
  {
    "plugins/lighttable/filtering/item0",
    "int", "32", "",
    "", "",
    "first filter",
    ""
  },
  {
    "plugins/lighttable/filtering/mode0",
    "int", "0", "",
    "", "",
    "first filter",
    ""
  },
  {
    "plugins/lighttable/filtering/off0",
    "int", "0", "",
    "", "",
    "first filter",
    ""
  },
  {
    "plugins/lighttable/filtering/top0",
    "int", "1", "",
    "", "",
    "first filter",
    ""
  },
  {
    "plugins/lighttable/filtering/string0",
    "string", "%", "",
    "", "",
    "first filter",
    ""
  },
  {
    "plugins/lighttable/filtering/item1",
    "int", "18", "",
    "", "",
    "second filter",
    ""
  },
  {
    "plugins/lighttable/filtering/mode1",
    "int", "0", "",
    "", "",
    "second filter",
    ""
  },
  {
    "plugins/lighttable/filtering/off1",
    "int", "0", "",
    "", "",
    "second filter",
    ""
  },
  {
    "plugins/lighttable/filtering/top1",
    "int", "1", "",
    "", "",
    "second filter",
    ""
  },
  {
    "plugins/lighttable/filtering/string1",
    "string", "", "",
    "", "",
    "second filter",
    ""
  },
  {
    "plugins/lighttable/filtering/item2",
    "int", "33", "",
    "", "",
    "third filter",
    ""
  },
  {
    "plugins/lighttable/filtering/mode2",
    "int", "0", "",
    "", "",
    "third filter",
    ""
  },
  {
    "plugins/lighttable/filtering/off2",
    "int", "0", "",
    "", "",
    "third filter",
    ""
  },
  {
    "plugins/lighttable/filtering/top2",
    "int", "1", "",
    "", "",
    "third filter",
    ""
  },
  {
    "plugins/lighttable/filtering/string2",
    "string", "%%", "",
    "", "",
    "third filter",
    ""
  },
  {
    "show_folder_levels",
    "int", "1", "",
    "1", "5",
    "number of folder levels to show in lists",
    "the number of folder levels to show in film roll names, starting from the right"
  },
  {
    "plugins/collection/film_id",
    "int", "1", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/rating",
    "int", "1", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/rating_comparator",
    "int", "3", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/query_flags",
    "int", "3", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/filter_flags",
    "int", "3", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/colors_filter",
    "string", "80000000", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/text_filter",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/descending",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/collection/sort",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/session/jobcode",
    "string", "capture job", "",
    "", "",
    "name of capture job",
    ""
  },
  {
    "plugins/capture/camera/live_view_fps",
    "int", "15", "",
    "", "",
    "maximum fps of live view update in tethering view",
    "going too fast will result in too many redraws without a real benefit"
  },
  {
    "plugins/collect/filmroll_sort",
    "enum", "import time", "[import time][folder name]",
     WRAP_TRANSLATION(C_("preferences", "import time"))
     WRAP_TRANSLATION(C_("preferences", "folder name"))
    "", "",
    "sort film rolls by",
    "sets the collections-list order for film rolls"
  },
  {
    "ui_last/colorpicker_model",
    "enum", "RGB", "[RGB][Lab][LCh][HSL][Hex][none]",
     WRAP_TRANSLATION(C_("preferences", "RGB"))
     WRAP_TRANSLATION(C_("preferences", "Lab"))
     WRAP_TRANSLATION(C_("preferences", "LCh"))
     WRAP_TRANSLATION(C_("preferences", "HSL"))
     WRAP_TRANSLATION(C_("preferences", "Hex"))
     WRAP_TRANSLATION(C_("preferences", "none"))
    "", "",
    "color model with which to represent primary colorpicker",
    ""
  },
  {
    "ui_last/colorpicker_mode",
    "enum", "mean", "[mean][min][max]",
     WRAP_TRANSLATION(C_("preferences", "mean"))
     WRAP_TRANSLATION(C_("preferences", "min"))
     WRAP_TRANSLATION(C_("preferences", "max"))
    "", "",
    "statistic used to describe colorpicker box",
    ""
  },
  {
    "ui_last/colorpicker_display_samples",
    "boolean", "false", "",
    "", "",
    "display live sample areas on image",
    ""
  },
  {
    "ui_last/colorpicker_restrict_histogram",
    "boolean", "false", "",
    "", "",
    "restrict histogram to selection",
    ""
  },
  {
    "ui_last/colorpicker_large",
    "boolean", "false", "",
    "", "",
    "display large colorpicker patch",
    ""
  },
  {
    "ui_last/fullscreen",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/maximized",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/grouping",
    "bool", "false", "",
    "", "",
    "grouping of images",
    "only show a single image for each set of grouped images in lighttable and filmstrip"
  },
  {
    "ui_last/view",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/window_x",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/window_y",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/window_w",
    "int", "900", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/window_h",
    "int", "500", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/panel_left",
    "int", "-1", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/panel_right",
    "int", "-1", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/panel_top",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/panel_bottom",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/expander_import",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_dialog_paned_pos",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_dialog_paned_places_pos",
    "int", "150", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_dialog_show_home",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_dialog_show_pictures",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_dialog_show_mounted",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_dialog_width",
    "int", "800", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_dialog_height",
    "int", "600", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/shortcuts_dialog_width",
    "int", "1100", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/shortcuts_dialog_height",
    "int", "700", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/preferences_dialog_width",
    "int", "1100", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/preferences_dialog_height",
    "int", "720", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/modulegroups_dialog_width",
    "int", "1100", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/modulegroups_dialog_height",
    "int", "700", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/session_expander_import",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/import_select_new",
    "bool", "true", "",
    "", "",
    N_("select only new images"),
    N_("only select images that have not already been imported")
  },
  {
    "ui_last/import_ignore_nonraws",
    "bool", "false", "",
    "", "",
    N_("ignore non-raw images"),
    N_("if enabled, only raw files will be allowed to import. non-raw files will not be visible in the dialog and will not be imported.")
  },
  {
    "ui_last/import_apply_metadata",
    "bool", "false", "",
    "", "",
    N_("apply metadata"),
    N_("apply some metadata to all newly imported images.")
  },
  {
    "ui_last/import_recursive",
    "bool", "false", "",
    "", "",
    N_("recursive directory"),
    N_("recursive directory traversal when importing filmrolls")
  },
  {
    "ui_last/import_last_creator",
    "string", "", "",
    "", "",
    N_("creator to be applied when importing"),
    ""
  },
  {
    "ui_last/import_last_publisher",
    "string", "", "",
    "", "",
    N_("publisher to be applied when importing"),
    ""
  },
  {
    "ui_last/import_last_rights",
    "string", "", "",
    "", "",
    N_("rights to be applied when importing"),
    ""
  },
  {
    "ui_last/import_last_tags",
    "string", "", "",
    "", "",
    N_("comma separated tags to be applied when importing"),
    ""
  },
  {
    "ui_last/import_last_tags_imported",
    "bool", "true", "",
    "", "",
    N_("import tags from XMP"),
    ""
  },
  {
    "ui_last/import_last_directory",
    "dir", "$(home)", "",
    "", "",
    "last opened directory.",
    ""
  },
  {
    "ui_last/import_last_root",
    "string", "", "",
    "", "",
    "last root folder",
    ""
  },
  {
    "ui_last/import_last_folder_descending",
    "bool", "false", "",
    "", "",
    "folders display order in folder pane",
    ""
  },
  {
    "ui_last/import_initial_rating",
    "int", "1", "",
    "0", "5",
    N_("initial rating"),
    N_("initial star rating for all images when importing a filmroll")
  },
  {
    "ui_last/ignore_exif_rating",
    "bool", "false", "",
    "", "",
    N_("ignore EXIF rating"),
    N_("ignore EXIF rating. if not set and EXIF rating is found, it overrides 'initial rating'")
  },
  {
    "ui_last/import_jobcode",
    "string", "no_name", "",
    "", "",
    N_("import job"),
    N_("name of the import job")
  },
  {
    "ui_last/import_datetime_override",
    "string", "", "",
    "", "",
    N_("override today's date"),
    N_("type a date in the form: YYYY:MM:DD[ hh:mm:ss[.sss]] if you want to override the current date/time used when expanding variables:\n$(YEAR), $(MONTH), $(DAY), $(HOUR), $(MINUTE), $(SECONDS), $(MSEC).\nlet the field empty otherwise")
  },
  {
    "ui_last/import_keep_open",
    "bool", "false", "",
    "", "",
    N_("keep this window open"),
    N_("keep this window open to run several imports")
  },
  {
    "plugins/capture/mode",
    "int", "0", "",
    "", "",
    "capture view mode",
    ""
  },
  {
    "plugins/lighttable/overlay_timeout",
    "int", "3", "",
    "", "",
    "timeout for overlay hover block in seconds",
    ""
  },
  {
    "plugins/lighttable/overlays/0/0",
    "int", "0", "",
    "", "",
    "overlays for filemanager at size 0 = none",
    ""
  },
  {
    "plugins/lighttable/overlays/0/1",
    "int", "1", "",
    "", "",
    "overlays for filemanager at size 1 = on hover",
    ""
  },
  {
    "plugins/lighttable/overlays/0/2",
    "int", "4", "",
    "", "",
    "overlays for filemanager at size 2 = always extended",
    ""
  },
  {
    "plugins/lighttable/overlays/1/0",
    "int", "0", "",
    "", "",
    "overlays for filmstrip at size 0 = none",
    ""
  },
  {
    "plugins/lighttable/overlays/1/1",
    "int", "1", "",
    "", "",
    "overlays for filmstrip at size 1 = on hover",
    ""
  },
  {
    "plugins/lighttable/overlays/1/2",
    "int", "1", "",
    "", "",
    "overlays for filmstrip at size 2 = on hover",
    ""
  },
  {
    "plugins/lighttable/overlays/2/0",
    "int", "0", "",
    "", "",
    "overlays for zomable lighttable at size 0 = none",
    ""
  },
  {
    "plugins/lighttable/overlays/2/1",
    "int", "1", "",
    "", "",
    "overlays for zomable lighttable at size 1 = on hover",
    ""
  },
  {
    "plugins/lighttable/overlays/2/2",
    "int", "4", "",
    "", "",
    "overlays for zomable lighttable at size 2 = always extended",
    ""
  },
  {
    "plugins/lighttable/overlays/culling/0",
    "int", "6", "",
    "", "",
    "overlays for culling = block",
    ""
  },
  {
    "plugins/lighttable/overlays/culling/1",
    "int", "6", "",
    "", "",
    "overlays for full preview = block",
    ""
  },
  {
    "plugins/lighttable/tooltips/0/0",
    "bool", "true", "",
    "", "",
    "tooltips for filemanager at size 0",
    ""
  },
  {
    "plugins/lighttable/tooltips/0/1",
    "bool", "true", "",
    "", "",
    "tooltips for filemanager at size 1",
    ""
  },
  {
    "plugins/lighttable/tooltips/0/2",
    "bool", "false", "",
    "", "",
    "tooltips for filemanager at size 2",
    ""
  },
  {
    "plugins/lighttable/tooltips/1/0",
    "bool", "true", "",
    "", "",
    "tooltips for filmstrip at size 0",
    ""
  },
  {
    "plugins/lighttable/tooltips/1/1",
    "bool", "true", "",
    "", "",
    "tooltips for filmstrip at size 1",
    ""
  },
  {
    "plugins/lighttable/tooltips/1/2",
    "bool", "true", "",
    "", "",
    "tooltips for filmstrip at size 2",
    ""
  },
  {
    "plugins/lighttable/tooltips/2/0",
    "bool", "true", "",
    "", "",
    "tooltips for zomable lighttable at size 0",
    ""
  },
  {
    "plugins/lighttable/tooltips/2/1",
    "bool", "true", "",
    "", "",
    "tooltips for zomable lighttable at size 1",
    ""
  },
  {
    "plugins/lighttable/tooltips/2/2",
    "bool", "false", "",
    "", "",
    "tooltips for zomable lighttable at size 2",
    ""
  },
  {
    "plugins/lighttable/tooltips/culling/0",
    "bool", "false", "",
    "", "",
    "tooltips for culling",
    ""
  },
  {
    "plugins/lighttable/tooltips/culling/1",
    "bool", "false", "",
    "", "",
    "tooltips for full preview",
    ""
  },
  {
    "plugins/lighttable/timeline/last_zoom",
    "int", "0", "",
    "", "",
    "last timeline zoom.",
    ""
  },
  {
    "plugins/lighttable/thumbnail_raw_min_level",
    "enum", "never", "[always][small][VGA][720p][1080p][WQXGA][4K][5K][never]",
     WRAP_TRANSLATION(C_("preferences", "always"))
     WRAP_TRANSLATION(C_("preferences", "small"))
     WRAP_TRANSLATION(C_("preferences", "VGA"))
     WRAP_TRANSLATION(C_("preferences", "720p"))
     WRAP_TRANSLATION(C_("preferences", "1080p"))
     WRAP_TRANSLATION(C_("preferences", "WQXGA"))
     WRAP_TRANSLATION(C_("preferences", "4K"))
     WRAP_TRANSLATION(C_("preferences", "5K"))
     WRAP_TRANSLATION(C_("preferences", "never"))
    "", "",
    "use raw file instead of embedded JPEG from size",
    "if the thumbnail size is greater than this value, it will be processed using raw file instead of the embedded preview JPEG (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)"
  },
  {
    "plugins/lighttable/thumbnail_hq_min_level",
    "enum", "720p", "[always][small][VGA][720p][1080p][WQXGA][4K][5K][never]",
     WRAP_TRANSLATION(C_("preferences", "always"))
     WRAP_TRANSLATION(C_("preferences", "small"))
     WRAP_TRANSLATION(C_("preferences", "VGA"))
     WRAP_TRANSLATION(C_("preferences", "720p"))
     WRAP_TRANSLATION(C_("preferences", "1080p"))
     WRAP_TRANSLATION(C_("preferences", "WQXGA"))
     WRAP_TRANSLATION(C_("preferences", "4K"))
     WRAP_TRANSLATION(C_("preferences", "5K"))
     WRAP_TRANSLATION(C_("preferences", "never"))
    "", "",
    "high quality processing from size",
    "if the thumbnail size is greater than this value, it will be processed using the full quality rendering path (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)"
  },
  {
    "cache_disk_backend",
    "bool", "true", "",
    "", "",
    "enable disk backend for thumbnail cache",
    "if enabled, write thumbnails to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached thumbnails again.\nit's safe though to delete these manually, if you want.\nlight table performance will be increased greatly when browsing a lot.\nto generate all thumbnails of your entire collection offline, run 'darktable-generate-cache'."
  },
  {
    "cache_disk_backend_full",
    "bool", "false", "",
    "", "",
    "enable disk backend for full preview cache",
    "if enabled, write full preview to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached full previews again.\nit's safe though to delete these manually, if you want.\nlight table performance will be increased greatly when zooming image in full preview mode."
  },
  {
    "thumbtable_fractional_scrolling",
    "bool", "false", "",
    "", "",
    "enable smooth scrolling for lighttable thumbnails",
    "if enabled, scrolling the lighttable scrolls by some number of pixels, as expected with a touch pad.\ndisabled, the lighttable scrolls full rows of thumbnails, as befits a scroll wheel."
  },
  {
    "backthumbs_mipsize",
    "enum", "never", "[never][small][VGA][720p][1080p][WQXGA][4K][5K]",
     WRAP_TRANSLATION(C_("preferences", "never"))
     WRAP_TRANSLATION(C_("preferences", "small"))
     WRAP_TRANSLATION(C_("preferences", "VGA"))
     WRAP_TRANSLATION(C_("preferences", "720p"))
     WRAP_TRANSLATION(C_("preferences", "1080p"))
     WRAP_TRANSLATION(C_("preferences", "WQXGA"))
     WRAP_TRANSLATION(C_("preferences", "4K"))
     WRAP_TRANSLATION(C_("preferences", "5K"))
    "", "",
    "generate thumbnails in background",
    "if 'enable disk backend for thumbnail cache' is enabled thumbnails/mipmaps up to the selected size are generated while user is inactive in lighttable."
  },
  {
    "backthumbs_initialize",
    "bool", "false", "",
    "", "",
    "reset cached thumbnails",
    "force thumbnails to be regenerated by resetting the database. this may be needed in case some thumbnails have been manually removed or corrupted."
  },
  {
    "plugins/lighttable/thumbnail_sizes",
    "string", "120|400", "",
    "", "",
    "delimiters for size categories",
    "size categories are used to be able to set different overlays and CSS values depending of the size of the thumbnail, separated by |.\nfor example, 120|400 means 3 categories of thumbnails: <120px, 120-400px, >400px"
  },
  {
    "plugins/lighttable/extended_pattern",
    "longstring", "$(FILE_NAME).$(FILE_EXTENSION)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b> $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON) $(SIDECAR_TXT)", "",
    "", "",
    "pattern for the thumbnail extended overlay text",
    "see manual to know all the tags you can use."
  },
  {
    "plugins/lighttable/thumbnail_tooltip_pattern",
    "longstring", "<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)$(NL)<b>$(EXIF.EXPOSURE)</b> • <b>f/$(EXIF.APERTURE)</b> • <b>$(EXIF.FOCAL.LENGTH)</b>mm • ISO <b>$(EXIF.ISO)</b>", "",
    "", "",
    "pattern for the thumbnail tooltip (empty to disable)",
    "see manual to know all the tags you can use."
  },
  {
    "pressure_sensitivity",
    "enum", "off", "[off][hardness (relative)][hardness (absolute)][opacity (relative)][opacity (absolute)][brush size (relative)]",
     WRAP_TRANSLATION(C_("preferences", "off"))
     WRAP_TRANSLATION(C_("preferences", "hardness (relative)"))
     WRAP_TRANSLATION(C_("preferences", "hardness (absolute)"))
     WRAP_TRANSLATION(C_("preferences", "opacity (relative)"))
     WRAP_TRANSLATION(C_("preferences", "opacity (absolute)"))
     WRAP_TRANSLATION(C_("preferences", "brush size (relative)"))
    "", "",
    "pen pressure control for brush masks",
    " - 'off': pressure reading ignored,\n - 'hardness'/'opacity'/'brush size': pressure reading controls specified attribute,\n - 'absolute'/'relative': pressure reading is taken directly as attribute value or multiplied with pre-defined setting."
  },
  {
    "brush_smoothing",
    "enum", "medium", "[low][medium][high]",
     WRAP_TRANSLATION(C_("preferences", "low"))
     WRAP_TRANSLATION(C_("preferences", "medium"))
     WRAP_TRANSLATION(C_("preferences", "high"))
    "", "",
    "smoothing of brush strokes",
    "sets level for smoothing of brush strokes.\nstronger smoothing leads to less nodes and easier editing but with lower control of accuracy."
  },
  {
    "masks_scroll_down_increases",
    "bool", "false", "",
    "", "",
    "scroll down to increase mask parameters",
    "when using the mouse scroll wheel to change mask parameters, scroll down to increase the mask size, feather size, opacity, brush hardness and gradient curvature\nby default scrolling up increases these parameters"
  },
  {
    "darkroom/mouse/middle_button_cycle_zoom_to_200_percent",
    "bool", "true", "",
    "", "",
    "middle mouse button zooms to 200%",
    "if enabled, the zoom level will cycle between 100%, 200% and fit to viewport on middle mouse clicks. if disabled, it will toggle between viewport size and 100%, and the 'ctrl' key can be used to control the zoom level."
  },
  {
    "channel_display",
    "enum", "false color", "[false color][grayscale]",
     WRAP_TRANSLATION(C_("preferences", "false color"))
     WRAP_TRANSLATION(C_("preferences", "grayscale"))
    "", "",
    "display of individual color channels",
    "defines how color channels are displayed when activated in the parametric masks feature."
  },
  {
    "plugins/darkroom/image_infos_pattern",
    "longstring", "$(EXIF.EXPOSURE) • f/$(EXIF.APERTURE) • $(EXIF.FOCAL.LENGTH) mm • ISO $(EXIF.ISO) $(GPS.LOCATION.ICON) $(EXIF.FLASH.ICON)", "",
    "", "",
    "pattern for the image information line",
    "see manual for a list of the tags you can use."
  },
  {
    "plugins/darkroom/image_infos_position",
    "enum", "bottom", "[top left][top right][top center][bottom][hidden]",
     WRAP_TRANSLATION(C_("preferences", "top left"))
     WRAP_TRANSLATION(C_("preferences", "top right"))
     WRAP_TRANSLATION(C_("preferences", "top center"))
     WRAP_TRANSLATION(C_("preferences", "bottom"))
     WRAP_TRANSLATION(C_("preferences", "hidden"))
    "", "",
    "position of the image information line",
    ""
  },
  {
    "database_cache_quality",
    "int", "89", "",
    "", "",
    "JPEG quality of on-disk thumbnails",
    "affects only the thumbnail cache used for quick startup."
  },
  {
    "plugins/lighttable/draw_group_borders",
    "bool", "true", "",
    "", "",
    "draw borders around grouped images",
    "draw borders around grouped images when grouping is turned off and the mouse hovers over one of the images of the group"
  },
  {
    "modules/default_presets_first",
    "bool", "true", "",
    "", "",
    "sort built-in presets first",
    "whether to show built-in presets first before user's presets in presets menu."
  },
  {
    "plugins/darkroom/hide_default_presets",
    "bool", "false", "",
    "", "",
    "hide built-in presets for processing modules",
    "hide built-in presets of processing modules in presets menu."
  },
  {
    "plugins/darkroom/show_guides_in_ui",
    "bool", "true", "",
    "", "",
    "show the guides widget in modules UI",
    "show the guides widget in modules UI"
  },
  {
    "plugins/lighttable/hide_default_presets",
    "bool", "false", "",
    "", "",
    "hide built-in presets for utility modules",
    "hide built-in presets of utility modules in presets menu."
  },
  {
    "session/base_directory_pattern",
    "string", "$(PICTURES_FOLDER)/Darktable", "",
    "", "",
    "base filmroll's directory",
    "directory where new imported filmrolls are created"
  },
  {
    "session/sub_directory_pattern",
    "string", "$(YEAR)$(MONTH)$(DAY)_$(JOBCODE)", "",
    "", "",
    "filmroll name",
    "name of the imported filmroll"
  },
  {
    "session/use_filename",
    "bool", "false", "",
    "", "",
    "keep original filename",
    "keep original filename instead of a pattern while importing from camera or card"
  },
  {
    "session/filename_pattern",
    "string", "$(YEAR)$(MONTH)$(DAY)_$(SEQUENCE).$(FILE_EXTENSION)", "",
    "", "",
    "file naming pattern",
    "file naming pattern used for a import session"
  },
  {
    "plugins/lighttable/layout",
    "int", "1", "",
    "", "",
    "lighttable layout mode",
    "select a layout for the lighttable: 0 - zoomable lighttable or 1 - file manager or 2 - culling layout."
  },
  {
    "plugins/lighttable/base_layout",
    "int", "1", "",
    "", "",
    "lighttable basic layout mode",
    "the layout to return to when exiting culling layout"
  },
  {
    "plugins/lighttable/images_in_row",
    "int", "5", "",
    "", "",
    "images per row",
    ""
  },
  {
    "plugins/lighttable/culling_num_images",
    "int", "2", "",
    "", "",
    "images to display in culling layout",
    ""
  },
  {
    "plugins/lighttable/culling_zoom_mode",
    "int", "0", "",
    "", "",
    "zoom mode in culling layout. 0=fixed ; 1=dynamic",
    ""
  },
  {
    "plugins/lighttable/culling_last_id",
    "int", "-1", "",
    "", "",
    "last culling first image id",
    ""
  },
  {
    "plugins/lighttable/recentcollect/num_items",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line0",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line1",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line2",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line3",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line4",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line5",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line6",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line7",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line8",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/recentcollect/line9",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/copy_history/pastemode",
    "int", "0", "",
    "", "",
    "append or replace history stack if pasted",
    "0 -- append on top of stack, 1 -- replace it."
  },
  {
    "plugins/lighttable/collect/single-click",
    "bool", "false", "",
    "", "",
    "use single-click in the collections module",
    "check this option to use single-click to select items in the collections module. this will allow you to do range selections for date-time and numeric values."
  },
  {
    "plugins/lighttable/act_on",
    "bool", "true", "",
    "", "",
    "prioritize the hovered image over the selected images",
    "this defines how the list of images to act on is constructed."
  },
  {
    "plugins/lighttable/collect/num_rules",
    "int", "1", "",
    "1", "10",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item0",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string0",
    "string", "%", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item1",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string1",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item2",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string2",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item3",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string3",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item4",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string4",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item5",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string5",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item6",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string6",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item7",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string7",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item8",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string8",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/item9",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/string9",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode0",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode1",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode2",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode3",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode4",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode5",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode6",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode7",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode8",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/collect/mode9",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/tagging/visible",
    "bool", "true", "",
    "", "",
    "show the tagging module in the darkroom view (as well as in lighttable)",
    ""
  },
  {
    "plugins/darkroom/export/visible",
    "bool", "true", "",
    "", "",
    "show the export module in the darkroom view (as well as in lighttable)",
    ""
  },
  {
    "plugins/lighttable/tagging/ask_before_delete_tag",
    "bool", "true", "",
    "", "",
    "ask before deleting a tag",
    ""
  },
  {
    "plugins/lighttable/tagging/dttags",
    "bool", "false", "",
    "", "",
    "whether to show darktable internal tags",
    ""
  },
  {
    "plugins/lighttable/tagging/nosuggestion",
    "bool", "false", "",
    "", "",
    "whether display suggestions",
    ""
  },
  {
    "plugins/lighttable/tagging/treeview",
    "bool", "false", "",
    "", "",
    "whether display tags in list or tree",
    ""
  },
  {
    "plugins/lighttable/tagging/hidehierarchy",
    "bool", "false", "",
    "", "",
    "whether to show/hide the tag hierarchy",
    ""
  },
  {
    "plugins/lighttable/tagging/listsortedbycount",
    "bool", "false", "",
    "", "",
    "whether to sort tags by count or by name",
    ""
  },
  {
    "plugins/lighttable/tagging/heightattachedwindow",
    "int", "100", "",
    "", "",
    "height of the tagging attached view",
    "maximum height the tagging attached view will grow to before scrolling"
  },
  {
    "plugins/lighttable/tagging/heightdictionarywindow",
    "int", "200", "",
    "", "",
    "height of the tagging dictionary view",
    "maximum height the tagging dictionary view will grow to before scrolling"
  },
  {
    "plugins/lighttable/tagging/confidence",
    "int", "50", "",
    "0", "100",
    "suggested tags level of confidence",
    "level of confidence to include the tag in the suggestions list, 0: all associated tags, 99: 99% matching associated tags, 100: no matching tag to show only recent tags (faster)"
  },
  {
    "plugins/lighttable/tagging/nb_recent_tags",
    "int", "20", "",
    "-1", "1000",
    "number of recently attached tags",
    "number of recently attached tags which are included in the suggestions list. the value `-1' disables the recent list"
  },
  {
    "plugins/lighttable/tagging/recent_tags",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/metadata/creator_text_height",
    "int", "1", "",
    "", "",
    "height of the metadata creator field",
    "maximum height the metadata textview will grow to before scrolling"
  },
  {
    "plugins/lighttable/metadata/publisher_text_height",
    "int", "1", "",
    "", "",
    "height of the metadata publisher field",
    "maximum height the metadata textview will grow to before scrolling"
  },
  {
    "plugins/lighttable/metadata/title_text_height",
    "int", "1", "",
    "", "",
    "height of the metadata title field",
    "maximum height the metadata textview will grow to before scrolling"
  },
  {
    "plugins/lighttable/metadata/description_text_height",
    "int", "1", "",
    "", "",
    "height of the metadata description field",
    "maximum height the metadata textview will grow to before scrolling"
  },
  {
    "plugins/lighttable/metadata/rights_text_height",
    "int", "1", "",
    "", "",
    "height of the metadata rights field",
    "maximum height the metadata textview will grow to before scrolling"
  },
  {
    "plugins/lighttable/metadata/notes_text_height",
    "int", "1", "",
    "", "",
    "height of the metadata notes field",
    "maximum height the metadata textview will grow to before scrolling"
  },
  {
    "plugins/lighttable/metadata/version name_text_height",
    "int", "1", "",
    "", "",
    "height of the metadata version name field",
    "maximum height the metadata textview will grow to before scrolling"
  },
  {
    "plugins/lighttable/style/ask_before_delete_style",
    "bool", "true", "",
    "", "",
    "ask before deleting a style",
    ""
  },
  {
    "plugins/lighttable/preset/ask_before_delete_preset",
    "bool", "true", "",
    "", "",
    "ask before deleting a preset",
    "will ask for confirmation before deleting or overwriting a preset"
  },
  {
    "plugins/lighttable/export/ask_before_export_overwrite",
    "bool", "true", "",
    "", "",
    "ask before exporting in overwrite mode",
    "will ask for confirmation before exporting files in overwrite mode"
  },
  {
    "plugins/map/show_map_osd",
    "bool", "true", "",
    "", "",
    N_("show OSD"),
    N_("toggle the visibility of the map overlays")
  },
  {
    "plugins/map/filter_images_drawn",
    "bool", "false", "",
    "", "",
    N_("filtered images"),
    N_("when set limit the images drawn to the current filmstrip")
  },
  {
    "plugins/map/max_images_drawn",
    "int", "100", "",
    "10", "100000",
    N_("max images"),
    N_("the maximum number of image thumbnails drawn on the map")
  },
  {
    "plugins/map/epsilon_factor",
    "int", "25", "",
    "1", "100",
    N_("group size factor"),
    N_("increase or decrease the spatial size of images groups on the map. can influence the calculation time")
  },
  {
    "plugins/map/min_images_per_group",
    "int", "1", "",
    "1", "10",
    N_("min images per group"),
    N_("the minimum number of images to set up an images group. can influence the calculation time.")
  },
  {
    "plugins/map/images_thumbnail",
    "enum", "thumbnail", "[thumbnail][count][none]",
     WRAP_TRANSLATION(C_("preferences", "thumbnail"))
     WRAP_TRANSLATION(C_("preferences", "count"))
     WRAP_TRANSLATION(C_("preferences", "none"))
    "", "",
    N_("thumbnail display"),
    N_("three options are available: images thumbnails, only the count of images of the group or nothing")
  },
  {
    "plugins/map/show_outline",
    "bool", "true", "",
    "", "",
    "Whether to highlight the search result on the map",
    ""
  },
  {
    "plugins/map/max_outline_nodes",
    "int", "10000", "",
    "", "",
    N_("max polygon points"),
    N_("limit the number of points imported with polygon in find location module")
  },
  {
    "plugins/lighttable/metadata_view/pretty_location",
    "bool", "true", "",
    "", "",
    "pretty print the image location",
    "show a more readable representation of the location in the image information module"
  },
  {
    "lighttable/ui/single_module",
    "bool", "false", "",
    "", "",
    "expand a single utility module at a time",
    "this option toggles the behavior of shift clicking in lighttable mode"
  },
  {
    "lighttable/ui/expose_statuses",
    "bool", "false", "",
    "", "",
    "always show thumbnail overlays",
    "show overlays (rating stars, 'edited' mark, etc) for all thumbnails in file manager, not only hovered one"
  },
  {
    "darkroom/ui/single_module",
    "bool", "true", "",
    "", "",
    "expand a single processing module at a time",
    "this option toggles the behavior of shift clicking in darkroom mode"
  },
  {
    "darkroom/ui/single_module_group_only",
    "bool", "true", "",
    "", "",
    "only collapse modules in current group",
    "if only expanding a single module at a time, only collapse other modules in the current group - ignore modules in other groups"
  },
  {
    "darkroom/ui/activate_expand",
    "bool", "false", "",
    "", "",
    "expand the module when it is activated, and collapse it when disabled",
    "this option allows to expand or collapse automatically the module when it is enabled or disabled."
  },
  {
    "darkroom/ui/overlay_contrast",
    "float", "0.5", "",
    "", "",
    "contrast to use in darkroom overlays",
    
  },
  {
    "lighttable/ui/scroll_to_module",
    "bool", "false", "",
    "", "",
    "scroll utility modules to the top when expanded",
    "when this option is enabled then darktable will try to scroll the module to the top of the visible list"
  },
  {
    "lighttable/ui/preview/bottom_visible",
    "bool", "true", "",
    "", "",
    "show bottom panel in preview mode",
    ""
  },
  {
    "lighttable/ui/preview/left_visible",
    "bool", "false", "",
    "", "",
    "show left panel in preview mode",
    ""
  },
  {
    "lighttable/ui/preview/right_visible",
    "bool", "false", "",
    "", "",
    "show right panel in preview mode",
    ""
  },
  {
    "lighttable/ui/preview/header_visible",
    "bool", "false", "",
    "", "",
    "show header panel in preview mode",
    ""
  },
  {
    "lighttable/ui/preview/toolbar_bottom_visible",
    "bool", "false", "",
    "", "",
    "show toolbar bottom panel in preview mode",
    ""
  },
  {
    "lighttable/ui/preview/toolbar_top_visible",
    "bool", "false", "",
    "", "",
    "show toolbar top panel in preview mode",
    ""
  },
  {
    "lighttable/ui/preview/panels_collapse_controls",
    "bool", "false", "",
    "", "",
    "show borders arrows in preview mode",
    ""
  },
  {
    "lighttable/ui/preview/panel_collaps_state",
    "int", "1", "",
    "", "",
    "panels collapsing state in preview mode",
    ""
  },
  {
    "slideshow/ui/panels_collapse_controls",
    "bool", "false", "",
    "", "",
    "show borders arrows in slideshow",
    ""
  },
  {
    "slideshow/ui/panel_collaps_state",
    "int", "1", "",
    "", "",
    "panels collapsing state in slideshow",
    ""
  },
  {
    "darkroom/ui/scroll_to_module",
    "bool", "true", "",
    "", "",
    "scroll processing modules to the top when expanded",
    "when this option is enabled then darktable will try to scroll the module to the top of the visible list"
  },
  {
    "darkroom/ui/sidebar_scroll_default",
    "bool", "false", "",
    "", "",
    "mouse wheel scrolls modules side panel by default",
    "when enabled, use mouse wheel to scroll modules side panel.  use ctrl+alt to use mouse wheel for data entry.  when disabled, this behavior is reversed"
  },
  {
    "plugins/darkroom/ui/border_size",
    "int", "10", "",
    "", "",
    "border around image in darkroom mode",
    "process the image in darkroom mode with a small border. set to 0 if you don't want any border."
  },
  {
    "darkroom/ui/color_assessment_total_border_width",
    "float", "0.2", "",
    "0.05", "0.4",
    "total border width relative to screen size in color assessment mode",
    
  },
  {
    "darkroom/ui/color_assessment_border_white_ratio",
    "float", "0.40", "",
    "0.1", "0.9",
    "white fraction border in color assessment mode",
    ""
  },
  {
    "darkroom/ui/scrollbars",
    "bool", "false", "",
    "", "",
    "show scrollbars for central view",
    "defines whether scrollbars should be displayed"
  },
  {
    "panel_scrollbars_always_visible",
    "bool", "true", "",
    "", "",
    "always show panels' scrollbars",
    "defines whether the panel scrollbars should be always visible or activated only depending on the content. (restart required)"
  },
  {
    "darkroom/ui/transition_duration",
    "int", "250", "",
    "0", "1000",
    "duration of the UI transitions in ms",
    "how long the transitions take (in ms) for expanding or collapsing modules and other UI elements"
  },
  {
    "ui/style/preview_size",
    "int", "250", "",
    "100", "500",
    "max style preview size",
    
  },
  {
    "ui_last/expander_metadata",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/expander_navigation",
    "int", "-1", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/expander_histogram",
    "int", "-1", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/expander_snapshots",
    "int", "-1", "",
    "", "",
    "",
    ""
  },
  {
    "ui_last/expander_history",
    "int", "-1", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/export/force_lcms2",
    "bool", "false", "",
    "", "",
    "always use LittleCMS 2 to apply output color profile",
    "this is slower than the default."
  },
  {
    "plugins/lighttable/export/high_quality_processing",
    "bool", "false", "",
    "", "",
    "do high quality resampling during export",
    "the image will first be processed in full resolution, and downscaled at the very end. this can result in better quality sometimes, but will always be slower."
  },
  {
    "rating_one_double_tap",
    "bool", "false", "",
    "", "",
    "rating an image one star twice will not zero out the rating",
    "defines whether rating an image one star twice will zero out star rating"
  },
  {
    "lighttable/ui/scrollbars",
    "bool", "true", "",
    "", "",
    "show scrollbars for central view",
    "defines whether scrollbars should be displayed"
  },
  {
    "lighttable/ui/milliseconds",
    "bool", "false", "",
    "", "",
    "show image time with milliseconds",
    "defines whether time should be displayed with milliseconds"
  },
  {
    "darkroom/ui/rawoverexposed/mode",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "darkroom/ui/rawoverexposed/colorscheme",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "darkroom/ui/rawoverexposed/threshold",
    "float", "1.0", "",
    "", "",
    "",
    ""
  },
  {
    "darkroom/ui/overexposed/colorscheme",
    "int", "1", "",
    "", "",
    "",
    ""
  },
  {
    "darkroom/ui/overexposed/lower",
    "float", "-12.69", "",
    "", "",
    "",
    ""
  },
  {
    "darkroom/ui/overexposed/upper",
    "float", "99.99", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/channelmixerrgb/gui_page",
    "int", "0", "",
    "", "",
    "last page selected in channel mixer rgb notebook",
    
  },
  {
    "plugins/darkroom/retouch/default_algo",
    "int", "2", "",
    "", "",
    "default algorithm for the retouch module",
    
  },
  {
    "plugins/darkroom/demosaic/fdc_xover_iso",
    "int", "1600", "",
    "", "",
    "crossover ISO for X-Trans FDC demosaicing",
    "up to, and including, this ISO, X-Trans frequency domain chroma demosaicing uses the hybrid mode for determining chroma; for all higher ISO values the pure FDC is used."
  },
  {
    "plugins/darkroom/denoiseprofile/show_compute_variance_mode",
    "bool", "false", "",
    "", "",
    "whether to show the compute variance mode in denoiseprofile",
    "adds a mode in denoiseprofile that allows to compute the variance after the generalized anscombe transform is performed"
  },
  {
    "preview_downsampling",
    "enum", "original", "[original][to 1/2][to 1/3][to 1/4]",
     WRAP_TRANSLATION(C_("preferences", "original"))
     WRAP_TRANSLATION(C_("preferences", "to 1/2"))
     WRAP_TRANSLATION(C_("preferences", "to 1/3"))
     WRAP_TRANSLATION(C_("preferences", "to 1/4"))
    "", "",
    "reduce resolution of preview image",
    "decrease to speed up preview rendering, hinders accurate masking, pickers and some module algorithm"
  },
  {
    "darkroom/ui/loading_screen",
    "bool", "true", "",
    "", "",
    "show loading screen between images",
    "show gray loading screen when navigating between images in the darkroom\ndisable to just show a toast message"
  },
  {
    "darkroom/ui/develop_mask_mix",
    "float", "0.3", "",
    "", "",
    "show mask in mixed mode",
    "the mask visualize button will show the mask mixed with image content. 0 shows only content, 1 only the mask. Choose any value between."
  },
  {
    "plugins/lighttable/export/pixel_interpolator_warp",
    "enum", "bicubic", "[bilinear][bicubic][lanczos2]",
     WRAP_TRANSLATION(C_("preferences", "bilinear"))
     WRAP_TRANSLATION(C_("preferences", "bicubic"))
     WRAP_TRANSLATION(C_("preferences", "lanczos2"))
    "", "",
    "pixel interpolator (warp)",
    "pixel interpolator used in modules for rotation, lens correction, liquify, cropping and final scaling (bilinear, bicubic, lanczos2)."
  },
  {
    "plugins/lighttable/export/pixel_interpolator",
    "enum", "lanczos3", "[bilinear][bicubic][lanczos2][lanczos3]",
     WRAP_TRANSLATION(C_("preferences", "bilinear"))
     WRAP_TRANSLATION(C_("preferences", "bicubic"))
     WRAP_TRANSLATION(C_("preferences", "lanczos2"))
     WRAP_TRANSLATION(C_("preferences", "lanczos3"))
    "", "",
    "pixel interpolator (scaling)",
    "pixel interpolator used for scaling (bilinear, bicubic, lanczos2, lanczos3)."
  },
  {
    "plugins/lighttable/export/dimensions_type",
    "int", "0", "",
    "0", "",
    "unit of the printing size",
    "unit in which to input the image size."
  },
  {
    "plugins/lighttable/export/print_dpi",
    "int", "300", "",
    "72", "9600",
    "DPI",
    "print resolusion in DPI."
  },
  {
    "plugins/lighttable/export/width",
    "int", "0", "",
    "0", "",
    "width of the exported image",
    "width of the exported image, or 0 if no scaling should be done."
  },
  {
    "plugins/lighttable/export/height",
    "int", "0", "",
    "0", "",
    "height of the exported image",
    "height of the exported image, or 0 if no scaling should be done."
  },
  {
    "plugins/lighttable/export/storage_name",
    "string", "disk", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/export/format_name",
    "string", "jpeg", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/lighttable/export/style",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/storage/disk/file_directory",
    "string", "$(FILE_FOLDER)/darktable_exported/$(FILE_NAME)", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/storage/gallery/file_directory",
    "string", "$(HOME)/darktable_gallery/img_$(SEQUENCE)", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/storage/gallery/title",
    "string", "darktable gallery", "",
    "", "",
    "",
    ""
  },
  {
    "context_help/use_default_url",
    "boolean", "true", "",
    "", "",
    "",
    ""
  },
  {
    "context_help/url",
    "string", "https://docs.darktable.org/usermanual/", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/storage/email/client",
    "string", "", "",
    "", "",
    "client to use, this overrides detection of default client.",
    ""
  },
  {
    "plugins/imageio/storage/gphoto/id",
    "string", "642055548087-n01fgvugnbns7a9jq8jfucjsn5l1t6so.apps.googleusercontent.com", "",
    "", "",
    "google photo client id",
    ""
  },
  {
    "plugins/imageio/storage/gphoto/secret",
    "string", "o29QcbsDWS5cauRqdmGdF3sP", "",
    "", "",
    "google photo client secret",
    ""
  },
  {
    "plugins/imageio/format/pdf/size",
    "string", "a4", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/pdf/border",
    "string", "0 mm", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/pdf/dpi",
    "float", "300", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/pdf/bpp",
    "enum", "8", "[8][16]",
    "", "",
    "PDF bit depth (bpp)",
    ""
  },
  {
    "plugins/imageio/format/pdf/compression",
    "int", "1", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/exr/bpp",
    "enum", "32", "[16][32]",
    "", "",
    "EXR float bit depth (bpp)",
    ""
  },
  {
    "plugins/imageio/format/exr/compression",
    "int", "4", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/jpeg/quality",
    "int", "95", "",
    "5", "100",
    "",
    ""
  },
  {
    "plugins/imageio/format/j2k/quality",
    "int", "95", "",
    "5", "100",
    "",
    ""
  },
  {
    "plugins/imageio/format/tiff/bpp",
    "enum", "8", "[8][16][32]",
    "", "",
    "TIFF bit depth (bpp)",
    ""
  },
  {
    "plugins/imageio/format/tiff/pixelformat",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/tiff/compress",
    "int", "2", "",
    "0", "2",
    "",
    ""
  },
  {
    "plugins/imageio/format/tiff/compresslevel",
    "int", "6", "",
    "1", "9",
    "",
    ""
  },
  {
    "plugins/imageio/format/tiff/shortfile",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/png/bpp",
    "enum", "8", "[8][16]",
    "", "",
    "PNG bit depth (bpp)",
    ""
  },
  {
    "plugins/imageio/format/png/compression",
    "int", "5", "",
    "0", "9",
    "",
    ""
  },
  {
    "plugins/imageio/format/jxl/bpp",
    "enum", "8", "[8][10][12][16][32]",
    "", "",
    "JPEG XL bit depth (bpp)",
    ""
  },
  {
    "plugins/imageio/format/jxl/pixel_type",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/jxl/quality",
    "int", "95", "",
    "4", "100",
    "",
    ""
  },
  {
    "plugins/imageio/format/jxl/original",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/jxl/effort",
    "int", "7", "",
    "1", "9",
    "",
    ""
  },
  {
    "plugins/imageio/format/jxl/tier",
    "int", "0", "",
    "0", "4",
    "",
    ""
  },
  {
    "plugins/imageio/format/webp/comp_type",
    "int", "0", "",
    "0", "1",
    "",
    ""
  },
  {
    "plugins/imageio/format/webp/quality",
    "int", "95", "",
    "0", "100",
    "",
    ""
  },
  {
    "plugins/imageio/format/webp/hint",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/avif/bpp",
    "enum", "8", "[8][10][12]",
    "", "",
    "AVIF bit depth (bpp)",
    ""
  },
  {
    "plugins/imageio/format/avif/color_mode",
    "bool", "false", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/imageio/format/avif/tiling",
    "bool", "true", "",
    "", "",
    "AVIF Tiling",
    ""
  },
  {
    "plugins/imageio/format/avif/compression_type",
    "int", "1", "",
    "0", "1",
    "",
    ""
  },
  {
    "plugins/imageio/format/avif/quality",
    "int", "90", "",
    "0", "100",
    "",
    ""
  },
  {
    "plugins/imageio/format/xcf/bpp",
    "enum", "32", "[8][16][32]",
    "", "",
    "XCF bit depth (bpp)",
    ""
  },
  {
    "plugins/pwstorage/pwstorage_backend",
    "enum", "auto", "[auto][none][libsecret][kwallet][apple_keychain][windows_credentials]",
     WRAP_TRANSLATION(C_("preferences", "auto"))
     WRAP_TRANSLATION(C_("preferences", "none"))
     WRAP_TRANSLATION(C_("preferences", "libsecret"))
     WRAP_TRANSLATION(C_("preferences", "kwallet"))
     WRAP_TRANSLATION(C_("preferences", "apple_keychain"))
     WRAP_TRANSLATION(C_("preferences", "windows_credentials"))
    "", "",
    "password storage backend to use",
    "the storage backend for password storage: auto, none, libsecret, kwallet, apple_keychain, windows_credentials"
  },
  {
    "plugins/imageio/storage/export/auto_login",
    "bool", "false", "",
    "", "",
    "auto login to storage server",
    "automatically login to the configured storage server. this requires that a password storage backend is set."
  },
  {
    "plugins/lighttable/export/icctype",
    "int", "-1", "",
    "", "",
    "ICC profile type to use for export",
    "this overrides the per-image settings, if not set to -1."
  },
  {
    "plugins/lighttable/export/iccprofile",
    "string", "", "",
    "", "",
    "ICC profile filename to use for export",
    "this overrides the per-image settings, if icctype not set to -1."
  },
  {
    "plugins/lighttable/export/iccintent",
    "int", "-1", "",
    "", "",
    "ICC rendering intent",
    "if non-negative, this overrides the per-image output color profile rendering intent on export."
  },
  {
    "plugins/darkroom/groups",
    "int", "2", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/active",
    "string", "", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/circle_size",
    "float", "0.02", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/circle_border",
    "float", "0.02", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/ellipse_radius_a",
    "float", "0.02", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/ellipse_radius_b",
    "float", "0.01414", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/ellipse_border",
    "float", "0.02", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/ellipse_rotation",
    "float", "90.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/ellipse_flags",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/path_border",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/brush_border",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/brush_density",
    "float", "1.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/spots/brush_hardness",
    "float", "0.66", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/clipping/ratio_d",
    "int", "0", "",
    "", "",
    "last chosen aspect ratio denominator",
    ""
  },
  {
    "plugins/darkroom/clipping/ratio_n",
    "int", "0", "",
    "", "",
    "last chosen aspect ratio numerator",
    ""
  },
  {
    "plugins/darkroom/clipping/guide",
    "int", "0", "",
    "", "",
    "last chosen guide style",
    ""
  },
  {
    "plugins/darkroom/histogram/graphheight",
    "int", "180", "",
    "100", "300",
    "height of the scopes module",
    "height of the scopes module in the darkroom and tethering views"
  },
  {
    "plugins/darkroom/colorequal/graphheight",
    "int", "200", "",
    "100", "300",
    "height of the colorequal module",
    "height of the colorequal module"
  },
  {
    "plugins/darkroom/navigation/graphheight",
    "int", "200", "",
    "100", "300",
    "height of the navigation module",
    "height of the navigation module in the darkroom"
  },
  {
    "plugins/darkroom/atrous/graphheight",
    "int", "200", "",
    "100", "300",
    "height of contrast equalizer",
    "height of contrast equalizer"
  },
  {
    "plugins/darkroom/denoiseprofile/graphheight",
    "int", "200", "",
    "100", "300",
    "height of denoise (profiled) wavelets",
    "height of denoise (profiled) wavelets"
  },
  {
    "plugins/darkroom/rawdenoise/graphheight",
    "int", "200", "",
    "100", "300",
    "height of raw denoise wavelets",
    "height of raw denoise wavelets"
  },
  {
    "plugins/darkroom/colorzones/graphheight",
    "int", "200", "",
    "100", "300",
    "height of color zones graph in per cent",
    "height of color zones graph in per cent"
  },
  {
    "plugins/darkroom/lowlight/graphheight",
    "int", "200", "",
    "100", "300",
    "height of lowlight graph in per cent",
    "height of lowlight graph in per cent"
  },
  {
    "plugins/darkroom/levels/graphheight",
    "int", "200", "",
    "100", "300",
    "height of levels graph in per cent",
    "height of levels graph in per cent"
  },
  {
    "plugins/darkroom/rgblevels/graphheight",
    "int", "200", "",
    "100", "300",
    "height of rgb levels graph in per cent",
    "height of rgb levels graph in per cent"
  },
  {
    "plugins/darkroom/filmicrgb/graphheight",
    "int", "200", "",
    "100", "300",
    "height of filmic rgb graph in per cent",
    "height of filmic rgb graph in per cent"
  },
  {
    "plugins/darkroom/colorbalancergb/graphheight",
    "int", "200", "",
    "100", "300",
    "height of color balance rgb graph in per cent",
    "height of color balance rgb graph in per cent"
  },
  {
    "plugins/darkroom/histogram/mode",
    "enum", "waveform", "[vectorscope][waveform][RGB parade][histogram]",
     WRAP_TRANSLATION(C_("preferences", "vectorscope"))
     WRAP_TRANSLATION(C_("preferences", "waveform"))
     WRAP_TRANSLATION(C_("preferences", "RGB parade"))
     WRAP_TRANSLATION(C_("preferences", "histogram"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/panel_position",
    "enum", "right", "[left][right]",
     WRAP_TRANSLATION(C_("preferences", "left"))
     WRAP_TRANSLATION(C_("preferences", "right"))
    "", "",
    "position of the scopes module",
    "position the scopes at the top-left or top-right of the screen"
  },
  {
    "plugins/darkroom/panel_swap",
    "bool", "false", "",
    "", "",
    "swap the utility and processing modules panels",
    "move the list of processing modules to the left of the screen"
  },
  {
    "plugins/darkroom/histogram/histogram",
    "enum", "logarithmic", "[logarithmic][linear]",
     WRAP_TRANSLATION(C_("preferences", "logarithmic"))
     WRAP_TRANSLATION(C_("preferences", "linear"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/orient",
    "enum", "horizontal", "[horizontal][vertical]",
     WRAP_TRANSLATION(C_("preferences", "horizontal"))
     WRAP_TRANSLATION(C_("preferences", "vertical"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/waveform",
    "enum", "overlaid", "[overlaid][parade]",
     WRAP_TRANSLATION(C_("preferences", "overlaid"))
     WRAP_TRANSLATION(C_("preferences", "parade"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/vectorscope",
    "enum", "u*v*", "[u*v*][AzBz][RYB]",
     WRAP_TRANSLATION(C_("preferences", "u*v*"))
     WRAP_TRANSLATION(C_("preferences", "AzBz"))
     WRAP_TRANSLATION(C_("preferences", "RYB"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/vectorscope/scale",
    "enum", "logarithmic", "[logarithmic][linear]",
     WRAP_TRANSLATION(C_("preferences", "logarithmic"))
     WRAP_TRANSLATION(C_("preferences", "linear"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/vectorscope/angle",
    "int", "270", "",
    "", "",
    "",
    "Angle in degrees to orient the vectorscope. 0 is the color science proper orientation (see CIE 1976 UCS diagram). 270 is what video editors are used to when using a vectorscope (with red/magenta in 12:00 position)."
  },
  {
    "plugins/darkroom/histogram/show_red",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/show_green",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/show_blue",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/vectorscope/harmony_type",
    "enum", "none", "[none][monochromatic][analogous][analogous complementary][complementary][split complementary][dyad][triad][tetrad][square]",
     WRAP_TRANSLATION(C_("preferences", "none"))
     WRAP_TRANSLATION(C_("preferences", "monochromatic"))
     WRAP_TRANSLATION(C_("preferences", "analogous"))
     WRAP_TRANSLATION(C_("preferences", "analogous complementary"))
     WRAP_TRANSLATION(C_("preferences", "complementary"))
     WRAP_TRANSLATION(C_("preferences", "split complementary"))
     WRAP_TRANSLATION(C_("preferences", "dyad"))
     WRAP_TRANSLATION(C_("preferences", "triad"))
     WRAP_TRANSLATION(C_("preferences", "tetrad"))
     WRAP_TRANSLATION(C_("preferences", "square"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/vectorscope/harmony_rotation",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/vectorscope/harmony_width",
    "enum", "normal", "[normal][large][narrow][line]",
     WRAP_TRANSLATION(C_("preferences", "normal"))
     WRAP_TRANSLATION(C_("preferences", "large"))
     WRAP_TRANSLATION(C_("preferences", "narrow"))
     WRAP_TRANSLATION(C_("preferences", "line"))
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/histogram/vectorscope/harmony/dim",
    "float", "0.7", "",
    "0", "1",
    "dim pixels outside of guides",
    ""
  },
  {
    "plugins/darkroom/masks/opacity",
    "float", "1.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/circle/size",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/circle/border",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/ellipse/radius_a",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/ellipse/radius_b",
    "float", "0.03535", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/ellipse/border",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/ellipse/rotation",
    "float", "90.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/ellipse/flags",
    "int", "0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/path/border",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/gradient/rotation",
    "float", "0.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/gradient/compression",
    "float", "0.5", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/gradient/steepness",
    "float", "0.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/brush/border",
    "float", "0.05", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/brush/density",
    "float", "1.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/brush/hardness",
    "float", "0.66", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/masks/heightview",
    "int", "300", "",
    "100", "1000",
    "height of mask manager view window",
    "maximum height the masks view in darkroom will grow to before scrolling"
  },
  {
    "plugins/darkroom/ashift/near_delta",
    "float", "20.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/ashift/near_delta_draw",
    "float", "5.0", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/print/print/black_point_compensation",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/print/print/grid_size",
    "float", "10", "",
    "0", "100",
    "",
    ""
  },
  {
    "plugins/print/print/unit",
    "enum", "mm", "[mm][cm][inch]",
     WRAP_TRANSLATION(C_("preferences", "mm"))
     WRAP_TRANSLATION(C_("preferences", "cm"))
     WRAP_TRANSLATION(C_("preferences", "inch"))
    "", "",
    "measurement units",
    ""
  },
  {
    "plugins/print/print/top_margin",
    "float", "17", "",
    "-50", "500",
    "",
    ""
  },
  {
    "plugins/print/print/bottom_margin",
    "float", "17", "",
    "-50", "500",
    "",
    ""
  },
  {
    "plugins/print/print/left_margin",
    "float", "17", "",
    "-50", "500",
    "",
    ""
  },
  {
    "plugins/print/print/right_margin",
    "float", "17", "",
    "-50", "500",
    "",
    ""
  },
  {
    "ui_last/theme",
    "string", "darktable-elegant-grey", "",
    "", "",
    "darktable theme",
    
  },
  {
    "ui_last/display_profile_source",
    "enum", "all", "[all][xatom][colord]",
     WRAP_TRANSLATION(C_("preferences", "all"))
     WRAP_TRANSLATION(C_("preferences", "xatom"))
     WRAP_TRANSLATION(C_("preferences", "colord"))
    "", "",
    "method to use for getting the display profile",
    "this option allows to force a specific means of getting the current display profile.\nthis is useful when one alternative gives wrong results"
  },
  {
    "metadata/resolution",
    "int", "300", "",
    "72", "9600",
    "DPI value for exported files",
    ""
  },
  {
    "run_crawler_on_start",
    "bool", "false", "",
    "", "",
    "look for updated XMP files on startup",
    "check file modification times of all XMP files on startup to check if any got updated in the meantime"
  },
  {
    "colorlabel/red",
    "string", "", "",
    "", "",
    "red color label",
    
  },
  {
    "colorlabel/yellow",
    "string", "", "",
    "", "",
    "yellow color label",
    
  },
  {
    "colorlabel/green",
    "string", "", "",
    "", "",
    "green color label",
    
  },
  {
    "colorlabel/blue",
    "string", "", "",
    "", "",
    "blue color label",
    
  },
  {
    "colorlabel/purple",
    "string", "", "",
    "", "",
    "purple color label",
    
  },
  {
    "plugins/lighttable/audio_player",
    "string", "aplay", "",
    "", "",
    "executable for playing audio files",
    "this external program is used to play audio files some cameras record to keep notes for images"
  },
  {
    "plugins/darkroom/lut3d/def_path",
    "dir", "$(home)", "",
    "", "",
    "LUT 3D root folder",
    "this folder (and sub-folders) contains LUT files used by LUT 3D module. (restart required)"
  },
  {
    "plugins/darkroom/segments/def_path",
    "dir", "$(home)", "",
    "", "",
    "raster mask files root folder",
    "this folder (and sub-folders) contains PFM files used by the raster mask import module. (restart required)"
  },
  {
    "plugins/darkroom/workflow",
    "enum", "scene-referred (sigmoid)", "[scene-referred (sigmoid)][scene-referred (filmic)][display-referred (legacy)][none]",
     WRAP_TRANSLATION(C_("preferences", "scene-referred (sigmoid)"))
     WRAP_TRANSLATION(C_("preferences", "scene-referred (filmic)"))
     WRAP_TRANSLATION(C_("preferences", "display-referred (legacy)"))
     WRAP_TRANSLATION(C_("preferences", "none"))
    "", "",
    "auto-apply pixel workflow defaults",
    "scene-referred workflow is based on linear modules and will auto-apply filmic or sigmoid, color calibration and exposure,\ndisplay-referred workflow is based on Lab modules and will auto-apply base curve, white balance and the legacy module pipe order."
  },
  {
    "plugins/darkroom/basecurve/auto_apply_percamera_presets",
    "bool", "false", "",
    "", "",
    "auto-apply per camera basecurve presets",
    "use the per-camera basecurve by default instead of the generic manufacturer one if there is one available. (restart required)\nthis option is taken into account when the \"auto-apply pixel workflow defaults\" is set to \"display-referred\".\nto prevent auto-apply basecurve presets \"auto-apply pixel workflow defaults\" should be set to \"none\""
  },
  {
    "ui/detect_mono_exif",
    "bool", "false", "",
    "", "",
    "detect monochrome previews",
    "many monochrome images can be identified via EXIF and preview data. beware: this slows down imports and reading of EXIF data"
  },
  {
    "plugins/darkroom/show_warnings",
    "bool", "true", "",
    "", "",
    "show warning messages",
    "display messages in modules to warn beginner users when non-standard and possibly harmful settings are used in the pipeline.\nthese messages can be false-positive and should be disregarded if you know what you are doing. this option will hide them all the time."
  },
  {
    "screen_dpi_overwrite",
    "float", "-1.0", "",
    "", "",
    "overwrite the screen's dpi setting",
    "if this value is > 0.0 then it is used as the screen's dpi setting which is used to scale the gui"
  },
  {
    "plugins/lighttable/preview/max_in_memory_images",
    "int", "4", "",
    "", "",
    "maximum number of full-res images to load in memory",
    "if more images are display in expose mode, zooming will be deactivated"
  },
  {
    "codepaths/openmp_simd",
    "bool", "false", "",
    "", "",
    "enable usage of OpenMP SIMD codepaths. if enabled, and such codepath exists, it will have the highest priority",
    ""
  },
  {
    "allow_lab_output",
    "bool", "false", "",
    "", "",
    "allow XYZ and Lab color spaces as output",
    "this is mainly useful for debugging and to create colorchecker LUT styles externally."
  },
  {
    "plugins/darkroom/rawprepare/allow_editing_crop",
    "bool", "false", "",
    "", "",
    "allow editing raw cropping boundaries",
    "this is mainly useful for debugging and to add new camera support."
  },
  {
    "darkroom/modules/exposure/lightness",
    "float", "50.0", "",
    "", "",
    "lightness spot in exposure compensation",
    
  },
  {
    "darkroom/modules/channelmixerrgb/colorchecker",
    "int", "0", "",
    "", "",
    "current colorchecker model used",
    
  },
  {
    "darkroom/modules/channelmixerrgb/optimization",
    "int", "0", "",
    "", "",
    "current colorchecker optimization mode",
    
  },
  {
    "darkroom/modules/channelmixerrgb/safety",
    "float", "0.5", "",
    "", "",
    "patch scale, safety margin",
    
  },
  {
    "plugins/darkroom/modulegroups_preset",
    "string", "", "",
    "", "",
    "preset use for defining iop layout",
    "preset use for defining iop layout"
  },
  {
    "plugins/darkroom/modulegroups_basics_sections_labels",
    "bool", "true", "",
    "", "",
    "show the name of the module of each basic widget",
    "show the name of the module of each basic widget"
  },
  {
    "plugins/lighttable/geotagging/heighttracklist",
    "int", "50", "",
    "", "",
    "height of the track list",
    "maximum height the track list will grow to before scrolling"
  },
  {
    "plugins/lighttable/geotagging/tz",
    "string", "UTC", "",
    "", "",
    N_("camera time zone"),
    N_("most cameras don't store the time zone in EXIF. give the correct time zone so the GPX data can be correctly matched")
  },
  {
    "plugins/map/geotagging_search_url",
    "string", "https://nominatim.openstreetmap.org/search?q=%s&format=xml&limit=%d&polygon_text=1", "",
    "", "",
    "Geotagging search URL",
    "this can be changed when the default OpenStreetMap search URL is broken"
  },
  {
    "plugins/darkroom/temperature/colored_sliders",
    "enum", "no color", "[no color][illuminant color][effect emulation]",
     WRAP_TRANSLATION(C_("preferences", "no color"))
     WRAP_TRANSLATION(C_("preferences", "illuminant color"))
     WRAP_TRANSLATION(C_("preferences", "effect emulation"))
    "", "",
    "white balance slider colors",
    "visual indication of temperature adjustments.\nin 'illuminant color' mode slider colors represent the color of the light source,\nin 'effect emulation' slider colors represent the effect the adjustment would have on the scene"
  },
  {
    "plugins/darkroom/temperature/expand_coefficients",
    "bool", "false", "",
    "", "",
    "whether to show coefficients",
    "this is just for remembering whether to show coefficients or not and remember it"
  },
  {
    "plugins/darkroom/temperature/button_bar",
    "bool", "true", "",
    "", "",
    "arange buttons as bar below temp/tint sliders",
    "if enabled, the buttons in white balance module will be arranged below temp/tint sliders, otherwise they'll be shown in a grid to the right of temp/tint sliders"
  },
  {
    "plugins/darkroom/crop/expand_margins",
    "bool", "false", "",
    "", "",
    "whether to show margins",
    "this is just for remembering whether to show margins or not and remember it"
  },
  {
    "plugins/darkroom/ashift/expand_values",
    "bool", "false", "",
    "", "",
    "whether to show values",
    "this is just for remembering whether to show values or not"
  },
  {
    "plugins/darkroom/ashift/autocrop_value",
    "int", "1", "",
    "", "",
    "auto-crop mode",
    "0=off ; 1= largest area ; 2= original image"
  },
  {
    "plugins/darkroom/colorzones/bg_sat_factor",
    "float", "0.5", "",
    "0.1", "1.0",
    "saturation factor of the color zones background",
    "higher value means more saturated backgrounds in color zones"
  },
  {
    "plugins/darkroom/colorbalance/layout",
    "enum", "list", "[list][tabs][columns]",
     WRAP_TRANSLATION(C_("preferences", "list"))
     WRAP_TRANSLATION(C_("preferences", "tabs"))
     WRAP_TRANSLATION(C_("preferences", "columns"))
    "", "",
    "color balance slider block layout",
    "choose how to organise the slider blocks for lift, gamma and gain:\n'list' - all sliders are shown in one long list (with headers),\n'tabs' - use tabs to switch between the blocks of sliders,\n'columns' - the blocks of sliders are shown next to each other (in narrow columns)"
  },
  {
    "darkroom/ui/hide_header_buttons",
    "enum", "always", "[always][active][dim][auto][fade][fit][smooth][glide]",
     WRAP_TRANSLATION(C_("preferences", "always"))
     WRAP_TRANSLATION(C_("preferences", "active"))
     WRAP_TRANSLATION(C_("preferences", "dim"))
     WRAP_TRANSLATION(C_("preferences", "auto"))
     WRAP_TRANSLATION(C_("preferences", "fade"))
     WRAP_TRANSLATION(C_("preferences", "fit"))
     WRAP_TRANSLATION(C_("preferences", "smooth"))
     WRAP_TRANSLATION(C_("preferences", "glide"))
    "", "",
    "show right-side buttons in processing module headers",
    "when the mouse is not over a module, the multi-instance, reset and preset buttons can be hidden:\n - 'always': always show all buttons,\n - 'active': only show the buttons when the mouse is over the module,\n - 'dim': buttons are dimmed when mouse is away,\n - 'auto': hide the buttons when the panel is narrow,\n - 'fade': fade out all buttons when panel narrows,\n - 'fit': hide all the buttons if the module name doesn't fit,\n - 'smooth': fade out all buttons in one header simultaneously,\n - 'glide': gradually hide individual buttons as needed"
  },
  {
    "darkroom/ui/show_mask_indicator",
    "bool", "true", "",
    "", "",
    "show mask indicator in module headers",
    "if enabled, an icon will be shown in the header of any processing modules that have a mask applied"
  },
  {
    "darkroom/ui/rename_new_instance",
    "bool", "false", "",
    "", "",
    "prompt for name on addition of new instance",
    "if enabled, a rename prompt will be present for each new module instance (either new instance or duplicate)"
  },
  {
    "darkroom/ui/auto_module_name_update",
    "bool", "true", "",
    "", "",
    "automatically update module name",
    "if enabled, the module name will be automatically updated to match a preset name or a preset instance name if present."
  },
  {
    "plugins/darkroom/temperature/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/exposure/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/colorbalance/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/colorin/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/clipping/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/crop/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/sharpen/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/basecurve/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/highlights/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/demosaic/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/rgblevels/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/flip/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/bilat/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/denoiseprofile/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/hazeremoval/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/toneequal/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "plugins/darkroom/lens/visible",
    "bool", "true", "",
    "", "",
    "",
    ""
  },
  {
    "darkroom/ui/scale_step_multiplier",
    "float", "1.0", "",
    "", "",
    "the multiplier that is applied to any slider value change",
    "any slider value change will be multiplied by this number, when slider precision is set to normal"
  },
  {
    "darkroom/ui/scale_rough_step_multiplier",
    "float", "10.0", "",
    "", "",
    "the multiplier that is applied to any slider rough value change",
    "any slider value change will be multiplied by this number, when slider precision is set to coarse"
  },
  {
    "darkroom/ui/scale_precise_step_multiplier",
    "float", "0.1", "",
    "", "",
    "the multiplier that is applied to any slider precise value change",
    "any slider value change will be multiplied by this number, when slider precision is set to fine"
  },
  {
    "darkroom/undo/merge_same_secs",
    "float", "10", "",
    "", "",
    "the interval within which same widget changes are merged for undo",
    "when continuously manipulating the same widget (slider, curve) no new undo records are created during this time"
  },
  {
    "darkroom/undo/review_secs",
    "float", "2", "",
    "", "",
    "create new undo record after reviewing last change to same widget this long",
    "when continuing to change the same widget after a period of review allow undo to return to this state"
  },
  {
    "performance_configuration_version_completed",
    "int", "0", "",
    "", "",
    "version of the last completed performance configuration",
    "what was the last performance configuration which has been completed"
  },
  {
    "plugins/darkroom/duplicate/windowheight",
    "int", "400", "",
    "", "",
    "height of the duplicates view",
    "maximum height the duplicates view in darkroom will grow to before scrolling"
  },
  {
    "plugins/darkroom/colorpicker/windowheight",
    "int", "200", "",
    "", "",
    "height of the color picker list",
    "maximum height the color picker samples list in darkroom will grow to before scrolling"
  },
  {
    "plugins/darkroom/history/windowheight",
    "int", "1000", "",
    "", "",
    "height of the history list",
    "maximum height the history list in darkroom will grow to before scrolling"
  },
  {
    "plugins/lighttable/metadata_view/windowheight",
    "int", "1000", "",
    "", "",
    "height of the image information view",
    "maximum height the image information view in lighttable and darkroom will grow to before scrolling"
  },
  {
    "plugins/lighttable/recentcollect/windowheight",
    "int", "1000", "",
    "", "",
    "height of the recent collections list",
    "maximum height the recent collections list in lighttable will grow to before scrolling"
  },
  {
    "plugins/darkroom/snapshots/windowheight",
    "int", "200", "",
    "", "",
    "height of the snapshots list",
    "maximum height the snapshots list in darkroom will grow to before scrolling"
  },
  {
    "plugins/lighttable/style/windowheight",
    "int", "400", "",
    "", "",
    "height of the styles list",
    "maximum height the styles list in lighttable will grow to before scrolling"
  },
  {
    "plugins/darkroom/toneequal/gui_page",
    "int", "0", "",
    "", "",
    "active tab in tone equaliser module",
    "which of simple, advanced or masking tabs will show at startup"
  },
  {
    "plugins/lighttable/collect/windowheight",
    "int", "500", "",
    "", "",
    "height of the collect list",
    "maximum height the collect list in lighttable will grow to before scrolling"
  },
  {
    "plugins/midi/devices",
    "string", "", "",
    "", "",
    "order or exclude MIDI devices",
    "comma-separated list of device name fragments that if matched load MIDI device at id given by location in list\nor if preceded by '-' prevent matching devices from loading. add encoding and number of knobs like 'BeatStep:63:16'"
  },
};

void dt_confgen_init()
{
   darktable.conf->x_confgen = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, _free_confgen_value);
   for(int i = 0; i < sizeof(_config_variables)/sizeof(_config_variables[0]); i++)
   {
     _default_config_t *var = &_config_variables[i];
     dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, var->name);
     if(item)
     {
       _clear_confgen_value(item);
     }
     else
     {
       item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
       g_hash_table_insert(darktable.conf->x_confgen, g_strdup(var->name), item);
     }
     if      (!strcmp(var->type, "int"))   item->type = DT_INT;
     else if (!strcmp(var->type, "int64")) item->type = DT_INT64;
     else if (!strcmp(var->type, "bool"))  item->type = DT_BOOL;
     else if (!strcmp(var->type, "float")) item->type = DT_FLOAT;
     else if (!strcmp(var->type, "enum"))  item->type = DT_ENUM;
     else if (!strcmp(var->type, "dir"))   item->type = DT_PATH;
     else                                  item->type = DT_STRING;
     if(item->type == DT_PATH)
       item->def = dt_conf_expand_default_dir(var->def);
     else
       item->def = g_strdup(var->def);
     item->min = _copy_string(var->min);
     item->max = _copy_string(var->max);
     item->enum_values = _copy_string(var->enum_values);
     item->shortdesc = _copy_string(var->shortdesc);
     item->longdesc = _copy_string(var->longdesc);
   }
}

#endif
