// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/studio_request.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// StudioProtocol are the supported protocols for Studio Requests.
type StudioProtocol int32

const (
	// STUDIO_PROTOCOL_UNSPECIFIED is a safe default for requests with no protocol
	// defined.
	StudioProtocol_STUDIO_PROTOCOL_UNSPECIFIED StudioProtocol = 0
	// STUDIO_PROTOCOL_CONNECT is the Connect protocol in Studio.
	StudioProtocol_STUDIO_PROTOCOL_CONNECT StudioProtocol = 1
	// STUDIO_PROTOCOL_GRPC is the gRPC protocol in Studio.
	StudioProtocol_STUDIO_PROTOCOL_GRPC StudioProtocol = 2
	// STUDIO_PROTOCOL_GRPC_WEB is the gRPC-web protocol in Studio.
	StudioProtocol_STUDIO_PROTOCOL_GRPC_WEB StudioProtocol = 3
)

// Enum value maps for StudioProtocol.
var (
	StudioProtocol_name = map[int32]string{
		0: "STUDIO_PROTOCOL_UNSPECIFIED",
		1: "STUDIO_PROTOCOL_CONNECT",
		2: "STUDIO_PROTOCOL_GRPC",
		3: "STUDIO_PROTOCOL_GRPC_WEB",
	}
	StudioProtocol_value = map[string]int32{
		"STUDIO_PROTOCOL_UNSPECIFIED": 0,
		"STUDIO_PROTOCOL_CONNECT":     1,
		"STUDIO_PROTOCOL_GRPC":        2,
		"STUDIO_PROTOCOL_GRPC_WEB":    3,
	}
)

func (x StudioProtocol) Enum() *StudioProtocol {
	p := new(StudioProtocol)
	*p = x
	return p
}

func (x StudioProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudioProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes[0].Descriptor()
}

func (StudioProtocol) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes[0]
}

func (x StudioProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// CreateStudioRequestRequest is the proto request representation of the
// CreateStudioRequest method.
type CreateStudioRequestRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Name            string                 `protobuf:"bytes,3,opt,name=name,proto3"`
	xxx_hidden_TargetBaseUrl   string                 `protobuf:"bytes,4,opt,name=target_base_url,json=targetBaseUrl,proto3"`
	xxx_hidden_Service         string                 `protobuf:"bytes,5,opt,name=service,proto3"`
	xxx_hidden_Method          string                 `protobuf:"bytes,6,opt,name=method,proto3"`
	xxx_hidden_Body            string                 `protobuf:"bytes,7,opt,name=body,proto3"`
	xxx_hidden_Headers         map[string]string      `protobuf:"bytes,8,rep,name=headers,proto3" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	xxx_hidden_IncludeCookies  bool                   `protobuf:"varint,9,opt,name=include_cookies,json=includeCookies,proto3"`
	xxx_hidden_Protocol        StudioProtocol         `protobuf:"varint,10,opt,name=protocol,proto3,enum=buf.alpha.registry.v1alpha1.StudioProtocol"`
	xxx_hidden_AgentUrl        string                 `protobuf:"bytes,11,opt,name=agent_url,json=agentUrl,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *CreateStudioRequestRequest) Reset() {
	*x = CreateStudioRequestRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateStudioRequestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStudioRequestRequest) ProtoMessage() {}

func (x *CreateStudioRequestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateStudioRequestRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetTargetBaseUrl() string {
	if x != nil {
		return x.xxx_hidden_TargetBaseUrl
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetService() string {
	if x != nil {
		return x.xxx_hidden_Service
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetMethod() string {
	if x != nil {
		return x.xxx_hidden_Method
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetBody() string {
	if x != nil {
		return x.xxx_hidden_Body
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetHeaders() map[string]string {
	if x != nil {
		return x.xxx_hidden_Headers
	}
	return nil
}

func (x *CreateStudioRequestRequest) GetIncludeCookies() bool {
	if x != nil {
		return x.xxx_hidden_IncludeCookies
	}
	return false
}

func (x *CreateStudioRequestRequest) GetProtocol() StudioProtocol {
	if x != nil {
		return x.xxx_hidden_Protocol
	}
	return StudioProtocol_STUDIO_PROTOCOL_UNSPECIFIED
}

func (x *CreateStudioRequestRequest) GetAgentUrl() string {
	if x != nil {
		return x.xxx_hidden_AgentUrl
	}
	return ""
}

func (x *CreateStudioRequestRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *CreateStudioRequestRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *CreateStudioRequestRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CreateStudioRequestRequest) SetTargetBaseUrl(v string) {
	x.xxx_hidden_TargetBaseUrl = v
}

func (x *CreateStudioRequestRequest) SetService(v string) {
	x.xxx_hidden_Service = v
}

func (x *CreateStudioRequestRequest) SetMethod(v string) {
	x.xxx_hidden_Method = v
}

func (x *CreateStudioRequestRequest) SetBody(v string) {
	x.xxx_hidden_Body = v
}

func (x *CreateStudioRequestRequest) SetHeaders(v map[string]string) {
	x.xxx_hidden_Headers = v
}

func (x *CreateStudioRequestRequest) SetIncludeCookies(v bool) {
	x.xxx_hidden_IncludeCookies = v
}

func (x *CreateStudioRequestRequest) SetProtocol(v StudioProtocol) {
	x.xxx_hidden_Protocol = v
}

func (x *CreateStudioRequestRequest) SetAgentUrl(v string) {
	x.xxx_hidden_AgentUrl = v
}

type CreateStudioRequestRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The linked BSR repository owner name (user or organization).
	RepositoryOwner string
	// The linked BSR repository name.
	RepositoryName string
	// The friendly name of this request.
	Name string
	// The target base URL of this request.
	TargetBaseUrl string
	// The target service name as defined in the BSR repository.
	Service string
	// The target RPC method name as defined in the BSR repository.
	Method string
	// The request body as defined in Studio.
	Body string
	// The request headers as defined in Studio.
	Headers map[string]string
	// Should this request include cookies from the Studio current session?
	IncludeCookies bool
	// The protocol that Studio uses to send this request.
	Protocol StudioProtocol
	// The agent url (if any) used by Studio to send the request. See
	// https://docs.buf.build/bsr/studio#via-buf-studio-agent for details.
	AgentUrl string
}

func (b0 CreateStudioRequestRequest_builder) Build() *CreateStudioRequestRequest {
	m0 := &CreateStudioRequestRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_TargetBaseUrl = b.TargetBaseUrl
	x.xxx_hidden_Service = b.Service
	x.xxx_hidden_Method = b.Method
	x.xxx_hidden_Body = b.Body
	x.xxx_hidden_Headers = b.Headers
	x.xxx_hidden_IncludeCookies = b.IncludeCookies
	x.xxx_hidden_Protocol = b.Protocol
	x.xxx_hidden_AgentUrl = b.AgentUrl
	return m0
}

// CreateStudioRequestResponse returns the created StudioRequest.
type CreateStudioRequestResponse struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_CreatedRequest *StudioRequest         `protobuf:"bytes,1,opt,name=created_request,json=createdRequest,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *CreateStudioRequestResponse) Reset() {
	*x = CreateStudioRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateStudioRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStudioRequestResponse) ProtoMessage() {}

func (x *CreateStudioRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateStudioRequestResponse) GetCreatedRequest() *StudioRequest {
	if x != nil {
		return x.xxx_hidden_CreatedRequest
	}
	return nil
}

func (x *CreateStudioRequestResponse) SetCreatedRequest(v *StudioRequest) {
	x.xxx_hidden_CreatedRequest = v
}

func (x *CreateStudioRequestResponse) HasCreatedRequest() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreatedRequest != nil
}

func (x *CreateStudioRequestResponse) ClearCreatedRequest() {
	x.xxx_hidden_CreatedRequest = nil
}

type CreateStudioRequestResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Created Studio Request.
	CreatedRequest *StudioRequest
}

func (b0 CreateStudioRequestResponse_builder) Build() *CreateStudioRequestResponse {
	m0 := &CreateStudioRequestResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_CreatedRequest = b.CreatedRequest
	return m0
}

// RenameStudioRequestRequest is the proto request representation of the
// RenameStudioRequest method.
type RenameStudioRequestRequest struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id      string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_NewName string                 `protobuf:"bytes,2,opt,name=new_name,json=newName,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *RenameStudioRequestRequest) Reset() {
	*x = RenameStudioRequestRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenameStudioRequestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameStudioRequestRequest) ProtoMessage() {}

func (x *RenameStudioRequestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RenameStudioRequestRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *RenameStudioRequestRequest) GetNewName() string {
	if x != nil {
		return x.xxx_hidden_NewName
	}
	return ""
}

func (x *RenameStudioRequestRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *RenameStudioRequestRequest) SetNewName(v string) {
	x.xxx_hidden_NewName = v
}

type RenameStudioRequestRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Studio Request ID that will be renamed.
	Id string
	// The new name for the request.
	NewName string
}

func (b0 RenameStudioRequestRequest_builder) Build() *RenameStudioRequestRequest {
	m0 := &RenameStudioRequestRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_NewName = b.NewName
	return m0
}

// RenameStudioRequestResponse returns empty on successful renaming.
type RenameStudioRequestResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenameStudioRequestResponse) Reset() {
	*x = RenameStudioRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenameStudioRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameStudioRequestResponse) ProtoMessage() {}

func (x *RenameStudioRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type RenameStudioRequestResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 RenameStudioRequestResponse_builder) Build() *RenameStudioRequestResponse {
	m0 := &RenameStudioRequestResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// DeleteStudioRequestRequest is the proto request representation of the
// DeleteStudioRequest method.
type DeleteStudioRequestRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteStudioRequestRequest) Reset() {
	*x = DeleteStudioRequestRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteStudioRequestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStudioRequestRequest) ProtoMessage() {}

func (x *DeleteStudioRequestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteStudioRequestRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *DeleteStudioRequestRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

type DeleteStudioRequestRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Studio Request ID that will be deleted.
	Id string
}

func (b0 DeleteStudioRequestRequest_builder) Build() *DeleteStudioRequestRequest {
	m0 := &DeleteStudioRequestRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	return m0
}

// DeleteStudioRequestResponse returns empty on successful deletions.
type DeleteStudioRequestResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteStudioRequestResponse) Reset() {
	*x = DeleteStudioRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteStudioRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStudioRequestResponse) ProtoMessage() {}

func (x *DeleteStudioRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteStudioRequestResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteStudioRequestResponse_builder) Build() *DeleteStudioRequestResponse {
	m0 := &DeleteStudioRequestResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// ListStudioRequestsRequest is the proto request representation of the
// ListStudioRequests method.
type ListStudioRequestsRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListStudioRequestsRequest) Reset() {
	*x = ListStudioRequestsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStudioRequestsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudioRequestsRequest) ProtoMessage() {}

func (x *ListStudioRequestsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListStudioRequestsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListStudioRequestsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListStudioRequestsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListStudioRequestsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListStudioRequestsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListStudioRequestsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListStudioRequestsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The page size for listing studio requests, values between 1-250.
	PageSize uint32
	// The page token for paginating. The first page is returned if this is empty.
	PageToken string
	// The listed studio requests are order by created time in ascending order.
	// You can reverse that order setting this value to true.
	Reverse bool
}

func (b0 ListStudioRequestsRequest_builder) Build() *ListStudioRequestsRequest {
	m0 := &ListStudioRequestsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

// ListStudioRequestsResponse is the proto response representation of the
// ListStudioRequests method.
type ListStudioRequestsResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Requests      *[]*StudioRequest      `protobuf:"bytes,1,rep,name=requests,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListStudioRequestsResponse) Reset() {
	*x = ListStudioRequestsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStudioRequestsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudioRequestsResponse) ProtoMessage() {}

func (x *ListStudioRequestsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListStudioRequestsResponse) GetRequests() []*StudioRequest {
	if x != nil {
		if x.xxx_hidden_Requests != nil {
			return *x.xxx_hidden_Requests
		}
	}
	return nil
}

func (x *ListStudioRequestsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListStudioRequestsResponse) SetRequests(v []*StudioRequest) {
	x.xxx_hidden_Requests = &v
}

func (x *ListStudioRequestsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListStudioRequestsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of requests in the current page.
	Requests []*StudioRequest
	// The requests' next page token. There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListStudioRequestsResponse_builder) Build() *ListStudioRequestsResponse {
	m0 := &ListStudioRequestsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Requests = &b.Requests
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

// StudioRequest represents a saved request in Studio, that is synced to a BSR
// user's profile.
type StudioRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id              string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime      *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime      *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_AuthorUserId    string                 `protobuf:"bytes,4,opt,name=author_user_id,json=authorUserId,proto3"`
	xxx_hidden_RepositoryId    string                 `protobuf:"bytes,5,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_Name            string                 `protobuf:"bytes,6,opt,name=name,proto3"`
	xxx_hidden_TargetBaseUrl   string                 `protobuf:"bytes,7,opt,name=target_base_url,json=targetBaseUrl,proto3"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,8,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,9,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Service         string                 `protobuf:"bytes,10,opt,name=service,proto3"`
	xxx_hidden_Method          string                 `protobuf:"bytes,11,opt,name=method,proto3"`
	xxx_hidden_Body            string                 `protobuf:"bytes,12,opt,name=body,proto3"`
	xxx_hidden_Headers         map[string]string      `protobuf:"bytes,13,rep,name=headers,proto3" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	xxx_hidden_IncludeCookies  bool                   `protobuf:"varint,14,opt,name=include_cookies,json=includeCookies,proto3"`
	xxx_hidden_Protocol        StudioProtocol         `protobuf:"varint,15,opt,name=protocol,proto3,enum=buf.alpha.registry.v1alpha1.StudioProtocol"`
	xxx_hidden_AgentUrl        string                 `protobuf:"bytes,16,opt,name=agent_url,json=agentUrl,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *StudioRequest) Reset() {
	*x = StudioRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StudioRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudioRequest) ProtoMessage() {}

func (x *StudioRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *StudioRequest) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *StudioRequest) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *StudioRequest) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *StudioRequest) GetAuthorUserId() string {
	if x != nil {
		return x.xxx_hidden_AuthorUserId
	}
	return ""
}

func (x *StudioRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *StudioRequest) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *StudioRequest) GetTargetBaseUrl() string {
	if x != nil {
		return x.xxx_hidden_TargetBaseUrl
	}
	return ""
}

func (x *StudioRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *StudioRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *StudioRequest) GetService() string {
	if x != nil {
		return x.xxx_hidden_Service
	}
	return ""
}

func (x *StudioRequest) GetMethod() string {
	if x != nil {
		return x.xxx_hidden_Method
	}
	return ""
}

func (x *StudioRequest) GetBody() string {
	if x != nil {
		return x.xxx_hidden_Body
	}
	return ""
}

func (x *StudioRequest) GetHeaders() map[string]string {
	if x != nil {
		return x.xxx_hidden_Headers
	}
	return nil
}

func (x *StudioRequest) GetIncludeCookies() bool {
	if x != nil {
		return x.xxx_hidden_IncludeCookies
	}
	return false
}

func (x *StudioRequest) GetProtocol() StudioProtocol {
	if x != nil {
		return x.xxx_hidden_Protocol
	}
	return StudioProtocol_STUDIO_PROTOCOL_UNSPECIFIED
}

func (x *StudioRequest) GetAgentUrl() string {
	if x != nil {
		return x.xxx_hidden_AgentUrl
	}
	return ""
}

func (x *StudioRequest) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *StudioRequest) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *StudioRequest) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *StudioRequest) SetAuthorUserId(v string) {
	x.xxx_hidden_AuthorUserId = v
}

func (x *StudioRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *StudioRequest) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *StudioRequest) SetTargetBaseUrl(v string) {
	x.xxx_hidden_TargetBaseUrl = v
}

func (x *StudioRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *StudioRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *StudioRequest) SetService(v string) {
	x.xxx_hidden_Service = v
}

func (x *StudioRequest) SetMethod(v string) {
	x.xxx_hidden_Method = v
}

func (x *StudioRequest) SetBody(v string) {
	x.xxx_hidden_Body = v
}

func (x *StudioRequest) SetHeaders(v map[string]string) {
	x.xxx_hidden_Headers = v
}

func (x *StudioRequest) SetIncludeCookies(v bool) {
	x.xxx_hidden_IncludeCookies = v
}

func (x *StudioRequest) SetProtocol(v StudioProtocol) {
	x.xxx_hidden_Protocol = v
}

func (x *StudioRequest) SetAgentUrl(v string) {
	x.xxx_hidden_AgentUrl = v
}

func (x *StudioRequest) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *StudioRequest) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *StudioRequest) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *StudioRequest) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

type StudioRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of this Studio Request.
	Id string
	// The request creation timestamp.
	CreateTime *timestamppb.Timestamp
	// The request last updated timestamp.
	UpdateTime *timestamppb.Timestamp
	// User ID who created and saved this request.
	AuthorUserId string
	// BSR repository ID this request is linked to.
	RepositoryId string
	// The friendly name of this request.
	Name string
	// The target base URL of this request.
	TargetBaseUrl string
	// The BSR repository owner name (user or organization).
	RepositoryOwner string
	// The BSR repository name.
	RepositoryName string
	// The target service name as defined in the BSR repository.
	Service string
	// The target RPC method name as defined in the BSR repository.
	Method string
	// The request body as defined in Studio.
	Body string
	// The request headers as defined in Studio.
	Headers map[string]string
	// Should this request include cookies from the Studio current session?
	IncludeCookies bool
	// The protocol that Studio uses to send this request.
	Protocol StudioProtocol
	// The agent url (if any) used by Studio to send the request. See
	// https://docs.buf.build/bsr/studio#via-buf-studio-agent for details.
	AgentUrl string
}

func (b0 StudioRequest_builder) Build() *StudioRequest {
	m0 := &StudioRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_AuthorUserId = b.AuthorUserId
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_TargetBaseUrl = b.TargetBaseUrl
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Service = b.Service
	x.xxx_hidden_Method = b.Method
	x.xxx_hidden_Body = b.Body
	x.xxx_hidden_Headers = b.Headers
	x.xxx_hidden_IncludeCookies = b.IncludeCookies
	x.xxx_hidden_Protocol = b.Protocol
	x.xxx_hidden_AgentUrl = b.AgentUrl
	return m0
}

var File_buf_alpha_registry_v1alpha1_studio_request_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDesc = "" +
	"\n" +
	"0buf/alpha/registry/v1alpha1/studio_request.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a\x1fgoogle/protobuf/timestamp.proto\"\x9d\x04\n" +
	"\x1aCreateStudioRequestRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12&\n" +
	"\x0ftarget_base_url\x18\x04 \x01(\tR\rtargetBaseUrl\x12\x18\n" +
	"\aservice\x18\x05 \x01(\tR\aservice\x12\x16\n" +
	"\x06method\x18\x06 \x01(\tR\x06method\x12\x12\n" +
	"\x04body\x18\a \x01(\tR\x04body\x12^\n" +
	"\aheaders\x18\b \x03(\v2D.buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.HeadersEntryR\aheaders\x12'\n" +
	"\x0finclude_cookies\x18\t \x01(\bR\x0eincludeCookies\x12G\n" +
	"\bprotocol\x18\n" +
	" \x01(\x0e2+.buf.alpha.registry.v1alpha1.StudioProtocolR\bprotocol\x12\x1b\n" +
	"\tagent_url\x18\v \x01(\tR\bagentUrl\x1a:\n" +
	"\fHeadersEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"r\n" +
	"\x1bCreateStudioRequestResponse\x12S\n" +
	"\x0fcreated_request\x18\x01 \x01(\v2*.buf.alpha.registry.v1alpha1.StudioRequestR\x0ecreatedRequest\"G\n" +
	"\x1aRenameStudioRequestRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x19\n" +
	"\bnew_name\x18\x02 \x01(\tR\anewName\"\x1d\n" +
	"\x1bRenameStudioRequestResponse\",\n" +
	"\x1aDeleteStudioRequestRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\"\x1d\n" +
	"\x1bDeleteStudioRequestResponse\"q\n" +
	"\x19ListStudioRequestsRequest\x12\x1b\n" +
	"\tpage_size\x18\x01 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x03 \x01(\bR\areverse\"\x8c\x01\n" +
	"\x1aListStudioRequestsResponse\x12F\n" +
	"\brequests\x18\x01 \x03(\v2*.buf.alpha.registry.v1alpha1.StudioRequestR\brequests\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xd8\x05\n" +
	"\rStudioRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12;\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"updateTime\x12$\n" +
	"\x0eauthor_user_id\x18\x04 \x01(\tR\fauthorUserId\x12#\n" +
	"\rrepository_id\x18\x05 \x01(\tR\frepositoryId\x12\x12\n" +
	"\x04name\x18\x06 \x01(\tR\x04name\x12&\n" +
	"\x0ftarget_base_url\x18\a \x01(\tR\rtargetBaseUrl\x12)\n" +
	"\x10repository_owner\x18\b \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\t \x01(\tR\x0erepositoryName\x12\x18\n" +
	"\aservice\x18\n" +
	" \x01(\tR\aservice\x12\x16\n" +
	"\x06method\x18\v \x01(\tR\x06method\x12\x12\n" +
	"\x04body\x18\f \x01(\tR\x04body\x12Q\n" +
	"\aheaders\x18\r \x03(\v27.buf.alpha.registry.v1alpha1.StudioRequest.HeadersEntryR\aheaders\x12'\n" +
	"\x0finclude_cookies\x18\x0e \x01(\bR\x0eincludeCookies\x12G\n" +
	"\bprotocol\x18\x0f \x01(\x0e2+.buf.alpha.registry.v1alpha1.StudioProtocolR\bprotocol\x12\x1b\n" +
	"\tagent_url\x18\x10 \x01(\tR\bagentUrl\x1a:\n" +
	"\fHeadersEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01*\x86\x01\n" +
	"\x0eStudioProtocol\x12\x1f\n" +
	"\x1bSTUDIO_PROTOCOL_UNSPECIFIED\x10\x00\x12\x1b\n" +
	"\x17STUDIO_PROTOCOL_CONNECT\x10\x01\x12\x18\n" +
	"\x14STUDIO_PROTOCOL_GRPC\x10\x02\x12\x1c\n" +
	"\x18STUDIO_PROTOCOL_GRPC_WEB\x10\x032\xcd\x04\n" +
	"\x14StudioRequestService\x12\x8a\x01\n" +
	"\x13CreateStudioRequest\x127.buf.alpha.registry.v1alpha1.CreateStudioRequestRequest\x1a8.buf.alpha.registry.v1alpha1.CreateStudioRequestResponse\"\x00\x12\x8a\x01\n" +
	"\x13RenameStudioRequest\x127.buf.alpha.registry.v1alpha1.RenameStudioRequestRequest\x1a8.buf.alpha.registry.v1alpha1.RenameStudioRequestResponse\"\x00\x12\x8d\x01\n" +
	"\x13DeleteStudioRequest\x127.buf.alpha.registry.v1alpha1.DeleteStudioRequestRequest\x1a8.buf.alpha.registry.v1alpha1.DeleteStudioRequestResponse\"\x03\x90\x02\x02\x12\x8a\x01\n" +
	"\x12ListStudioRequests\x126.buf.alpha.registry.v1alpha1.ListStudioRequestsRequest\x1a7.buf.alpha.registry.v1alpha1.ListStudioRequestsResponse\"\x03\x90\x02\x01B\x9f\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\x12StudioRequestProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_buf_alpha_registry_v1alpha1_studio_request_proto_goTypes = []any{
	(StudioProtocol)(0),                 // 0: buf.alpha.registry.v1alpha1.StudioProtocol
	(*CreateStudioRequestRequest)(nil),  // 1: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest
	(*CreateStudioRequestResponse)(nil), // 2: buf.alpha.registry.v1alpha1.CreateStudioRequestResponse
	(*RenameStudioRequestRequest)(nil),  // 3: buf.alpha.registry.v1alpha1.RenameStudioRequestRequest
	(*RenameStudioRequestResponse)(nil), // 4: buf.alpha.registry.v1alpha1.RenameStudioRequestResponse
	(*DeleteStudioRequestRequest)(nil),  // 5: buf.alpha.registry.v1alpha1.DeleteStudioRequestRequest
	(*DeleteStudioRequestResponse)(nil), // 6: buf.alpha.registry.v1alpha1.DeleteStudioRequestResponse
	(*ListStudioRequestsRequest)(nil),   // 7: buf.alpha.registry.v1alpha1.ListStudioRequestsRequest
	(*ListStudioRequestsResponse)(nil),  // 8: buf.alpha.registry.v1alpha1.ListStudioRequestsResponse
	(*StudioRequest)(nil),               // 9: buf.alpha.registry.v1alpha1.StudioRequest
	nil,                                 // 10: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.HeadersEntry
	nil,                                 // 11: buf.alpha.registry.v1alpha1.StudioRequest.HeadersEntry
	(*timestamppb.Timestamp)(nil),       // 12: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_studio_request_proto_depIdxs = []int32{
	10, // 0: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.headers:type_name -> buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.HeadersEntry
	0,  // 1: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.protocol:type_name -> buf.alpha.registry.v1alpha1.StudioProtocol
	9,  // 2: buf.alpha.registry.v1alpha1.CreateStudioRequestResponse.created_request:type_name -> buf.alpha.registry.v1alpha1.StudioRequest
	9,  // 3: buf.alpha.registry.v1alpha1.ListStudioRequestsResponse.requests:type_name -> buf.alpha.registry.v1alpha1.StudioRequest
	12, // 4: buf.alpha.registry.v1alpha1.StudioRequest.create_time:type_name -> google.protobuf.Timestamp
	12, // 5: buf.alpha.registry.v1alpha1.StudioRequest.update_time:type_name -> google.protobuf.Timestamp
	11, // 6: buf.alpha.registry.v1alpha1.StudioRequest.headers:type_name -> buf.alpha.registry.v1alpha1.StudioRequest.HeadersEntry
	0,  // 7: buf.alpha.registry.v1alpha1.StudioRequest.protocol:type_name -> buf.alpha.registry.v1alpha1.StudioProtocol
	1,  // 8: buf.alpha.registry.v1alpha1.StudioRequestService.CreateStudioRequest:input_type -> buf.alpha.registry.v1alpha1.CreateStudioRequestRequest
	3,  // 9: buf.alpha.registry.v1alpha1.StudioRequestService.RenameStudioRequest:input_type -> buf.alpha.registry.v1alpha1.RenameStudioRequestRequest
	5,  // 10: buf.alpha.registry.v1alpha1.StudioRequestService.DeleteStudioRequest:input_type -> buf.alpha.registry.v1alpha1.DeleteStudioRequestRequest
	7,  // 11: buf.alpha.registry.v1alpha1.StudioRequestService.ListStudioRequests:input_type -> buf.alpha.registry.v1alpha1.ListStudioRequestsRequest
	2,  // 12: buf.alpha.registry.v1alpha1.StudioRequestService.CreateStudioRequest:output_type -> buf.alpha.registry.v1alpha1.CreateStudioRequestResponse
	4,  // 13: buf.alpha.registry.v1alpha1.StudioRequestService.RenameStudioRequest:output_type -> buf.alpha.registry.v1alpha1.RenameStudioRequestResponse
	6,  // 14: buf.alpha.registry.v1alpha1.StudioRequestService.DeleteStudioRequest:output_type -> buf.alpha.registry.v1alpha1.DeleteStudioRequestResponse
	8,  // 15: buf.alpha.registry.v1alpha1.StudioRequestService.ListStudioRequests:output_type -> buf.alpha.registry.v1alpha1.ListStudioRequestsResponse
	12, // [12:16] is the sub-list for method output_type
	8,  // [8:12] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_studio_request_proto_init() }
func file_buf_alpha_registry_v1alpha1_studio_request_proto_init() {
	if File_buf_alpha_registry_v1alpha1_studio_request_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_studio_request_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_studio_request_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_studio_request_proto = out.File
	file_buf_alpha_registry_v1alpha1_studio_request_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_studio_request_proto_depIdxs = nil
}
