/* sound_output.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sound_output.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "org.buddiesofbudgie.budgie-desktop.raven.widget.SoundOutput.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "raven-plugin.h"
#include <glib-object.h>
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gtk/gtk.h>
#include <gvc-mixer-stream.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gvc-mixer-card.h>
#include <gvc-mixer-ui-device.h>
#include <gvc-channel-map.h>
#include <libpeas/peas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_OUTPUT_RAVEN_PLUGIN_0_PROPERTY,
	SOUND_OUTPUT_RAVEN_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* sound_output_raven_plugin_properties[SOUND_OUTPUT_RAVEN_PLUGIN_NUM_PROPERTIES];
enum  {
	SOUND_OUTPUT_RAVEN_WIDGET_0_PROPERTY,
	SOUND_OUTPUT_RAVEN_WIDGET_NUM_PROPERTIES
};
static GParamSpec* sound_output_raven_widget_properties[SOUND_OUTPUT_RAVEN_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
enum  {
	SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL,
	SOUND_OUTPUT_RAVEN_WIDGET_NUM_SIGNALS
};
static guint sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_NUM_SIGNALS] = {0};
enum  {
	SOUND_OUTPUT_RAVEN_WIDGET_SETTINGS_0_PROPERTY,
	SOUND_OUTPUT_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* sound_output_raven_widget_settings_properties[SOUND_OUTPUT_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES];

struct _SoundOutputRavenWidgetPrivate {
	GSettings* gnome_sound_settings;
	GSettings* budgie_settings;
	GSettings* gnome_desktop_settings;
	gulong scale_id;
	GvcMixerControl* mixer;
	GHashTable* apps;
	GHashTable* derpers;
	GHashTable* devices;
	gulong primary_notify_id;
	GvcMixerStream* primary_stream;
	GtkBox* main_box;
	GtkBox* apps_area;
	GtkListBox* apps_listbox;
	GtkLabel* apps_placeholder_label;
	GtkListBox* devices_list;
	GtkBox* header;
	GtkButton* header_icon;
	GtkButton* header_reveal_button;
	GtkRevealer* content_revealer;
	GtkBox* content;
	GtkStack* widget_area;
	GtkStackSwitcher* widget_area_switch;
	GtkScale* volume_slider;
};

struct _Block1Data {
	int _ref_count_;
	SoundOutputRavenWidget* self;
	BudgieAppSoundControl* control;
};

struct _SoundOutputRavenWidgetSettingsPrivate {
	GtkSwitch* switch_allow_volume_overdrive;
};

static gpointer sound_output_raven_plugin_parent_class = NULL;
static BudgieRavenPluginIface * sound_output_raven_plugin_budgie_raven_plugin_parent_iface = NULL;
static GType sound_output_raven_plugin_type_id = 0;
static gint SoundOutputRavenWidget_private_offset;
static gpointer sound_output_raven_widget_parent_class = NULL;
static GType sound_output_raven_widget_type_id = 0;
static gint SoundOutputRavenWidgetSettings_private_offset;
static gpointer sound_output_raven_widget_settings_parent_class = NULL;
static GType sound_output_raven_widget_settings_type_id = 0;

static BudgieRavenWidget* sound_output_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                                       const gchar* uuid,
                                                                       GSettings* settings);
static gboolean sound_output_raven_plugin_real_supports_settings (BudgieRavenPlugin* base);
static void __lambda4_ (SoundOutputRavenWidget* self);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda5_ (SoundOutputRavenWidget* self,
                 guint id);
static void ___lambda5__gvc_mixer_control_card_added (GvcMixerControl* _sender,
                                               guint id,
                                               gpointer self);
static void __lambda6_ (SoundOutputRavenWidget* self,
                 guint id);
static void ___lambda6__gvc_mixer_control_card_removed (GvcMixerControl* _sender,
                                                 guint id,
                                                 gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void sound_output_raven_widget_on_device_selected (SoundOutputRavenWidget* self,
                                                   GtkListBoxRow* list_item);
static void _sound_output_raven_widget_on_device_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                              GtkListBoxRow* row,
                                                                              gpointer self);
static void sound_output_raven_widget_on_scale_change (SoundOutputRavenWidget* self);
static void _sound_output_raven_widget_on_scale_change_gtk_range_value_changed (GtkRange* _sender,
                                                                         gpointer self);
static void __lambda7_ (SoundOutputRavenWidget* self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void sound_output_raven_widget_on_device_changed (SoundOutputRavenWidget* self,
                                                  guint id);
static void _sound_output_raven_widget_on_device_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                                          guint id,
                                                                                          gpointer self);
static void sound_output_raven_widget_on_device_added (SoundOutputRavenWidget* self,
                                                guint id);
static void _sound_output_raven_widget_on_device_added_gvc_mixer_control_output_added (GvcMixerControl* _sender,
                                                                                guint id,
                                                                                gpointer self);
static void sound_output_raven_widget_on_device_removed (SoundOutputRavenWidget* self,
                                                  guint id);
static void _sound_output_raven_widget_on_device_removed_gvc_mixer_control_output_removed (GvcMixerControl* _sender,
                                                                                    guint id,
                                                                                    gpointer self);
static void sound_output_raven_widget_on_state_changed (SoundOutputRavenWidget* self,
                                                 guint id);
static void _sound_output_raven_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                                  guint new_state,
                                                                                  gpointer self);
static void sound_output_raven_widget_on_stream_added (SoundOutputRavenWidget* self,
                                                guint id);
static void _sound_output_raven_widget_on_stream_added_gvc_mixer_control_stream_added (GvcMixerControl* _sender,
                                                                                guint id,
                                                                                gpointer self);
static void sound_output_raven_widget_on_stream_removed (SoundOutputRavenWidget* self,
                                                  guint id);
static void _sound_output_raven_widget_on_stream_removed_gvc_mixer_control_stream_removed (GvcMixerControl* _sender,
                                                                                    guint id,
                                                                                    gpointer self);
static void sound_output_raven_widget_update_input_draw_markers (SoundOutputRavenWidget* self);
static void _sound_output_raven_widget_update_input_draw_markers_g_settings_changed (GSettings* _sender,
                                                                              const gchar* key,
                                                                              gpointer self);
static gint __lambda10_ (SoundOutputRavenWidget* self,
                  GtkListBoxRow* row1,
                  GtkListBoxRow* row2);
static gint ___lambda10__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                          GtkListBoxRow* row2,
                                          gpointer self);
static void sound_output_raven_widget_settings_updated (SoundOutputRavenWidget* self,
                                                 const gchar* key);
static void _sound_output_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
static void __lambda8_ (SoundOutputRavenWidget* self,
                 GObject* n,
                 GParamSpec* p);
static void sound_output_raven_widget_update_volume (SoundOutputRavenWidget* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static BudgieAppSoundControl* sound_output_raven_widget_get_control_for_app (SoundOutputRavenWidget* self,
                                                                      guint id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _____lambda9_ (Block1Data* _data1_);
static void ______lambda9__gvc_channel_map_volume_changed (GvcChannelMap* _sender,
                                                    gboolean set,
                                                    gpointer self);
static void sound_output_raven_widget_set_slider_range_on_max (SoundOutputRavenWidget* self,
                                                        gboolean allow_overdrive);
static GtkWidget* sound_output_raven_widget_real_build_settings_ui (BudgieRavenWidget* base);
static void sound_output_raven_widget_finalize (GObject * obj);
static void sound_output_raven_widget_settings_finalize (GObject * obj);
GType budgie_app_sound_control_register_type (GTypeModule * module);

static BudgieRavenWidget*
sound_output_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                    const gchar* uuid,
                                                    GSettings* settings)
{
	SoundOutputRavenPlugin * self;
	SoundOutputRavenWidget* _tmp0_;
	BudgieRavenWidget* result;
	self = (SoundOutputRavenPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = sound_output_raven_widget_new (uuid, settings);
	g_object_ref_sink (_tmp0_);
	result = (BudgieRavenWidget*) _tmp0_;
	return result;
}

static gboolean
sound_output_raven_plugin_real_supports_settings (BudgieRavenPlugin* base)
{
	SoundOutputRavenPlugin * self;
	gboolean result;
	self = (SoundOutputRavenPlugin*) base;
	result = TRUE;
	return result;
}

SoundOutputRavenPlugin*
sound_output_raven_plugin_construct (GType object_type)
{
	SoundOutputRavenPlugin * self = NULL;
	self = (SoundOutputRavenPlugin*) g_object_new (object_type, NULL);
	return self;
}

SoundOutputRavenPlugin*
sound_output_raven_plugin_new (void)
{
	return sound_output_raven_plugin_construct (TYPE_SOUND_OUTPUT_RAVEN_PLUGIN);
}

static void
sound_output_raven_plugin_class_init (SoundOutputRavenPluginClass * klass,
                                      gpointer klass_data)
{
	sound_output_raven_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
sound_output_raven_plugin_budgie_raven_plugin_interface_init (BudgieRavenPluginIface * iface,
                                                              gpointer iface_data)
{
	sound_output_raven_plugin_budgie_raven_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->new_widget_instance = (BudgieRavenWidget* (*) (BudgieRavenPlugin*, const gchar*, GSettings*)) sound_output_raven_plugin_real_new_widget_instance;
	iface->supports_settings = (gboolean (*) (BudgieRavenPlugin*)) sound_output_raven_plugin_real_supports_settings;
}

static void
sound_output_raven_plugin_instance_init (SoundOutputRavenPlugin * self,
                                         gpointer klass)
{
}

GType
sound_output_raven_plugin_get_type (void)
{
	return sound_output_raven_plugin_type_id;
}

GType
sound_output_raven_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundOutputRavenPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_output_raven_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundOutputRavenPlugin), 0, (GInstanceInitFunc) sound_output_raven_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_raven_plugin_info = { (GInterfaceInitFunc) sound_output_raven_plugin_budgie_raven_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	sound_output_raven_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "SoundOutputRavenPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, sound_output_raven_plugin_type_id, budgie_raven_plugin_get_type (), &budgie_raven_plugin_info);
	return sound_output_raven_plugin_type_id;
}

static inline gpointer
sound_output_raven_widget_get_instance_private (SoundOutputRavenWidget* self)
{
	return G_STRUCT_MEMBER_P (self, SoundOutputRavenWidget_private_offset);
}

static void
__lambda4_ (SoundOutputRavenWidget* self)
{
	GvcMixerStream* _tmp0_;
	_tmp0_ = self->priv->primary_stream;
	if (_tmp0_ != NULL) {
		GvcMixerStream* _tmp1_;
		GvcMixerStream* _tmp2_;
		_tmp1_ = self->priv->primary_stream;
		_tmp2_ = self->priv->primary_stream;
		gvc_mixer_stream_change_is_muted (_tmp1_, !gvc_mixer_stream_get_is_muted (_tmp2_));
	}
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ ((SoundOutputRavenWidget*) self);
}

static void
__lambda5_ (SoundOutputRavenWidget* self,
            guint id)
{
	g_signal_emit (self, sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

static void
___lambda5__gvc_mixer_control_card_added (GvcMixerControl* _sender,
                                          guint id,
                                          gpointer self)
{
	__lambda5_ ((SoundOutputRavenWidget*) self, id);
}

static void
__lambda6_ (SoundOutputRavenWidget* self,
            guint id)
{
	g_signal_emit (self, sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

static void
___lambda6__gvc_mixer_control_card_removed (GvcMixerControl* _sender,
                                            guint id,
                                            gpointer self)
{
	__lambda6_ ((SoundOutputRavenWidget*) self, id);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_sound_output_raven_widget_on_device_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self)
{
	sound_output_raven_widget_on_device_selected ((SoundOutputRavenWidget*) self, row);
}

static void
_sound_output_raven_widget_on_scale_change_gtk_range_value_changed (GtkRange* _sender,
                                                                    gpointer self)
{
	sound_output_raven_widget_on_scale_change ((SoundOutputRavenWidget*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda7_ (SoundOutputRavenWidget* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkImage* image = NULL;
	GtkButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkImage* _tmp6_;
	GtkRevealer* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	_tmp0_ = self->priv->content_revealer;
	_tmp1_ = self->priv->content_revealer;
	_tmp2_ = gtk_revealer_get_child_revealed (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->header_reveal_button;
	_tmp5_ = gtk_button_get_image (_tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_image_get_type (), GtkImage));
	image = _tmp6_;
	_tmp7_ = self->priv->content_revealer;
	_tmp8_ = gtk_revealer_get_reveal_child (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GtkImage* _tmp10_;
		_tmp10_ = image;
		gtk_image_set_from_icon_name (_tmp10_, "pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	} else {
		GtkImage* _tmp11_;
		_tmp11_ = image;
		gtk_image_set_from_icon_name (_tmp11_, "pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
	_g_object_unref0 (image);
}

static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ ((SoundOutputRavenWidget*) self);
}

static void
_sound_output_raven_widget_on_device_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                                     guint id,
                                                                                     gpointer self)
{
	sound_output_raven_widget_on_device_changed ((SoundOutputRavenWidget*) self, id);
}

static void
_sound_output_raven_widget_on_device_added_gvc_mixer_control_output_added (GvcMixerControl* _sender,
                                                                           guint id,
                                                                           gpointer self)
{
	sound_output_raven_widget_on_device_added ((SoundOutputRavenWidget*) self, id);
}

static void
_sound_output_raven_widget_on_device_removed_gvc_mixer_control_output_removed (GvcMixerControl* _sender,
                                                                               guint id,
                                                                               gpointer self)
{
	sound_output_raven_widget_on_device_removed ((SoundOutputRavenWidget*) self, id);
}

static void
_sound_output_raven_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                             guint new_state,
                                                                             gpointer self)
{
	sound_output_raven_widget_on_state_changed ((SoundOutputRavenWidget*) self, new_state);
}

static void
_sound_output_raven_widget_on_stream_added_gvc_mixer_control_stream_added (GvcMixerControl* _sender,
                                                                           guint id,
                                                                           gpointer self)
{
	sound_output_raven_widget_on_stream_added ((SoundOutputRavenWidget*) self, id);
}

static void
_sound_output_raven_widget_on_stream_removed_gvc_mixer_control_stream_removed (GvcMixerControl* _sender,
                                                                               guint id,
                                                                               gpointer self)
{
	sound_output_raven_widget_on_stream_removed ((SoundOutputRavenWidget*) self, id);
}

static void
_sound_output_raven_widget_update_input_draw_markers_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self)
{
	sound_output_raven_widget_update_input_draw_markers ((SoundOutputRavenWidget*) self);
}

static gint
__lambda10_ (SoundOutputRavenWidget* self,
             GtkListBoxRow* row1,
             GtkListBoxRow* row2)
{
	gchar* app_1 = NULL;
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* app_2 = NULL;
	GtkWidget* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_ = 0;
	GCompareFunc _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BUDGIE_TYPE_APP_SOUND_CONTROL, BudgieAppSoundControl)->app_name;
	_tmp2_ = g_strdup (_tmp1_);
	app_1 = _tmp2_;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) row2);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BUDGIE_TYPE_APP_SOUND_CONTROL, BudgieAppSoundControl)->app_name;
	_tmp5_ = g_strdup (_tmp4_);
	app_2 = _tmp5_;
	_tmp7_ = ((GCompareFunc) g_strcmp0);
	_tmp8_ = app_1;
	_tmp9_ = app_2;
	if (_tmp7_ (_tmp8_, _tmp9_) <= 0) {
		_tmp6_ = -1;
	} else {
		_tmp6_ = 1;
	}
	result = _tmp6_;
	_g_free0 (app_2);
	_g_free0 (app_1);
	return result;
}

static gint
___lambda10__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                     GtkListBoxRow* row2,
                                     gpointer self)
{
	gint result;
	result = __lambda10_ ((SoundOutputRavenWidget*) self, row1, row2);
	return result;
}

static void
_sound_output_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	sound_output_raven_widget_settings_updated ((SoundOutputRavenWidget*) self, key);
}

SoundOutputRavenWidget*
sound_output_raven_widget_construct (GType object_type,
                                     const gchar* uuid,
                                     GSettings* settings)
{
	SoundOutputRavenWidget * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkBox* _tmp15_;
	GtkButton* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkRevealer* _tmp20_;
	GtkRevealer* _tmp21_;
	GtkBox* _tmp22_;
	GtkRevealer* _tmp23_;
	GtkBox* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkStyleContext* _tmp26_;
	GvcMixerControl* _tmp27_;
	GvcMixerControl* _tmp28_;
	GvcMixerControl* _tmp29_;
	GHashFunc _tmp30_;
	GEqualFunc _tmp31_;
	GHashTable* _tmp32_;
	GHashTable* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GHashTable* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GHashFunc _tmp39_;
	GEqualFunc _tmp40_;
	GHashTable* _tmp41_;
	GtkListBox* _tmp42_;
	GtkListBox* _tmp43_;
	GtkStyleContext* _tmp44_;
	GtkListBox* _tmp45_;
	GtkStyleContext* _tmp46_;
	GtkListBox* _tmp47_;
	GtkListBox* _tmp48_;
	GtkScale* _tmp49_;
	GtkScale* _tmp50_;
	GtkScale* _tmp51_;
	GtkScale* _tmp52_;
	GtkBox* _tmp53_;
	GtkScale* _tmp54_;
	GtkButton* _tmp55_;
	GtkButton* _tmp56_;
	GtkStyleContext* _tmp57_;
	GtkButton* _tmp58_;
	GtkStyleContext* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkBox* _tmp64_;
	GtkButton* _tmp65_;
	GSettings* _tmp66_;
	GHashFunc _tmp67_;
	GEqualFunc _tmp68_;
	GHashTable* _tmp69_;
	GSettings* _tmp70_;
	GSettings* _tmp71_;
	GvcMixerControl* _tmp72_;
	GvcMixerControl* _tmp73_;
	GvcMixerControl* _tmp74_;
	GvcMixerControl* _tmp75_;
	GvcMixerControl* _tmp76_;
	GvcMixerControl* _tmp77_;
	GSettings* _tmp78_;
	GSettings* _tmp79_;
	GtkBox* _tmp80_;
	GtkListBox* _tmp81_;
	GtkListBox* _tmp82_;
	GtkStyleContext* _tmp83_;
	GtkListBox* _tmp84_;
	GtkStyleContext* _tmp85_;
	GtkListBox* _tmp86_;
	GtkListBox* _tmp87_;
	GtkListBox* _tmp88_;
	GtkListBox* _tmp89_;
	GtkBox* _tmp90_;
	GtkListBox* _tmp91_;
	GtkLabel* _tmp92_ = NULL;
	GtkBox* _tmp93_;
	GtkLabel* _tmp94_;
	GtkStack* _tmp95_;
	GtkStack* _tmp96_;
	GtkStack* _tmp97_;
	GtkStack* _tmp98_;
	GtkStack* _tmp99_;
	GtkBox* _tmp100_;
	GtkStack* _tmp101_;
	GtkListBox* _tmp102_;
	GtkStackSwitcher* _tmp103_;
	GtkStackSwitcher* _tmp104_;
	GtkStack* _tmp105_;
	GtkStackSwitcher* _tmp106_;
	GtkBox* _tmp107_;
	GtkStack* _tmp108_;
	GtkBox* _tmp109_;
	GtkStackSwitcher* _tmp110_;
	GvcMixerControl* _tmp111_;
	GtkListBox* _tmp112_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (SoundOutputRavenWidget*) g_object_new (object_type, NULL);
	budgie_raven_widget_initialize ((BudgieRavenWidget*) self, uuid, settings);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = _tmp0_;
	_tmp1_ = self->priv->main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp2_;
	_tmp3_ = self->priv->header;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "raven-header");
	_tmp5_ = self->priv->main_box;
	_tmp6_ = self->priv->header;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("audio-volume-high-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->header_icon);
	self->priv->header_icon = _tmp7_;
	_tmp8_ = self->priv->header_icon;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_add_class (_tmp9_, "flat");
	_tmp10_ = self->priv->header_icon;
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
	_tmp11_ = self->priv->header_icon;
	g_object_set ((GtkWidget*) _tmp11_, "margin", 4, NULL);
	_tmp12_ = self->priv->header_icon;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp12_, 8);
	_tmp13_ = self->priv->header_icon;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp13_, 4);
	_tmp14_ = self->priv->header_icon;
	g_signal_connect_object (_tmp14_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, self, 0);
	_tmp15_ = self->priv->header;
	_tmp16_ = self->priv->header_icon;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->content);
	self->priv->content = _tmp17_;
	_tmp18_ = self->priv->content;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, "raven-background");
	_tmp20_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->content_revealer);
	self->priv->content_revealer = _tmp20_;
	_tmp21_ = self->priv->content_revealer;
	_tmp22_ = self->priv->content;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->content_revealer;
	gtk_revealer_set_reveal_child (_tmp23_, TRUE);
	_tmp24_ = self->priv->main_box;
	_tmp25_ = self->priv->content_revealer;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp26_, "audio-widget");
	_tmp27_ = gvc_mixer_control_new ("Budgie Volume Control");
	_g_object_unref0 (self->priv->mixer);
	self->priv->mixer = _tmp27_;
	_tmp28_ = self->priv->mixer;
	g_signal_connect_object (_tmp28_, "card-added", (GCallback) ___lambda5__gvc_mixer_control_card_added, self, 0);
	_tmp29_ = self->priv->mixer;
	g_signal_connect_object (_tmp29_, "card-removed", (GCallback) ___lambda6__gvc_mixer_control_card_removed, self, 0);
	_tmp30_ = g_str_hash;
	_tmp31_ = g_str_equal;
	_tmp32_ = g_hash_table_new_full (_tmp30_, _tmp31_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->derpers);
	self->priv->derpers = _tmp32_;
	_tmp33_ = self->priv->derpers;
	_tmp34_ = g_strdup ("Vivaldi");
	_tmp35_ = g_strdup ("vivaldi");
	g_hash_table_insert (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = self->priv->derpers;
	_tmp37_ = g_strdup ("Vivaldi Snapshot");
	_tmp38_ = g_strdup ("vivaldi-snapshot");
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = g_direct_hash;
	_tmp40_ = g_direct_equal;
	_tmp41_ = g_hash_table_new_full (_tmp39_, _tmp40_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->devices);
	self->priv->devices = _tmp41_;
	_tmp42_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->devices_list);
	self->priv->devices_list = _tmp42_;
	_tmp43_ = self->priv->devices_list;
	_tmp44_ = gtk_widget_get_style_context ((GtkWidget*) _tmp43_);
	gtk_style_context_add_class (_tmp44_, "devices-list");
	_tmp45_ = self->priv->devices_list;
	_tmp46_ = gtk_widget_get_style_context ((GtkWidget*) _tmp45_);
	gtk_style_context_add_class (_tmp46_, "sound-devices");
	_tmp47_ = self->priv->devices_list;
	gtk_list_box_set_selection_mode (_tmp47_, GTK_SELECTION_SINGLE);
	_tmp48_ = self->priv->devices_list;
	g_signal_connect_object (_tmp48_, "row-selected", (GCallback) _sound_output_raven_widget_on_device_selected_gtk_list_box_row_selected, self, 0);
	_tmp49_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 10);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->volume_slider);
	self->priv->volume_slider = _tmp49_;
	_tmp50_ = self->priv->volume_slider;
	gtk_scale_set_draw_value (_tmp50_, FALSE);
	_tmp51_ = self->priv->volume_slider;
	g_signal_connect_object ((GtkRange*) _tmp51_, "value-changed", (GCallback) _sound_output_raven_widget_on_scale_change_gtk_range_value_changed, self, 0);
	_tmp52_ = self->priv->volume_slider;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp52_, TRUE);
	_tmp53_ = self->priv->header;
	_tmp54_ = self->priv->volume_slider;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = (GtkButton*) gtk_button_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->header_reveal_button);
	self->priv->header_reveal_button = _tmp55_;
	_tmp56_ = self->priv->header_reveal_button;
	_tmp57_ = gtk_widget_get_style_context ((GtkWidget*) _tmp56_);
	gtk_style_context_add_class (_tmp57_, "flat");
	_tmp58_ = self->priv->header_reveal_button;
	_tmp59_ = gtk_widget_get_style_context ((GtkWidget*) _tmp58_);
	gtk_style_context_add_class (_tmp59_, "expander-button");
	_tmp60_ = self->priv->header_reveal_button;
	g_object_set ((GtkWidget*) _tmp60_, "margin", 4, NULL);
	_tmp61_ = self->priv->header_reveal_button;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp61_, 2);
	_tmp62_ = self->priv->header_reveal_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp62_, GTK_ALIGN_CENTER);
	_tmp63_ = self->priv->header_reveal_button;
	g_signal_connect_object (_tmp63_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	_tmp64_ = self->priv->header;
	_tmp65_ = self->priv->header_reveal_button;
	gtk_box_pack_end (_tmp64_, (GtkWidget*) _tmp65_, FALSE, FALSE, (guint) 0);
	_tmp66_ = g_settings_new ("org.gnome.desktop.sound");
	_g_object_unref0 (self->priv->gnome_sound_settings);
	self->priv->gnome_sound_settings = _tmp66_;
	_tmp67_ = g_direct_hash;
	_tmp68_ = g_direct_equal;
	_tmp69_ = g_hash_table_new_full (_tmp67_, _tmp68_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->apps);
	self->priv->apps = _tmp69_;
	_tmp70_ = g_settings_new ("com.solus-project.budgie-panel");
	_g_object_unref0 (self->priv->budgie_settings);
	self->priv->budgie_settings = _tmp70_;
	_tmp71_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->gnome_desktop_settings);
	self->priv->gnome_desktop_settings = _tmp71_;
	_tmp72_ = self->priv->mixer;
	g_signal_connect_object (_tmp72_, "default-sink-changed", (GCallback) _sound_output_raven_widget_on_device_changed_gvc_mixer_control_default_sink_changed, self, 0);
	_tmp73_ = self->priv->mixer;
	g_signal_connect_object (_tmp73_, "output-added", (GCallback) _sound_output_raven_widget_on_device_added_gvc_mixer_control_output_added, self, 0);
	_tmp74_ = self->priv->mixer;
	g_signal_connect_object (_tmp74_, "output-removed", (GCallback) _sound_output_raven_widget_on_device_removed_gvc_mixer_control_output_removed, self, 0);
	_tmp75_ = self->priv->mixer;
	g_signal_connect_object (_tmp75_, "state-changed", (GCallback) _sound_output_raven_widget_on_state_changed_gvc_mixer_control_state_changed, self, 0);
	_tmp76_ = self->priv->mixer;
	g_signal_connect_object (_tmp76_, "stream-added", (GCallback) _sound_output_raven_widget_on_stream_added_gvc_mixer_control_stream_added, self, 0);
	_tmp77_ = self->priv->mixer;
	g_signal_connect_object (_tmp77_, "stream-removed", (GCallback) _sound_output_raven_widget_on_stream_removed_gvc_mixer_control_stream_removed, self, 0);
	_tmp78_ = self->priv->budgie_settings;
	g_signal_connect_object (_tmp78_, "changed::builtin-theme", (GCallback) _sound_output_raven_widget_update_input_draw_markers_g_settings_changed, self, 0);
	_tmp79_ = self->priv->gnome_desktop_settings;
	g_signal_connect_object (_tmp79_, "changed::gtk-theme", (GCallback) _sound_output_raven_widget_update_input_draw_markers_g_settings_changed, self, 0);
	_tmp80_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (self->priv->apps_area);
	self->priv->apps_area = _tmp80_;
	_tmp81_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->apps_listbox);
	self->priv->apps_listbox = _tmp81_;
	_tmp82_ = self->priv->apps_listbox;
	_tmp83_ = gtk_widget_get_style_context ((GtkWidget*) _tmp82_);
	gtk_style_context_add_class (_tmp83_, "apps-list");
	_tmp84_ = self->priv->apps_listbox;
	_tmp85_ = gtk_widget_get_style_context ((GtkWidget*) _tmp84_);
	gtk_style_context_remove_class (_tmp85_, GTK_STYLE_CLASS_LIST);
	_tmp86_ = self->priv->apps_listbox;
	gtk_list_box_set_selection_mode (_tmp86_, GTK_SELECTION_NONE);
	_tmp87_ = self->priv->apps_listbox;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp87_, 10);
	_tmp88_ = self->priv->apps_listbox;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp88_, 10);
	_tmp89_ = self->priv->apps_listbox;
	gtk_list_box_set_sort_func (_tmp89_, ___lambda10__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp90_ = self->priv->apps_area;
	_tmp91_ = self->priv->apps_listbox;
	gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
	_tmp92_ = (GtkLabel*) gtk_label_new (_ ("No apps are playing audio."));
	g_object_set (_tmp92_, "wrap", TRUE, NULL);
	g_object_set (_tmp92_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_max_width_chars (_tmp92_, 1);
	gtk_label_set_justify (_tmp92_, GTK_JUSTIFY_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp92_, 8);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp92_, 8);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp92_, TRUE);
	g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->apps_placeholder_label);
	self->priv->apps_placeholder_label = _tmp92_;
	_tmp93_ = self->priv->apps_area;
	_tmp94_ = self->priv->apps_placeholder_label;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->widget_area);
	self->priv->widget_area = _tmp95_;
	_tmp96_ = self->priv->widget_area;
	gtk_stack_set_transition_duration (_tmp96_, (guint) 125);
	_tmp97_ = self->priv->widget_area;
	gtk_stack_set_transition_type (_tmp97_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	_tmp98_ = self->priv->widget_area;
	gtk_stack_set_vhomogeneous (_tmp98_, FALSE);
	_tmp99_ = self->priv->widget_area;
	_tmp100_ = self->priv->apps_area;
	gtk_stack_add_titled (_tmp99_, (GtkWidget*) _tmp100_, "apps", _ ("Apps"));
	_tmp101_ = self->priv->widget_area;
	_tmp102_ = self->priv->devices_list;
	gtk_stack_add_titled (_tmp101_, (GtkWidget*) _tmp102_, "devices", _ ("Devices"));
	_tmp103_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp103_);
	_g_object_unref0 (self->priv->widget_area_switch);
	self->priv->widget_area_switch = _tmp103_;
	_tmp104_ = self->priv->widget_area_switch;
	_tmp105_ = self->priv->widget_area;
	gtk_stack_switcher_set_stack (_tmp104_, _tmp105_);
	_tmp106_ = self->priv->widget_area_switch;
	gtk_box_set_homogeneous ((GtkBox*) _tmp106_, TRUE);
	g_signal_connect_object (settings, "changed", (GCallback) _sound_output_raven_widget_settings_updated_g_settings_changed, self, 0);
	sound_output_raven_widget_settings_updated (self, "allow-volume-overdrive");
	_tmp107_ = self->priv->content;
	_tmp108_ = self->priv->widget_area;
	gtk_box_pack_start (_tmp107_, (GtkWidget*) _tmp108_, FALSE, FALSE, (guint) 0);
	_tmp109_ = self->priv->content;
	_tmp110_ = self->priv->widget_area_switch;
	gtk_box_pack_start (_tmp109_, (GtkWidget*) _tmp110_, TRUE, FALSE, (guint) 0);
	_tmp111_ = self->priv->mixer;
	gvc_mixer_control_open (_tmp111_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp112_ = self->priv->apps_listbox;
	gtk_widget_hide ((GtkWidget*) _tmp112_);
	return self;
}

SoundOutputRavenWidget*
sound_output_raven_widget_new (const gchar* uuid,
                               GSettings* settings)
{
	return sound_output_raven_widget_construct (TYPE_SOUND_OUTPUT_RAVEN_WIDGET, uuid, settings);
}

/**
 * has_devices will check if we have devices associated with this type
 */
static inline gboolean
vala_g_slist_is_empty (GSList* self)
{
	gboolean result;
	result = ((GSList*) self) == NULL;
	return result;
}

gboolean
sound_output_raven_widget_has_devices (SoundOutputRavenWidget* self)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->devices;
	if (g_hash_table_size (_tmp1_) != ((guint) 0)) {
		GvcMixerControl* _tmp2_;
		GSList* _tmp3_;
		GSList* _tmp4_;
		_tmp2_ = self->priv->mixer;
		_tmp3_ = gvc_mixer_control_get_cards (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_g_slist_is_empty (_tmp4_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_slist_free (_tmp4_), NULL));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * on_device_added will handle when an input or output device has been added
 */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
sound_output_raven_widget_on_device_added (SoundOutputRavenWidget* self,
                                           guint id)
{
	GHashTable* _tmp0_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp1_;
	GvcMixerUIDevice* _tmp2_;
	GvcMixerUIDevice* _tmp3_;
	GvcMixerUIDevice* _tmp4_;
	GvcMixerUIDevice* _tmp5_;
	void* _tmp6_;
	void* _tmp7_;
	GvcMixerCard* card = NULL;
	GvcMixerUIDevice* _tmp8_;
	void* _tmp9_;
	void* _tmp10_;
	GvcMixerCard* _tmp11_;
	GvcMixerUIDevice* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	GtkBox* box = NULL;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_;
	GvcMixerUIDevice* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GvcMixerCard* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GtkBox* _tmp34_;
	GtkLabel* _tmp35_;
	GtkListBoxRow* list_item = NULL;
	GtkListBoxRow* _tmp36_;
	GtkListBoxRow* _tmp37_;
	GtkBox* _tmp38_;
	GtkListBoxRow* _tmp39_;
	GtkListBox* _tmp40_;
	GtkListBoxRow* _tmp41_;
	GHashTable* _tmp42_;
	GtkListBoxRow* _tmp43_;
	GtkListBoxRow* _tmp44_;
	GtkListBoxRow* _tmp45_;
	GtkListBox* _tmp46_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	if (g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		return;
	}
	_tmp1_ = self->priv->mixer;
	_tmp2_ = gvc_mixer_control_lookup_output_id (_tmp1_, id);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	device = _tmp3_;
	_tmp4_ = device;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp5_ = device;
	g_object_get (_tmp5_, "card", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp8_ = device;
	g_object_get (_tmp8_, "card", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gvc_mixer_card_get_type ()) ? ((GvcMixerCard*) _tmp10_) : NULL);
	card = _tmp11_;
	_tmp12_ = device;
	g_object_get (_tmp12_, "description", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = string_contains (_tmp15_, "Digital Output");
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		_g_object_unref0 (card);
		_g_object_unref0 (device);
		return;
	}
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp17_);
	box = _tmp17_;
	_tmp18_ = box;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp18_, 6);
	_tmp19_ = box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp19_, 6);
	_tmp20_ = box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp20_, 3);
	_tmp21_ = box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp21_, 3);
	_tmp22_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp22_, 0.0f);
	gtk_label_set_max_width_chars (_tmp22_, 1);
	gtk_label_set_ellipsize (_tmp22_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	label = _tmp22_;
	_tmp23_ = label;
	_tmp24_ = device;
	g_object_get (_tmp24_, "description", &_tmp25_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp28_ = card;
	g_object_get (_tmp28_, "name", &_tmp29_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf ("%s - %s", _tmp27_, _tmp31_);
	_tmp33_ = _tmp32_;
	gtk_label_set_markup (_tmp23_, _tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp27_);
	_tmp34_ = box;
	_tmp35_ = label;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, TRUE, (guint) 0);
	_tmp36_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp36_);
	list_item = _tmp36_;
	_tmp37_ = list_item;
	_tmp38_ = box;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = list_item;
	g_object_set_data_full ((GObject*) _tmp39_, "device_id", (gpointer) ((guintptr) id), NULL);
	_tmp40_ = self->priv->devices_list;
	_tmp41_ = list_item;
	gtk_list_box_insert (_tmp40_, (GtkWidget*) _tmp41_, -1);
	_tmp42_ = self->priv->devices;
	_tmp43_ = list_item;
	_tmp44_ = _g_object_ref0 (_tmp43_);
	g_hash_table_insert (_tmp42_, (gpointer) ((guintptr) id), _tmp44_);
	_tmp45_ = list_item;
	gtk_widget_show_all ((GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp46_);
	g_signal_emit (self, sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	_g_object_unref0 (card);
	_g_object_unref0 (device);
}

/**
 * on_device_changed will handle when a Gvc.MixerUIDevice has been changed
 */
static void
__lambda8_ (SoundOutputRavenWidget* self,
            GObject* n,
            GParamSpec* p)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = p->name;
	if (g_strcmp0 (_tmp1_, "volume") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = p->name;
		_tmp0_ = g_strcmp0 (_tmp2_, "is-muted") == 0;
	}
	if (_tmp0_) {
		sound_output_raven_widget_update_volume (self);
	}
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((SoundOutputRavenWidget*) self, _sender, pspec);
}

static void
sound_output_raven_widget_on_device_changed (SoundOutputRavenWidget* self,
                                             guint id)
{
	GvcMixerStream* stream = NULL;
	GvcMixerControl* _tmp0_;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp2_;
	GvcMixerStream* _tmp3_;
	GvcMixerStream* _tmp4_;
	GvcMixerStream* _tmp5_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp6_;
	GvcMixerStream* _tmp7_;
	GvcMixerUIDevice* _tmp8_;
	GvcMixerUIDevice* _tmp9_;
	GtkListBoxRow* list_item = NULL;
	GHashTable* _tmp10_;
	GvcMixerUIDevice* _tmp11_;
	gconstpointer _tmp12_;
	GtkListBoxRow* _tmp13_;
	GtkListBoxRow* _tmp14_;
	GvcMixerStream* _tmp17_;
	GvcMixerStream* _tmp19_;
	gulong _tmp20_;
	GvcMixerStream* _tmp21_;
	GvcMixerStream* _tmp22_;
	GtkListBox* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mixer;
	_tmp1_ = gvc_mixer_control_get_default_sink (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	stream = _tmp2_;
	_tmp3_ = stream;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (stream);
		return;
	}
	_tmp4_ = stream;
	_tmp5_ = self->priv->primary_stream;
	if (_tmp4_ == _tmp5_) {
		_g_object_unref0 (stream);
		return;
	}
	_tmp6_ = self->priv->mixer;
	_tmp7_ = stream;
	_tmp8_ = gvc_mixer_control_lookup_device_from_stream (_tmp6_, _tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	device = _tmp9_;
	_tmp10_ = self->priv->devices;
	_tmp11_ = device;
	_tmp12_ = g_hash_table_lookup (_tmp10_, (gpointer) ((guintptr) gvc_mixer_ui_device_get_id (_tmp11_)));
	_tmp13_ = _g_object_ref0 ((GtkListBoxRow*) _tmp12_);
	list_item = _tmp13_;
	_tmp14_ = list_item;
	if (_tmp14_ != NULL) {
		GtkListBox* _tmp15_;
		GtkListBoxRow* _tmp16_;
		_tmp15_ = self->priv->devices_list;
		_tmp16_ = list_item;
		gtk_list_box_select_row (_tmp15_, _tmp16_);
	}
	_tmp17_ = self->priv->primary_stream;
	if (_tmp17_ != NULL) {
		GvcMixerStream* _tmp18_;
		_tmp18_ = self->priv->primary_stream;
		g_signal_handler_disconnect ((GObject*) _tmp18_, self->priv->primary_notify_id);
		self->priv->primary_notify_id = (gulong) 0;
	}
	_tmp19_ = stream;
	_tmp20_ = g_signal_connect_object ((GObject*) _tmp19_, "notify", (GCallback) ___lambda8__g_object_notify, self, 0);
	self->priv->primary_notify_id = _tmp20_;
	_tmp21_ = stream;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->primary_stream);
	self->priv->primary_stream = _tmp22_;
	sound_output_raven_widget_update_volume (self);
	_tmp23_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp23_);
	g_signal_emit (self, sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
	_g_object_unref0 (device);
	_g_object_unref0 (stream);
}

/**
 * on_device_removed will handle when a Gvc.MixerUIDevice has been removed
 */
static void
sound_output_raven_widget_on_device_removed (SoundOutputRavenWidget* self,
                                             guint id)
{
	GtkListBoxRow* list_item = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	GHashTable* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
	_tmp2_ = _g_object_ref0 ((GtkListBoxRow*) _tmp1_);
	list_item = _tmp2_;
	_tmp3_ = list_item;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (list_item);
		return;
	}
	_tmp4_ = self->priv->devices;
	g_hash_table_steal (_tmp4_, (gpointer) ((guintptr) id));
	_tmp5_ = list_item;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
	g_signal_emit (self, sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
}

/**
 * get_control_for_app will get the respective inner AppSoundControl of a ListBoxRow associated with the id
 */
static BudgieAppSoundControl*
sound_output_raven_widget_get_control_for_app (SoundOutputRavenWidget* self,
                                               guint id)
{
	BudgieAppSoundControl* control = NULL;
	GHashTable* _tmp0_;
	BudgieAppSoundControl* result;
	g_return_val_if_fail (self != NULL, NULL);
	control = NULL;
	_tmp0_ = self->priv->apps;
	if (g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		GtkListBoxRow* row = NULL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		_tmp1_ = self->priv->apps;
		_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) id));
		_tmp3_ = _g_object_ref0 ((GtkListBoxRow*) _tmp2_);
		row = _tmp3_;
		_tmp4_ = row;
		if (_tmp4_ != NULL) {
			GtkListBoxRow* _tmp5_;
			GtkWidget* _tmp6_;
			BudgieAppSoundControl* _tmp7_;
			_tmp5_ = row;
			_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BUDGIE_TYPE_APP_SOUND_CONTROL, BudgieAppSoundControl));
			_g_object_unref0 (control);
			control = _tmp7_;
		}
		_g_object_unref0 (row);
	}
	result = control;
	return result;
}

/**
 * on_device_selected will handle when a checkbox related to an input or output device is selected
 */
static void
sound_output_raven_widget_on_device_selected (SoundOutputRavenWidget* self,
                                              GtkListBoxRow* list_item)
{
	GtkListBox* _tmp0_;
	guint id = 0U;
	gconstpointer _tmp1_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp2_;
	GvcMixerUIDevice* _tmp3_;
	GvcMixerUIDevice* _tmp4_;
	GvcMixerUIDevice* _tmp5_;
	GtkListBox* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices_list;
	g_signal_handlers_block_by_func ((void*) _tmp0_, (void*) sound_output_raven_widget_on_device_selected, self);
	_tmp1_ = g_object_get_data ((GObject*) list_item, "device_id");
	id = (guint) ((guintptr) _tmp1_);
	_tmp2_ = self->priv->mixer;
	_tmp3_ = gvc_mixer_control_lookup_output_id (_tmp2_, id);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	device = _tmp4_;
	_tmp5_ = device;
	if (_tmp5_ != NULL) {
		GvcMixerControl* _tmp6_;
		GvcMixerUIDevice* _tmp7_;
		_tmp6_ = self->priv->mixer;
		_tmp7_ = device;
		gvc_mixer_control_change_output (_tmp6_, _tmp7_);
	}
	_tmp8_ = self->priv->devices_list;
	g_signal_handlers_unblock_by_func ((void*) _tmp8_, (void*) sound_output_raven_widget_on_device_selected, self);
	_g_object_unref0 (device);
}

/**
 * When our volume slider has changed
 */
static void
sound_output_raven_widget_on_scale_change (SoundOutputRavenWidget* self)
{
	GvcMixerStream* _tmp0_;
	GvcMixerStream* _tmp1_;
	GtkScale* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_stream;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->primary_stream;
	_tmp2_ = self->priv->volume_slider;
	if (gvc_mixer_stream_set_volume (_tmp1_, (guint32) gtk_range_get_value ((GtkRange*) _tmp2_))) {
		GvcMixerStream* _tmp3_;
		_tmp3_ = self->priv->primary_stream;
		gvc_mixer_stream_push_volume (_tmp3_);
	}
}

/**
 * on_state_changed will handle when the state of our Mixer or its streams have changed
 */
static void
sound_output_raven_widget_on_state_changed (SoundOutputRavenWidget* self,
                                            guint id)
{
	GvcMixerStream* stream = NULL;
	GvcMixerControl* _tmp0_;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GvcMixerStream* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mixer;
	_tmp1_ = gvc_mixer_control_lookup_stream_id (_tmp0_, id);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	stream = _tmp2_;
	_tmp4_ = stream;
	if (_tmp4_ != NULL) {
		GvcMixerStream* _tmp5_;
		_tmp5_ = stream;
		_tmp3_ = gvc_mixer_stream_get_card_index (_tmp5_) == -1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GHashTable* _tmp6_;
		_tmp6_ = self->priv->apps;
		if (g_hash_table_contains (_tmp6_, (gpointer) ((guintptr) id))) {
			BudgieAppSoundControl* control = NULL;
			BudgieAppSoundControl* _tmp7_;
			BudgieAppSoundControl* _tmp8_;
			_tmp7_ = sound_output_raven_widget_get_control_for_app (self, id);
			control = _tmp7_;
			_tmp8_ = control;
			if (_tmp8_ != NULL) {
				GvcMixerStream* _tmp9_;
				_tmp9_ = stream;
				if (gvc_mixer_stream_is_running (_tmp9_)) {
					BudgieAppSoundControl* _tmp10_;
					_tmp10_ = control;
					budgie_app_sound_control_refresh (_tmp10_);
				} else {
					BudgieAppSoundControl* _tmp11_;
					GHashTable* _tmp12_;
					_tmp11_ = control;
					gtk_widget_destroy ((GtkWidget*) _tmp11_);
					_tmp12_ = self->priv->apps;
					g_hash_table_steal (_tmp12_, (gpointer) ((guintptr) id));
				}
			}
			_g_object_unref0 (control);
		}
	}
	g_signal_emit (self, sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (stream);
}

/**
 * on_stream_added will handle when a stream (like an application) has been added
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SoundOutputRavenWidget* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->control);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_____lambda9_ (Block1Data* _data1_)
{
	SoundOutputRavenWidget* self;
	BudgieAppSoundControl* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->control;
	budgie_app_sound_control_refresh_volume (_tmp0_);
}

static void
______lambda9__gvc_channel_map_volume_changed (GvcChannelMap* _sender,
                                               gboolean set,
                                               gpointer self)
{
	_____lambda9_ (self);
}

static void
sound_output_raven_widget_on_stream_added (SoundOutputRavenWidget* self,
                                           guint id)
{
	GvcMixerStream* stream = NULL;
	GvcMixerControl* _tmp0_;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GvcMixerStream* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mixer;
	_tmp1_ = gvc_mixer_control_lookup_stream_id (_tmp0_, id);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	stream = _tmp2_;
	_tmp4_ = stream;
	if (_tmp4_ != NULL) {
		GvcMixerStream* _tmp5_;
		_tmp5_ = stream;
		_tmp3_ = gvc_mixer_stream_get_card_index (_tmp5_) == -1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Block1Data* _data1_;
		gchar* name = NULL;
		GvcMixerStream* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* icon = NULL;
		GvcMixerStream* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		GvcMixerStream* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		GvcMixerStream* _tmp16_;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		const gchar* _tmp20_;
		GvcMixerUIDevice* device = NULL;
		GvcMixerControl* _tmp21_;
		GvcMixerStream* _tmp22_;
		GvcMixerUIDevice* _tmp23_;
		GvcMixerUIDevice* _tmp24_;
		gboolean _tmp25_ = FALSE;
		GvcMixerUIDevice* _tmp26_;
		GHashTable* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp34_;
		GvcMixerControl* _tmp40_;
		GvcMixerStream* _tmp41_;
		GvcMixerStream* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		BudgieAppSoundControl* _tmp45_;
		BudgieAppSoundControl* _tmp46_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_tmp6_ = stream;
		_tmp7_ = gvc_mixer_stream_get_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		name = _tmp8_;
		_tmp9_ = stream;
		_tmp10_ = gvc_mixer_stream_get_icon_name (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		icon = _tmp11_;
		_tmp12_ = name;
		if (_tmp12_ == NULL) {
			_g_free0 (icon);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp13_ = stream;
		g_object_get (_tmp13_, "is-event-stream", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		if (_tmp15_) {
			_g_free0 (icon);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp16_ = stream;
		if (gvc_mixer_stream_get_volume (_tmp16_) == ((guint32) 100)) {
			_g_free0 (icon);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp18_ = icon;
		if (g_strcmp0 (_tmp18_, "") != 0) {
			const gchar* _tmp19_;
			_tmp19_ = icon;
			_tmp17_ = string_contains (_tmp19_, "audio-input-");
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			_g_free0 (icon);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp20_ = name;
		if (g_strcmp0 (_tmp20_, "System Sounds") == 0) {
			_g_free0 (icon);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp21_ = self->priv->mixer;
		_tmp22_ = stream;
		_tmp23_ = gvc_mixer_control_lookup_device_from_stream (_tmp21_, _tmp22_);
		_tmp24_ = _g_object_ref0 (_tmp23_);
		device = _tmp24_;
		_tmp26_ = device;
		if (_tmp26_ != NULL) {
			GvcMixerUIDevice* _tmp27_;
			_tmp27_ = device;
			_tmp25_ = !gvc_mixer_ui_device_is_output (_tmp27_);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			_g_object_unref0 (device);
			_g_free0 (icon);
			_g_free0 (name);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp28_ = self->priv->derpers;
		_tmp29_ = name;
		if (g_hash_table_contains (_tmp28_, _tmp29_)) {
			GHashTable* _tmp30_;
			const gchar* _tmp31_;
			gconstpointer _tmp32_;
			gchar* _tmp33_;
			_tmp30_ = self->priv->derpers;
			_tmp31_ = name;
			_tmp32_ = g_hash_table_lookup (_tmp30_, _tmp31_);
			_tmp33_ = g_strdup ((const gchar*) _tmp32_);
			_g_free0 (icon);
			icon = _tmp33_;
		}
		_tmp34_ = name;
		if (g_strcmp0 (_tmp34_, "AudioIPC Server") == 0) {
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = g_strdup ("firefox");
			_g_free0 (icon);
			icon = _tmp35_;
			_tmp36_ = g_strdup ("Firefox");
			_g_free0 (name);
			name = _tmp36_;
		} else {
			const gchar* _tmp37_;
			_tmp37_ = name;
			if (g_strcmp0 (_tmp37_, "WEBRTC VoiceEngine") == 0) {
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp38_ = g_strdup ("discord");
				_g_free0 (icon);
				icon = _tmp38_;
				_tmp39_ = g_strdup ("Discord");
				_g_free0 (name);
				name = _tmp39_;
			}
		}
		_tmp40_ = self->priv->mixer;
		_tmp41_ = self->priv->primary_stream;
		_tmp42_ = stream;
		_tmp43_ = icon;
		_tmp44_ = name;
		_tmp45_ = budgie_app_sound_control_new (_tmp40_, _tmp41_, _tmp42_, _tmp43_, _tmp44_);
		g_object_ref_sink (_tmp45_);
		_data1_->control = _tmp45_;
		_tmp46_ = _data1_->control;
		if (_tmp46_ != NULL) {
			GtkListBoxRow* list_row = NULL;
			GtkListBoxRow* _tmp47_;
			GtkListBoxRow* _tmp48_;
			GtkListBoxRow* _tmp49_;
			BudgieAppSoundControl* _tmp50_;
			GtkListBox* _tmp51_;
			GtkListBoxRow* _tmp52_;
			GHashTable* _tmp53_;
			GtkListBoxRow* _tmp54_;
			GtkListBoxRow* _tmp55_;
			GtkLabel* _tmp56_;
			GtkListBox* _tmp57_;
			GtkListBox* _tmp58_;
			GvcChannelMap* channel_map = NULL;
			GvcMixerStream* _tmp59_;
			GvcChannelMap* _tmp60_;
			GvcChannelMap* _tmp61_;
			GvcChannelMap* _tmp62_;
			_tmp47_ = (GtkListBoxRow*) gtk_list_box_row_new ();
			g_object_ref_sink (_tmp47_);
			list_row = _tmp47_;
			_tmp48_ = list_row;
			gtk_list_box_row_set_activatable (_tmp48_, FALSE);
			_tmp49_ = list_row;
			_tmp50_ = _data1_->control;
			gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
			_tmp51_ = self->priv->apps_listbox;
			_tmp52_ = list_row;
			gtk_list_box_insert (_tmp51_, (GtkWidget*) _tmp52_, -1);
			_tmp53_ = self->priv->apps;
			_tmp54_ = list_row;
			_tmp55_ = _g_object_ref0 (_tmp54_);
			g_hash_table_insert (_tmp53_, (gpointer) ((guintptr) id), _tmp55_);
			_tmp56_ = self->priv->apps_placeholder_label;
			gtk_widget_hide ((GtkWidget*) _tmp56_);
			_tmp57_ = self->priv->apps_listbox;
			gtk_widget_show ((GtkWidget*) _tmp57_);
			_tmp58_ = self->priv->apps_listbox;
			gtk_widget_show_all ((GtkWidget*) _tmp58_);
			_tmp59_ = stream;
			_tmp60_ = gvc_mixer_stream_get_channel_map (_tmp59_);
			_tmp61_ = _g_object_ref0 (_tmp60_);
			channel_map = _tmp61_;
			_tmp62_ = channel_map;
			if (_tmp62_ != NULL) {
				GvcChannelMap* _tmp63_;
				_tmp63_ = channel_map;
				g_signal_connect_data (_tmp63_, "volume-changed", (GCallback) ______lambda9__gvc_channel_map_volume_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			}
			_g_object_unref0 (channel_map);
			_g_object_unref0 (list_row);
		}
		_g_object_unref0 (device);
		_g_free0 (icon);
		_g_free0 (name);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	_g_object_unref0 (stream);
}

/**
 * on_stream_removed will handle when a stream (like an application) has been removed
 */
static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static void
sound_output_raven_widget_on_stream_removed (SoundOutputRavenWidget* self,
                                             guint id)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->apps;
	if (g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		GtkListBoxRow* row = NULL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GHashTable* _tmp7_;
		GtkListBox* _tmp8_;
		GList* _tmp9_;
		GList* _tmp10_;
		gboolean _tmp11_;
		_tmp1_ = self->priv->apps;
		_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) id));
		_tmp3_ = _g_object_ref0 ((GtkListBoxRow*) _tmp2_);
		row = _tmp3_;
		_tmp4_ = row;
		if (_tmp4_ != NULL) {
			GtkListBox* _tmp5_;
			GtkListBoxRow* _tmp6_;
			_tmp5_ = self->priv->apps_listbox;
			_tmp6_ = row;
			gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
		}
		_tmp7_ = self->priv->apps;
		g_hash_table_steal (_tmp7_, (gpointer) ((guintptr) id));
		_tmp8_ = self->priv->apps_listbox;
		_tmp9_ = gtk_container_get_children ((GtkContainer*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_g_list_is_empty (_tmp10_);
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (g_list_free (_tmp10_), NULL));
		if (_tmp11_) {
			GtkListBox* _tmp12_;
			GtkBox* _tmp13_;
			_tmp12_ = self->priv->apps_listbox;
			gtk_widget_hide ((GtkWidget*) _tmp12_);
			_tmp13_ = self->priv->apps_area;
			gtk_widget_show ((GtkWidget*) _tmp13_);
		}
		_g_object_unref0 (row);
	}
}

static void
sound_output_raven_widget_set_slider_range_on_max (SoundOutputRavenWidget* self,
                                                   gboolean allow_overdrive)
{
	gdouble current_volume = 0.0;
	GtkScale* _tmp0_;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp1_;
	gdouble vol_max_above = 0.0;
	GvcMixerControl* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble step_size = 0.0;
	gint slider_start = 0;
	gint slider_end = 0;
	GtkScale* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_slider;
	current_volume = gtk_range_get_value ((GtkRange*) _tmp0_);
	_tmp1_ = self->priv->mixer;
	vol_max = gvc_mixer_control_get_vol_max_norm (_tmp1_);
	_tmp2_ = self->priv->mixer;
	vol_max_above = gvc_mixer_control_get_vol_max_amplified (_tmp2_);
	if (allow_overdrive) {
		_tmp3_ = vol_max_above / 20;
	} else {
		_tmp3_ = vol_max / 20;
	}
	step_size = _tmp3_;
	slider_start = 0;
	slider_end = 0;
	_tmp4_ = self->priv->volume_slider;
	gtk_range_get_slider_range ((GtkRange*) _tmp4_, &_tmp5_, &_tmp6_);
	slider_start = _tmp5_;
	slider_end = _tmp6_;
	if (allow_overdrive) {
		_tmp7_ = ((gdouble) slider_end) != vol_max_above;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GtkScale* _tmp8_;
		GtkScale* _tmp9_;
		GtkScale* _tmp10_;
		_tmp8_ = self->priv->volume_slider;
		gtk_range_set_increments ((GtkRange*) _tmp8_, step_size, step_size);
		_tmp9_ = self->priv->volume_slider;
		gtk_range_set_range ((GtkRange*) _tmp9_, (gdouble) 0, vol_max_above);
		_tmp10_ = self->priv->volume_slider;
		gtk_range_set_value ((GtkRange*) _tmp10_, current_volume);
	} else {
		gboolean _tmp11_ = FALSE;
		if (!allow_overdrive) {
			_tmp11_ = ((gdouble) slider_end) != vol_max;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GtkScale* _tmp12_;
			GtkScale* _tmp13_;
			GtkScale* _tmp14_;
			_tmp12_ = self->priv->volume_slider;
			gtk_range_set_increments ((GtkRange*) _tmp12_, step_size, step_size);
			_tmp13_ = self->priv->volume_slider;
			gtk_range_set_range ((GtkRange*) _tmp13_, (gdouble) 0, vol_max);
			_tmp14_ = self->priv->volume_slider;
			gtk_range_set_value ((GtkRange*) _tmp14_, current_volume);
		}
	}
	sound_output_raven_widget_update_input_draw_markers (self);
}

/**
 * update_input_draw_markers will update our draw markers
 */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
sound_output_raven_widget_update_input_draw_markers (SoundOutputRavenWidget* self)
{
	gboolean builtin_enabled = FALSE;
	GSettings* _tmp0_;
	gchar* current_theme = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gboolean supported_theme = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->budgie_settings;
	builtin_enabled = g_settings_get_boolean (_tmp0_, "builtin-theme");
	_tmp1_ = self->priv->gnome_desktop_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "gtk-theme");
	current_theme = _tmp2_;
	_tmp3_ = current_theme;
	supported_theme = string_index_of (_tmp3_, "Arc", 0) == -1;
	if (!builtin_enabled) {
		_tmp4_ = supported_theme;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean allow_higher_than_max = FALSE;
		GSettings* _tmp5_;
		_tmp5_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
		allow_higher_than_max = g_settings_get_boolean (_tmp5_, "allow-volume-overdrive");
		if (allow_higher_than_max) {
			gdouble vol_max = 0.0;
			GvcMixerControl* _tmp6_;
			GtkScale* _tmp7_;
			_tmp6_ = self->priv->mixer;
			vol_max = gvc_mixer_control_get_vol_max_norm (_tmp6_);
			_tmp7_ = self->priv->volume_slider;
			gtk_scale_add_mark (_tmp7_, vol_max, GTK_POS_BOTTOM, "");
		} else {
			GtkScale* _tmp8_;
			_tmp8_ = self->priv->volume_slider;
			gtk_scale_clear_marks (_tmp8_);
		}
	} else {
		GtkScale* _tmp9_;
		_tmp9_ = self->priv->volume_slider;
		gtk_scale_clear_marks (_tmp9_);
	}
	_g_free0 (current_theme);
}

/**
 * update_volume will handle updating our volume slider and output header during device change
 */
static void
sound_output_raven_widget_update_volume (SoundOutputRavenWidget* self)
{
	guint32 vol = 0U;
	GvcMixerStream* _tmp0_;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp1_;
	GSettings* _tmp2_;
	gint n = 0;
	gchar* image_name = NULL;
	gchar* icon_prefix = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GvcMixerStream* _tmp6_;
	GtkImage* header_image = NULL;
	GtkButton* _tmp11_;
	GtkWidget* _tmp12_;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gdouble step_size = 0.0;
	GtkScale* _tmp20_;
	GtkScale* _tmp21_;
	GtkScale* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_stream;
	vol = gvc_mixer_stream_get_volume (_tmp0_);
	_tmp1_ = self->priv->mixer;
	vol_max = gvc_mixer_control_get_vol_max_norm (_tmp1_);
	_tmp2_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
	if (g_settings_get_boolean (_tmp2_, "allow-volume-overdrive")) {
		GvcMixerControl* _tmp3_;
		_tmp3_ = self->priv->mixer;
		vol_max = gvc_mixer_control_get_vol_max_amplified (_tmp3_);
	}
	n = ((gint) floor ((3 * vol) / vol_max)) + 1;
	_tmp4_ = g_strdup ("audio-volume");
	icon_prefix = _tmp4_;
	_tmp6_ = self->priv->primary_stream;
	if (gvc_mixer_stream_get_is_muted (_tmp6_)) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = vol <= ((guint32) 0);
	}
	if (_tmp5_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("muted");
		_g_free0 (image_name);
		image_name = _tmp7_;
	} else {
		switch (n) {
			case 1:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("low");
				_g_free0 (image_name);
				image_name = _tmp8_;
				break;
			}
			case 2:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("medium");
				_g_free0 (image_name);
				image_name = _tmp9_;
				break;
			}
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("high");
				_g_free0 (image_name);
				image_name = _tmp10_;
				break;
			}
		}
	}
	_tmp11_ = self->priv->header_icon;
	_tmp12_ = gtk_button_get_image (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_image_get_type (), GtkImage));
	header_image = _tmp13_;
	_tmp14_ = header_image;
	_tmp15_ = icon_prefix;
	_tmp16_ = image_name;
	_tmp17_ = g_strdup_printf ("%s-%s-symbolic", _tmp15_, _tmp16_);
	_tmp18_ = _tmp17_;
	gtk_image_set_from_icon_name (_tmp14_, _tmp18_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp18_);
	step_size = vol_max / 20;
	if (self->priv->scale_id > ((gulong) 0)) {
		GtkScale* _tmp19_;
		_tmp19_ = self->priv->volume_slider;
		g_signal_handler_block (_tmp19_, self->priv->scale_id);
	}
	_tmp20_ = self->priv->volume_slider;
	gtk_range_set_increments ((GtkRange*) _tmp20_, step_size, step_size);
	_tmp21_ = self->priv->volume_slider;
	gtk_range_set_range ((GtkRange*) _tmp21_, (gdouble) 0, vol_max);
	_tmp22_ = self->priv->volume_slider;
	gtk_range_set_value ((GtkRange*) _tmp22_, (gdouble) vol);
	if (self->priv->scale_id > ((gulong) 0)) {
		GtkScale* _tmp23_;
		_tmp23_ = self->priv->volume_slider;
		g_signal_handler_unblock (_tmp23_, self->priv->scale_id);
	}
	_g_object_unref0 (header_image);
	_g_free0 (icon_prefix);
	_g_free0 (image_name);
}

static void
sound_output_raven_widget_settings_updated (SoundOutputRavenWidget* self,
                                            const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "allow-volume-overdrive") == 0) {
		GSettings* _tmp0_;
		_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
		sound_output_raven_widget_set_slider_range_on_max (self, g_settings_get_boolean (_tmp0_, key));
	}
}

static GtkWidget*
sound_output_raven_widget_real_build_settings_ui (BudgieRavenWidget* base)
{
	SoundOutputRavenWidget * self;
	GSettings* _tmp0_;
	SoundOutputRavenWidgetSettings* _tmp1_;
	GtkWidget* result;
	self = (SoundOutputRavenWidget*) base;
	_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
	_tmp1_ = sound_output_raven_widget_settings_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (GtkWidget*) _tmp1_;
	return result;
}

static void
sound_output_raven_widget_class_init (SoundOutputRavenWidgetClass * klass,
                                      gpointer klass_data)
{
	sound_output_raven_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundOutputRavenWidget_private_offset);
	((BudgieRavenWidgetClass *) klass)->build_settings_ui = (GtkWidget* (*) (BudgieRavenWidget*)) sound_output_raven_widget_real_build_settings_ui;
	G_OBJECT_CLASS (klass)->finalize = sound_output_raven_widget_finalize;
	/**
	 * Signals
	 */
	sound_output_raven_widget_signals[SOUND_OUTPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL] = g_signal_new ("devices-state-changed", TYPE_SOUND_OUTPUT_RAVEN_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sound_output_raven_widget_instance_init (SoundOutputRavenWidget * self,
                                         gpointer klass)
{
	self->priv = sound_output_raven_widget_get_instance_private (self);
	self->priv->gnome_sound_settings = NULL;
	self->priv->budgie_settings = NULL;
	self->priv->gnome_desktop_settings = NULL;
	self->priv->scale_id = (gulong) 0;
	self->priv->mixer = NULL;
	self->priv->primary_notify_id = (gulong) 0;
	self->priv->primary_stream = NULL;
	self->priv->main_box = NULL;
	self->priv->apps_area = NULL;
	self->priv->apps_listbox = NULL;
	self->priv->apps_placeholder_label = NULL;
	self->priv->devices_list = NULL;
	self->priv->header = NULL;
	self->priv->header_icon = NULL;
	self->priv->header_reveal_button = NULL;
	self->priv->content_revealer = NULL;
	self->priv->content = NULL;
	self->priv->widget_area = NULL;
	self->priv->widget_area_switch = NULL;
	self->priv->volume_slider = NULL;
}

static void
sound_output_raven_widget_finalize (GObject * obj)
{
	SoundOutputRavenWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOUND_OUTPUT_RAVEN_WIDGET, SoundOutputRavenWidget);
	_g_object_unref0 (self->priv->gnome_sound_settings);
	_g_object_unref0 (self->priv->budgie_settings);
	_g_object_unref0 (self->priv->gnome_desktop_settings);
	_g_object_unref0 (self->priv->mixer);
	_g_hash_table_unref0 (self->priv->apps);
	_g_hash_table_unref0 (self->priv->derpers);
	_g_hash_table_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->primary_stream);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->apps_area);
	_g_object_unref0 (self->priv->apps_listbox);
	_g_object_unref0 (self->priv->apps_placeholder_label);
	_g_object_unref0 (self->priv->devices_list);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->header_icon);
	_g_object_unref0 (self->priv->header_reveal_button);
	_g_object_unref0 (self->priv->content_revealer);
	_g_object_unref0 (self->priv->content);
	_g_object_unref0 (self->priv->widget_area);
	_g_object_unref0 (self->priv->widget_area_switch);
	_g_object_unref0 (self->priv->volume_slider);
	G_OBJECT_CLASS (sound_output_raven_widget_parent_class)->finalize (obj);
}

GType
sound_output_raven_widget_get_type (void)
{
	return sound_output_raven_widget_type_id;
}

GType
sound_output_raven_widget_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundOutputRavenWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_output_raven_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundOutputRavenWidget), 0, (GInstanceInitFunc) sound_output_raven_widget_instance_init, NULL };
	sound_output_raven_widget_type_id = g_type_module_register_type (module, budgie_raven_widget_get_type (), "SoundOutputRavenWidget", &g_define_type_info, 0);
	SoundOutputRavenWidget_private_offset = sizeof (SoundOutputRavenWidgetPrivate);
	return sound_output_raven_widget_type_id;
}

static inline gpointer
sound_output_raven_widget_settings_get_instance_private (SoundOutputRavenWidgetSettings* self)
{
	return G_STRUCT_MEMBER_P (self, SoundOutputRavenWidgetSettings_private_offset);
}

SoundOutputRavenWidgetSettings*
sound_output_raven_widget_settings_construct (GType object_type,
                                              GSettings* settings)
{
	SoundOutputRavenWidgetSettings * self = NULL;
	GtkSwitch* _tmp0_;
	self = (SoundOutputRavenWidgetSettings*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->switch_allow_volume_overdrive;
	g_settings_bind (settings, "allow-volume-overdrive", (GObject*) _tmp0_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

SoundOutputRavenWidgetSettings*
sound_output_raven_widget_settings_new (GSettings* settings)
{
	return sound_output_raven_widget_settings_construct (TYPE_SOUND_OUTPUT_RAVEN_WIDGET_SETTINGS, settings);
}

static void
sound_output_raven_widget_settings_class_init (SoundOutputRavenWidgetSettingsClass * klass,
                                               gpointer klass_data)
{
	sound_output_raven_widget_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundOutputRavenWidgetSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sound_output_raven_widget_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/buddiesofbudgie/budgie-desktop/raven/widget/SoundOutput/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_allow_volume_overdrive", FALSE, SoundOutputRavenWidgetSettings_private_offset + G_STRUCT_OFFSET (SoundOutputRavenWidgetSettingsPrivate, switch_allow_volume_overdrive));
}

static void
sound_output_raven_widget_settings_instance_init (SoundOutputRavenWidgetSettings * self,
                                                  gpointer klass)
{
	self->priv = sound_output_raven_widget_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
sound_output_raven_widget_settings_finalize (GObject * obj)
{
	SoundOutputRavenWidgetSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOUND_OUTPUT_RAVEN_WIDGET_SETTINGS, SoundOutputRavenWidgetSettings);
	G_OBJECT_CLASS (sound_output_raven_widget_settings_parent_class)->finalize (obj);
}

GType
sound_output_raven_widget_settings_get_type (void)
{
	return sound_output_raven_widget_settings_type_id;
}

GType
sound_output_raven_widget_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundOutputRavenWidgetSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_output_raven_widget_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundOutputRavenWidgetSettings), 0, (GInstanceInitFunc) sound_output_raven_widget_settings_instance_init, NULL };
	sound_output_raven_widget_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "SoundOutputRavenWidgetSettings", &g_define_type_info, 0);
	SoundOutputRavenWidgetSettings_private_offset = sizeof (SoundOutputRavenWidgetSettingsPrivate);
	return sound_output_raven_widget_settings_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	budgie_app_sound_control_register_type (module);
	sound_output_raven_plugin_register_type (module);
	sound_output_raven_widget_register_type (module);
	sound_output_raven_widget_settings_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_raven_plugin_get_type (), TYPE_SOUND_OUTPUT_RAVEN_PLUGIN);
	_g_object_unref0 (objmodule);
}

