/* DBusInterfaces.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DBusInterfaces.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "budgiemenuapplet.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_ACCOUNTS_REMOTE (accounts_remote_get_type ())
#define ACCOUNTS_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_REMOTE, AccountsRemote))
#define IS_ACCOUNTS_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_REMOTE))
#define ACCOUNTS_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNTS_REMOTE, AccountsRemoteIface))

typedef struct _AccountsRemote AccountsRemote;
typedef struct _AccountsRemoteIface AccountsRemoteIface;

#define TYPE_ACCOUNTS_REMOTE_PROXY (accounts_remote_proxy_get_type ())
typedef GDBusProxy AccountsRemoteProxy;
typedef GDBusProxyClass AccountsRemoteProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ACCOUNT_USER_REMOTE (account_user_remote_get_type ())
#define ACCOUNT_USER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_USER_REMOTE, AccountUserRemote))
#define IS_ACCOUNT_USER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_USER_REMOTE))
#define ACCOUNT_USER_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNT_USER_REMOTE, AccountUserRemoteIface))

typedef struct _AccountUserRemote AccountUserRemote;
typedef struct _AccountUserRemoteIface AccountUserRemoteIface;

#define TYPE_ACCOUNT_USER_REMOTE_PROXY (account_user_remote_proxy_get_type ())
enum  {
	ACCOUNT_USER_REMOTE_CHANGED_SIGNAL,
	ACCOUNT_USER_REMOTE_NUM_SIGNALS
};
static guint account_user_remote_signals[ACCOUNT_USER_REMOTE_NUM_SIGNALS] = {0};
typedef GDBusProxy AccountUserRemoteProxy;
typedef GDBusProxyClass AccountUserRemoteProxyClass;

#define TYPE_PROPERTIES_REMOTE (properties_remote_get_type ())
#define PROPERTIES_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_REMOTE, PropertiesRemote))
#define IS_PROPERTIES_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_REMOTE))
#define PROPERTIES_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROPERTIES_REMOTE, PropertiesRemoteIface))

typedef struct _PropertiesRemote PropertiesRemote;
typedef struct _PropertiesRemoteIface PropertiesRemoteIface;

#define TYPE_PROPERTIES_REMOTE_PROXY (properties_remote_proxy_get_type ())
enum  {
	PROPERTIES_REMOTE_PROPERTIES_CHANGED_SIGNAL,
	PROPERTIES_REMOTE_NUM_SIGNALS
};
static guint properties_remote_signals[PROPERTIES_REMOTE_NUM_SIGNALS] = {0};
typedef GDBusProxy PropertiesRemoteProxy;
typedef GDBusProxyClass PropertiesRemoteProxyClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_POWER_DIALOG_REMOTE (power_dialog_remote_get_type ())
#define POWER_DIALOG_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POWER_DIALOG_REMOTE, PowerDialogRemote))
#define IS_POWER_DIALOG_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POWER_DIALOG_REMOTE))
#define POWER_DIALOG_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POWER_DIALOG_REMOTE, PowerDialogRemoteIface))

typedef struct _PowerDialogRemote PowerDialogRemote;
typedef struct _PowerDialogRemoteIface PowerDialogRemoteIface;

#define TYPE_POWER_DIALOG_REMOTE_PROXY (power_dialog_remote_proxy_get_type ())
typedef GDBusProxy PowerDialogRemoteProxy;
typedef GDBusProxyClass PowerDialogRemoteProxyClass;
enum  {
	XDG_DIR_TRACKER_REMOTE_XDG_DIRS_EXIST_SIGNAL,
	XDG_DIR_TRACKER_REMOTE_NUM_SIGNALS
};
static guint xdg_dir_tracker_remote_signals[XDG_DIR_TRACKER_REMOTE_NUM_SIGNALS] = {0};
typedef GDBusProxy XDGDirTrackerRemoteProxy;
typedef GDBusProxyClass XDGDirTrackerRemoteProxyClass;

struct _AccountsRemoteIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (AccountsRemote* self, const gchar* username, GError** error);
};

struct _AccountUserRemoteIface {
	GTypeInterface parent_iface;
};

struct _PropertiesRemoteIface {
	GTypeInterface parent_iface;
	GVariant* (*get) (PropertiesRemote* self, const gchar* interface, const gchar* property, GError** error);
};

struct _PowerDialogRemoteIface {
	GTypeInterface parent_iface;
	void (*Toggle) (PowerDialogRemote* self, GError** error);
};

static GType accounts_remote_type_id = 0;
static GType account_user_remote_type_id = 0;
static GType properties_remote_type_id = 0;
static GType power_dialog_remote_type_id = 0;
static GType xdg_dir_tracker_remote_type_id = 0;

VALA_EXTERN GType accounts_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void accounts_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint accounts_remote_register_object (void* object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error);
GType accounts_remote_register_type (GTypeModule * module);
VALA_EXTERN GType accounts_remote_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* accounts_remote_find_user_by_name (AccountsRemote* self,
                                          const gchar* username,
                                          GError** error);
static void accounts_remote_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters);
static gchar* accounts_remote_proxy_find_user_by_name (AccountsRemote* self,
                                                const gchar* username,
                                                GError** error);
static void accounts_remote_proxy_accounts_remote_interface_init (AccountsRemoteIface* iface);
static void _dbus_accounts_remote_find_user_by_name (AccountsRemote* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void accounts_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* accounts_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean accounts_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _accounts_remote_unregister_object (gpointer user_data);
GType account_user_remote_register_type (GTypeModule * module);
VALA_EXTERN GType account_user_remote_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType account_user_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void account_user_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint account_user_remote_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
static void account_user_remote_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void _dbus_handle_account_user_remote_changed (AccountUserRemote* self,
                                               GVariant* parameters);
static void account_user_remote_proxy_account_user_remote_interface_init (AccountUserRemoteIface* iface);
static void account_user_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* account_user_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean account_user_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_account_user_remote_changed (GObject* _sender,
                                        gpointer* _data);
static void _account_user_remote_unregister_object (gpointer user_data);
VALA_EXTERN GType properties_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void properties_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint properties_remote_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
GType properties_remote_register_type (GTypeModule * module);
VALA_EXTERN GType properties_remote_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GVariant* properties_remote_get (PropertiesRemote* self,
                                 const gchar* interface,
                                 const gchar* property,
                                 GError** error);
static void properties_remote_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _dbus_handle_properties_remote_properties_changed (PropertiesRemote* self,
                                                        GVariant* parameters);
static GVariant* properties_remote_proxy_get (PropertiesRemote* self,
                                       const gchar* interface,
                                       const gchar* property,
                                       GError** error);
static void properties_remote_proxy_properties_remote_interface_init (PropertiesRemoteIface* iface);
static void _dbus_properties_remote_get (PropertiesRemote* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation);
static void properties_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* properties_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean properties_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_properties_remote_properties_changed (GObject* _sender,
                                                 gpointer* _data);
static void _properties_remote_unregister_object (gpointer user_data);
VALA_EXTERN GType power_dialog_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void power_dialog_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint power_dialog_remote_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
GType power_dialog_remote_register_type (GTypeModule * module);
VALA_EXTERN GType power_dialog_remote_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void power_dialog_remote_Toggle (PowerDialogRemote* self,
                                 GError** error);
static void power_dialog_remote_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void power_dialog_remote_proxy_Toggle (PowerDialogRemote* self,
                                       GError** error);
static void power_dialog_remote_proxy_power_dialog_remote_interface_init (PowerDialogRemoteIface* iface);
static void _dbus_power_dialog_remote_Toggle (PowerDialogRemote* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void power_dialog_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* power_dialog_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean power_dialog_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _power_dialog_remote_unregister_object (gpointer user_data);
static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void xdg_dir_tracker_remote_proxy_g_signal (GDBusProxy* proxy,
                                            const gchar* sender_name,
                                            const gchar* signal_name,
                                            GVariant* parameters);
static void _dbus_handle_xdg_dir_tracker_remote_xdg_dirs_exist (XDGDirTrackerRemote* self,
                                                         GVariant* parameters);
static GUserDirectory* xdg_dir_tracker_remote_proxy_get_dirs (XDGDirTrackerRemote* self,
                                                       gint* result_length1,
                                                       GError** error);
static void xdg_dir_tracker_remote_proxy_xdg_dir_tracker_remote_interface_init (XDGDirTrackerRemoteIface* iface);
static void _dbus_xdg_dir_tracker_remote_get_dirs (XDGDirTrackerRemote* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void xdg_dir_tracker_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* xdg_dir_tracker_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean xdg_dir_tracker_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _dbus_xdg_dir_tracker_remote_xdg_dirs_exist (GObject* _sender,
                                                  GUserDirectory* dirs,
                                                  gint dirs_length1,
                                                  gpointer* _data);
static void _xdg_dir_tracker_remote_unregister_object (gpointer user_data);

static const GDBusArgInfo _accounts_remote_dbus_arg_info_find_user_by_name_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _accounts_remote_dbus_arg_info_find_user_by_name_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _accounts_remote_dbus_arg_info_find_user_by_name_in[] = {&_accounts_remote_dbus_arg_info_find_user_by_name_username, NULL};
static const GDBusArgInfo * const _accounts_remote_dbus_arg_info_find_user_by_name_out[] = {&_accounts_remote_dbus_arg_info_find_user_by_name_result, NULL};
static const GDBusMethodInfo _accounts_remote_dbus_method_info_find_user_by_name = {-1, "FindUserByName", (GDBusArgInfo **) (&_accounts_remote_dbus_arg_info_find_user_by_name_in), (GDBusArgInfo **) (&_accounts_remote_dbus_arg_info_find_user_by_name_out), NULL};
static const GDBusMethodInfo * const _accounts_remote_dbus_method_info[] = {&_accounts_remote_dbus_method_info_find_user_by_name, NULL};
static const GDBusSignalInfo * const _accounts_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _accounts_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _accounts_remote_dbus_interface_info = {-1, "org.freedesktop.Accounts", (GDBusMethodInfo **) (&_accounts_remote_dbus_method_info), (GDBusSignalInfo **) (&_accounts_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_accounts_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _accounts_remote_dbus_interface_vtable = {accounts_remote_dbus_interface_method_call, accounts_remote_dbus_interface_get_property, accounts_remote_dbus_interface_set_property};
static const GDBusMethodInfo * const _account_user_remote_dbus_method_info[] = {NULL};
static const GDBusArgInfo * const _account_user_remote_dbus_arg_info_changed[] = {NULL};
static const GDBusSignalInfo _account_user_remote_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_account_user_remote_dbus_arg_info_changed), NULL};
static const GDBusSignalInfo * const _account_user_remote_dbus_signal_info[] = {&_account_user_remote_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo * const _account_user_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _account_user_remote_dbus_interface_info = {-1, "org.freedesktop.Accounts.User", (GDBusMethodInfo **) (&_account_user_remote_dbus_method_info), (GDBusSignalInfo **) (&_account_user_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_account_user_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _account_user_remote_dbus_interface_vtable = {account_user_remote_dbus_interface_method_call, account_user_remote_dbus_interface_get_property, account_user_remote_dbus_interface_set_property};
static const GDBusArgInfo _properties_remote_dbus_arg_info_get_interface = {-1, "interface", "s", NULL};
static const GDBusArgInfo _properties_remote_dbus_arg_info_get_property = {-1, "property", "s", NULL};
static const GDBusArgInfo _properties_remote_dbus_arg_info_get_result = {-1, "result", "v", NULL};
static const GDBusArgInfo * const _properties_remote_dbus_arg_info_get_in[] = {&_properties_remote_dbus_arg_info_get_interface, &_properties_remote_dbus_arg_info_get_property, NULL};
static const GDBusArgInfo * const _properties_remote_dbus_arg_info_get_out[] = {&_properties_remote_dbus_arg_info_get_result, NULL};
static const GDBusMethodInfo _properties_remote_dbus_method_info_get = {-1, "Get", (GDBusArgInfo **) (&_properties_remote_dbus_arg_info_get_in), (GDBusArgInfo **) (&_properties_remote_dbus_arg_info_get_out), NULL};
static const GDBusMethodInfo * const _properties_remote_dbus_method_info[] = {&_properties_remote_dbus_method_info_get, NULL};
static const GDBusArgInfo * const _properties_remote_dbus_arg_info_properties_changed[] = {NULL};
static const GDBusSignalInfo _properties_remote_dbus_signal_info_properties_changed = {-1, "PropertiesChanged", (GDBusArgInfo **) (&_properties_remote_dbus_arg_info_properties_changed), NULL};
static const GDBusSignalInfo * const _properties_remote_dbus_signal_info[] = {&_properties_remote_dbus_signal_info_properties_changed, NULL};
static const GDBusPropertyInfo * const _properties_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _properties_remote_dbus_interface_info = {-1, "org.freedesktop.DBus.Properties", (GDBusMethodInfo **) (&_properties_remote_dbus_method_info), (GDBusSignalInfo **) (&_properties_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_properties_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _properties_remote_dbus_interface_vtable = {properties_remote_dbus_interface_method_call, properties_remote_dbus_interface_get_property, properties_remote_dbus_interface_set_property};
static const GDBusArgInfo * const _power_dialog_remote_dbus_arg_info_Toggle_in[] = {NULL};
static const GDBusArgInfo * const _power_dialog_remote_dbus_arg_info_Toggle_out[] = {NULL};
static const GDBusMethodInfo _power_dialog_remote_dbus_method_info_Toggle = {-1, "Toggle", (GDBusArgInfo **) (&_power_dialog_remote_dbus_arg_info_Toggle_in), (GDBusArgInfo **) (&_power_dialog_remote_dbus_arg_info_Toggle_out), NULL};
static const GDBusMethodInfo * const _power_dialog_remote_dbus_method_info[] = {&_power_dialog_remote_dbus_method_info_Toggle, NULL};
static const GDBusSignalInfo * const _power_dialog_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _power_dialog_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _power_dialog_remote_dbus_interface_info = {-1, "org.buddiesofbudgie.PowerDialog", (GDBusMethodInfo **) (&_power_dialog_remote_dbus_method_info), (GDBusSignalInfo **) (&_power_dialog_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_power_dialog_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_dialog_remote_dbus_interface_vtable = {power_dialog_remote_dbus_interface_method_call, power_dialog_remote_dbus_interface_get_property, power_dialog_remote_dbus_interface_set_property};
static const GDBusArgInfo _xdg_dir_tracker_remote_dbus_arg_info_get_dirs_result = {-1, "result", "ai", NULL};
static const GDBusArgInfo * const _xdg_dir_tracker_remote_dbus_arg_info_get_dirs_in[] = {NULL};
static const GDBusArgInfo * const _xdg_dir_tracker_remote_dbus_arg_info_get_dirs_out[] = {&_xdg_dir_tracker_remote_dbus_arg_info_get_dirs_result, NULL};
static const GDBusMethodInfo _xdg_dir_tracker_remote_dbus_method_info_get_dirs = {-1, "GetDirs", (GDBusArgInfo **) (&_xdg_dir_tracker_remote_dbus_arg_info_get_dirs_in), (GDBusArgInfo **) (&_xdg_dir_tracker_remote_dbus_arg_info_get_dirs_out), NULL};
static const GDBusMethodInfo * const _xdg_dir_tracker_remote_dbus_method_info[] = {&_xdg_dir_tracker_remote_dbus_method_info_get_dirs, NULL};
static const GDBusArgInfo _xdg_dir_tracker_remote_dbus_arg_info_xdg_dirs_exist_dirs = {-1, "dirs", "ai", NULL};
static const GDBusArgInfo * const _xdg_dir_tracker_remote_dbus_arg_info_xdg_dirs_exist[] = {&_xdg_dir_tracker_remote_dbus_arg_info_xdg_dirs_exist_dirs, NULL};
static const GDBusSignalInfo _xdg_dir_tracker_remote_dbus_signal_info_xdg_dirs_exist = {-1, "XdgDirsExist", (GDBusArgInfo **) (&_xdg_dir_tracker_remote_dbus_arg_info_xdg_dirs_exist), NULL};
static const GDBusSignalInfo * const _xdg_dir_tracker_remote_dbus_signal_info[] = {&_xdg_dir_tracker_remote_dbus_signal_info_xdg_dirs_exist, NULL};
static const GDBusPropertyInfo * const _xdg_dir_tracker_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _xdg_dir_tracker_remote_dbus_interface_info = {-1, "org.buddiesofbudgie.XDGDirTracker", (GDBusMethodInfo **) (&_xdg_dir_tracker_remote_dbus_method_info), (GDBusSignalInfo **) (&_xdg_dir_tracker_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_xdg_dir_tracker_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _xdg_dir_tracker_remote_dbus_interface_vtable = {xdg_dir_tracker_remote_dbus_interface_method_call, xdg_dir_tracker_remote_dbus_interface_get_property, xdg_dir_tracker_remote_dbus_interface_set_property};

gchar*
accounts_remote_find_user_by_name (AccountsRemote* self,
                                   const gchar* username,
                                   GError** error)
{
	AccountsRemoteIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ACCOUNTS_REMOTE_GET_INTERFACE (self);
	if (_iface_->find_user_by_name) {
		return _iface_->find_user_by_name (self, username, error);
	}
	return NULL;
}

static void
accounts_remote_default_init (AccountsRemoteIface * iface,
                              gpointer iface_data)
{
}

GType
accounts_remote_get_type (void)
{
	return accounts_remote_type_id;
}

GType
accounts_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	accounts_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "AccountsRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (accounts_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (accounts_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) accounts_remote_proxy_get_type);
	g_type_set_qdata (accounts_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts");
	g_type_set_qdata (accounts_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_accounts_remote_dbus_interface_info));
	g_type_set_qdata (accounts_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) accounts_remote_register_object);
	return accounts_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (AccountsRemoteProxy, accounts_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_ACCOUNTS_REMOTE, accounts_remote_proxy_accounts_remote_interface_init) )
static void
accounts_remote_proxy_class_init (AccountsRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = accounts_remote_proxy_g_signal;
}

static void
accounts_remote_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters)
{
}

static void
accounts_remote_proxy_class_finalize (AccountsRemoteProxyClass* klass)
{
}

void
accounts_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	accounts_remote_proxy_register_type (module);
}

static void
accounts_remote_proxy_init (AccountsRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_accounts_remote_dbus_interface_info));
}

static gchar*
accounts_remote_proxy_find_user_by_name (AccountsRemote* self,
                                         const gchar* username,
                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp0_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts", "FindUserByName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (username));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static void
accounts_remote_proxy_accounts_remote_interface_init (AccountsRemoteIface* iface)
{
	iface->find_user_by_name = accounts_remote_proxy_find_user_by_name;
}

static void
_dbus_accounts_remote_find_user_by_name (AccountsRemote* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp1_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	result = accounts_remote_find_user_by_name (self, username, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
accounts_remote_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindUserByName") == 0) {
		_dbus_accounts_remote_find_user_by_name (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
accounts_remote_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
accounts_remote_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
accounts_remote_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_accounts_remote_dbus_interface_info), &_accounts_remote_dbus_interface_vtable, data, _accounts_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_accounts_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
account_user_remote_default_init (AccountUserRemoteIface * iface,
                                  gpointer iface_data)
{
	account_user_remote_signals[ACCOUNT_USER_REMOTE_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_ACCOUNT_USER_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

GType
account_user_remote_get_type (void)
{
	return account_user_remote_type_id;
}

GType
account_user_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountUserRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_user_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	account_user_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "AccountUserRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (account_user_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (account_user_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) account_user_remote_proxy_get_type);
	g_type_set_qdata (account_user_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts.User");
	g_type_set_qdata (account_user_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_account_user_remote_dbus_interface_info));
	g_type_set_qdata (account_user_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) account_user_remote_register_object);
	return account_user_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (AccountUserRemoteProxy, account_user_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_ACCOUNT_USER_REMOTE, account_user_remote_proxy_account_user_remote_interface_init) )
static void
account_user_remote_proxy_class_init (AccountUserRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = account_user_remote_proxy_g_signal;
}

static void
_dbus_handle_account_user_remote_changed (AccountUserRemote* self,
                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "changed");
}

static void
account_user_remote_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_account_user_remote_changed ((AccountUserRemote*) proxy, parameters);
	}
}

static void
account_user_remote_proxy_class_finalize (AccountUserRemoteProxyClass* klass)
{
}

void
account_user_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	account_user_remote_proxy_register_type (module);
}

static void
account_user_remote_proxy_init (AccountUserRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_account_user_remote_dbus_interface_info));
}

static void
account_user_remote_proxy_account_user_remote_interface_init (AccountUserRemoteIface* iface)
{
}

static void
account_user_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
account_user_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
account_user_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_account_user_remote_changed (GObject* _sender,
                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Accounts.User", "Changed", _arguments, NULL);
}

guint
account_user_remote_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_account_user_remote_dbus_interface_info), &_account_user_remote_dbus_interface_vtable, data, _account_user_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_account_user_remote_changed, data);
	return result;
}

static void
_account_user_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_account_user_remote_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

GVariant*
properties_remote_get (PropertiesRemote* self,
                       const gchar* interface,
                       const gchar* property,
                       GError** error)
{
	PropertiesRemoteIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PROPERTIES_REMOTE_GET_INTERFACE (self);
	if (_iface_->get) {
		return _iface_->get (self, interface, property, error);
	}
	return NULL;
}

static void
properties_remote_default_init (PropertiesRemoteIface * iface,
                                gpointer iface_data)
{
	properties_remote_signals[PROPERTIES_REMOTE_PROPERTIES_CHANGED_SIGNAL] = g_signal_new ("properties-changed", TYPE_PROPERTIES_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

GType
properties_remote_get_type (void)
{
	return properties_remote_type_id;
}

GType
properties_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropertiesRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	properties_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "PropertiesRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (properties_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (properties_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) properties_remote_proxy_get_type);
	g_type_set_qdata (properties_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus.Properties");
	g_type_set_qdata (properties_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_properties_remote_dbus_interface_info));
	g_type_set_qdata (properties_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) properties_remote_register_object);
	return properties_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (PropertiesRemoteProxy, properties_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_PROPERTIES_REMOTE, properties_remote_proxy_properties_remote_interface_init) )
static void
properties_remote_proxy_class_init (PropertiesRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = properties_remote_proxy_g_signal;
}

static void
_dbus_handle_properties_remote_properties_changed (PropertiesRemote* self,
                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "properties-changed");
}

static void
properties_remote_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	if (strcmp (signal_name, "PropertiesChanged") == 0) {
		_dbus_handle_properties_remote_properties_changed ((PropertiesRemote*) proxy, parameters);
	}
}

static void
properties_remote_proxy_class_finalize (PropertiesRemoteProxyClass* klass)
{
}

void
properties_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	properties_remote_proxy_register_type (module);
}

static void
properties_remote_proxy_init (PropertiesRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_properties_remote_dbus_interface_info));
}

static GVariant*
properties_remote_proxy_get (PropertiesRemote* self,
                             const gchar* interface,
                             const gchar* property,
                             GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _result = NULL;
	GVariant* _tmp2_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus.Properties", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (interface));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (property));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_variant (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static void
properties_remote_proxy_properties_remote_interface_init (PropertiesRemoteIface* iface)
{
	iface->get = properties_remote_proxy_get;
}

static void
_dbus_properties_remote_get (PropertiesRemote* self,
                             GVariant* _parameters_,
                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* interface = NULL;
	GVariant* _tmp3_;
	gchar* property = NULL;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	interface = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	property = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	result = properties_remote_get (self, interface, property, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_variant (result));
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (interface);
	_g_free0 (property);
	;
}

static void
properties_remote_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Get") == 0) {
		_dbus_properties_remote_get (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
properties_remote_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
properties_remote_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_properties_remote_properties_changed (GObject* _sender,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus.Properties", "PropertiesChanged", _arguments, NULL);
}

guint
properties_remote_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_properties_remote_dbus_interface_info), &_properties_remote_dbus_interface_vtable, data, _properties_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "properties-changed", (GCallback) _dbus_properties_remote_properties_changed, data);
	return result;
}

static void
_properties_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_properties_remote_properties_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
power_dialog_remote_Toggle (PowerDialogRemote* self,
                            GError** error)
{
	PowerDialogRemoteIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = POWER_DIALOG_REMOTE_GET_INTERFACE (self);
	if (_iface_->Toggle) {
		_iface_->Toggle (self, error);
	}
}

static void
power_dialog_remote_default_init (PowerDialogRemoteIface * iface,
                                  gpointer iface_data)
{
}

GType
power_dialog_remote_get_type (void)
{
	return power_dialog_remote_type_id;
}

GType
power_dialog_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerDialogRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_dialog_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	power_dialog_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "PowerDialogRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_dialog_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (power_dialog_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_dialog_remote_proxy_get_type);
	g_type_set_qdata (power_dialog_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.buddiesofbudgie.PowerDialog");
	g_type_set_qdata (power_dialog_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_dialog_remote_dbus_interface_info));
	g_type_set_qdata (power_dialog_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_dialog_remote_register_object);
	return power_dialog_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (PowerDialogRemoteProxy, power_dialog_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_POWER_DIALOG_REMOTE, power_dialog_remote_proxy_power_dialog_remote_interface_init) )
static void
power_dialog_remote_proxy_class_init (PowerDialogRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_dialog_remote_proxy_g_signal;
}

static void
power_dialog_remote_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
power_dialog_remote_proxy_class_finalize (PowerDialogRemoteProxyClass* klass)
{
}

void
power_dialog_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	power_dialog_remote_proxy_register_type (module);
}

static void
power_dialog_remote_proxy_init (PowerDialogRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_dialog_remote_dbus_interface_info));
}

static void
power_dialog_remote_proxy_Toggle (PowerDialogRemote* self,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.buddiesofbudgie.PowerDialog", "Toggle");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
power_dialog_remote_proxy_power_dialog_remote_interface_init (PowerDialogRemoteIface* iface)
{
	iface->Toggle = power_dialog_remote_proxy_Toggle;
}

static void
_dbus_power_dialog_remote_Toggle (PowerDialogRemote* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	power_dialog_remote_Toggle (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
power_dialog_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Toggle") == 0) {
		_dbus_power_dialog_remote_Toggle (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
power_dialog_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
power_dialog_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
power_dialog_remote_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_dialog_remote_dbus_interface_info), &_power_dialog_remote_dbus_interface_vtable, data, _power_dialog_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_power_dialog_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

GUserDirectory*
xdg_dir_tracker_remote_get_dirs (XDGDirTrackerRemote* self,
                                 gint* result_length1,
                                 GError** error)
{
	XDGDirTrackerRemoteIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = XDG_DIR_TRACKER_REMOTE_GET_INTERFACE (self);
	if (_iface_->get_dirs) {
		return _iface_->get_dirs (self, result_length1, error);
	}
	return NULL;
}

static void
g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__POINTER_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
xdg_dir_tracker_remote_default_init (XDGDirTrackerRemoteIface * iface,
                                     gpointer iface_data)
{
	xdg_dir_tracker_remote_signals[XDG_DIR_TRACKER_REMOTE_XDG_DIRS_EXIST_SIGNAL] = g_signal_new ("xdg-dirs-exist", TYPE_XDG_DIR_TRACKER_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
}

GType
xdg_dir_tracker_remote_get_type (void)
{
	return xdg_dir_tracker_remote_type_id;
}

GType
xdg_dir_tracker_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (XDGDirTrackerRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xdg_dir_tracker_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	xdg_dir_tracker_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "XDGDirTrackerRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (xdg_dir_tracker_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (xdg_dir_tracker_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) xdg_dir_tracker_remote_proxy_get_type);
	g_type_set_qdata (xdg_dir_tracker_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.buddiesofbudgie.XDGDirTracker");
	g_type_set_qdata (xdg_dir_tracker_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_xdg_dir_tracker_remote_dbus_interface_info));
	g_type_set_qdata (xdg_dir_tracker_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) xdg_dir_tracker_remote_register_object);
	return xdg_dir_tracker_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (XDGDirTrackerRemoteProxy, xdg_dir_tracker_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_XDG_DIR_TRACKER_REMOTE, xdg_dir_tracker_remote_proxy_xdg_dir_tracker_remote_interface_init) )
static void
xdg_dir_tracker_remote_proxy_class_init (XDGDirTrackerRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = xdg_dir_tracker_remote_proxy_g_signal;
}

static void
_dbus_handle_xdg_dir_tracker_remote_xdg_dirs_exist (XDGDirTrackerRemote* self,
                                                    GVariant* parameters)
{
	GVariantIter _arguments_iter;
	GUserDirectory* dirs = NULL;
	gint dirs_length1;
	GVariant* _tmp5_;
	GUserDirectory* _tmp6_;
	gint _tmp6__length;
	gint _tmp6__size;
	gint _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, parameters);
	dirs_length1 = 0;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (GUserDirectory, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (GUserDirectory, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_get_int32 (_tmp8_);
		g_variant_unref (_tmp8_);
	}
	dirs_length1 = _tmp6__length1;
	dirs = _tmp6_;
	g_variant_unref (_tmp5_);
	g_signal_emit_by_name (self, "xdg-dirs-exist", dirs, dirs_length1);
	dirs = (g_free (dirs), NULL);
}

static void
xdg_dir_tracker_remote_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters)
{
	if (strcmp (signal_name, "XdgDirsExist") == 0) {
		_dbus_handle_xdg_dir_tracker_remote_xdg_dirs_exist ((XDGDirTrackerRemote*) proxy, parameters);
	}
}

static void
xdg_dir_tracker_remote_proxy_class_finalize (XDGDirTrackerRemoteProxyClass* klass)
{
}

void
xdg_dir_tracker_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	xdg_dir_tracker_remote_proxy_register_type (module);
}

static void
xdg_dir_tracker_remote_proxy_init (XDGDirTrackerRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_xdg_dir_tracker_remote_dbus_interface_info));
}

static GUserDirectory*
xdg_dir_tracker_remote_proxy_get_dirs (XDGDirTrackerRemote* self,
                                       gint* result_length1,
                                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GUserDirectory* _result = NULL;
	gint _result_length1;
	GVariant* _tmp9_;
	GUserDirectory* _tmp10_;
	gint _tmp10__length;
	gint _tmp10__size;
	gint _tmp10__length1;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.buddiesofbudgie.XDGDirTracker", "GetDirs");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp9_ = g_variant_iter_next_value (&_reply_iter);
	_tmp10_ = g_new (GUserDirectory, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	g_variant_iter_init (&_tmp11_, _tmp9_);
	for (; (_tmp12_ = g_variant_iter_next_value (&_tmp11_)) != NULL; _tmp10__length1++) {
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (GUserDirectory, _tmp10_, _tmp10__size + 1);
		}
		_tmp10_[_tmp10__length++] = g_variant_get_int32 (_tmp12_);
		g_variant_unref (_tmp12_);
	}
	_result_length1 = _tmp10__length1;
	_result = _tmp10_;
	g_variant_unref (_tmp9_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static void
xdg_dir_tracker_remote_proxy_xdg_dir_tracker_remote_interface_init (XDGDirTrackerRemoteIface* iface)
{
	iface->get_dirs = xdg_dir_tracker_remote_proxy_get_dirs;
}

static void
_dbus_xdg_dir_tracker_remote_get_dirs (XDGDirTrackerRemote* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUserDirectory* result;
	gint result_length1 = 0;
	GUserDirectory* _tmp13_;
	GVariantBuilder _tmp14_;
	gint _tmp15_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = xdg_dir_tracker_remote_get_dirs (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp13_ = result;
	g_variant_builder_init (&_tmp14_, G_VARIANT_TYPE ("ai"));
	for (_tmp15_ = 0; _tmp15_ < result_length1; _tmp15_++) {
		g_variant_builder_add_value (&_tmp14_, g_variant_new_int32 (*_tmp13_));
		_tmp13_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp14_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
xdg_dir_tracker_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetDirs") == 0) {
		_dbus_xdg_dir_tracker_remote_get_dirs (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
xdg_dir_tracker_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
xdg_dir_tracker_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_xdg_dir_tracker_remote_xdg_dirs_exist (GObject* _sender,
                                             GUserDirectory* dirs,
                                             gint dirs_length1,
                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GUserDirectory* _tmp16_;
	GVariantBuilder _tmp17_;
	gint _tmp18_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp16_ = dirs;
	g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE ("ai"));
	for (_tmp18_ = 0; _tmp18_ < dirs_length1; _tmp18_++) {
		g_variant_builder_add_value (&_tmp17_, g_variant_new_int32 (*_tmp16_));
		_tmp16_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp17_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.XDGDirTracker", "XdgDirsExist", _arguments, NULL);
}

guint
xdg_dir_tracker_remote_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_xdg_dir_tracker_remote_dbus_interface_info), &_xdg_dir_tracker_remote_dbus_interface_vtable, data, _xdg_dir_tracker_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "xdg-dirs-exist", (GCallback) _dbus_xdg_dir_tracker_remote_xdg_dirs_exist, data);
	return result;
}

static void
_xdg_dir_tracker_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_xdg_dir_tracker_remote_xdg_dirs_exist, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

