// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: cc/arduino/cli/commands/v1/upload.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UploadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the target board (e.g., `arduino:avr:uno`).
	// If this field is not defined, the FQBN of the board attached to the sketch
	// via the `BoardAttach` method is used.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Path where the sketch to be uploaded is stored. Unless the `import_file`
	// field is defined, the compiled binary is assumed to be at the location and
	// filename under this path where it is saved by the `Compile` method.
	SketchPath string `protobuf:"bytes,3,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// The port of the board.
	Port *Port `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	// Whether to turn on verbose output during the upload.
	Verbose bool `protobuf:"varint,5,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// After upload, verify that the contents of the memory on the board match the
	// uploaded binary.
	Verify bool `protobuf:"varint,6,opt,name=verify,proto3" json:"verify,omitempty"`
	// When `import_file` is specified, it overrides the `import_dir` and
	// `sketch_path` params.
	ImportFile string `protobuf:"bytes,7,opt,name=import_file,json=importFile,proto3" json:"import_file,omitempty"`
	// Custom path to a directory containing compiled files. When `import_dir` is
	// not specified, the standard build directory under `sketch_path` is used.
	ImportDir string `protobuf:"bytes,8,opt,name=import_dir,json=importDir,proto3" json:"import_dir,omitempty"`
	// The programmer to use for upload. If set an UploadUsingProgrammer is
	// triggered instead of a normal upload. The UploadUsingProgrammer call may
	// also be used for explicit error check.
	Programmer string `protobuf:"bytes,9,opt,name=programmer,proto3" json:"programmer,omitempty"`
	// If set to true, the actual upload will not be performed but a trace output
	// will be printed stdout. This is for debugging purposes.
	DryRun bool `protobuf:"varint,10,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// User provided fields usually used by upload tools that need authentication
	// or in any case fields that can be customized by the user at upload time
	// and cannot be known previously.
	// For more info:
	// https://arduino.github.io/arduino-cli/latest/platform-specification/#user-provided-fields
	UserFields map[string]string `protobuf:"bytes,11,rep,name=user_fields,json=userFields,proto3" json:"user_fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// List of custom upload properties.
	UploadProperties []string `protobuf:"bytes,12,rep,name=upload_properties,json=uploadProperties,proto3" json:"upload_properties,omitempty"`
}

func (x *UploadRequest) Reset() {
	*x = UploadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRequest) ProtoMessage() {}

func (x *UploadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRequest.ProtoReflect.Descriptor instead.
func (*UploadRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{0}
}

func (x *UploadRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UploadRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *UploadRequest) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

func (x *UploadRequest) GetPort() *Port {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *UploadRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *UploadRequest) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *UploadRequest) GetImportFile() string {
	if x != nil {
		return x.ImportFile
	}
	return ""
}

func (x *UploadRequest) GetImportDir() string {
	if x != nil {
		return x.ImportDir
	}
	return ""
}

func (x *UploadRequest) GetProgrammer() string {
	if x != nil {
		return x.Programmer
	}
	return ""
}

func (x *UploadRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *UploadRequest) GetUserFields() map[string]string {
	if x != nil {
		return x.UserFields
	}
	return nil
}

func (x *UploadRequest) GetUploadProperties() []string {
	if x != nil {
		return x.UploadProperties
	}
	return nil
}

type UploadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*UploadResponse_OutStream
	//	*UploadResponse_ErrStream
	//	*UploadResponse_Result
	Message isUploadResponse_Message `protobuf_oneof:"message"`
}

func (x *UploadResponse) Reset() {
	*x = UploadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadResponse) ProtoMessage() {}

func (x *UploadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadResponse.ProtoReflect.Descriptor instead.
func (*UploadResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{1}
}

func (m *UploadResponse) GetMessage() isUploadResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *UploadResponse) GetOutStream() []byte {
	if x, ok := x.GetMessage().(*UploadResponse_OutStream); ok {
		return x.OutStream
	}
	return nil
}

func (x *UploadResponse) GetErrStream() []byte {
	if x, ok := x.GetMessage().(*UploadResponse_ErrStream); ok {
		return x.ErrStream
	}
	return nil
}

func (x *UploadResponse) GetResult() *UploadResult {
	if x, ok := x.GetMessage().(*UploadResponse_Result); ok {
		return x.Result
	}
	return nil
}

type isUploadResponse_Message interface {
	isUploadResponse_Message()
}

type UploadResponse_OutStream struct {
	// The output of the upload process.
	OutStream []byte `protobuf:"bytes,1,opt,name=out_stream,json=outStream,proto3,oneof"`
}

type UploadResponse_ErrStream struct {
	// The error output of the upload process.
	ErrStream []byte `protobuf:"bytes,2,opt,name=err_stream,json=errStream,proto3,oneof"`
}

type UploadResponse_Result struct {
	// The upload result.
	Result *UploadResult `protobuf:"bytes,3,opt,name=result,proto3,oneof"`
}

func (*UploadResponse_OutStream) isUploadResponse_Message() {}

func (*UploadResponse_ErrStream) isUploadResponse_Message() {}

func (*UploadResponse_Result) isUploadResponse_Message() {}

type UploadResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When a board requires a port disconnection to perform the upload, this
	// field returns the port where the board reconnects after the upload.
	UpdatedUploadPort *Port `protobuf:"bytes,1,opt,name=updated_upload_port,json=updatedUploadPort,proto3" json:"updated_upload_port,omitempty"`
}

func (x *UploadResult) Reset() {
	*x = UploadResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadResult) ProtoMessage() {}

func (x *UploadResult) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadResult.ProtoReflect.Descriptor instead.
func (*UploadResult) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{2}
}

func (x *UploadResult) GetUpdatedUploadPort() *Port {
	if x != nil {
		return x.UpdatedUploadPort
	}
	return nil
}

type ProgrammerIsRequiredForUploadError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ProgrammerIsRequiredForUploadError) Reset() {
	*x = ProgrammerIsRequiredForUploadError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProgrammerIsRequiredForUploadError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProgrammerIsRequiredForUploadError) ProtoMessage() {}

func (x *ProgrammerIsRequiredForUploadError) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProgrammerIsRequiredForUploadError.ProtoReflect.Descriptor instead.
func (*ProgrammerIsRequiredForUploadError) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{3}
}

type UploadUsingProgrammerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the target board (e.g., `arduino:avr:uno`).
	// If this field is not defined, the FQBN of the board attached to the sketch
	// via the `BoardAttach` method is used.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Path where the sketch to be uploaded is stored. Unless the `import_file`
	// field is defined, the compiled binary is assumed to be at the location and
	// filename under this path where it is saved by the `Compile` method.
	SketchPath string `protobuf:"bytes,3,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// The port of the board.
	Port *Port `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	// Whether to turn on verbose output during the upload.
	Verbose bool `protobuf:"varint,5,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// After upload, verify that the contents of the memory on the board match the
	// uploaded binary.
	Verify bool `protobuf:"varint,6,opt,name=verify,proto3" json:"verify,omitempty"`
	// When `import_file` is specified, it overrides the `import_dir` and
	// `sketch_path` params.
	ImportFile string `protobuf:"bytes,7,opt,name=import_file,json=importFile,proto3" json:"import_file,omitempty"`
	// Custom path to a directory containing compiled files. When `import_dir` is
	// not specified, the standard build directory under `sketch_path` is used.
	ImportDir string `protobuf:"bytes,8,opt,name=import_dir,json=importDir,proto3" json:"import_dir,omitempty"`
	// The programmer to use for upload.
	Programmer string `protobuf:"bytes,9,opt,name=programmer,proto3" json:"programmer,omitempty"`
	// If set to true, the actual upload will not be performed but a trace output
	// will be printed stdout. This is for debugging purposes.
	DryRun bool `protobuf:"varint,10,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// User provided fields usually used by upload tools that need authentication
	// or in any case fields that can be customized by the user at upload time
	// and cannot be known previously.
	// For more info:
	// https://arduino.github.io/arduino-cli/latest/platform-specification/#user-provided-fields
	UserFields map[string]string `protobuf:"bytes,11,rep,name=user_fields,json=userFields,proto3" json:"user_fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// List of custom upload properties.
	UploadProperties []string `protobuf:"bytes,12,rep,name=upload_properties,json=uploadProperties,proto3" json:"upload_properties,omitempty"`
}

func (x *UploadUsingProgrammerRequest) Reset() {
	*x = UploadUsingProgrammerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadUsingProgrammerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadUsingProgrammerRequest) ProtoMessage() {}

func (x *UploadUsingProgrammerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadUsingProgrammerRequest.ProtoReflect.Descriptor instead.
func (*UploadUsingProgrammerRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{4}
}

func (x *UploadUsingProgrammerRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UploadUsingProgrammerRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *UploadUsingProgrammerRequest) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

func (x *UploadUsingProgrammerRequest) GetPort() *Port {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *UploadUsingProgrammerRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *UploadUsingProgrammerRequest) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *UploadUsingProgrammerRequest) GetImportFile() string {
	if x != nil {
		return x.ImportFile
	}
	return ""
}

func (x *UploadUsingProgrammerRequest) GetImportDir() string {
	if x != nil {
		return x.ImportDir
	}
	return ""
}

func (x *UploadUsingProgrammerRequest) GetProgrammer() string {
	if x != nil {
		return x.Programmer
	}
	return ""
}

func (x *UploadUsingProgrammerRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *UploadUsingProgrammerRequest) GetUserFields() map[string]string {
	if x != nil {
		return x.UserFields
	}
	return nil
}

func (x *UploadUsingProgrammerRequest) GetUploadProperties() []string {
	if x != nil {
		return x.UploadProperties
	}
	return nil
}

type UploadUsingProgrammerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*UploadUsingProgrammerResponse_OutStream
	//	*UploadUsingProgrammerResponse_ErrStream
	Message isUploadUsingProgrammerResponse_Message `protobuf_oneof:"message"`
}

func (x *UploadUsingProgrammerResponse) Reset() {
	*x = UploadUsingProgrammerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadUsingProgrammerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadUsingProgrammerResponse) ProtoMessage() {}

func (x *UploadUsingProgrammerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadUsingProgrammerResponse.ProtoReflect.Descriptor instead.
func (*UploadUsingProgrammerResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{5}
}

func (m *UploadUsingProgrammerResponse) GetMessage() isUploadUsingProgrammerResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *UploadUsingProgrammerResponse) GetOutStream() []byte {
	if x, ok := x.GetMessage().(*UploadUsingProgrammerResponse_OutStream); ok {
		return x.OutStream
	}
	return nil
}

func (x *UploadUsingProgrammerResponse) GetErrStream() []byte {
	if x, ok := x.GetMessage().(*UploadUsingProgrammerResponse_ErrStream); ok {
		return x.ErrStream
	}
	return nil
}

type isUploadUsingProgrammerResponse_Message interface {
	isUploadUsingProgrammerResponse_Message()
}

type UploadUsingProgrammerResponse_OutStream struct {
	// The output of the upload process.
	OutStream []byte `protobuf:"bytes,1,opt,name=out_stream,json=outStream,proto3,oneof"`
}

type UploadUsingProgrammerResponse_ErrStream struct {
	// The error output of the upload process.
	ErrStream []byte `protobuf:"bytes,2,opt,name=err_stream,json=errStream,proto3,oneof"`
}

func (*UploadUsingProgrammerResponse_OutStream) isUploadUsingProgrammerResponse_Message() {}

func (*UploadUsingProgrammerResponse_ErrStream) isUploadUsingProgrammerResponse_Message() {}

type BurnBootloaderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the target board (e.g., `arduino:avr:uno`).
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// The port of the programmer used to program the bootloader.
	Port *Port `protobuf:"bytes,3,opt,name=port,proto3" json:"port,omitempty"`
	// Whether to turn on verbose output during the programming.
	Verbose bool `protobuf:"varint,4,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// After programming, verify the contents of the memory on the board match the
	// uploaded binary.
	Verify bool `protobuf:"varint,5,opt,name=verify,proto3" json:"verify,omitempty"`
	// The programmer to use for burning bootloader.
	Programmer string `protobuf:"bytes,6,opt,name=programmer,proto3" json:"programmer,omitempty"`
	// If set to true, the actual upload will not be performed but a trace output
	// will be printed stdout. This is for debugging purposes.
	DryRun bool `protobuf:"varint,7,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// User provided fields usually used by upload tools that need authentication
	// or in any case fields that can be customized by the user at upload time
	// and cannot be known previously.
	// For more info:
	// https://arduino.github.io/arduino-cli/latest/platform-specification/#user-provided-fields
	UserFields map[string]string `protobuf:"bytes,11,rep,name=user_fields,json=userFields,proto3" json:"user_fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// List of custom upload properties.
	UploadProperties []string `protobuf:"bytes,12,rep,name=upload_properties,json=uploadProperties,proto3" json:"upload_properties,omitempty"`
}

func (x *BurnBootloaderRequest) Reset() {
	*x = BurnBootloaderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BurnBootloaderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BurnBootloaderRequest) ProtoMessage() {}

func (x *BurnBootloaderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BurnBootloaderRequest.ProtoReflect.Descriptor instead.
func (*BurnBootloaderRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{6}
}

func (x *BurnBootloaderRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BurnBootloaderRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *BurnBootloaderRequest) GetPort() *Port {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *BurnBootloaderRequest) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *BurnBootloaderRequest) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *BurnBootloaderRequest) GetProgrammer() string {
	if x != nil {
		return x.Programmer
	}
	return ""
}

func (x *BurnBootloaderRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *BurnBootloaderRequest) GetUserFields() map[string]string {
	if x != nil {
		return x.UserFields
	}
	return nil
}

func (x *BurnBootloaderRequest) GetUploadProperties() []string {
	if x != nil {
		return x.UploadProperties
	}
	return nil
}

type BurnBootloaderResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*BurnBootloaderResponse_OutStream
	//	*BurnBootloaderResponse_ErrStream
	Message isBurnBootloaderResponse_Message `protobuf_oneof:"message"`
}

func (x *BurnBootloaderResponse) Reset() {
	*x = BurnBootloaderResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BurnBootloaderResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BurnBootloaderResponse) ProtoMessage() {}

func (x *BurnBootloaderResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BurnBootloaderResponse.ProtoReflect.Descriptor instead.
func (*BurnBootloaderResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{7}
}

func (m *BurnBootloaderResponse) GetMessage() isBurnBootloaderResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *BurnBootloaderResponse) GetOutStream() []byte {
	if x, ok := x.GetMessage().(*BurnBootloaderResponse_OutStream); ok {
		return x.OutStream
	}
	return nil
}

func (x *BurnBootloaderResponse) GetErrStream() []byte {
	if x, ok := x.GetMessage().(*BurnBootloaderResponse_ErrStream); ok {
		return x.ErrStream
	}
	return nil
}

type isBurnBootloaderResponse_Message interface {
	isBurnBootloaderResponse_Message()
}

type BurnBootloaderResponse_OutStream struct {
	// The output of the burn bootloader process.
	OutStream []byte `protobuf:"bytes,1,opt,name=out_stream,json=outStream,proto3,oneof"`
}

type BurnBootloaderResponse_ErrStream struct {
	// The error output of the burn bootloader process.
	ErrStream []byte `protobuf:"bytes,2,opt,name=err_stream,json=errStream,proto3,oneof"`
}

func (*BurnBootloaderResponse_OutStream) isBurnBootloaderResponse_Message() {}

func (*BurnBootloaderResponse_ErrStream) isBurnBootloaderResponse_Message() {}

type ListProgrammersAvailableForUploadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the target board (e.g., `arduino:avr:uno`).
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
}

func (x *ListProgrammersAvailableForUploadRequest) Reset() {
	*x = ListProgrammersAvailableForUploadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProgrammersAvailableForUploadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProgrammersAvailableForUploadRequest) ProtoMessage() {}

func (x *ListProgrammersAvailableForUploadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProgrammersAvailableForUploadRequest.ProtoReflect.Descriptor instead.
func (*ListProgrammersAvailableForUploadRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{8}
}

func (x *ListProgrammersAvailableForUploadRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *ListProgrammersAvailableForUploadRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

type ListProgrammersAvailableForUploadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of programmers supported by the board.
	Programmers []*Programmer `protobuf:"bytes,1,rep,name=programmers,proto3" json:"programmers,omitempty"`
}

func (x *ListProgrammersAvailableForUploadResponse) Reset() {
	*x = ListProgrammersAvailableForUploadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProgrammersAvailableForUploadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProgrammersAvailableForUploadResponse) ProtoMessage() {}

func (x *ListProgrammersAvailableForUploadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProgrammersAvailableForUploadResponse.ProtoReflect.Descriptor instead.
func (*ListProgrammersAvailableForUploadResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{9}
}

func (x *ListProgrammersAvailableForUploadResponse) GetProgrammers() []*Programmer {
	if x != nil {
		return x.Programmers
	}
	return nil
}

type SupportedUserFieldsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the target board (e.g., `arduino:avr:uno`).
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Protocol that will be used to upload, this information is
	// necessary to pick the right upload tool for the board specified
	// with the FQBN.
	Protocol string `protobuf:"bytes,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
}

func (x *SupportedUserFieldsRequest) Reset() {
	*x = SupportedUserFieldsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedUserFieldsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedUserFieldsRequest) ProtoMessage() {}

func (x *SupportedUserFieldsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedUserFieldsRequest.ProtoReflect.Descriptor instead.
func (*SupportedUserFieldsRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{10}
}

func (x *SupportedUserFieldsRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *SupportedUserFieldsRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *SupportedUserFieldsRequest) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

type UserField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Id of the tool that supports this field.
	ToolId string `protobuf:"bytes,1,opt,name=tool_id,json=toolId,proto3" json:"tool_id,omitempty"`
	// Name used internally to store and retrieve this field.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Label is the text shown to the user when they need to input this field.
	Label string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
	// True if the value of the field must not be shown when typing, for example
	// when the user inputs a network password.
	Secret bool `protobuf:"varint,4,opt,name=secret,proto3" json:"secret,omitempty"`
}

func (x *UserField) Reset() {
	*x = UserField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserField) ProtoMessage() {}

func (x *UserField) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserField.ProtoReflect.Descriptor instead.
func (*UserField) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{11}
}

func (x *UserField) GetToolId() string {
	if x != nil {
		return x.ToolId
	}
	return ""
}

func (x *UserField) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UserField) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *UserField) GetSecret() bool {
	if x != nil {
		return x.Secret
	}
	return false
}

type SupportedUserFieldsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User fields supported by board specified in SupportedUserFieldsRequest.
	// If board doesn't support any field it will be empty.
	UserFields []*UserField `protobuf:"bytes,1,rep,name=user_fields,json=userFields,proto3" json:"user_fields,omitempty"`
}

func (x *SupportedUserFieldsResponse) Reset() {
	*x = SupportedUserFieldsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportedUserFieldsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportedUserFieldsResponse) ProtoMessage() {}

func (x *SupportedUserFieldsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportedUserFieldsResponse.ProtoReflect.Descriptor instead.
func (*SupportedUserFieldsResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP(), []int{12}
}

func (x *SupportedUserFieldsResponse) GetUserFields() []*UserField {
	if x != nil {
		return x.UserFields
	}
	return nil
}

var File_cc_arduino_cli_commands_v1_upload_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_upload_proto_rawDesc = []byte{
	0x0a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25,
	0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x04, 0x0a, 0x0d, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x12, 0x34,
	0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x04,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x69, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x6d, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x12,
	0x5a, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0a, 0x75, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa1, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x6f, 0x75,
	0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00,
	0x52, 0x09, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1f, 0x0a, 0x0a, 0x65,
	0x72, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48,
	0x00, 0x52, 0x09, 0x65, 0x72, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x42, 0x0a, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x60, 0x0a, 0x0c, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x50, 0x0a, 0x13, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x11, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x22, 0x24, 0x0a,
	0x22, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x49, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x22, 0xcd, 0x04, 0x0a, 0x1c, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6b,
	0x65, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x12, 0x34, 0x0a, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64,
	0x69, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x69, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65,
	0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x6d, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x12, 0x69, 0x0a, 0x0b,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x48, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x75, 0x73, 0x65,
	0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x75, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x10, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x6c, 0x0a, 0x1d, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x69,
	0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1f, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x5f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x09, 0x65, 0x72, 0x72,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0xde, 0x03, 0x0a, 0x15, 0x42, 0x75, 0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62,
	0x6e, 0x12, 0x34, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72,
	0x74, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f,
	0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72, 0x79,
	0x5f, 0x72, 0x75, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52,
	0x75, 0x6e, 0x12, 0x62, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x65, 0x0a, 0x16, 0x42, 0x75, 0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0a,
	0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x48, 0x00, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1f, 0x0a,
	0x0a, 0x65, 0x72, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x48, 0x00, 0x52, 0x09, 0x65, 0x72, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x09,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x28, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x41, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x22, 0x75, 0x0a, 0x29,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x41,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d,
	0x65, 0x72, 0x73, 0x22, 0x8e, 0x01, 0x0a, 0x1a, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x22, 0x66, 0x0a, 0x09, 0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x74, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x65, 0x0a, 0x1b,
	0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x42, 0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_upload_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_upload_proto_rawDescData = file_cc_arduino_cli_commands_v1_upload_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_upload_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_upload_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_upload_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_upload_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_upload_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_upload_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_cc_arduino_cli_commands_v1_upload_proto_goTypes = []any{
	(*UploadRequest)(nil),                             // 0: cc.arduino.cli.commands.v1.UploadRequest
	(*UploadResponse)(nil),                            // 1: cc.arduino.cli.commands.v1.UploadResponse
	(*UploadResult)(nil),                              // 2: cc.arduino.cli.commands.v1.UploadResult
	(*ProgrammerIsRequiredForUploadError)(nil),        // 3: cc.arduino.cli.commands.v1.ProgrammerIsRequiredForUploadError
	(*UploadUsingProgrammerRequest)(nil),              // 4: cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest
	(*UploadUsingProgrammerResponse)(nil),             // 5: cc.arduino.cli.commands.v1.UploadUsingProgrammerResponse
	(*BurnBootloaderRequest)(nil),                     // 6: cc.arduino.cli.commands.v1.BurnBootloaderRequest
	(*BurnBootloaderResponse)(nil),                    // 7: cc.arduino.cli.commands.v1.BurnBootloaderResponse
	(*ListProgrammersAvailableForUploadRequest)(nil),  // 8: cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadRequest
	(*ListProgrammersAvailableForUploadResponse)(nil), // 9: cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadResponse
	(*SupportedUserFieldsRequest)(nil),                // 10: cc.arduino.cli.commands.v1.SupportedUserFieldsRequest
	(*UserField)(nil),                                 // 11: cc.arduino.cli.commands.v1.UserField
	(*SupportedUserFieldsResponse)(nil),               // 12: cc.arduino.cli.commands.v1.SupportedUserFieldsResponse
	nil,                                               // 13: cc.arduino.cli.commands.v1.UploadRequest.UserFieldsEntry
	nil,                                               // 14: cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest.UserFieldsEntry
	nil,                                               // 15: cc.arduino.cli.commands.v1.BurnBootloaderRequest.UserFieldsEntry
	(*Instance)(nil),                                  // 16: cc.arduino.cli.commands.v1.Instance
	(*Port)(nil),                                      // 17: cc.arduino.cli.commands.v1.Port
	(*Programmer)(nil),                                // 18: cc.arduino.cli.commands.v1.Programmer
}
var file_cc_arduino_cli_commands_v1_upload_proto_depIdxs = []int32{
	16, // 0: cc.arduino.cli.commands.v1.UploadRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 1: cc.arduino.cli.commands.v1.UploadRequest.port:type_name -> cc.arduino.cli.commands.v1.Port
	13, // 2: cc.arduino.cli.commands.v1.UploadRequest.user_fields:type_name -> cc.arduino.cli.commands.v1.UploadRequest.UserFieldsEntry
	2,  // 3: cc.arduino.cli.commands.v1.UploadResponse.result:type_name -> cc.arduino.cli.commands.v1.UploadResult
	17, // 4: cc.arduino.cli.commands.v1.UploadResult.updated_upload_port:type_name -> cc.arduino.cli.commands.v1.Port
	16, // 5: cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 6: cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest.port:type_name -> cc.arduino.cli.commands.v1.Port
	14, // 7: cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest.user_fields:type_name -> cc.arduino.cli.commands.v1.UploadUsingProgrammerRequest.UserFieldsEntry
	16, // 8: cc.arduino.cli.commands.v1.BurnBootloaderRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 9: cc.arduino.cli.commands.v1.BurnBootloaderRequest.port:type_name -> cc.arduino.cli.commands.v1.Port
	15, // 10: cc.arduino.cli.commands.v1.BurnBootloaderRequest.user_fields:type_name -> cc.arduino.cli.commands.v1.BurnBootloaderRequest.UserFieldsEntry
	16, // 11: cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	18, // 12: cc.arduino.cli.commands.v1.ListProgrammersAvailableForUploadResponse.programmers:type_name -> cc.arduino.cli.commands.v1.Programmer
	16, // 13: cc.arduino.cli.commands.v1.SupportedUserFieldsRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	11, // 14: cc.arduino.cli.commands.v1.SupportedUserFieldsResponse.user_fields:type_name -> cc.arduino.cli.commands.v1.UserField
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_upload_proto_init() }
func file_cc_arduino_cli_commands_v1_upload_proto_init() {
	if File_cc_arduino_cli_commands_v1_upload_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	file_cc_arduino_cli_commands_v1_port_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*UploadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*UploadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*UploadResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ProgrammerIsRequiredForUploadError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*UploadUsingProgrammerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*UploadUsingProgrammerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*BurnBootloaderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*BurnBootloaderResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ListProgrammersAvailableForUploadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ListProgrammersAvailableForUploadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*SupportedUserFieldsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UserField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*SupportedUserFieldsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[1].OneofWrappers = []any{
		(*UploadResponse_OutStream)(nil),
		(*UploadResponse_ErrStream)(nil),
		(*UploadResponse_Result)(nil),
	}
	file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[5].OneofWrappers = []any{
		(*UploadUsingProgrammerResponse_OutStream)(nil),
		(*UploadUsingProgrammerResponse_ErrStream)(nil),
	}
	file_cc_arduino_cli_commands_v1_upload_proto_msgTypes[7].OneofWrappers = []any{
		(*BurnBootloaderResponse_OutStream)(nil),
		(*BurnBootloaderResponse_ErrStream)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_upload_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_upload_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_upload_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_upload_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_upload_proto = out.File
	file_cc_arduino_cli_commands_v1_upload_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_upload_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_upload_proto_depIdxs = nil
}
