// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "IconProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::IconPropertyPrivate
{
public:
    std::unique_ptr<AlignmentProperty> alignment;
    std::optional<qreal> width;
    std::optional<qreal> height;
    std::optional<QString> name;
    std::optional<QUrl> source;
    std::optional<Union::Color> color;
};

IconProperty::IconProperty()
    : d(std::make_unique<IconPropertyPrivate>())
{
}

IconProperty::IconProperty(const IconProperty &other)
    : d(std::make_unique<IconPropertyPrivate>())
{
    d->alignment = std::make_unique<AlignmentProperty>();
    *(d->alignment) = *(other.d->alignment);
    d->width = other.d->width;
    d->height = other.d->height;
    d->name = other.d->name;
    d->source = other.d->source;
    d->color = other.d->color;
}

IconProperty::IconProperty(IconProperty &&other)
    : d(std::move(other.d))
{
}

IconProperty::~IconProperty() = default;

IconProperty &IconProperty::operator=(const IconProperty &other)
{
    if (this != &other) {
        *(d->alignment) = *(other.d->alignment);
        d->width = other.d->width;
        d->height = other.d->height;
        d->name = other.d->name;
        d->source = other.d->source;
        d->color = other.d->color;
    }
    return *this;
}

IconProperty &IconProperty::operator=(IconProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

AlignmentProperty *IconProperty::alignment() const
{
    return d->alignment.get();
}

void IconProperty::setAlignment(std::unique_ptr<AlignmentProperty> &&newValue)
{
    d->alignment = std::move(newValue);
}

std::optional<qreal> IconProperty::width() const
{
    return d->width;
}

void IconProperty::setWidth(const std::optional<qreal> &newValue)
{
    if (newValue == d->width) {
        return;
    }

    d->width = newValue;
}

std::optional<qreal> IconProperty::height() const
{
    return d->height;
}

void IconProperty::setHeight(const std::optional<qreal> &newValue)
{
    if (newValue == d->height) {
        return;
    }

    d->height = newValue;
}

std::optional<QString> IconProperty::name() const
{
    return d->name;
}

void IconProperty::setName(const std::optional<QString> &newValue)
{
    if (newValue == d->name) {
        return;
    }

    d->name = newValue;
}

std::optional<QUrl> IconProperty::source() const
{
    return d->source;
}

void IconProperty::setSource(const std::optional<QUrl> &newValue)
{
    if (newValue == d->source) {
        return;
    }

    d->source = newValue;
}

std::optional<Union::Color> IconProperty::color() const
{
    return d->color;
}

void IconProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}

bool IconProperty::hasAnyValue() const
{
    if (d->alignment && d->alignment->hasAnyValue()) {
        return true;
    }
    if (d->width.has_value()) {
        return true;
    }
    if (d->height.has_value()) {
        return true;
    }
    if (d->name.has_value()) {
        return true;
    }
    if (d->source.has_value()) {
        return true;
    }
    if (d->color.has_value()) {
        return true;
    }
    return false;
}

bool IconProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->alignment && !d->alignment->isEmpty()) {
        return false;
    }
    if (d->width.has_value() && d->width.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->height.has_value() && d->height.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->name.has_value() && d->name.value() != emptyValue<QString>()) {
        return false;
    }
    if (d->source.has_value() && d->source.value() != emptyValue<QUrl>()) {
        return false;
    }
    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }

    return true;
}

QString IconProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "IconProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "alignment: ";
    if (d->alignment) {
        out << d->alignment->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "width: ";
    if (d->width) {
        out << d->width.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "height: ";
    if (d->height) {
        out << d->height.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "name: ";
    if (d->name) {
        out << d->name.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "source: ";
    if (d->source) {
        out << d->source->toString() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "color: ";
    if (d->color) {
        out << d->color->toString() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void IconProperty::resolveProperties(const IconProperty *source, IconProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (source->d->alignment) {
        if (!destination->d->alignment) {
            destination->d->alignment = std::make_unique<AlignmentProperty>();
        }
        AlignmentProperty::resolveProperties(source->d->alignment.get(), destination->d->alignment.get());
    }
    if (!destination->d->width.has_value()) {
        destination->d->width = source->d->width;
    }
    if (!destination->d->height.has_value()) {
        destination->d->height = source->d->height;
    }
    if (!destination->d->name.has_value()) {
        destination->d->name = source->d->name;
    }
    if (!destination->d->source.has_value()) {
        destination->d->source = source->d->source;
    }
    if (!destination->d->color.has_value()) {
        destination->d->color = source->d->color;
    }
}

std::unique_ptr<IconProperty> IconProperty::empty()
{
    auto result = std::make_unique<IconProperty>();
    result->d->alignment = AlignmentProperty::empty();
    result->d->width = emptyValue<qreal>();
    result->d->height = emptyValue<qreal>();
    result->d->name = emptyValue<QString>();
    result->d->source = emptyValue<QUrl>();
    result->d->color = emptyValue<Union::Color>();
    return result;
}

bool Union::Properties::operator==(const IconProperty &left, const IconProperty &right)
{
    if (left.alignment() && right.alignment()) {
        if (*(left.alignment()) != *(right.alignment())) {
            return false;
        }
    } else if (left.alignment() != right.alignment()) {
        return false;
    }
    if (left.width() != right.width()) {
        return false;
    }
    if (left.height() != right.height()) {
        return false;
    }
    if (left.name() != right.name()) {
        return false;
    }
    if (left.source() != right.source()) {
        return false;
    }
    if (left.color() != right.color()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::IconProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}