
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "mainapplication_wrapper.h"

// Wrappers providing overrides
#include "qtsingleapplication_wrapper.h"
#include "webview_wrapper.h"

// Wrappers
#include "qtsingleapplication_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_MainApplication_Type = nullptr;
static PyTypeObject *Sbk_MainApplication_TypeF(void)
{
    return _Sbk_MainApplication_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void MainApplicationWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::MainApplication::AfterLaunch >("MainApplication::AfterLaunch");
}

void MainApplicationWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

void MainApplicationWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("MainApplication", funcName, gil, pyOverride, event);
}

void MainApplicationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("MainApplication", funcName, gil, pyOverride, signal);
}

void MainApplicationWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("MainApplication", funcName, gil, pyOverride, event);
}

void MainApplicationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("MainApplication", funcName, gil, pyOverride, signal);
}

bool MainApplicationWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QApplication::event(arg__1);
    }
    return WebViewWrapper::sbk_o_event("MainApplication", funcName, gil, pyOverride, arg__1);
}

bool MainApplicationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("MainApplication", funcName, gil, pyOverride, watched, event);
}

bool MainApplicationWrapper::notify(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "notify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QApplication::notify(arg__1, arg__2);
    }
    return QtSingleApplicationWrapper::sbk_o_notify("MainApplication", funcName, gil, pyOverride, arg__1, arg__2);
}

void MainApplicationWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_MainApplication_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("MainApplication", funcName, gil, pyOverride, event);
}

const QMetaObject *MainApplicationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return MainApplication::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int MainApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = MainApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *MainApplicationWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< MainApplicationWrapper *>(this));
    }
    return MainApplication::qt_metacast(_clname);
}

MainApplicationWrapper::~MainApplicationWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_MainApplication_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int Sbk_MainApplication_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("MainApplication");
    return -1;
}

static PyObject *Sbk_MainApplicationFunc_addNewTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);

    if (PyArg_ParseTuple(args, "|O:addNewTab", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: MainApplication::addNewTab(const QUrl&=)
    if (numArgs == 0) {
        overloadId = 0; // addNewTab(QUrl)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addNewTab(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"url", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local = QUrl();
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // addNewTab(QUrl)
            cppSelf->addNewTab(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_afterLaunch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // afterLaunch()const
        MainApplication::AfterLaunch cppResult = MainApplication::AfterLaunch(const_cast<const MainApplicationWrapper *>(cppSelf)->afterLaunch());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_AfterLaunch_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_autoFill(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // autoFill()
        AutoFill * cppResult = cppSelf->autoFill();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoFill_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_bookmarks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bookmarks()
        Bookmarks * cppResult = cppSelf->bookmarks();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Bookmarks_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_changeOccurred(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // changeOccurred()
        cppSelf->changeOccurred();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_cookieJar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // cookieJar()
        CookieJar * cppResult = cppSelf->cookieJar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_createWindow(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "createWindow", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);

    if (PyArg_ParseTuple(args, "|OO:createWindow", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: MainApplication::createWindow(Qz::BrowserWindowType,const QList<QUrl>&=)->BrowserWindow*
    // 1: MainApplication::createWindow(Qz::BrowserWindowType,QUrl)->BrowserWindow*
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_BrowserWindowType_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createWindow(Qz::BrowserWindowType,QList<QUrl>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))) {
            overloadId = 1; // createWindow(Qz::BrowserWindowType,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QUrl_IDX], (pyArgs[1])))) {
            overloadId = 0; // createWindow(Qz::BrowserWindowType,QList<QUrl>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createWindow", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // createWindow(Qz::BrowserWindowType type, const QList<QUrl> &startUrls)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"startUrls", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QUrl_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "createWindow", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);
                }
            }
            ::Qz::BrowserWindowType cppArg0{Qz::BW_FirstAppWindow};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QList<QUrl> cppArg1{};
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // createWindow(Qz::BrowserWindowType,QList<QUrl>)
                BrowserWindow * cppResult = cppSelf->createWindow(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppResult);
                // Ownership transferences (return value heuristics).
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // createWindow(Qz::BrowserWindowType type, const QUrl &startUrl)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "createWindow", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);
            }
            ::Qz::BrowserWindowType cppArg0{Qz::BW_FirstAppWindow};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // createWindow(Qz::BrowserWindowType,QUrl)
                BrowserWindow * cppResult = cppSelf->createWindow(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppResult);
                // Ownership transferences (return value heuristics).
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_desktopNotifications(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // desktopNotifications()
        DesktopNotificationsFactory * cppResult = cppSelf->desktopNotifications();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_destroyRestoreManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // destroyRestoreManager()
        cppSelf->destroyRestoreManager();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_downloadManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // downloadManager()
        DownloadManager * cppResult = cppSelf->downloadManager();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_getWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getWindow()const
        BrowserWindow * cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->getWindow();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_history(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // history()
        History * cppResult = cppSelf->history();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_instance(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // instance()
        // Begin code injection
        // ========================================================================
        // START of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-instance)]
        PyObject *pyApp = Py_None;
        if (qApp) {
            pyApp = reinterpret_cast<PyObject *>(
                Shiboken::BindingManager::instance().retrieveWrapper(qApp));
            if (!pyApp)
                pyApp = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QCoreApplication_IDX]), qApp);
                // this will keep app live after python exit (extra ref)
        }
        // PYSIDE-571: make sure that we return the singleton "None"
        if (Py_TYPE(pyApp) == Py_TYPE(Py_None))
            Py_DECREF(MakeQAppWrapper(nullptr));
        pyResult = pyApp;
        Py_XINCREF(pyResult);
        // END of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-instance)]
        // ========================================================================
        // End of code injection

    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_isClosing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isClosing()const
        bool cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->isClosing();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_isPortable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isPortable()const
        bool cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->isPortable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_isPrivate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isPrivate()const
        bool cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->isPrivate();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_isStartingAfterCrash(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isStartingAfterCrash()const
        bool cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->isStartingAfterCrash();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_isTestModeEnabled(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isTestModeEnabled()
        bool cppResult = ::MainApplication::isTestModeEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_networkManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // networkManager()
        NetworkManager * cppResult = cppSelf->networkManager();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_plugins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // plugins()
        PluginProxy * cppResult = cppSelf->plugins();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_quitApplication(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // quitApplication()
        cppSelf->quitApplication();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_reloadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reloadSettings()
        cppSelf->reloadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_reloadUserStyleSheet(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reloadUserStyleSheet()
        cppSelf->reloadUserStyleSheet();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_restoreOverrideCursor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // restoreOverrideCursor()
        cppSelf->restoreOverrideCursor();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_saveState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveState()const
        QByteArray cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->saveState();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_searchEnginesManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // searchEnginesManager()
        SearchEnginesManager * cppResult = cppSelf->searchEnginesManager();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SearchEnginesManager_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_setChromiumFlags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setChromiumFlags()
        cppSelf->setChromiumFlags();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_setTestModeEnabled(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static MainApplication::setTestModeEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTestModeEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTestModeEnabled", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTestModeEnabled(bool)
            ::MainApplication::setTestModeEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_siteSettingsManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // siteSettingsManager()
        SiteSettingsManager * cppResult = cppSelf->siteSettingsManager();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SiteSettingsManager_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_startPrivateBrowsing(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "startPrivateBrowsing", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);

    if (PyArg_ParseTuple(args, "|O:startPrivateBrowsing", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: MainApplication::startPrivateBrowsing(const QUrl&=)
    if (numArgs == 0) {
        overloadId = 0; // startPrivateBrowsing(QUrl)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        overloadId = 0; // startPrivateBrowsing(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "startPrivateBrowsing", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"startUrl", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "startPrivateBrowsing", errInfo, SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local = QUrl();
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // startPrivateBrowsing(QUrl)
            cppSelf->startPrivateBrowsing(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_MainApplicationFunc_styleName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // styleName()const
        QString cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->styleName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_webProfile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webProfile()const
        QWebEngineProfile * cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->webProfile();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineProfile_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_webSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webSettings()const
        QWebEngineSettings * cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->webSettings();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineSettings_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_windowCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // windowCount()const
        int cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->windowCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_windows(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // windows()const
        QList<BrowserWindow*> cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->windows();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_BrowserWindowPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_MainApplicationFunc_wmClass(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // wmClass()const
        QByteArray cppResult = const_cast<const MainApplicationWrapper *>(cppSelf)->wmClass();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_MainApplication_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_MainApplication_EnumFlagInfo[] = {
    "AfterLaunch:IntEnum",
    "PostLaunchAction:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_MainApplication_methods[] = {
    {"addNewTab", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_addNewTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"afterLaunch", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_afterLaunch), METH_NOARGS, nullptr},
    {"autoFill", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_autoFill), METH_NOARGS, nullptr},
    {"bookmarks", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_bookmarks), METH_NOARGS, nullptr},
    {"changeOccurred", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_changeOccurred), METH_NOARGS, nullptr},
    {"cookieJar", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_cookieJar), METH_NOARGS, nullptr},
    {"createWindow", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_createWindow), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"desktopNotifications", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_desktopNotifications), METH_NOARGS, nullptr},
    {"destroyRestoreManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_destroyRestoreManager), METH_NOARGS, nullptr},
    {"downloadManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_downloadManager), METH_NOARGS, nullptr},
    {"getWindow", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_getWindow), METH_NOARGS, nullptr},
    {"history", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_history), METH_NOARGS, nullptr},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_instance), METH_NOARGS|METH_STATIC, nullptr},
    {"isClosing", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isClosing), METH_NOARGS, nullptr},
    {"isPortable", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isPortable), METH_NOARGS, nullptr},
    {"isPrivate", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isPrivate), METH_NOARGS, nullptr},
    {"isStartingAfterCrash", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isStartingAfterCrash), METH_NOARGS, nullptr},
    {"isTestModeEnabled", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isTestModeEnabled), METH_NOARGS|METH_STATIC, nullptr},
    {"networkManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_networkManager), METH_NOARGS, nullptr},
    {"plugins", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_plugins), METH_NOARGS, nullptr},
    {"quitApplication", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_quitApplication), METH_NOARGS, nullptr},
    {"reloadSettings", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_reloadSettings), METH_NOARGS, nullptr},
    {"reloadUserStyleSheet", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_reloadUserStyleSheet), METH_NOARGS, nullptr},
    {"restoreOverrideCursor", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_restoreOverrideCursor), METH_NOARGS, nullptr},
    {"saveState", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_saveState), METH_NOARGS, nullptr},
    {"searchEnginesManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_searchEnginesManager), METH_NOARGS, nullptr},
    {"setChromiumFlags", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_setChromiumFlags), METH_NOARGS, nullptr},
    {"setTestModeEnabled", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_setTestModeEnabled), METH_O|METH_STATIC, nullptr},
    {"siteSettingsManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_siteSettingsManager), METH_NOARGS, nullptr},
    {"startPrivateBrowsing", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_startPrivateBrowsing), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"styleName", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_styleName), METH_NOARGS, nullptr},
    {"webProfile", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_webProfile), METH_NOARGS, nullptr},
    {"webSettings", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_webSettings), METH_NOARGS, nullptr},
    {"windowCount", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_windowCount), METH_NOARGS, nullptr},
    {"windows", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_windows), METH_NOARGS, nullptr},
    {"wmClass", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_wmClass), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_MainApplication_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<MainApplicationWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_MainApplication_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_MainApplication_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_MainApplication_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocQAppWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_MainApplication_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_MainApplication_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_MainApplication_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_MainApplication_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_MainApplication_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkQApp_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_MainApplication_spec = {
    "1:PyFalkon.MainApplication",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_MainApplication_slots
};

} //extern "C"

static void *Sbk_MainApplication_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::MainApplication *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_MainApplication_AfterLaunch(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::MainApplication::AfterLaunch>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::MainApplication::AfterLaunch *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_MainApplication_AfterLaunch_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_MainApplication_AfterLaunch_IDX])))
        return Enum_PythonToCpp_MainApplication_AfterLaunch;
    return {};
}

static PyObject *MainApplication_AfterLaunch_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::MainApplication::AfterLaunch>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::MainApplication::AfterLaunch *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void MainApplication_PythonToCpp_MainApplication_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_MainApplication_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_MainApplication_PythonToCpp_MainApplication_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_MainApplication_TypeF()))
        return MainApplication_PythonToCpp_MainApplication_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *MainApplication_PTR_CppToPython_MainApplication(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::MainApplication *>(const_cast<void *>(cppIn)), Sbk_MainApplication_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *MainApplication_SignatureStrings[] = {
    "PyFalkon.MainApplication.addNewTab(self,url:typing.Union[PySide6.QtCore.QUrl, QString]=QUrl())",
    "PyFalkon.MainApplication.afterLaunch(self)->PyFalkon.MainApplication.AfterLaunch",
    "PyFalkon.MainApplication.autoFill(self)->PyFalkon.AutoFill",
    "PyFalkon.MainApplication.bookmarks(self)->PyFalkon.Bookmarks",
    "PyFalkon.MainApplication.changeOccurred(self)",
    "PyFalkon.MainApplication.cookieJar(self)->PyFalkon.CookieJar",
    "1:PyFalkon.MainApplication.createWindow(self,type:PyFalkon.Qz.BrowserWindowType,startUrls:QList[PySide6.QtCore.QUrl]={})->PyFalkon.BrowserWindow",
    "0:PyFalkon.MainApplication.createWindow(self,type:PyFalkon.Qz.BrowserWindowType,startUrl:typing.Union[PySide6.QtCore.QUrl, QString])->PyFalkon.BrowserWindow",
    "PyFalkon.MainApplication.desktopNotifications(self)->PyFalkon.DesktopNotificationsFactory",
    "PyFalkon.MainApplication.destroyRestoreManager(self)",
    "PyFalkon.MainApplication.downloadManager(self)->PyFalkon.DownloadManager",
    "PyFalkon.MainApplication.getWindow(self)->PyFalkon.BrowserWindow",
    "PyFalkon.MainApplication.history(self)->PyFalkon.History",
    "PyFalkon.MainApplication.instance()->Optional[PySide6.QtCore.QCoreApplication]",
    "PyFalkon.MainApplication.isClosing(self)->bool",
    "PyFalkon.MainApplication.isPortable(self)->bool",
    "PyFalkon.MainApplication.isPrivate(self)->bool",
    "PyFalkon.MainApplication.isStartingAfterCrash(self)->bool",
    "PyFalkon.MainApplication.isTestModeEnabled()->bool",
    "PyFalkon.MainApplication.networkManager(self)->PyFalkon.NetworkManager",
    "PyFalkon.MainApplication.plugins(self)->PyFalkon.PluginProxy",
    "PyFalkon.MainApplication.quitApplication(self)",
    "PyFalkon.MainApplication.reloadSettings(self)",
    "PyFalkon.MainApplication.reloadUserStyleSheet(self)",
    "PyFalkon.MainApplication.restoreOverrideCursor(self)",
    "PyFalkon.MainApplication.saveState(self)->PySide6.QtCore.QByteArray",
    "PyFalkon.MainApplication.searchEnginesManager(self)->PyFalkon.SearchEnginesManager",
    "PyFalkon.MainApplication.setChromiumFlags(self)",
    "PyFalkon.MainApplication.setTestModeEnabled(enabled:bool)",
    "PyFalkon.MainApplication.siteSettingsManager(self)->PyFalkon.SiteSettingsManager",
    "PyFalkon.MainApplication.startPrivateBrowsing(self,startUrl:typing.Union[PySide6.QtCore.QUrl, QString]=QUrl())",
    "PyFalkon.MainApplication.styleName(self)->QString",
    "PyFalkon.MainApplication.webProfile(self)->PySide6.QtWebEngineCore.QWebEngineProfile",
    "PyFalkon.MainApplication.webSettings(self)->PySide6.QtWebEngineCore.QWebEngineSettings",
    "PyFalkon.MainApplication.windowCount(self)->int",
    "PyFalkon.MainApplication.windows(self)->QList[PyFalkon.BrowserWindow]",
    "PyFalkon.MainApplication.wmClass(self)->PySide6.QtCore.QByteArray",
    nullptr}; // Sentinel
#else
static constexpr size_t MainApplication_SignatureByteSize = 614;
static constexpr uint8_t MainApplication_SignatureBytes[614] = {
    0x78, 0xda, 0xb5, 0x56, 0x4d, 0x8f, 0xda, 0x30, 0x10, 0xbd, 0xf3, 0x2b, 0x7a, 0x04, 0x89, 0xa2,
    0xf6, 0xd2, 0x03, 0xd2, 0x56, 0x82, 0x74, 0x51, 0x55, 0x2d, 0x5f, 0x0d, 0x68, 0x0f, 0x2b, 0x0e,
    0x26, 0x19, 0x88, 0x85, 0xb1, 0xd3, 0xf1, 0x04, 0x9a, 0x56, 0xfd, 0xef, 0x75, 0x12, 0xc2, 0xc7,
    0x26, 0x76, 0xe8, 0x4a, 0xbd, 0x10, 0xd9, 0xf3, 0xde, 0xcb, 0xe0, 0xf7, 0xc6, 0x30, 0x4b, 0x47,
    0x4c, 0xec, 0x94, 0xec, 0x8d, 0x19, 0x97, 0x83, 0x38, 0x16, 0x3c, 0x60, 0xc4, 0xcd, 0x9a, 0x85,
    0xe1, 0x04, 0x8e, 0x0b, 0xb6, 0x6e, 0x6b, 0x10, 0x9b, 0x6e, 0x82, 0xa2, 0x4f, 0x69, 0xcc, 0xe5,
    0xb6, 0xb7, 0x94, 0xa6, 0xfe, 0x32, 0x4b, 0x7d, 0x1e, 0xc2, 0xa7, 0xde, 0x9c, 0x3c, 0x85, 0xd0,
    0x9b, 0x2f, 0x51, 0x74, 0xdf, 0xcd, 0x7d, 0x42, 0x03, 0x59, 0x3d, 0x64, 0xcb, 0x76, 0xa7, 0xd3,
    0x9a, 0x59, 0xe5, 0x37, 0x04, 0xf8, 0xc4, 0x12, 0x19, 0x44, 0xf9, 0x0b, 0x3a, 0xef, 0x3f, 0x5b,
    0xb1, 0x83, 0x0b, 0xd6, 0x21, 0x98, 0x90, 0x1a, 0x71, 0x21, 0x2a, 0x6a, 0x83, 0x53, 0xc1, 0x4e,
    0x5d, 0x2b, 0xb5, 0xdb, 0x33, 0xdc, 0xe9, 0x0a, 0x77, 0x58, 0x56, 0xec, 0xe4, 0x20, 0x62, 0x72,
    0x0b, 0xd3, 0x20, 0x48, 0x10, 0x21, 0x2c, 0x14, 0x1c, 0x68, 0x23, 0xc8, 0xe1, 0x1b, 0xc3, 0xca,
    0xab, 0xbc, 0xb2, 0xd2, 0xfa, 0xd8, 0xb7, 0xd3, 0x11, 0x18, 0xc1, 0x33, 0x97, 0xa1, 0x3a, 0x16,
    0xbe, 0x18, 0x4f, 0xe0, 0x82, 0x9f, 0xff, 0xea, 0x0d, 0x51, 0x1d, 0x35, 0x60, 0x81, 0x59, 0x98,
    0x6a, 0x57, 0x13, 0x43, 0x32, 0x7e, 0xe8, 0xfe, 0xfc, 0x89, 0x6b, 0xaa, 0x73, 0x6e, 0xf5, 0xf0,
    0xfb, 0xcf, 0xcd, 0xf7, 0xbe, 0x16, 0x69, 0x7d, 0xf8, 0x4f, 0x0d, 0xfd, 0x43, 0xa0, 0xec, 0xcd,
    0x59, 0x5b, 0x0b, 0x41, 0xef, 0x48, 0xc5, 0x13, 0x45, 0x7c, 0x73, 0xda, 0xab, 0x1a, 0xfc, 0xa5,
    0x06, 0x34, 0x62, 0x01, 0x29, 0x4c, 0x9d, 0xca, 0x84, 0x2a, 0xfd, 0x6e, 0x1e, 0xa6, 0xd3, 0x31,
    0x93, 0x6c, 0x0b, 0xd8, 0xe4, 0xbc, 0xe9, 0x55, 0x0a, 0xc5, 0xc2, 0x1b, 0xf8, 0x75, 0x27, 0xb7,
    0x75, 0xbb, 0xd0, 0x16, 0xe8, 0xea, 0xbc, 0xdf, 0x70, 0x30, 0x11, 0xcf, 0xfa, 0x4e, 0x2b, 0xf4,
    0xaf, 0xc5, 0xbe, 0x9d, 0xc8, 0xa5, 0x71, 0x4e, 0x06, 0xd0, 0x36, 0xac, 0x69, 0x9c, 0x6d, 0x31,
    0x51, 0xb1, 0x2d, 0xfb, 0xbc, 0x22, 0xad, 0x1c, 0x72, 0xda, 0x13, 0x4a, 0x1b, 0x77, 0xcb, 0x4e,
    0xcc, 0x1c, 0x0a, 0x17, 0x7c, 0xa6, 0x90, 0xd8, 0x5a, 0xc0, 0xdd, 0x78, 0xe4, 0x07, 0x93, 0xce,
    0x7b, 0xe1, 0x7e, 0x16, 0x4b, 0xd3, 0x4e, 0x7e, 0xdd, 0x78, 0xc8, 0x74, 0x74, 0x2f, 0x73, 0x61,
    0x92, 0x30, 0x56, 0x21, 0x3c, 0xca, 0xac, 0xbd, 0xb0, 0xdd, 0x48, 0x91, 0x40, 0x47, 0x85, 0x3b,
    0x5b, 0x16, 0x26, 0x37, 0x65, 0xbb, 0x4c, 0x2c, 0x92, 0x2d, 0xaf, 0x49, 0xf5, 0x2c, 0xdf, 0x9f,
    0xa1, 0xfa, 0xe9, 0x70, 0xf3, 0x47, 0xc2, 0xe9, 0x6a, 0xdd, 0x94, 0x5f, 0x84, 0x2c, 0x9d, 0x3e,
    0x50, 0x76, 0x44, 0xfa, 0x3e, 0xf4, 0xd2, 0xa4, 0xd1, 0xa7, 0x54, 0x80, 0x1f, 0x01, 0x50, 0x33,
    0x27, 0x9f, 0xa7, 0xe9, 0x01, 0x10, 0x4d, 0xa4, 0xbc, 0x04, 0xb5, 0x6a, 0x1c, 0x2b, 0xcd, 0x0e,
    0x60, 0x8c, 0xbb, 0xb8, 0xfc, 0x3a, 0x8f, 0xc3, 0x94, 0x60, 0x80, 0xc8, 0x1c, 0x27, 0xa1, 0x81,
    0x61, 0x10, 0x3d, 0x4a, 0x73, 0x66, 0xa0, 0x6d, 0x9e, 0xf8, 0x35, 0x20, 0x97, 0x24, 0x79, 0x11,
    0xaa, 0x3d, 0x4f, 0xf6, 0x23, 0xc1, 0x9a, 0xcf, 0xcb, 0xe0, 0x5f, 0x87, 0x08, 0x8a, 0x67, 0x3f,
    0x4b, 0x92, 0x8b, 0xc9, 0x09, 0x4a, 0x57, 0xac, 0xbd, 0x57, 0x31, 0x0e, 0xc1, 0x6c, 0x0c, 0x4e,
    0xa3, 0x93, 0xdf, 0x28, 0xe5, 0x84, 0xbe, 0xe5, 0xde, 0x6e, 0xfe, 0x23, 0xa0, 0xb3, 0x7c, 0x4c,
    0xd8, 0xfe, 0x6c, 0xe0, 0x89, 0x6a, 0x67, 0x1c, 0x61, 0x6d, 0xa2, 0xbd, 0xe1, 0xa2, 0xc6, 0xf3,
    0x67, 0x58, 0x17, 0x16, 0x15, 0xbd, 0x9c, 0x97, 0x27, 0x82, 0x53, 0xf4, 0x36, 0xdb, 0xf7, 0xa8,
    0x96, 0x0c, 0x87, 0x6c, 0x7e, 0x17, 0x7b, 0x2a, 0x91, 0x54, 0xca, 0x72, 0x49, 0x4d, 0xf8, 0x73,
    0x0b, 0xe5, 0x0f, 0x76, 0xdd, 0x05, 0xef, 0xb8, 0x59, 0x8f, 0x7b, 0x4f, 0x30, 0xad, 0x9b, 0x47,
    0xe2, 0x2f, 0x9a, 0x37, 0xb6, 0x8d
};
#endif

PyTypeObject *init_MainApplication(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_MainApplication_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_MainApplication_IDX].type;

    Shiboken::AutoDecRef Sbk_MainApplication_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QtSingleApplication_IDX]))));

    _Sbk_MainApplication_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "MainApplication",
        "MainApplication*",
        &Sbk_MainApplication_spec,
        &Shiboken::callCppDestructor< MainApplication >,
        Sbk_MainApplication_Type_bases.object(),
        0);
    auto *pyType = Sbk_MainApplication_TypeF(); // references _Sbk_MainApplication_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, MainApplication_SignatureStrings);
#else
    InitSignatureBytes(pyType, MainApplication_SignatureBytes, MainApplication_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_MainApplication_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_MainApplication_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        MainApplication_PythonToCpp_MainApplication_PTR,
        is_MainApplication_PythonToCpp_MainApplication_PTR_Convertible,
        MainApplication_PTR_CppToPython_MainApplication);

    Shiboken::Conversions::registerConverterName(converter, "MainApplication");
    Shiboken::Conversions::registerConverterName(converter, "MainApplication*");
    Shiboken::Conversions::registerConverterName(converter, "MainApplication&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::MainApplication).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(MainApplicationWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_MainApplication_TypeF(), &Sbk_MainApplication_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_MainApplication_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'AfterLaunch'.
    const char *AfterLaunch_Initializer[] = {
        "OpenBlankPage",
        "OpenHomePage",
        "OpenSpeedDial",
        "RestoreSession",
        "SelectSession",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t AfterLaunch_InitializerValues[] = {
        uint8_t(MainApplication::AfterLaunch::OpenBlankPage),  //  0x00  0
        uint8_t(MainApplication::AfterLaunch::OpenHomePage),   //  0x01  1
        uint8_t(MainApplication::AfterLaunch::OpenSpeedDial),  //  0x02  2
        uint8_t(MainApplication::AfterLaunch::RestoreSession), //  0x03  3
        uint8_t(MainApplication::AfterLaunch::SelectSession)   //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_MainApplication_TypeF(),
        "1:PyFalkon.MainApplication.AfterLaunch",
        AfterLaunch_Initializer, AfterLaunch_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_MainApplication_AfterLaunch_IDX].type = EType;
    // Register converter for enum 'MainApplication::AfterLaunch'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            MainApplication_AfterLaunch_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_MainApplication_AfterLaunch,
            is_Enum_PythonToCpp_MainApplication_AfterLaunch_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "MainApplication::AfterLaunch");
        Shiboken::Conversions::registerConverterAlias(converter, "AfterLaunch");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'AfterLaunch' enum.

    PySide::Signal::registerSignals(pyType, &::MainApplication::staticMetaObject);
    MainApplicationWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::MainApplication::staticMetaObject, sizeof(MainApplicationWrapper));

    return pyType;
}
