/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.StandardExpressionPreprocessor;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class ExpressionSequenceUtils {
    public static ExpressionSequence parseExpressionSequence(IExpressionContext context, String input) {
        ExpressionSequence cachedExpressionSequence;
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        String preprocessedInput = StandardExpressionPreprocessor.preprocess(context, input);
        IEngineConfiguration configuration = context.getConfiguration();
        if (configuration != null && (cachedExpressionSequence = ExpressionCache.getExpressionSequenceFromCache(configuration, preprocessedInput)) != null) {
            return cachedExpressionSequence;
        }
        ExpressionSequence expressionSequence = ExpressionSequenceUtils.internalParseExpressionSequence(preprocessedInput.trim());
        if (expressionSequence == null) {
            throw new TemplateProcessingException("Could not parse as expression sequence: \"" + input + "\"");
        }
        if (configuration != null) {
            ExpressionCache.putExpressionSequenceIntoCache(configuration, preprocessedInput, expressionSequence);
        }
        return expressionSequence;
    }

    static ExpressionSequence internalParseExpressionSequence(String input) {
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        ExpressionParsingState decomposition = ExpressionParsingUtil.decompose(input);
        if (decomposition == null) {
            return null;
        }
        return ExpressionSequenceUtils.composeSequence(decomposition, 0);
    }

    private static ExpressionSequence composeSequence(ExpressionParsingState state, int nodeIndex) {
        if (state == null || nodeIndex >= state.size()) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            ArrayList<Expression> expressions = new ArrayList<Expression>(2);
            expressions.add(((ExpressionParsingNode)state.get(nodeIndex)).getExpression());
            return new ExpressionSequence(expressions);
        }
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int pointer = ExpressionParsingUtil.parseAsSimpleIndexPlaceholder(input);
        if (pointer != -1) {
            return ExpressionSequenceUtils.composeSequence(state, pointer);
        }
        String[] inputParts = StringUtils.split(input, ",");
        ArrayList<Expression> expressions = new ArrayList<Expression>(4);
        for (String inputPart : inputParts) {
            Expression expression = ExpressionParsingUtil.parseAndCompose(state, inputPart);
            if (expression == null) {
                return null;
            }
            expressions.add(expression);
        }
        return new ExpressionSequence(expressions);
    }

    private ExpressionSequenceUtils() {
    }
}

