/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class DriverInfo {
    public static final String DRIVER_NAME = "Redshift JDBC Driver";
    public static final String DRIVER_SHORT_NAME = "RsJDBC";
    public static final String DRIVER_VERSION;
    public static final String DRIVER_FULL_NAME;
    public static final int MAJOR_VERSION;
    public static final int MINOR_VERSION;
    public static final int PATCH_VERSION;
    public static final String JDBC_VERSION = "4.2";
    private static final int JDBC_INTVERSION = 42;
    public static final int JDBC_MAJOR_VERSION = 4;
    public static final int JDBC_MINOR_VERSION = 2;

    private DriverInfo() {
    }

    static {
        String version = "2.0.0.0";
        try (InputStream resourceAsStream2 = DriverInfo.class.getClassLoader().getResourceAsStream("redshift_jdbc_driver.properties");){
            Properties versionFromBuild = new Properties();
            versionFromBuild.load(resourceAsStream2);
            version = versionFromBuild.getProperty("version");
        }
        catch (IOException resourceAsStream2) {
            // empty catch block
        }
        String[] versionComponents = version.split("\\.");
        int majorVersion = 2;
        int minorVersion = 0;
        int patchVersion = 0;
        try {
            if (versionComponents.length >= 3) {
                majorVersion = Integer.parseInt(versionComponents[0]);
                minorVersion = Integer.parseInt(versionComponents[1]);
                patchVersion = Integer.parseInt(versionComponents[2]);
            } else {
                version = "2.0.0.0";
            }
        }
        catch (NumberFormatException ex) {
            majorVersion = 2;
            minorVersion = 0;
            patchVersion = 0;
        }
        MAJOR_VERSION = majorVersion;
        MINOR_VERSION = minorVersion;
        PATCH_VERSION = patchVersion;
        DRIVER_VERSION = version;
        DRIVER_FULL_NAME = "Redshift JDBC Driver " + DRIVER_VERSION;
    }
}

