/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jre7.sasl;

import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.ongres.scram.client.ScramClient;
import com.ongres.scram.client.ScramSession;
import com.ongres.scram.common.exception.ScramException;
import com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.exception.ScramServerErrorException;
import com.ongres.scram.common.stringprep.StringPreparation;
import com.ongres.scram.common.stringprep.StringPreparations;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class ScramAuthenticator {
    private final String user;
    private final String password;
    private final RedshiftStream pgStream;
    private ScramClient scramClient;
    private ScramSession scramSession;
    private ScramSession.ServerFirstProcessor serverFirstProcessor;
    private ScramSession.ClientFinalProcessor clientFinalProcessor;

    private void sendAuthenticationMessage(int bodyLength, BodySender bodySender) throws IOException {
        this.pgStream.sendChar(112);
        this.pgStream.sendInteger4(4 + bodyLength);
        bodySender.sendBody(this.pgStream);
        this.pgStream.flush();
    }

    public ScramAuthenticator(String user, String password, RedshiftStream pgStream) {
        this.user = user;
        this.password = password;
        this.pgStream = pgStream;
    }

    public void processServerMechanismsAndInit() throws IOException, RedshiftException {
        ArrayList<String> mechanisms = new ArrayList<String>();
        do {
            mechanisms.add(this.pgStream.receiveString());
        } while (this.pgStream.peekChar() != 0);
        int c = this.pgStream.receiveChar();
        assert (c == 0);
        if (mechanisms.size() < 1) {
            throw new RedshiftException(GT.tr("No SCRAM mechanism(s) advertised by the server", new Object[0]), RedshiftState.CONNECTION_REJECTED);
        }
        try {
            this.scramClient = ScramClient.channelBinding((ScramClient.ChannelBinding)ScramClient.ChannelBinding.NO).stringPreparation((StringPreparation)StringPreparations.NO_PREPARATION).selectMechanismBasedOnServerAdvertised(mechanisms.toArray(new String[0])).setup();
        }
        catch (IllegalArgumentException e) {
            throw new RedshiftException(GT.tr("Invalid or unsupported by client SCRAM mechanisms", e), RedshiftState.CONNECTION_REJECTED);
        }
        this.scramSession = this.scramClient.scramSession("*");
    }

    public void sendScramClientFirstMessage() throws IOException {
        String clientFirstMessage = this.scramSession.clientFirstMessage();
        String scramMechanismName = this.scramClient.getScramMechanism().getName();
        final byte[] scramMechanismNameBytes = scramMechanismName.getBytes(StandardCharsets.UTF_8);
        final byte[] clientFirstMessageBytes = clientFirstMessage.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(scramMechanismNameBytes.length + 1 + 4 + clientFirstMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(RedshiftStream pgStream) throws IOException {
                pgStream.send(scramMechanismNameBytes);
                pgStream.sendChar(0);
                pgStream.sendInteger4(clientFirstMessageBytes.length);
                pgStream.send(clientFirstMessageBytes);
            }
        });
    }

    public void processServerFirstMessage(int length) throws IOException, RedshiftException {
        String serverFirstMessage = this.pgStream.receiveString(length);
        try {
            this.serverFirstProcessor = this.scramSession.receiveServerFirstMessage(serverFirstMessage);
        }
        catch (ScramException e) {
            throw new RedshiftException(GT.tr("Invalid server-first-message: {0}", serverFirstMessage), RedshiftState.CONNECTION_REJECTED, (Throwable)e);
        }
        this.clientFinalProcessor = this.serverFirstProcessor.clientFinalProcessor(this.password);
        String clientFinalMessage = this.clientFinalProcessor.clientFinalMessage();
        final byte[] clientFinalMessageBytes = clientFinalMessage.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(clientFinalMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(RedshiftStream pgStream) throws IOException {
                pgStream.send(clientFinalMessageBytes);
            }
        });
    }

    public void verifyServerSignature(int length) throws IOException, RedshiftException {
        String serverFinalMessage = this.pgStream.receiveString(length);
        try {
            this.clientFinalProcessor.receiveServerFinalMessage(serverFinalMessage);
        }
        catch (ScramParseException e) {
            throw new RedshiftException(GT.tr("Invalid server-final-message: {0}", serverFinalMessage), RedshiftState.CONNECTION_REJECTED, (Throwable)e);
        }
        catch (ScramServerErrorException e) {
            throw new RedshiftException(GT.tr("SCRAM authentication failed, server returned error: {0}", e.getError().getErrorMessage()), RedshiftState.CONNECTION_REJECTED, (Throwable)e);
        }
        catch (ScramInvalidServerSignatureException e) {
            throw new RedshiftException(GT.tr("Invalid server SCRAM signature", new Object[0]), RedshiftState.CONNECTION_REJECTED, (Throwable)e);
        }
    }

    private static interface BodySender {
        public void sendBody(RedshiftStream var1) throws IOException;
    }
}

