import socket
from types import FrameType
from typing import ClassVar

from gunicorn.app.base import BaseApplication
from gunicorn.config import Config
from gunicorn.glogging import Logger as GLogger
from gunicorn.workers.base import Worker

from ._types import _AddressType
from .pidfile import Pidfile

class Arbiter:
    WORKER_BOOT_ERROR: ClassVar[int]
    APP_LOAD_ERROR: ClassVar[int]
    START_CTX: ClassVar[dict[int | str, str | list[str]]]
    LISTENERS: ClassVar[list[socket.socket]]
    WORKERS: ClassVar[dict[int, Worker]]
    PIPE: ClassVar[list[int]]
    SIG_QUEUE: ClassVar[list[int]]
    SIGNALS: ClassVar[list[int]]
    SIG_NAMES: ClassVar[dict[int, str]]
    log: GLogger | None
    pidfile: Pidfile | None
    systemd: bool
    worker_age: int
    reexec_pid: int
    master_pid: int
    master_name: str
    pid: int
    app: BaseApplication
    cfg: Config
    worker_class: type[Worker]
    address: list[_AddressType]
    timeout: int
    proc_name: str
    num_workers: int

    def __init__(self, app: BaseApplication) -> None: ...
    def setup(self, app: BaseApplication) -> None: ...
    def start(self) -> None: ...
    def init_signals(self) -> None: ...
    def signal(self, sig: int, frame: FrameType | None) -> None: ...
    def run(self) -> None: ...
    def handle_chld(self, sig: int, frame: FrameType | None) -> None: ...
    def handle_hup(self) -> None: ...
    def handle_term(self) -> None: ...
    def handle_int(self) -> None: ...
    def handle_quit(self) -> None: ...
    def handle_ttin(self) -> None: ...
    def handle_ttou(self) -> None: ...
    def handle_usr1(self) -> None: ...
    def handle_usr2(self) -> None: ...
    def handle_winch(self) -> None: ...
    def maybe_promote_master(self) -> None: ...
    def wakeup(self) -> None: ...
    def halt(self, reason: str | None = None, exit_status: int = 0) -> None: ...
    def sleep(self) -> None: ...
    def stop(self, graceful: bool = True) -> None: ...
    def reexec(self) -> None: ...
    def reload(self) -> None: ...
    def murder_workers(self) -> None: ...
    def reap_workers(self) -> None: ...
    def manage_workers(self) -> None: ...
    def spawn_worker(self) -> int: ...
    def spawn_workers(self) -> None: ...
    def kill_workers(self, sig: int) -> None: ...
    def kill_worker(self, pid: int, sig: int) -> None: ...
