/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc.spm;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.brotli.BrotliInputStream;
import net.sourceforge.plantuml.preproc.Stdlib;

public enum SpmChannel {
    INFO,
    PUML,
    JSON,
    SPRITE,
    SVG,
    IMAGE;


    private String getFileName() {
        return this.name().toLowerCase().replace('_', '-') + ".spm";
    }

    public InputStream getInternalInputStream(String libname) throws IOException {
        String path = "stdlib/" + libname + "/" + this.getFileName();
        return new BrotliInputStream(SpmChannel.inputStream(path));
    }

    public static InputStream inputStream(String path) throws IOException {
        InputStream result = Stdlib.class.getResourceAsStream("/" + path);
        if (result == null) {
            result = new BufferedInputStream(new FileInputStream(path));
        }
        return result;
    }
}

