/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.util.ObjectBuilder;

public abstract class IndicesResponseBase
extends AcknowledgedResponseBase {
    @Nullable
    private final ShardStatistics shards;

    protected IndicesResponseBase(AbstractBuilder<?> builder) {
        super(builder);
        this.shards = ((AbstractBuilder)builder).shards;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupIndicesResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        IndicesResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.shards);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesResponseBase other = (IndicesResponseBase)o;
        return Objects.equals(this.shards, other.shards);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AcknowledgedResponseBase.AbstractBuilder<BuilderT> {
        @Nullable
        private ShardStatistics shards;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(IndicesResponseBase o) {
            super(o);
            this.shards = o.shards;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.shards = o.shards;
        }

        @Nonnull
        public final BuilderT shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }
    }
}

