/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.Vpc;

public class DescribeVpcsIterable
implements SdkIterable<DescribeVpcsResponse> {
    private final Ec2Client client;
    private final DescribeVpcsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcsIterable(Ec2Client client, DescribeVpcsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVpcsResponseFetcher();
    }

    public Iterator<DescribeVpcsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Vpc> vpcs() {
        Function<DescribeVpcsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcs() != null) {
                return response.vpcs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcsResponseFetcher
    implements SyncPageFetcher<DescribeVpcsResponse> {
        private DescribeVpcsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcsResponse nextPage(DescribeVpcsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcsIterable.this.client.describeVpcs(DescribeVpcsIterable.this.firstRequest);
            }
            return DescribeVpcsIterable.this.client.describeVpcs((DescribeVpcsRequest)((Object)DescribeVpcsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

