/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import java.util.ArrayList;
import org.opensearch.index.query.TermsSetQueryBuilder;
import org.opensearch.protobufs.TermsSetQuery;
import org.opensearch.script.Script;
import org.opensearch.transport.grpc.proto.request.common.ScriptProtoUtils;

class TermsSetQueryBuilderProtoUtils {
    private TermsSetQueryBuilderProtoUtils() {
    }

    static TermsSetQueryBuilder fromProto(TermsSetQuery termsSetQueryProto) {
        if (termsSetQueryProto == null) {
            throw new IllegalArgumentException("TermsSetQuery must not be null");
        }
        if (termsSetQueryProto.getField() == null || termsSetQueryProto.getField().isEmpty()) {
            throw new IllegalArgumentException("Field name is required for TermsSetQuery");
        }
        if (termsSetQueryProto.getTermsCount() == 0) {
            throw new IllegalArgumentException("At least one term is required for TermsSetQuery");
        }
        String fieldName = termsSetQueryProto.getField();
        ArrayList values = new ArrayList(termsSetQueryProto.getTermsList());
        String minimumShouldMatchField = null;
        Script minimumShouldMatchScript = null;
        String queryName = null;
        float boost = 1.0f;
        if (termsSetQueryProto.hasBoost()) {
            boost = termsSetQueryProto.getBoost();
        }
        if (termsSetQueryProto.hasXName()) {
            queryName = termsSetQueryProto.getXName();
        }
        if (termsSetQueryProto.hasMinimumShouldMatchField()) {
            minimumShouldMatchField = termsSetQueryProto.getMinimumShouldMatchField();
        }
        if (termsSetQueryProto.hasMinimumShouldMatchScript()) {
            minimumShouldMatchScript = ScriptProtoUtils.parseFromProtoRequest(termsSetQueryProto.getMinimumShouldMatchScript());
        }
        TermsSetQueryBuilder queryBuilder = new TermsSetQueryBuilder(fieldName, values);
        queryBuilder.boost(boost);
        queryBuilder.queryName(queryName);
        if (minimumShouldMatchField != null) {
            queryBuilder.setMinimumShouldMatchField(minimumShouldMatchField);
        }
        if (minimumShouldMatchScript != null) {
            queryBuilder.setMinimumShouldMatchScript(minimumShouldMatchScript);
        }
        return queryBuilder;
    }
}

