/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadSafeCache<K, V> {
    private final Lock lock = new ReentrantLock();
    private final Map<K, V> cache;

    public ThreadSafeCache(final int maxEntries) {
        this.cache = new LinkedHashMap<K, V>(maxEntries, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > maxEntries;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        try {
            this.lock.lock();
            V v = this.cache.put(key, value);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public V get(K key) {
        try {
            this.lock.lock();
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public V remove(K key) {
        try {
            this.lock.lock();
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }
}

