/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.servlet;

import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import oracle.aurora.rdbms.DbmsJava;
import oracle.xdb.servlet.XDBServletConfig;
import oracle.xdb.servlet.XDBServletRequest;
import oracle.xdb.servlet.XDBServletResponse;

public class XDBServletContainer {
    static final boolean DEBUG = false;
    private static Hashtable servletTab = new Hashtable();

    private static native String getServletName();

    private static native String getServletClass();

    private static native String getServletSchema();

    private static native void setError(String var0);

    private static final Servlet initServlet(String svname) throws ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        String svclass = XDBServletContainer.getServletClass();
        String svschema = XDBServletContainer.getServletSchema();
        Class c = DbmsJava.classForNameAndSchema((String)svclass, (String)svschema.toUpperCase());
        Servlet svt = (Servlet)c.newInstance();
        XDBServletConfig config = new XDBServletConfig(svname);
        svt.init((ServletConfig)config);
        return svt;
    }

    public static int handleRequest(int c1, int c2) {
        try {
            String svname = XDBServletContainer.getServletName();
            if (svname == null) {
                return 1;
            }
            Servlet svt = (Servlet)servletTab.get(svname);
            if (svt == null) {
                svt = XDBServletContainer.initServlet(svname);
                servletTab.put(svname, svt);
            }
            XDBServletRequest req = new XDBServletRequest();
            XDBServletResponse rsp = new XDBServletResponse();
            svt.service((ServletRequest)req, (ServletResponse)rsp);
        }
        catch (Exception e) {
            String error = e.toString();
            System.out.println("XDB: Uncaught servlet exception (" + error + ")");
            e.printStackTrace(System.out);
            System.out.println("========================================");
            XDBServletContainer.setError(error);
            return 1;
        }
        return 0;
    }
}

