/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.Row;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class TableWorks {
    OrderedHashSet emptySet = new OrderedHashSet();
    private Database database;
    private Table table;
    private Session session;

    public TableWorks(Session session, Table table) {
        this.database = table.database;
        this.table = table;
        this.session = session;
        if (table.isView()) {
            throw Error.error(5524);
        }
    }

    public Table getTable() {
        return this.table;
    }

    void checkCreateForeignKey(Table table, Constraint constraint) {
        Object object;
        Object object2;
        int n;
        int[] nArray = constraint.getRefColumns();
        for (n = 0; n < nArray.length; ++n) {
            ColumnSchema columnSchema = table.getColumn(nArray[n]);
            if (!columnSchema.isSystemPeriod()) continue;
            throw Error.error(5517);
        }
        n = constraint.hasTriggeredAction() ? 1 : 0;
        if (n != 0) {
            for (int i = 0; i < constraint.core.refCols.length; ++i) {
                object2 = table.getColumn(constraint.core.refCols[i]);
                if (!((ColumnSchema)object2).isGenerated()) continue;
                throw Error.error(5524, ((ColumnSchema)object2).getNameString());
            }
        }
        if (constraint.core.mainName == table.getName() && ArrayUtil.haveCommonElement(constraint.core.refCols, constraint.core.mainCols)) {
            throw Error.error(5527);
        }
        int n2 = n = constraint.getUpdateAction() == 4 || constraint.getDeleteAction() == 4 ? 1 : 0;
        if (n != 0) {
            for (int i = 0; i < constraint.core.refCols.length; ++i) {
                object2 = table.getColumn(constraint.core.refCols[i]);
                object = ((ColumnSchema)object2).getDefaultExpression();
                if (object != null) continue;
                String string = ((ColumnSchema)object2).getName().statementName;
                throw Error.error(5521, string);
            }
        }
        int n3 = n = constraint.core.updateAction == 2 || constraint.core.deleteAction == 2 ? 1 : 0;
        if (n != 0 && !this.session.isProcessingScript()) {
            for (int i = 0; i < constraint.core.refCols.length; ++i) {
                object2 = table.getColumn(constraint.core.refCols[i]);
                if (((ColumnSchema)object2).isNullable() && !((ColumnSchema)object2).isPrimaryKey()) continue;
                object = ((ColumnSchema)object2).getName().statementName;
                throw Error.error(5520, (String)object);
            }
        }
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        if (table.getConstraint(constraint.getName().name) != null) {
            throw Error.error(5504, constraint.getName().statementName);
        }
        if (table.getFKConstraintForColumns(constraint.core.mainTable, constraint.core.mainCols, constraint.core.refCols) != null) {
            throw Error.error(5528, constraint.getName().statementName);
        }
        if (constraint.core.mainTable.isTemp() != table.isTemp()) {
            throw Error.error(5524, constraint.getName().statementName);
        }
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        if (constraint2 == null) {
            throw Error.error(5529, constraint.getMain().getName().statementName);
        }
        constraint.core.mainTable.checkReferentialColumnsMatch(constraint.core.mainCols, table, constraint.core.refCols);
        ArrayUtil.reorderMaps(constraint2.getMainColumns(), constraint.getMainColumns(), constraint.getRefColumns());
        object2 = constraint.core.mainTable.getColumnCheckList(constraint.core.mainCols);
        object = this.session.getGrantee();
        ((Grantee)object).checkReferences(constraint.core.mainTable, (boolean[])object2);
    }

    void addForeignKey(Constraint constraint) {
        this.checkModifyTable(false);
        this.checkCreateForeignKey(this.table, constraint);
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        Index index = constraint2.getMainIndex();
        boolean bl = false;
        if (constraint.core.mainTable.getSchemaName() == this.table.getSchemaName()) {
            int n = this.database.schemaManager.getTableIndex(this.table);
            if (n != -1 && n < this.database.schemaManager.getTableIndex(constraint.core.mainTable)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("REF", constraint.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
        HsqlNameManager.HsqlName hsqlName2 = this.session.database.nameManager.newConstraintIndexName(this.table.getName(), constraint.getName(), this.session.database.sqlSysIndexNames);
        Index index2 = this.table.createIndexStructure(hsqlName2, constraint.core.refCols, null, null, false, false, true, bl);
        constraint.core.uniqueName = constraint2.getName();
        constraint.core.mainName = hsqlName;
        constraint.core.mainIndex = index;
        constraint.core.refTable = this.table;
        constraint.core.refName = constraint.getName();
        constraint.core.refIndex = index2;
        constraint.isForward = bl;
        if (!this.session.isProcessingScript()) {
            constraint.checkReferencedRows(this.session, this.table);
        }
        Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, constraint, index2, new int[0], 0, this.emptySet, this.emptySet);
        if (!this.session.isProcessingScript()) {
            this.moveData(this.table, table, new int[0], 0);
        }
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(table);
        Table table2 = this.database.schemaManager.getUserTable(constraint.core.mainTable.getName());
        table2.addConstraint(new Constraint(hsqlName, constraint));
        this.updateConstraints(table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(table);
        this.database.schemaManager.recompileDependentObjects(table2);
        this.table = table;
    }

    void checkAddColumn(ColumnSchema columnSchema) {
        this.checkModifyTable(true);
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Error.error(320);
        }
        if (this.table.findColumn(columnSchema.getName().name) != -1) {
            throw Error.error(5504);
        }
        if (columnSchema.isPrimaryKey() && this.table.hasPrimaryKey()) {
            throw Error.error(5530);
        }
        if (columnSchema.isIdentity() && this.table.hasIdentityColumn()) {
            throw Error.error(5525);
        }
        if (!(this.table.isEmpty(this.session) || columnSchema.hasDefault() || columnSchema.isNullable() && !columnSchema.isPrimaryKey() || columnSchema.isIdentity())) {
            throw Error.error(5531);
        }
    }

    void addColumn(ColumnSchema columnSchema, int n, HsqlArrayList hsqlArrayList) {
        Index index = null;
        Constraint constraint = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.checkAddColumn(columnSchema);
        Constraint constraint2 = (Constraint)hsqlArrayList.get(0);
        if (constraint2.getConstraintType() == 4) {
            if (columnSchema.getDataType().isLobType()) {
                throw Error.error(5534);
            }
            constraint2.core.mainCols = new int[]{n};
            this.database.schemaManager.checkSchemaObjectNotExists(constraint2.getName());
            if (this.table.hasPrimaryKey()) {
                throw Error.error(5530);
            }
            bl2 = true;
        } else {
            constraint2 = null;
        }
        Table table = this.table.moveDefinition(this.session, this.table.tableType, new ColumnSchema[]{columnSchema}, constraint2, null, new int[]{n}, 1, this.emptySet, this.emptySet);
        block5: for (int i = 1; i < hsqlArrayList.size(); ++i) {
            constraint2 = (Constraint)hsqlArrayList.get(i);
            switch (constraint2.getConstraintType()) {
                case 2: {
                    if (bl2) {
                        throw Error.error(5522);
                    }
                    if (columnSchema.getDataType().isLobType()) {
                        throw Error.error(5534);
                    }
                    bl2 = true;
                    constraint2.core.mainCols = new int[]{n};
                    this.database.schemaManager.checkSchemaObjectNotExists(constraint2.getName());
                    HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX", constraint2.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = table.createAndAddIndexStructure(this.session, hsqlName, constraint2.getMainColumns(), null, null, true, true, false);
                    constraint2.core.mainTable = table;
                    constraint2.core.mainIndex = index;
                    table.addConstraint(constraint2);
                    continue block5;
                }
                case 0: {
                    boolean bl4;
                    if (bl) {
                        throw Error.error(5528);
                    }
                    bl = true;
                    constraint2.core.refCols = new int[]{n};
                    constraint2.core.mainTable = this.database.schemaManager.getUserTable(constraint2.getMainTableName());
                    constraint2.core.refTable = table;
                    constraint2.core.refName = constraint2.getName();
                    boolean bl5 = bl4 = this.table == constraint2.core.mainTable;
                    if (bl4) {
                        constraint2.core.mainTable = table;
                    }
                    constraint2.setColumnsIndexes(table);
                    this.checkCreateForeignKey(table, constraint2);
                    Constraint constraint3 = constraint2.core.mainTable.getUniqueConstraintForColumns(constraint2.core.mainCols);
                    boolean bl6 = constraint2.core.mainTable.getSchemaName() != this.table.getSchemaName();
                    int n2 = this.database.schemaManager.getTableIndex(this.table);
                    if (!bl4 && n2 < this.database.schemaManager.getTableIndex(constraint2.core.mainTable)) {
                        bl6 = true;
                    }
                    HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX", constraint2.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = table.createAndAddIndexStructure(this.session, hsqlName, constraint2.getRefColumns(), null, null, false, true, bl6);
                    constraint2.core.uniqueName = constraint3.getName();
                    constraint2.core.mainName = this.database.nameManager.newAutoName("REF", constraint2.core.refName.name, this.table.getSchemaName(), this.table.getName(), 20);
                    constraint2.core.mainIndex = constraint3.getMainIndex();
                    constraint2.core.refIndex = index;
                    constraint2.isForward = bl6;
                    table.addConstraint(constraint2);
                    constraint = new Constraint(constraint2.core.mainName, constraint2);
                    continue block5;
                }
                case 3: {
                    if (bl3) {
                        throw Error.error(5528);
                    }
                    bl3 = true;
                    constraint2.prepareCheckConstraint(this.session, table);
                    table.addConstraint(constraint2);
                    if (!constraint2.isNotNull()) continue block5;
                    columnSchema.setNullable(false);
                    table.setColumnTypeVars(n);
                    if (this.table.isEmpty(this.session) || columnSchema.hasDefault()) continue block5;
                    throw Error.error(5531);
                }
            }
        }
        columnSchema.compile(this.session, table);
        this.moveData(this.table, table, new int[]{n}, 1);
        if (constraint != null) {
            constraint.getMain().addConstraint(constraint);
        }
        this.registerConstraintNames(hsqlArrayList);
        this.setNewTableInSchema(table);
        this.updateConstraints(table, this.emptySet);
        this.database.schemaManager.addSchemaObject(columnSchema);
        this.database.schemaManager.recompileDependentObjects(table);
        table.compile(this.session, null);
        TriggerDef[] triggerDefArray = this.table.getTriggers();
        for (int i = 0; i < triggerDefArray.length; ++i) {
            if (!(triggerDefArray[i] instanceof TriggerDefSQL)) continue;
            triggerDefArray[i].compile(this.session, null);
        }
        this.table = table;
        this.database.granteeManager.updateAddColumn(this.table.getName(), columnSchema.getName());
    }

    void updateConstraints(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Table table = (Table)orderedHashSet.get(i);
            this.updateConstraints(table, orderedHashSet2);
        }
    }

    void updateConstraints(Table table, OrderedHashSet orderedHashSet) {
        for (int i = table.constraintList.length - 1; i >= 0; --i) {
            Constraint constraint;
            Table table2;
            Table table3;
            Constraint constraint2 = table.constraintList[i];
            if (orderedHashSet.contains(constraint2.getName())) {
                table.removeConstraint(i);
                continue;
            }
            if (constraint2.getConstraintType() == 0) {
                constraint2.core.refTable = table3 = this.database.schemaManager.getUserTable(constraint2.core.refTable.getName());
                table2 = this.database.schemaManager.getUserTable(constraint2.core.mainTable.getName());
                constraint = table2.getConstraint(constraint2.getMainName().name);
                constraint.core = constraint2.core;
                continue;
            }
            if (constraint2.getConstraintType() != 1) continue;
            constraint2.core.mainTable = table3 = this.database.schemaManager.getUserTable(constraint2.core.mainTable.getName());
            table2 = this.database.schemaManager.getUserTable(constraint2.core.refTable.getName());
            constraint = table2.getConstraint(constraint2.getRefName().name);
            constraint.core = constraint2.core;
        }
    }

    OrderedHashSet dropConstraintsAndIndexes(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2, OrderedHashSet orderedHashSet3) {
        OrderedHashSet<Table> orderedHashSet4 = new OrderedHashSet<Table>();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Table table = (Table)orderedHashSet.get(i);
            TableWorks tableWorks = new TableWorks(this.session, table);
            tableWorks.dropConstraintsAndIndexes(orderedHashSet2, orderedHashSet3);
            orderedHashSet4.add(tableWorks.getTable());
        }
        return orderedHashSet4;
    }

    void dropConstraintsAndIndexes(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, orderedHashSet, orderedHashSet2);
        if (table.indexList.length == this.table.indexList.length) {
            this.database.persistentStoreCollection.removeStore(table);
            return;
        }
        this.moveData(this.table, table, new int[0], 0);
        this.table = table;
    }

    void alterIndex(Index index, int[] nArray) {
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this.table);
        int n = index.getPosition();
        boolean[] blArray = new boolean[nArray.length];
        Object[] objectArray = new Type[nArray.length];
        ArrayUtil.projectRow(this.table.getColumnTypes(), nArray, objectArray);
        Index index2 = this.database.logger.newIndex(index.getName(), index.getPersistenceId(), this.table, nArray, blArray, blArray, (Type[])objectArray, false, false, index.isConstraint(), index.isForward());
        index2.setPosition(n);
        this.table.getIndexList()[n] = index2;
        this.table.setBestRowIdentifiers();
        Index[] indexArray = persistentStore.getAccessorKeys();
        indexArray[n] = index2;
        persistentStore.reindex(this.session, index2, null);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    Index addIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Index index;
        this.checkModifyTable(false);
        if (this.session.isProcessingScript() || this.table.isEmpty(this.session) || this.table.isIndexingMutable()) {
            index = this.table.createIndex(this.session, hsqlName, nArray, null, null, bl, false, false);
        } else {
            index = this.table.createIndexStructure(hsqlName, nArray, null, null, false, bl, false, false);
            Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, index, new int[0], 0, this.emptySet, this.emptySet);
            this.moveData(this.table, table, new int[0], 0);
            this.table = table;
            this.setNewTableInSchema(this.table);
            this.updateConstraints(this.table, this.emptySet);
        }
        this.database.schemaManager.addSchemaObject(index);
        this.database.schemaManager.recompileDependentObjects(this.table);
        return index;
    }

    void addPrimaryKey(Constraint constraint) {
        this.checkModifyTable(true);
        if (this.table.hasPrimaryKey()) {
            throw Error.error(5532);
        }
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, constraint, null, new int[0], 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, new int[0], 0);
        this.table = table;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addUniqueConstraint(int[] nArray, HsqlNameManager.HsqlName hsqlName) {
        SchemaObject schemaObject;
        for (int i = 0; i < nArray.length; ++i) {
            schemaObject = this.table.getColumn(nArray[i]);
            if (!schemaObject.isSystemPeriod()) continue;
            throw Error.error(5517);
        }
        this.checkModifyTable(false);
        this.database.schemaManager.checkSchemaObjectNotExists(hsqlName);
        if (this.table.getUniqueConstraintForColumns(nArray) != null) {
            throw Error.error(5522);
        }
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("IDX", hsqlName.name, this.table.getSchemaName(), this.table.getName(), 20);
        schemaObject = this.table.createIndexStructure(hsqlName2, nArray, null, null, false, true, true, false);
        Constraint constraint = new Constraint(hsqlName, this.table, (Index)schemaObject, 2);
        Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, constraint, (Index)schemaObject, new int[0], 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, new int[0], 0);
        this.table = table;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addUniqueConstraint(Constraint constraint) {
        int[] nArray = constraint.getMainColumns();
        for (int i = 0; i < nArray.length; ++i) {
            ColumnSchema columnSchema = this.table.getColumn(nArray[i]);
            if (!columnSchema.isSystemPeriod()) continue;
            throw Error.error(5517);
        }
        this.checkModifyTable(false);
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        if (this.table.getUniqueConstraintForColumns(constraint.getMainColumns()) != null) {
            throw Error.error(5522);
        }
        Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, constraint, constraint.getMainIndex(), new int[0], 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, new int[0], 0);
        this.table = table;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addCheckConstraint(Constraint constraint) {
        this.checkModifyTable(false);
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        constraint.prepareCheckConstraint(this.session, this.table);
        constraint.checkCheckConstraint(this.session, this.table);
        this.table.addConstraint(constraint);
        if (constraint.isNotNull()) {
            ColumnSchema columnSchema = this.table.getColumn(constraint.notNullColumnIndex);
            columnSchema.setNullable(false);
            this.table.setColumnTypeVars(constraint.notNullColumnIndex);
        }
        this.database.schemaManager.addSchemaObject(constraint);
    }

    void dropIndex(String string) {
        this.checkModifyTable(false);
        Index index = this.table.getUserIndex(string);
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(this.session, index.getPosition());
        } else {
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            orderedHashSet.add(this.table.getIndex(string).getName());
            Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, this.emptySet, orderedHashSet);
            this.moveData(this.table, table, new int[0], 0);
            this.setNewTableInSchema(table);
            this.updateConstraints(table, this.emptySet);
            this.table = table;
        }
        if (!index.isConstraint()) {
            this.database.schemaManager.removeSchemaObject(index.getName());
        }
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void dropColumn(int n, boolean bl) {
        Object object;
        int n2;
        ColumnSchema columnSchema = this.table.getColumn(n);
        if (columnSchema.isSystemPeriod()) {
            throw Error.error(5517);
        }
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet orderedHashSet2 = this.table.getDependentConstraints(n);
        OrderedHashSet orderedHashSet3 = this.table.getContainingConstraints(n);
        OrderedHashSet orderedHashSet4 = this.table.getContainingIndexNames(n);
        HsqlNameManager.HsqlName hsqlName = columnSchema.getName();
        OrderedHashSet orderedHashSet5 = this.database.schemaManager.getReferencesTo(this.table.getName(), hsqlName);
        this.checkModifyTable(true);
        TriggerDef[] triggerDefArray = this.table.getTriggers();
        for (n2 = 0; n2 < triggerDefArray.length; ++n2) {
            object = triggerDefArray[n2];
            if (!(object instanceof TriggerDefSQL) || !((TriggerDef)object).hasOldTable() && !((TriggerDef)object).hasNewTable() && !((TriggerDef)object).hasOldRow() && !((TriggerDef)object).hasNewRow()) continue;
            throw Error.error(5502, ((TriggerDef)object).getName().getSchemaQualifiedStatementName());
        }
        if (!bl) {
            if (!orderedHashSet3.isEmpty()) {
                Constraint constraint = (Constraint)orderedHashSet3.get(0);
                object = constraint.getName();
                if (constraint.getConstraintType() == 1) {
                    object = constraint.getRefName();
                }
                throw Error.error(5536, ((HsqlNameManager.HsqlName)object).getSchemaQualifiedStatementName());
            }
            if (!orderedHashSet5.isEmpty()) {
                block1: for (n2 = 0; n2 < orderedHashSet5.size(); ++n2) {
                    object = (HsqlNameManager.HsqlName)orderedHashSet5.get(n2);
                    if (object == hsqlName) continue;
                    for (int i = 0; i < orderedHashSet2.size(); ++i) {
                        Constraint constraint = (Constraint)orderedHashSet2.get(i);
                        if (constraint.getName() == object) continue block1;
                    }
                    throw Error.error(5536, ((HsqlNameManager.HsqlName)object).getSchemaQualifiedStatementName());
                }
            }
        }
        orderedHashSet2.addAll(orderedHashSet3);
        orderedHashSet3.clear();
        OrderedHashSet orderedHashSet6 = new OrderedHashSet();
        for (int i = 0; i < orderedHashSet2.size(); ++i) {
            Constraint constraint = (Constraint)orderedHashSet2.get(i);
            if (constraint.getConstraintType() == 0) {
                orderedHashSet6.add(constraint.getMain());
                orderedHashSet.add(constraint.getMainName());
                orderedHashSet.add(constraint.getRefName());
                orderedHashSet4.add(constraint.getRefIndex().getName());
            }
            if (constraint.getConstraintType() == 1) {
                orderedHashSet6.add(constraint.getRef());
                orderedHashSet.add(constraint.getMainName());
                orderedHashSet.add(constraint.getRefName());
                orderedHashSet4.add(constraint.getRefIndex().getName());
            }
            orderedHashSet.add(constraint.getName());
        }
        orderedHashSet6 = this.dropConstraintsAndIndexes(orderedHashSet6, orderedHashSet, orderedHashSet4);
        Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[]{n}, -1, orderedHashSet, orderedHashSet4);
        this.moveData(this.table, table, new int[]{n}, -1);
        this.database.schemaManager.removeSchemaObjects(orderedHashSet5);
        this.database.schemaManager.removeSchemaObjects(orderedHashSet);
        this.database.schemaManager.removeSchemaObjects(orderedHashSet4);
        this.database.schemaManager.removeSchemaObject(hsqlName);
        this.setNewTableInSchema(table);
        this.setNewTablesInSchema(orderedHashSet6);
        this.updateConstraints(table, this.emptySet);
        this.updateConstraints(orderedHashSet6, orderedHashSet);
        this.database.schemaManager.recompileDependentObjects(orderedHashSet6);
        this.database.schemaManager.recompileDependentObjects(table);
        table.compile(this.session, null);
        this.table = table;
    }

    void registerConstraintNames(HsqlArrayList hsqlArrayList) {
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Constraint constraint = (Constraint)hsqlArrayList.get(i);
            switch (constraint.getConstraintType()) {
                case 2: 
                case 3: 
                case 4: {
                    this.database.schemaManager.addSchemaObject(constraint);
                }
            }
        }
    }

    void dropConstraint(String string, boolean bl) {
        Constraint constraint = this.table.getConstraint(string);
        if (constraint == null) {
            throw Error.error(5501, string);
        }
        switch (constraint.getConstraintType()) {
            case 1: {
                throw Error.error(4002);
            }
            case 2: 
            case 4: {
                Object object;
                this.checkModifyTable(false);
                OrderedHashSet orderedHashSet = this.table.getDependentConstraints(constraint);
                if (!bl && !orderedHashSet.isEmpty()) {
                    Constraint constraint2 = (Constraint)orderedHashSet.get(0);
                    HsqlNameManager.HsqlName hsqlName = constraint2.getName();
                    if (constraint2.getConstraintType() == 1) {
                        hsqlName = constraint2.getRefName();
                    }
                    throw Error.error(5533, hsqlName.getSchemaQualifiedStatementName());
                }
                OrderedHashSet orderedHashSet2 = new OrderedHashSet();
                OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet3 = new OrderedHashSet<HsqlNameManager.HsqlName>();
                OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet4 = new OrderedHashSet<HsqlNameManager.HsqlName>();
                for (int i = 0; i < orderedHashSet.size(); ++i) {
                    object = (Constraint)orderedHashSet.get(i);
                    Table table = ((Constraint)object).getMain();
                    if (table != this.table) {
                        orderedHashSet2.add(table);
                    }
                    if ((table = ((Constraint)object).getRef()) != this.table) {
                        orderedHashSet2.add(table);
                    }
                    orderedHashSet3.add(((Constraint)object).getMainName());
                    orderedHashSet3.add(((Constraint)object).getRefName());
                    orderedHashSet4.add(((Constraint)object).getRefIndex().getName());
                }
                orderedHashSet3.add(constraint.getName());
                if (constraint.getConstraintType() == 2) {
                    orderedHashSet4.add(constraint.getMainIndex().getName());
                }
                Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, orderedHashSet3, orderedHashSet4);
                this.moveData(this.table, table, new int[0], 0);
                orderedHashSet2 = this.dropConstraintsAndIndexes(orderedHashSet2, orderedHashSet3, orderedHashSet4);
                if (constraint.getConstraintType() == 4) {
                    object = constraint.getMainColumns();
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        table.getColumn((int)object[i]).setPrimaryKey(false);
                        table.setColumnTypeVars((int)object[i]);
                    }
                }
                this.database.schemaManager.removeSchemaObjects(orderedHashSet3);
                this.setNewTableInSchema(table);
                this.setNewTablesInSchema(orderedHashSet2);
                this.updateConstraints(table, this.emptySet);
                this.updateConstraints(orderedHashSet2, orderedHashSet3);
                this.database.schemaManager.recompileDependentObjects(orderedHashSet2);
                this.database.schemaManager.recompileDependentObjects(table);
                this.table = table;
                break;
            }
            case 0: {
                this.checkModifyTable(false);
                OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
                Table table = constraint.getMain();
                HsqlNameManager.HsqlName hsqlName = constraint.getMainName();
                orderedHashSet.add(hsqlName);
                orderedHashSet.add(constraint.getRefName());
                OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet5 = new OrderedHashSet<HsqlNameManager.HsqlName>();
                orderedHashSet5.add(constraint.getRefIndex().getName());
                Table table2 = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, new int[0], 0, orderedHashSet, orderedHashSet5);
                this.moveData(this.table, table2, new int[0], 0);
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                this.setNewTableInSchema(table2);
                table.removeConstraint(hsqlName.name);
                this.updateConstraints(table2, this.emptySet);
                this.database.schemaManager.recompileDependentObjects(this.table);
                this.table = table2;
                break;
            }
            case 3: {
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                if (!constraint.isNotNull()) break;
                ColumnSchema columnSchema = this.table.getColumn(constraint.notNullColumnIndex);
                columnSchema.setNullable(false);
                this.table.setColumnTypeVars(constraint.notNullColumnIndex);
            }
        }
    }

    void retypeColumn(ColumnSchema columnSchema, ColumnSchema columnSchema2) {
        int n;
        Type type;
        Type type2 = columnSchema.getDataType();
        if (type2.equals(type = columnSchema2.getDataType()) && columnSchema.getIdentitySequence() == columnSchema2.getIdentitySequence()) {
            return;
        }
        if (columnSchema.isGenerated() || columnSchema.isSystemPeriod()) {
            throw Error.error(5517);
        }
        this.checkModifyTable(true);
        if (!this.table.isEmpty(this.session) && type2.typeCode != type.typeCode) {
            n = columnSchema2.getDataType().canConvertFrom(columnSchema.getDataType()) ? 1 : 0;
            switch (type2.typeCode) {
                case 1111: 
                case 2000: {
                    n = 0;
                }
            }
            if (n == 0) {
                throw Error.error(5561);
            }
        }
        n = this.table.getColumnIndex(columnSchema.getName().name);
        int n2 = type.canMoveFrom(type2);
        if (columnSchema2.isIdentity() && this.table.hasIdentityColumn() && this.table.identityColumn != n) {
            throw Error.error(5525);
        }
        if (n2 == 0) {
            if (columnSchema2.isIdentity() && !columnSchema.isIdentity() && columnSchema.isNullable() && !columnSchema.isPrimaryKey()) {
                n2 = 1;
            }
            if (type.isDomainType() && type.userTypeModifier.getConstraints().length > 0) {
                n2 = 1;
            }
        }
        if (n2 == 1) {
            this.checkConvertColDataType(columnSchema, columnSchema2);
            n2 = 0;
        }
        if (n2 == 0) {
            columnSchema.setType(columnSchema2);
            columnSchema.setDefaultExpression(columnSchema2.getDefaultExpression());
            columnSchema.setIdentity(columnSchema2.getIdentitySequence());
            this.table.setColumnTypeVars(n);
            this.table.resetDefaultFlags();
            return;
        }
        this.database.schemaManager.checkColumnIsReferenced(this.table.getName(), this.table.getColumn(n).getName());
        this.table.checkColumnInCheckConstraint(n);
        this.table.checkColumnInFKConstraint(n);
        this.checkConvertColDataType(columnSchema, columnSchema2);
        this.retypeColumn(columnSchema2, n);
    }

    void checkConvertColDataType(ColumnSchema columnSchema, ColumnSchema columnSchema2) {
        int n = this.table.getColumnIndex(columnSchema.getName().name);
        Type type = columnSchema.getDataType();
        Type type2 = columnSchema2.getDataType();
        RowIterator rowIterator = this.table.rowIterator(this.session);
        while (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            Object object = row.getField(n);
            if (!columnSchema2.isNullable() && object == null) {
                throw Error.error(10);
            }
            type2.convertToType(this.session, object, type);
            if (!type2.isDomainType()) continue;
            Constraint[] constraintArray = type2.userTypeModifier.getConstraints();
            for (int i = 0; i < constraintArray.length; ++i) {
                constraintArray[i].checkCheckConstraint(this.session, this.table, columnSchema, object);
                this.checkAddDomainConstraint(type2, constraintArray[i]);
            }
        }
    }

    void checkAddDomainConstraint(Type type, Constraint constraint) {
        Type[] typeArray = this.table.getColumnTypes();
        RowIterator rowIterator = this.table.rowIterator(this.session);
        while (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                if (typeArray[i] != type) continue;
                ColumnSchema columnSchema = this.table.getColumn(i);
                constraint.checkCheckConstraint(this.session, this.table, columnSchema, row.getField(i));
            }
        }
    }

    private void retypeColumn(ColumnSchema columnSchema, int n) {
        Table table = this.table.moveDefinition(this.session, this.table.tableType, new ColumnSchema[]{columnSchema}, null, null, new int[]{n}, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, new int[]{n}, 0);
        this.setNewTableInSchema(table);
        this.updateConstraints(table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
        this.table = table;
    }

    void setColNullability(ColumnSchema columnSchema, boolean bl) {
        Constraint constraint = null;
        int n = this.table.getColumnIndex(columnSchema.getName().name);
        if (columnSchema.isGenerated() || columnSchema.isSystemPeriod()) {
            throw Error.error(5517);
        }
        if (columnSchema.isNullable() == bl) {
            return;
        }
        if (bl) {
            if (columnSchema.isPrimaryKey()) {
                throw Error.error(5526);
            }
            this.table.checkColumnInFKConstraint(n, 2);
            this.removeColumnNotNullConstraints(n);
        } else {
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("CT", this.table.getSchemaName(), this.table.getName(), 5);
            constraint = new Constraint(hsqlName, null, 3);
            constraint.check = new ExpressionLogical(columnSchema);
            constraint.prepareCheckConstraint(this.session, this.table);
            constraint.checkCheckConstraint(this.session, this.table);
            columnSchema.setNullable(false);
            this.table.addConstraint(constraint);
            this.table.setColumnTypeVars(n);
            this.database.schemaManager.addSchemaObject(constraint);
        }
    }

    void setColDefaultExpression(int n, Expression expression) {
        ColumnSchema columnSchema;
        if (expression == null) {
            this.table.checkColumnInFKConstraint(n, 4);
        }
        if ((columnSchema = this.table.getColumn(n)).isGenerated() || columnSchema.isSystemPeriod()) {
            throw Error.error(5517);
        }
        columnSchema.setDefaultExpression(expression);
        this.table.setColumnTypeVars(n);
    }

    public boolean setTableType(int n) {
        Table table;
        int n2 = this.table.getTableType();
        if (n2 == n) {
            return false;
        }
        switch (n) {
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        try {
            table = this.table.moveDefinition(this.session, n, ColumnSchema.emptyArray, null, null, new int[0], 0, this.emptySet, this.emptySet);
            this.moveData(this.table, table, new int[0], 0);
        }
        catch (HsqlException hsqlException) {
            return false;
        }
        this.setNewTableInSchema(table);
        this.updateConstraints(table, this.emptySet);
        this.table = table;
        this.database.schemaManager.recompileDependentObjects(this.table);
        return true;
    }

    void addSystemPeriod(PeriodDefinition periodDefinition) {
        if (this.table.systemPeriod != null) {
            throw Error.error(1551);
        }
        int n = this.table.getColumnCount();
        int[] nArray = new int[]{n, n + 1};
        ColumnSchema[] columnSchemaArray = new ColumnSchema[]{periodDefinition.startColumn, periodDefinition.endColumn};
        this.checkAddColumn(periodDefinition.startColumn);
        this.checkAddColumn(periodDefinition.endColumn);
        Table table = this.table.moveDefinition(this.session, this.table.tableType, columnSchemaArray, null, null, nArray, 2, this.emptySet, this.emptySet);
        table.systemPeriod = periodDefinition;
        this.moveData(this.table, table, nArray, 2);
        this.setNewTableInSchema(table);
        this.table = table;
        this.database.granteeManager.updateAddColumn(this.table.getName(), periodDefinition.startColumn.getName());
        this.database.granteeManager.updateAddColumn(this.table.getName(), periodDefinition.endColumn.getName());
    }

    void dropSystemPeriod(boolean bl) {
        if (this.table.systemPeriod == null) {
            throw Error.error(1551);
        }
        OrderedHashSet orderedHashSet = this.database.schemaManager.getReferencesTo(this.table.getName(), this.table.systemPeriod.startColumn.getName());
        OrderedHashSet orderedHashSet2 = this.database.schemaManager.getReferencesTo(this.table.getName(), this.table.systemPeriod.startColumn.getName());
        orderedHashSet.addAll(orderedHashSet2);
        if (bl) {
            if (!orderedHashSet.isEmpty()) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
                throw Error.error(5502, hsqlName.getSchemaQualifiedStatementName());
            }
        } else if (!orderedHashSet.isEmpty()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
            throw Error.error(5502, hsqlName.getSchemaQualifiedStatementName());
        }
        int[] nArray = new int[]{this.table.systemPeriodStartColumn, this.table.systemPeriodEndColumn};
        Table table = this.table.moveDefinition(this.session, this.table.tableType, ColumnSchema.emptyArray, null, null, nArray, -2, this.emptySet, this.emptySet);
        table.systemPeriod = null;
        this.moveData(this.table, table, nArray, -2);
        this.updateConstraints(table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(table);
        table.compile(this.session, null);
        this.setNewTableInSchema(table);
        this.table = table;
    }

    void dropSystemVersioning(boolean bl) {
        OrderedHashSet orderedHashSet = this.database.schemaManager.getReferencesTo(this.table.getName(), this.table.systemPeriod.getName());
        if (bl) {
            if (!orderedHashSet.isEmpty()) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
                throw Error.error(5502, hsqlName.getSchemaQualifiedStatementName());
            }
        } else if (!orderedHashSet.isEmpty()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
            throw Error.error(5502, hsqlName.getSchemaQualifiedStatementName());
        }
    }

    void setNewTablesInSchema(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Table table = (Table)orderedHashSet.get(i);
            this.setNewTableInSchema(table);
        }
    }

    void setNewTableInSchema(Table table) {
        int n = this.database.schemaManager.getTableIndex(table);
        if (n != -1) {
            this.database.schemaManager.setTable(n, table);
        }
    }

    void removeColumnNotNullConstraints(int n) {
        for (int i = this.table.constraintList.length - 1; i >= 0; --i) {
            Constraint constraint = this.table.constraintList[i];
            if (!constraint.isNotNull() || constraint.notNullColumnIndex != n) continue;
            this.database.schemaManager.removeSchemaObject(constraint.getName());
        }
        ColumnSchema columnSchema = this.table.getColumn(n);
        columnSchema.setNullable(true);
        this.table.setColumnTypeVars(n);
    }

    private void checkModifyTable(boolean bl) {
        if (this.session.getUser().isSystem()) {
            return;
        }
        if (this.session.isProcessingScript()) {
            return;
        }
        if (this.database.isFilesReadOnly() || this.table.isReadOnly()) {
            throw Error.error(456);
        }
        if (this.table.isText() && this.table.isConnected()) {
            throw Error.error(320);
        }
    }

    void moveData(Table table, Table table2, int[] nArray, int n) {
        if (table.isTemp) {
            Session[] sessionArray = this.database.sessionManager.getAllSessions();
            for (int i = 0; i < sessionArray.length; ++i) {
                sessionArray[i].sessionData.persistentStoreCollection.moveData(table, table2, nArray, n);
            }
        } else {
            PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(table);
            boolean bl = false;
            if (table2.isCached()) {
                boolean bl2 = bl = table.getSpaceID() != 7;
                if (bl) {
                    int n2 = this.database.logger.getCache().spaceManager.getNewTableSpaceID();
                    table2.setSpaceID(n2);
                }
            }
            PersistentStore persistentStore2 = this.database.persistentStoreCollection.getStore(table2);
            try {
                persistentStore2.moveData(this.session, persistentStore, nArray, n);
            }
            catch (HsqlException hsqlException) {
                this.database.persistentStoreCollection.removeStore(table2);
                throw hsqlException;
            }
            this.database.persistentStoreCollection.removeStore(table);
        }
    }
}

