/*
 *     Copyright (c) 2022, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 *
 */

#ifndef __NVHPC_COMMON
#define __NVHPC_COMMON

#include "nvhpc_cuda_complex.h"

#ifdef __cplusplus
#define __C "C"
#else
#define __C
#endif
#define __EXTERN extern __C

/*
 * We need to first undef `__forceinline__` because it is possible
 * that it is defined already in some CUDA headers.
 */
#undef __forceinline__
#define __forceinline__ __attribute__((always_inline))

/*
 * Adding this attribute to a function will tell the compiler to keep
 * the function in the LLVM IR and avoid to optimize it away.
 */
#define USED __attribute__((used))

/*
 * Macros for setting the attributes to all functions in the bitcode
 * files.
 */

/* Clang Attributes
 * We need to differentiate the function attributes between the nonvvm
 * and the nvvm case.
 */
#if !defined(PGI_COMPILE_BITCODE) // nonvvm
#define __ATTRIBUTES __device__ static inline
#define __ATTRIBUTES_NORETURN __device__ __attribute__((noinline)) __attribute__((noreturn)) static
#else // nvvm
#define __ATTRIBUTES __forceinline__
#define __ATTRIBUTES_NORETURN __attribute__((noinline)) __attribute__((noreturn)) static
#endif

/* NVCC attributes */
#define __DEVICE __EXTERN __device__

/* Utility macros. Should be updated every time new architecture support is added */
#if defined(__NVHPC_PASCAL) || defined(__NVHPC_VOLTA) || defined(__NVHPC_TURING) || defined(__NVHPC_AMPERE) || defined(__NVHPC_HOPPER)
#define __NVHPC_AT_LEAST_PASCAL 1
#endif
#if defined(__NVHPC_VOLTA) || defined(__NVHPC_TURING) || defined(__NVHPC_AMPERE) || defined(__NVHPC_HOPPER)
#define __NVHPC_AT_LEAST_VOLTA 1
#endif

#define SIZE_OF_FLOAT 4
#define SIZE_OF_DOUBLE 8

#endif /* __NVHPC_COMMON */
