/*===------------------ enqcmdintrin.h - enqcmd intrinsics -----------------===
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *===-----------------------------------------------------------------------===
 */

#if !defined(__EDG__) || !defined(__PGLLVM__)
#error "This version of <enqcmdintrin.h> does not work with this compiler."
#endif

#ifndef __IMMINTRIN_H
#error "Never use <enqcmdintrin.h> directly; include <immintrin.h> instead."
#endif

#ifndef __ENQCMDINTRIN_H
#define __ENQCMDINTRIN_H

/* Define the default attributes for the functions in this file */
#define _DEFAULT_FN_ATTRS \
  __attribute__((__always_inline__, __nodebug__, __target__("enqcmd")))

/// Reads 64-byte command pointed by \a __src, formats 64-byte enqueue store
///    data, and performs 64-byte enqueue store to memory pointed by \a __dst.
///    This intrinsics may only be used in User mode.
///
/// \headerfile <x86intrin.h>
///
/// This intrinsics corresponds to the <c> ENQCMD </c> instruction.
///
/// \param __dst
///    Pointer to the destination of the enqueue store.
/// \param __src
///    Pointer to 64-byte command data.
/// \returns If the command data is successfully written to \a __dst then 0 is
///    returned. Otherwise 1 is returned.
static __inline__ int _DEFAULT_FN_ATTRS
_enqcmd (void *__dst, const void *__src)
{
  return __builtin_ia32_enqcmd(__dst, __src);
}

/// Reads 64-byte command pointed by \a __src, formats 64-byte enqueue store
///    data, and performs 64-byte enqueue store to memory pointed by \a __dst
///    This intrinsic may only be used in Privileged mode.
///
/// \headerfile <x86intrin.h>
///
/// This intrinsics corresponds to the <c> ENQCMDS </c> instruction.
///
/// \param __dst
///    Pointer to the destination of the enqueue store.
/// \param __src
///    Pointer to 64-byte command data.
/// \returns If the command data is successfully written to \a __dst then 0 is
///    returned. Otherwise 1 is returned.
static __inline__ int _DEFAULT_FN_ATTRS
_enqcmds (void *__dst, const void *__src)
{
  return __builtin_ia32_enqcmds(__dst, __src);
}

#undef _DEFAULT_FN_ATTRS

#endif /* __ENQCMDINTRIN_H */
