/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.SqlResultSetMapping;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.QuerySecondPass;
import org.hibernate.boot.query.SqlResultSetMappingDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.PersistentClass;

public class ResultSetMappingSecondPass
implements QuerySecondPass {
    private final SqlResultSetMapping annotation;
    private final MetadataBuildingContext context;
    private final boolean isDefault;

    public ResultSetMappingSecondPass(SqlResultSetMapping annotation, MetadataBuildingContext context, boolean isDefault) {
        this.annotation = annotation;
        this.context = context;
        this.isDefault = isDefault;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        if (this.annotation == null) {
            return;
        }
        SqlResultSetMappingDescriptor mappingDefinition = SqlResultSetMappingDescriptor.from(this.annotation);
        if (this.isDefault) {
            this.context.getMetadataCollector().addDefaultResultSetMapping(mappingDefinition);
        } else {
            this.context.getMetadataCollector().addResultSetMapping(mappingDefinition);
        }
    }
}

