/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;

public class HashMapValuesFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Collection<HV>> {
    public static final Externalizer EXTERNALIZER = new Externalizer();

    public Collection<HV> apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        Optional existing = view.peek();
        if (existing.isPresent()) {
            return ((HashMapBucket)existing.get()).values();
        }
        return Collections.emptyList();
    }

    private static class Externalizer
    implements AdvancedExternalizer<HashMapValuesFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends HashMapValuesFunction>> getTypeClasses() {
            return Collections.singleton(HashMapValuesFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.HASH_MAP_VALUES_FUNCTION;
        }

        public void writeObject(ObjectOutput output, HashMapValuesFunction object) throws IOException {
        }

        public HashMapValuesFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new HashMapValuesFunction();
        }
    }
}

