/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class CollectionLoaderSingleKey
implements CollectionLoader {
    private final PluralAttributeMapping attributeMapping;
    private final int keyJdbcCount;
    private final SelectStatement sqlAst;
    private final JdbcOperationQuerySelect jdbcSelect;
    private final JdbcParametersList jdbcParameters;

    public CollectionLoaderSingleKey(PluralAttributeMapping attributeMapping, LoadQueryInfluencers influencers, SessionFactoryImplementor sessionFactory) {
        this.attributeMapping = attributeMapping;
        this.keyJdbcCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount();
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), null, 1, influencers, new LockOptions(), jdbcParametersBuilder::add, sessionFactory);
        QuerySpec querySpec = this.sqlAst.getQueryPart().getFirstQuerySpec();
        FromClause fromClause = querySpec.getFromClause();
        TableGroup tableGroup = fromClause.getRoots().get(0);
        attributeMapping.applySoftDeleteRestrictions(tableGroup, querySpec::applyPredicate);
        this.jdbcParameters = jdbcParametersBuilder.build();
        this.jdbcSelect = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.getAttributeMapping();
    }

    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    public SelectStatement getSqlAst() {
        return this.sqlAst;
    }

    public JdbcParametersList getJdbcParameters() {
        return this.jdbcParameters;
    }

    @Override
    public PersistentCollection<?> load(Object key, SharedSessionContractImplementor session) {
        CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key);
        JdbcServices jdbcServices = session.getFactory().getJdbcServices();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.keyJdbcCount);
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(key, this.attributeMapping.getKeyDescriptor(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), this.sqlAst, this.jdbcParameters, jdbcParameterBindings);
        jdbcServices.getJdbcSelectExecutor().list(this.jdbcSelect, jdbcParameterBindings, new CollectionLoaderSingleKeyExecutionContext(session, collectionKey, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    private static class CollectionLoaderSingleKeyExecutionContext
    extends BaseExecutionContext {
        private final CollectionKey collectionKey;
        private final SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler;

        CollectionLoaderSingleKeyExecutionContext(SharedSessionContractImplementor session, CollectionKey collectionKey, SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler) {
            super(session);
            this.collectionKey = collectionKey;
            this.subSelectFetchableKeysHandler = subSelectFetchableKeysHandler;
        }

        @Override
        public CollectionKey getCollectionKey() {
            return this.collectionKey;
        }

        @Override
        public void registerLoadingEntityHolder(EntityHolder holder) {
            this.subSelectFetchableKeysHandler.addKey(holder);
        }
    }
}

