/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.httpcore;

import io.netty.buffer.ByteBuf;
import io.undertow.httpcore.HttpExchange;
import java.io.IOException;
import java.io.InputStream;

public class UndertowInputStream
extends InputStream {
    private final HttpExchange exchange;
    private boolean closed;
    private boolean finished;
    private ByteBuf pooled;

    public UndertowInputStream(HttpExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.readIntoBuffer();
        if (this.finished) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuf buffer = this.pooled;
        int copied = Math.min(len, buffer.readableBytes());
        buffer.readBytes(b, off, copied);
        if (!buffer.isReadable()) {
            this.pooled.release();
            this.pooled = null;
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !this.finished) {
            this.pooled = this.exchange.getInputChannel().readBlocking();
            if (this.pooled == null) {
                this.finished = true;
                this.pooled = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.finished) {
            return -1;
        }
        return this.exchange.getInputChannel().readBytesAvailable();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.closed = true;
        try {
            while (!this.finished) {
                this.readIntoBuffer();
                if (this.pooled == null) continue;
                this.pooled.release();
                this.pooled = null;
            }
        }
        catch (IOException | RuntimeException e) {
            this.exchange.close();
            throw e;
        }
        finally {
            if (this.pooled != null) {
                this.pooled.release();
                this.pooled = null;
            }
            this.finished = true;
        }
    }
}

