/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import com.google.common.annotations.VisibleForTesting;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.bootstrap.classloading.ClassPathResourceIndex;
import io.quarkus.bootstrap.classloading.DriverRemover;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.paths.ManifestAttributes;
import io.quarkus.paths.PathVisit;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class QuarkusClassLoader
extends ClassLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(QuarkusClassLoader.class);
    private static final Logger lifecycleLog = Logger.getLogger((String)(QuarkusClassLoader.class.getName() + ".lifecycle"));
    private static final boolean LOG_ACCESS_TO_CLOSED_CLASS_LOADERS = Boolean.getBoolean("quarkus-log-access-to-closed-class-loaders");
    private static final byte STATUS_OPEN = 1;
    private static final byte STATUS_CLOSING = 0;
    private static final byte STATUS_CLOSED = -1;
    protected static final String META_INF_SERVICES = "META-INF/services/";
    private final CuratedApplication curatedApplication;
    private StartupAction startupAction;
    private final String name;
    private final List<ClassPathElement> normalPriorityElements;
    private final List<ClassPathElement> lesserPriorityElements;
    private final List<ClassPathElement> bannedElements;
    private final List<ClassPathElement> parentFirstElements;
    private final ConcurrentMap<ClassPathElement, ProtectionDomain> protectionDomains = new ConcurrentHashMap<ClassPathElement, ProtectionDomain>();
    private final ClassLoader parent;
    private final boolean parentFirst;
    private final boolean aggregateParentResources;
    private final List<ClassLoaderEventListener> classLoaderEventListeners;
    private volatile MemoryClassPathElement resettableElement;
    private volatile MemoryClassPathElement transformedClasses;
    private volatile ClassPathResourceIndex classPathResourceIndex;
    private final List<Runnable> closeTasks = new ArrayList<Runnable>();
    static final ClassLoader PLATFORM_CLASS_LOADER;
    private volatile byte status;
    private volatile boolean driverLoaded;

    private static RuntimeException nonQuarkusClassLoaderError() {
        return new IllegalStateException("The current classloader is not an instance of " + QuarkusClassLoader.class.getName() + " but " + Thread.currentThread().getContextClassLoader().getClass().getName());
    }

    public static void visitRuntimeResources(String resourceName, Consumer<PathVisit> visitor) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof QuarkusClassLoader) {
            QuarkusClassLoader classLoader2 = (QuarkusClassLoader)classLoader;
            for (ClassPathElement element : classLoader2.getElementsWithResource(resourceName)) {
                if (!element.isRuntime()) continue;
                element.apply(tree -> {
                    tree.accept(resourceName, visitor);
                    return null;
                });
            }
        } else {
            throw QuarkusClassLoader.nonQuarkusClassLoaderError();
        }
    }

    public static List<ClassPathElement> getElements(String resourceName, boolean onlyFromCurrentClassLoader) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof QuarkusClassLoader) {
            QuarkusClassLoader classLoader2 = (QuarkusClassLoader)classLoader;
            return classLoader2.getElementsWithResource(resourceName, onlyFromCurrentClassLoader);
        }
        throw QuarkusClassLoader.nonQuarkusClassLoaderError();
    }

    public static boolean isClassPresentAtRuntime(String className) {
        String resourceName = ClassLoaderHelper.fromClassNameToResourceName((String)className);
        return QuarkusClassLoader.isResourcePresentAtRuntime(resourceName);
    }

    public static boolean isApplicationClass(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof QuarkusClassLoader) {
            QuarkusClassLoader classLoader2 = (QuarkusClassLoader)classLoader;
            String resourceName = ClassLoaderHelper.fromClassNameToResourceName((String)className);
            ClassPathResourceIndex classPathResourceIndex = classLoader2.getClassPathResourceIndex();
            return classPathResourceIndex.getFirstClassPathElement(resourceName) != null;
        }
        throw QuarkusClassLoader.nonQuarkusClassLoaderError();
    }

    public static boolean isResourcePresentAtRuntime(String resourcePath) {
        List<ClassPathElement> classPathElements = QuarkusClassLoader.getElements(resourcePath, false);
        for (int i = 0; i < classPathElements.size(); ++i) {
            if (!classPathElements.get(i).isRuntime()) continue;
            return true;
        }
        return false;
    }

    private QuarkusClassLoader(Builder builder) {
        super(builder.parent);
        this.name = builder.name;
        this.status = 1;
        this.normalPriorityElements = builder.normalPriorityElements;
        this.bannedElements = builder.bannedElements;
        this.parentFirstElements = builder.parentFirstElements;
        this.lesserPriorityElements = builder.lesserPriorityElements;
        this.parent = builder.parent;
        this.parentFirst = builder.parentFirst;
        this.resettableElement = builder.resettableElement;
        this.transformedClasses = new MemoryClassPathElement(builder.transformedClasses, true);
        this.aggregateParentResources = builder.aggregateParentResources;
        this.classLoaderEventListeners = builder.classLoaderEventListeners.isEmpty() ? Collections.emptyList() : builder.classLoaderEventListeners;
        this.curatedApplication = builder.curatedApplication;
        this.setDefaultAssertionStatus(builder.assertionsEnabled);
        if (lifecycleLog.isDebugEnabled()) {
            lifecycleLog.debugf((Throwable)new RuntimeException("Created to log a stacktrace"), "Creating class loader %s", (Object)this);
        }
    }

    public static Builder builder(String name, ClassLoader parent, boolean parentFirst) {
        return new Builder(name, parent, parentFirst);
    }

    private String sanitizeName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private boolean parentFirst(String name, ClassPathResourceIndex classPathResourceIndex) {
        return this.parentFirst || name.startsWith("io/quarkus/devservices/crossclassloader") || classPathResourceIndex.isParentFirst(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Map<String, byte[]> generatedResources, Map<String, byte[]> transformedClasses) {
        this.ensureOpen();
        if (this.resettableElement == null) {
            throw new IllegalStateException("Classloader is not resettable");
        }
        QuarkusClassLoader quarkusClassLoader = this;
        synchronized (quarkusClassLoader) {
            this.transformedClasses = new MemoryClassPathElement(transformedClasses, true);
            this.resettableElement.reset(generatedResources);
            this.classPathResourceIndex = null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String unsanitisedName) throws IOException {
        this.ensureOpen(unsanitisedName);
        return this.getResources(unsanitisedName, false);
    }

    public Enumeration<URL> getResources(String unsanitisedName, boolean parentAlreadyFoundResources) throws IOException {
        this.ensureOpen(unsanitisedName);
        for (int i = 0; i < this.classLoaderEventListeners.size(); ++i) {
            this.classLoaderEventListeners.get(i).enumeratingResourceURLs(unsanitisedName, this.name);
        }
        ClassPathResourceIndex classPathResourceIndex = this.getClassPathResourceIndex();
        String name = this.sanitizeName(unsanitisedName);
        boolean banned = classPathResourceIndex.isBanned(name);
        if (name.startsWith(META_INF_SERVICES)) {
            try {
                Class<?> c = this.loadClass(name.substring(META_INF_SERVICES.length()));
                if (c.getClassLoader() == this) {
                    banned = true;
                }
            }
            catch (ClassNotFoundException c) {
                // empty catch block
            }
        }
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        List<ClassPathElement> classPathElements = classPathResourceIndex.getClassPathElements(name);
        if (!classPathElements.isEmpty()) {
            boolean endsWithTrailingSlash = unsanitisedName.endsWith("/");
            for (int i = 0; i < classPathElements.size(); ++i) {
                List<ClassPathResource> resList = classPathElements.get(i).getResources(name);
                for (int j = 0; j < resList.size(); ++j) {
                    ClassPathResource res = resList.get(j);
                    if (endsWithTrailingSlash) {
                        if (!res.isDirectory()) continue;
                        try {
                            resources.add(new URL(res.getUrl().toString() + "/"));
                            continue;
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    resources.add(res.getUrl());
                }
            }
        }
        if (!banned && (resources.isEmpty() && !parentAlreadyFoundResources || this.aggregateParentResources)) {
            Enumeration<URL> res = this.parent instanceof QuarkusClassLoader ? ((QuarkusClassLoader)this.parent).getResources(unsanitisedName, !resources.isEmpty()) : this.parent.getResources(unsanitisedName);
            while (res.hasMoreElements()) {
                resources.add(res.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPathResourceIndex getClassPathResourceIndex() {
        ClassPathResourceIndex classPathResourceIndex = this.classPathResourceIndex;
        if (classPathResourceIndex == null) {
            QuarkusClassLoader quarkusClassLoader = this;
            synchronized (quarkusClassLoader) {
                classPathResourceIndex = this.classPathResourceIndex;
                if (classPathResourceIndex == null) {
                    ClassPathResourceIndex.Builder classPathResourceIndexBuilder = ClassPathResourceIndex.builder();
                    classPathResourceIndexBuilder.scanClassPathElement(this.transformedClasses, classPathResourceIndexBuilder::addTransformedClassCandidate);
                    for (ClassPathElement element : this.normalPriorityElements) {
                        classPathResourceIndexBuilder.scanClassPathElement(element, classPathResourceIndexBuilder::addResourceMapping);
                    }
                    for (ClassPathElement lesserPriorityElement : this.lesserPriorityElements) {
                        classPathResourceIndexBuilder.scanClassPathElement(lesserPriorityElement, classPathResourceIndexBuilder::addResourceMapping);
                    }
                    for (ClassPathElement bannedElement : this.bannedElements) {
                        classPathResourceIndexBuilder.scanClassPathElement(bannedElement, (classPathElement, resource) -> classPathResourceIndexBuilder.addBannedResource((String)resource));
                    }
                    for (ClassPathElement parentFirstElement : this.parentFirstElements) {
                        classPathResourceIndexBuilder.scanClassPathElement(parentFirstElement, (classPathElement, resource) -> classPathResourceIndexBuilder.addParentFirstResource((String)resource));
                    }
                    this.classPathResourceIndex = classPathResourceIndexBuilder.build();
                    return this.classPathResourceIndex;
                }
            }
        }
        return classPathResourceIndex;
    }

    @Override
    public URL getResource(String unsanitisedName) {
        this.ensureOpen(unsanitisedName);
        for (ClassLoaderEventListener l : this.classLoaderEventListeners) {
            l.gettingURLFromResource(unsanitisedName, this.name);
        }
        String name = this.sanitizeName(unsanitisedName);
        ClassPathResourceIndex classPathResourceIndex = this.getClassPathResourceIndex();
        if (classPathResourceIndex.isBanned(name)) {
            return null;
        }
        boolean endsWithTrailingSlash = unsanitisedName.endsWith("/");
        if (name.endsWith(".class") && !endsWithTrailingSlash) {
            ClassPathElement classPathElement = classPathResourceIndex.getFirstClassPathElement(name);
            if (classPathElement != null) {
                ClassPathResource resource = classPathElement.getResource(name);
                if (resource == null) {
                    throw new IllegalStateException(String.valueOf(classPathElement) + " from " + this.getName() + " (closed=" + this.isClosed() + ") was expected to provide " + name + " but failed");
                }
                return resource.getUrl();
            }
        } else {
            URL url = QuarkusClassLoader.getClassPathElementResourceUrl(this.normalPriorityElements, name, endsWithTrailingSlash);
            if (url != null) {
                return url;
            }
            url = QuarkusClassLoader.getClassPathElementResourceUrl(this.lesserPriorityElements, name, endsWithTrailingSlash);
            if (url != null) {
                return url;
            }
        }
        return this.parent.getResource(unsanitisedName);
    }

    private static URL getClassPathElementResourceUrl(List<ClassPathElement> classPathElements, String name, boolean endsWithTrailingSlash) {
        for (int i = 0; i < classPathElements.size(); ++i) {
            ClassPathResource res = classPathElements.get(i).getResource(name);
            if (res == null) continue;
            if (endsWithTrailingSlash) {
                if (!res.isDirectory()) continue;
                try {
                    return new URL(res.getUrl().toString() + "/");
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            return res.getUrl();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String unsanitisedName) {
        this.ensureOpen(unsanitisedName);
        for (int i = 0; i < this.classLoaderEventListeners.size(); ++i) {
            this.classLoaderEventListeners.get(i).openResourceStream(unsanitisedName, this.name);
        }
        String name = this.sanitizeName(unsanitisedName);
        ClassPathResourceIndex classPathResourceIndex = this.getClassPathResourceIndex();
        if (classPathResourceIndex.isBanned(name)) {
            return null;
        }
        if (name.endsWith(".class")) {
            ClassPathElement classPathElement = classPathResourceIndex.getFirstClassPathElement(name);
            if (classPathElement != null) {
                ClassPathResource resource = classPathElement.getResource(name);
                if (resource == null) {
                    throw new IllegalStateException(String.valueOf(classPathElement) + " from " + this.getName() + " (closed=" + this.isClosed() + ") was expected to provide " + name + " but failed");
                }
                return new ByteArrayInputStream(resource.getData());
            }
        } else {
            InputStream inputStream = QuarkusClassLoader.getClassPathElementResourceInputStream(this.normalPriorityElements, name);
            if (inputStream != null) {
                return inputStream;
            }
            inputStream = QuarkusClassLoader.getClassPathElementResourceInputStream(this.lesserPriorityElements, name);
            if (inputStream != null) {
                return inputStream;
            }
        }
        return this.parent.getResourceAsStream(unsanitisedName);
    }

    private static InputStream getClassPathElementResourceInputStream(List<ClassPathElement> classPathElements, String name) {
        for (ClassPathElement classPathElement : classPathElements) {
            ClassPathResource res = classPathElement.getResource(name);
            if (res == null) continue;
            if (res.isDirectory()) {
                try {
                    return res.getUrl().openStream();
                }
                catch (IOException e) {
                    log.debug((Object)("Ignoring exception that occurred while opening a stream for resource " + name), (Throwable)e);
                    continue;
                }
            }
            return new ByteArrayInputStream(res.getData());
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        this.ensureOpen(moduleName);
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    protected URL findResource(String name) {
        this.ensureOpen(name);
        return this.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        this.ensureOpen(name);
        return this.getResources(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.ensureOpen(name);
        return this.loadClass(name, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassPathResource classPathElementResource;
        ClassPathElement classPathElement;
        ClassPathResourceIndex classPathResourceIndex;
        boolean interrupted;
        block18: {
            this.ensureOpen(name);
            for (ClassLoaderEventListener l : this.classLoaderEventListeners) {
                l.loadClass(name, this.name);
            }
            if (ClassLoaderHelper.isInJdkPackage((String)name)) {
                return this.parent.loadClass(name);
            }
            interrupted = Thread.interrupted();
            try {
                classPathResourceIndex = this.getClassPathResourceIndex();
                Object object = this.getClassLoadingLock(name);
                // MONITORENTER : object
                Class<?> c = this.findLoadedClass(name);
                if (c == null) break block18;
                Class<?> clazz = c;
                // MONITOREXIT : object
                if (!interrupted) return clazz;
                Thread.currentThread().interrupt();
                return clazz;
            }
            catch (Throwable throwable) {
                if (!interrupted) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
        String resourceName = ClassLoaderHelper.fromClassNameToResourceName((String)name);
        if (classPathResourceIndex.isBanned(resourceName)) {
            throw new ClassNotFoundException(name);
        }
        boolean parentFirst = this.parentFirst(resourceName, classPathResourceIndex);
        if (parentFirst) {
            try {
                Class<?> clazz = this.parent.loadClass(name);
                // MONITOREXIT : object
                if (!interrupted) return clazz;
                Thread.currentThread().interrupt();
                return clazz;
            }
            catch (ClassNotFoundException ignore) {
                log.tracef("Class %s not found in parent first load from %s", (Object)name, (Object)this.parent);
            }
        }
        if ((classPathElement = classPathResourceIndex.getFirstClassPathElement(resourceName)) != null && (classPathElementResource = classPathElement.getResource(resourceName)) != null) {
            byte[] data = classPathElementResource.getData();
            this.definePackage(name, classPathElement);
            Class<?> cl = this.defineClass(name, data, 0, data.length, this.protectionDomains.computeIfAbsent(classPathElement, ClassPathElement::getProtectionDomain));
            if (Driver.class.isAssignableFrom(cl)) {
                this.driverLoaded = true;
            }
            Class<?> clazz = cl;
            // MONITOREXIT : object
            if (!interrupted) return clazz;
            Thread.currentThread().interrupt();
            return clazz;
        }
        if (!parentFirst) {
            Class<?> clazz = this.parent.loadClass(name);
            // MONITOREXIT : object
            if (!interrupted) return clazz;
            Thread.currentThread().interrupt();
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @VisibleForTesting
    void definePackage(String name, ClassPathElement classPathElement) {
        String pkgName = this.getPackageNameFromClassName(name);
        if (pkgName == null) {
            return;
        }
        if (this.getDefinedPackage(pkgName) != null) {
            return;
        }
        try {
            ManifestAttributes manifest = classPathElement.getManifestAttributes();
            if (manifest != null) {
                this.definePackage(pkgName, manifest.getSpecificationTitle(), manifest.getSpecificationVersion(), manifest.getSpecificationVendor(), manifest.getImplementationTitle(), manifest.getImplementationVersion(), manifest.getImplementationVendor(), null);
            } else {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.getDefinedPackage(pkgName) != null) {
                return;
            }
            throw e;
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    public List<ClassPathElement> getElementsWithResource(String name) {
        this.ensureOpen(name);
        return this.getElementsWithResource(name, false);
    }

    public List<ClassPathElement> getElementsWithResource(String name, boolean localOnly) {
        QuarkusClassLoader parentQcl;
        ClassLoader classLoader;
        this.ensureOpen(name);
        boolean parentFirst = this.parentFirst(name, this.getClassPathResourceIndex());
        List<ClassPathElement> result = List.of();
        if (parentFirst && !localOnly && (classLoader = this.parent) instanceof QuarkusClassLoader) {
            parentQcl = (QuarkusClassLoader)classLoader;
            result = parentQcl.getElementsWithResource(name);
        }
        result = QuarkusClassLoader.joinAndDedupe(result, this.getClassPathResourceIndex().getClassPathElements(name));
        if (!parentFirst && !localOnly && (classLoader = this.parent) instanceof QuarkusClassLoader) {
            parentQcl = (QuarkusClassLoader)classLoader;
            result = QuarkusClassLoader.joinAndDedupe(result, parentQcl.getElementsWithResource(name));
        }
        return result;
    }

    private static <T> List<T> joinAndDedupe(List<T> list1, List<T> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        ArrayList<T> result = new ArrayList<T>(list1.size() + list2.size());
        if (list1.size() == 1) {
            T firstCpe = list1.get(0);
            result.add(firstCpe);
            for (T cpe : list2) {
                if (cpe == firstCpe) continue;
                result.add(cpe);
            }
            return result;
        }
        result.addAll(list1);
        for (T cpe : list2) {
            if (QuarkusClassLoader.containsReference(list1, cpe)) continue;
            result.add(cpe);
        }
        return result;
    }

    private static <T> boolean containsReference(List<T> list, T e) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (e != list.get(i)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getReloadableClassNames() {
        this.ensureOpen();
        HashSet<String> ret = new HashSet<String>();
        for (String resourceName : this.getClassPathResourceIndex().getReloadableClasses()) {
            ret.add(ClassLoaderHelper.fromResourceNameToClassName((String)resourceName));
        }
        return ret;
    }

    public Class<?> visibleDefineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        this.ensureOpen(name);
        return super.defineClass(name, b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseTask(Runnable task) {
        this.ensureOpen();
        List<Runnable> list = this.closeTasks;
        synchronized (list) {
            this.closeTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Runnable> tasks;
        QuarkusClassLoader quarkusClassLoader = this;
        synchronized (quarkusClassLoader) {
            if (this.status < 1) {
                return;
            }
            this.status = 0;
        }
        if (lifecycleLog.isDebugEnabled()) {
            lifecycleLog.debugf((Throwable)new RuntimeException("Created to log a stacktrace"), "Closing class loader %s", (Object)this);
        }
        List<Runnable> list = this.closeTasks;
        synchronized (list) {
            tasks = new ArrayList<Runnable>(this.closeTasks);
        }
        for (Runnable i : tasks) {
            try {
                i.run();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to run close task", t);
            }
        }
        if (this.driverLoaded) {
            try (InputStream is = this.getClass().getResourceAsStream("DriverRemover.class");){
                byte[] data = is.readAllBytes();
                Runnable r = (Runnable)this.defineClass(DriverRemover.class.getName(), data, 0, data.length).getConstructor(ClassLoader.class).newInstance(this);
                r.run();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to clean up DB drivers");
            }
        }
        QuarkusClassLoader.closeClassPathElements(this.normalPriorityElements);
        QuarkusClassLoader.closeClassPathElements(this.lesserPriorityElements);
        QuarkusClassLoader.closeClassPathElements(this.bannedElements);
        ResourceBundle.clearCache(this);
        this.status = (byte)-1;
    }

    private static void closeClassPathElements(List<ClassPathElement> classPathElements) {
        for (ClassPathElement element : classPathElements) {
            try {
                ClassPathElement ignored = element;
                if (ignored == null) continue;
                ignored.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close " + String.valueOf(element)), (Throwable)e);
            }
        }
    }

    public boolean isClosed() {
        return this.status < 1;
    }

    private void ensureOpen(String name) {
        if (LOG_ACCESS_TO_CLOSED_CLASS_LOADERS && this.status == -1) {
            System.out.println("Class loader " + String.valueOf(this) + " has been closed and may not be accessed anymore. Attempted to load '" + name + "'");
            Thread.dumpStack();
        }
    }

    private void ensureOpen() {
        if (LOG_ACCESS_TO_CLOSED_CLASS_LOADERS && this.status == -1) {
            System.out.println("Class loader " + String.valueOf(this) + " has been closed and may not be accessed anymore");
            Thread.dumpStack();
        }
    }

    public CuratedApplication getCuratedApplication() {
        return this.curatedApplication;
    }

    public String toString() {
        return "QuarkusClassLoader:" + this.name + "@" + Integer.toHexString(this.hashCode());
    }

    public StartupAction getStartupAction() {
        return this.startupAction;
    }

    public void setStartupAction(StartupAction startupAction) {
        this.startupAction = startupAction;
    }

    public ClassLoader parent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        QuarkusClassLoader.registerAsParallelCapable();
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        PLATFORM_CLASS_LOADER = cl;
    }

    public static class Builder {
        final String name;
        final ClassLoader parent;
        final List<ClassPathElement> normalPriorityElements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> bannedElements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> parentFirstElements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> lesserPriorityElements = new ArrayList<ClassPathElement>();
        final boolean parentFirst;
        CuratedApplication curatedApplication;
        MemoryClassPathElement resettableElement;
        private Map<String, byte[]> transformedClasses = Collections.emptyMap();
        boolean aggregateParentResources;
        boolean assertionsEnabled;
        private final ArrayList<ClassLoaderEventListener> classLoaderEventListeners = new ArrayList(5);

        public Builder(String name, ClassLoader parent, boolean parentFirst) {
            this.name = name;
            this.parent = parent;
            this.parentFirst = parentFirst;
        }

        public Builder addNormalPriorityElement(ClassPathElement element) {
            log.debugf("Adding normal priority element %s to QuarkusClassLoader %s", (Object)element, (Object)this.name);
            this.normalPriorityElements.add(element);
            return this;
        }

        public Builder addLesserPriorityElement(ClassPathElement element) {
            log.debugf("Adding lesser priority element %s to QuarkusClassLoader %s", (Object)element, (Object)this.name);
            this.lesserPriorityElements.add(element);
            return this;
        }

        public Builder setResettableElement(MemoryClassPathElement resettableElement) {
            this.resettableElement = resettableElement;
            return this;
        }

        public Builder addParentFirstElement(ClassPathElement element) {
            log.debugf("Adding parent first element %s to QuarkusClassLoader %s", (Object)element, (Object)this.name);
            this.parentFirstElements.add(element);
            return this;
        }

        public Builder addBannedElement(ClassPathElement element) {
            this.bannedElements.add(element);
            return this;
        }

        public Builder setAggregateParentResources(boolean aggregateParentResources) {
            this.aggregateParentResources = aggregateParentResources;
            return this;
        }

        public Builder setAssertionsEnabled(boolean assertionsEnabled) {
            this.assertionsEnabled = assertionsEnabled;
            return this;
        }

        public Builder setTransformedClasses(Map<String, byte[]> transformedClasses) {
            this.transformedClasses = transformedClasses;
            return this;
        }

        public Builder addClassLoaderEventListeners(List<ClassLoaderEventListener> classLoadListeners) {
            this.classLoaderEventListeners.addAll(classLoadListeners);
            return this;
        }

        public Builder setCuratedApplication(CuratedApplication curatedApplication) {
            this.curatedApplication = curatedApplication;
            return this;
        }

        public QuarkusClassLoader build() {
            if (this.resettableElement != null && !this.normalPriorityElements.contains(this.resettableElement)) {
                this.normalPriorityElements.add(0, this.resettableElement);
            }
            this.classLoaderEventListeners.trimToSize();
            return new QuarkusClassLoader(this);
        }

        public String toString() {
            return "QuarkusClassLoader.Builder:" + this.name + "@" + Integer.toHexString(this.hashCode());
        }
    }
}

