/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.processor.internals.Stamped;

public class StampedRecord
extends Stamped<ConsumerRecord<?, ?>> {
    private final byte[] rawKey;
    private final byte[] rawValue;

    public StampedRecord(ConsumerRecord<?, ?> record, long timestamp) {
        super(record, timestamp);
        this.rawKey = null;
        this.rawValue = null;
    }

    public StampedRecord(ConsumerRecord<?, ?> record, long timestamp, byte[] rawKey, byte[] rawValue) {
        super(record, timestamp);
        this.rawKey = rawKey;
        this.rawValue = rawValue;
    }

    public String topic() {
        return ((ConsumerRecord)this.value).topic();
    }

    public int partition() {
        return ((ConsumerRecord)this.value).partition();
    }

    public Object key() {
        return ((ConsumerRecord)this.value).key();
    }

    public Object value() {
        return ((ConsumerRecord)this.value).value();
    }

    public long offset() {
        return ((ConsumerRecord)this.value).offset();
    }

    public Optional<Integer> leaderEpoch() {
        return ((ConsumerRecord)this.value).leaderEpoch();
    }

    public Headers headers() {
        return ((ConsumerRecord)this.value).headers();
    }

    public byte[] rawKey() {
        return this.rawKey;
    }

    public byte[] rawValue() {
        return this.rawValue;
    }

    public String toString() {
        return ((ConsumerRecord)this.value).toString() + ", timestamp = " + this.timestamp;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

