/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDBVersionedStore;
import org.apache.kafka.streams.state.internals.VersionedKeyValueToBytesStoreAdapter;

public class RocksDbVersionedKeyValueBytesStoreSupplier
implements VersionedBytesStoreSupplier {
    private final String name;
    private final long historyRetentionMs;
    private final long segmentIntervalMs;

    public RocksDbVersionedKeyValueBytesStoreSupplier(String name, long historyRetentionMs) {
        this(name, historyRetentionMs, RocksDbVersionedKeyValueBytesStoreSupplier.defaultSegmentInterval(historyRetentionMs));
    }

    public RocksDbVersionedKeyValueBytesStoreSupplier(String name, long historyRetentionMs, long segmentIntervalMs) {
        this.name = name;
        this.historyRetentionMs = historyRetentionMs;
        this.segmentIntervalMs = segmentIntervalMs;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long historyRetentionMs() {
        return this.historyRetentionMs;
    }

    public long segmentIntervalMs() {
        return this.segmentIntervalMs;
    }

    @Override
    public KeyValueStore<Bytes, byte[]> get() {
        return new VersionedKeyValueToBytesStoreAdapter(new RocksDBVersionedStore(this.name, this.metricsScope(), this.historyRetentionMs, this.segmentIntervalMs));
    }

    @Override
    public String metricsScope() {
        return "rocksdb";
    }

    private static long defaultSegmentInterval(long historyRetentionMs) {
        if (historyRetentionMs <= 60000L) {
            return Math.max(historyRetentionMs / 3L, 2000L);
        }
        if (historyRetentionMs <= 300000L) {
            return Math.max(historyRetentionMs / 5L, 20000L);
        }
        if (historyRetentionMs <= 3600000L) {
            return Math.max(historyRetentionMs / 12L, 60000L);
        }
        return Math.max(historyRetentionMs / 24L, 300000L);
    }
}

