/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedSessionSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedSessionStore;

public class RocksDbTimeOrderedSessionBytesStoreSupplier
implements SessionBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;
    private final boolean withIndex;

    public RocksDbTimeOrderedSessionBytesStoreSupplier(String name, long retentionPeriod, boolean withIndex) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.withIndex = withIndex;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SessionStore<Bytes, byte[]> get() {
        return new RocksDBTimeOrderedSessionStore(new RocksDBTimeOrderedSessionSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentIntervalMs(), this.withIndex));
    }

    @Override
    public String metricsScope() {
        return "rocksdb-session";
    }

    @Override
    public long segmentIntervalMs() {
        return Math.max(this.retentionPeriod / 2L, 60000L);
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

