/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingListValueBytesStore;
import org.apache.kafka.streams.state.internals.ListValueStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;

public class ListValueStoreBuilder<K, V>
extends AbstractStoreBuilder<K, V, KeyValueStore<K, V>> {
    private final KeyValueBytesStoreSupplier storeSupplier;

    public ListValueStoreBuilder(KeyValueBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(storeSupplier.name(), keySerde, valueSerde, time);
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        Objects.requireNonNull(storeSupplier.metricsScope(), "storeSupplier's metricsScope can't be null");
        this.storeSupplier = storeSupplier;
    }

    @Override
    public KeyValueStore<K, V> build() {
        return new MeteredKeyValueStore(this.maybeWrapCaching(this.maybeWrapLogging(new ListValueStore((KeyValueStore)this.storeSupplier.get()))), this.storeSupplier.metricsScope(), this.time, this.keySerde, this.valueSerde);
    }

    private KeyValueStore<Bytes, byte[]> maybeWrapCaching(KeyValueStore<Bytes, byte[]> inner) {
        if (!this.enableCaching) {
            return inner;
        }
        return new CachingKeyValueStore(inner, false);
    }

    private KeyValueStore<Bytes, byte[]> maybeWrapLogging(KeyValueStore<Bytes, byte[]> inner) {
        if (!this.enableLogging) {
            return inner;
        }
        return new ChangeLoggingListValueBytesStore(inner);
    }
}

