/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public class StreamThreadTotalBlockedTime {
    private final Consumer<?, ?> consumer;
    private final Consumer<?, ?> restoreConsumer;
    private final Supplier<Double> producerTotalBlockedTime;

    StreamThreadTotalBlockedTime(Consumer<?, ?> consumer, Consumer<?, ?> restoreConsumer, Supplier<Double> producerTotalBlockedTime) {
        this.consumer = consumer;
        this.restoreConsumer = restoreConsumer;
        this.producerTotalBlockedTime = producerTotalBlockedTime;
    }

    private double metricValue(Map<MetricName, ? extends Metric> metrics, String name) {
        return metrics.keySet().stream().filter(n -> n.name().equals(name)).findFirst().map(n -> (Double)((Metric)metrics.get(n)).metricValue()).orElse(0.0);
    }

    public double compute() {
        return this.metricValue(this.consumer.metrics(), "io-wait-time-ns-total") + this.metricValue(this.consumer.metrics(), "io-time-ns-total") + this.metricValue(this.consumer.metrics(), "committed-time-ns-total") + this.metricValue(this.consumer.metrics(), "commit-sync-time-ns-total") + this.metricValue(this.restoreConsumer.metrics(), "io-wait-time-ns-total") + this.metricValue(this.restoreConsumer.metrics(), "io-time-ns-total") + this.producerTotalBlockedTime.get();
    }
}

